# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Namespace(pulumi.CustomResource):
    labels: pulumi.Output[dict]
    """
    Resource labels associated with this Namespace. No more than 64 user
    labels can be associated with a given resource. Label keys and values can
    be no longer than 63 characters.
    """
    location: pulumi.Output[str]
    """
    The location for the Namespace.
    A full list of valid locations can be found by running
    `gcloud beta service-directory locations list`.
    """
    name: pulumi.Output[str]
    """
    The resource name for the namespace in the format 'projects/*/locations/*/namespaces/*'.
    """
    namespace_id: pulumi.Output[str]
    """
    The Resource ID must be 1-63 characters long, including digits,
    lowercase letters or the hyphen character.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    def __init__(__self__, resource_name, opts=None, labels=None, location=None, namespace_id=None, project=None, __props__=None, __name__=None, __opts__=None):
        """
        A container for `services`. Namespaces allow administrators to group services
        together and define permissions for a collection of services.

        To get more information about Namespace, see:

        * [API documentation](https://cloud.google.com/service-directory/docs/reference/rest/v1beta1/projects.locations.namespaces)
        * How-to Guides
            * [Configuring a namespace](https://cloud.google.com/service-directory/docs/configuring-service-directory#configuring_a_namespace)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] labels: Resource labels associated with this Namespace. No more than 64 user
               labels can be associated with a given resource. Label keys and values can
               be no longer than 63 characters.
        :param pulumi.Input[str] location: The location for the Namespace.
               A full list of valid locations can be found by running
               `gcloud beta service-directory locations list`.
        :param pulumi.Input[str] namespace_id: The Resource ID must be 1-63 characters long, including digits,
               lowercase letters or the hyphen character.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['labels'] = labels
            if location is None:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            if namespace_id is None:
                raise TypeError("Missing required property 'namespace_id'")
            __props__['namespace_id'] = namespace_id
            __props__['project'] = project
            __props__['name'] = None
        super(Namespace, __self__).__init__(
            'gcp:servicedirectory/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, labels=None, location=None, name=None, namespace_id=None, project=None):
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] labels: Resource labels associated with this Namespace. No more than 64 user
               labels can be associated with a given resource. Label keys and values can
               be no longer than 63 characters.
        :param pulumi.Input[str] location: The location for the Namespace.
               A full list of valid locations can be found by running
               `gcloud beta service-directory locations list`.
        :param pulumi.Input[str] name: The resource name for the namespace in the format 'projects/*/locations/*/namespaces/*'.
        :param pulumi.Input[str] namespace_id: The Resource ID must be 1-63 characters long, including digits,
               lowercase letters or the hyphen character.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["labels"] = labels
        __props__["location"] = location
        __props__["name"] = name
        __props__["namespace_id"] = namespace_id
        __props__["project"] = project
        return Namespace(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

