# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class DatabaseInstance(pulumi.CustomResource):
    connection_name: pulumi.Output[str]
    """
    The connection name of the instance to be used in
    connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
    """
    database_version: pulumi.Output[str]
    """
    The MySQL, PostgreSQL or
    SQL Server (beta) version to use. Supported values include `MYSQL_5_6`,
    `MYSQL_5_7`, `POSTGRES_9_6`,`POSTGRES_11`, `SQLSERVER_2017_STANDARD`,
    `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
    [Database Version Policies](https://cloud.google.com/sql/docs/sqlserver/db-versions)
    includes an up-to-date reference of supported versions.
    """
    encryption_key_name: pulumi.Output[str]
    """

    The full path to the encryption key used for the CMEK disk encryption.  Setting
    up disk encryption currently requires manual steps outside of this provider.
    The provided key must be in the same region as the SQL instance.  In order
    to use this feature, a special kind of service account must be created and
    granted permission on this key.  This step can currently only be done
    manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
    That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
    key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
    """
    first_ip_address: pulumi.Output[str]
    """
    The first IPv4 address of any type assigned.
    """
    ip_addresses: pulumi.Output[list]
    master_instance_name: pulumi.Output[str]
    """
    The name of the instance that will act as
    the master in the replication setup. Note, this requires the master to have
    `binary_log_enabled` set, as well as existing backups.
    """
    name: pulumi.Output[str]
    """
    A name for this whitelist entry.
    """
    private_ip_address: pulumi.Output[str]
    """
    The first private (`PRIVATE`) IPv4 address assigned. 
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs. If it
    is not provided, the provider project is used.
    """
    public_ip_address: pulumi.Output[str]
    """
    The first public (`PRIMARY`) IPv4 address assigned. 
    """
    region: pulumi.Output[str]
    """
    The region the instance will sit in. Note, Cloud SQL is not
    available in all regions - choose from one of the options listed [here](https://cloud.google.com/sql/docs/mysql/instance-locations).
    A valid region must be provided to use this resource. If a region is not provided in the resource definition,
    the provider region will be used instead, but this will be an apply-time error for instances if the provider
    region is not supported with Cloud SQL. If you choose not to provide the `region` argument for this resource,
    make sure you understand this.
    """
    replica_configuration: pulumi.Output[dict]
    """
    The configuration for replication. The
    configuration is detailed below.

      * `caCertificate` (`str`) - PEM representation of the trusted CA's x509
        certificate.
      * `clientCertificate` (`str`) - PEM representation of the slave's x509
        certificate.
      * `clientKey` (`str`) - PEM representation of the slave's private key. The
        corresponding public key in encoded in the `client_certificate`.
      * `connectRetryInterval` (`float`) - The number of seconds
        between connect retries.
      * `dumpFilePath` (`str`) - Path to a SQL file in GCS from which slave
        instances are created. Format is `gs://bucket/filename`.
      * `failoverTarget` (`bool`) - Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
      * `masterHeartbeatPeriod` (`float`) - Time in ms between replication
        heartbeats.
      * `password` (`str`) - Password for the replication connection.
      * `sslCipher` (`str`)
      * `username` (`str`) - Username for replication connection.
      * `verifyServerCertificate` (`bool`) - True if the master's common name
        value is checked during the SSL handshake.
    """
    root_password: pulumi.Output[str]
    """
    Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    server_ca_cert: pulumi.Output[dict]
    service_account_email_address: pulumi.Output[str]
    """
    The service account email address assigned to the
    instance.
    """
    settings: pulumi.Output[dict]
    """
    The settings to use for the database. The
    configuration is detailed below.

      * `activationPolicy` (`str`) - This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
      * `authorizedGaeApplications` (`list`) - This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        A list of Google App Engine (GAE) project names that are allowed to access this instance.
      * `availabilityType` (`str`) - This specifies whether a PostgreSQL instance
        should be set up for high availability (`REGIONAL`) or single zone (`ZONAL`).
      * `backupConfiguration` (`dict`)
        * `binaryLogEnabled` (`bool`) - True if binary logging is enabled. If
          `settings.backup_configuration.enabled` is false, this must be as well.
          Cannot be used with Postgres.
        * `enabled` (`bool`) - True if backup configuration is enabled.
        * `location` (`str`)
        * `startTime` (`str`) - `HH:MM` format time indicating when backup
          configuration starts.

      * `crashSafeReplication` (`bool`) - This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Specific to read instances, indicates
        when crash-safe replication flags are enabled.
      * `databaseFlags` (`list`)
        * `name` (`str`) - A name for this whitelist entry.
        * `value` (`str`) - A CIDR notation IPv4 or IPv6 address that is allowed to
          access this instance. Must be set even if other two attributes are not for
          the whitelist to become active.

      * `diskAutoresize` (`bool`) - Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
      * `diskSize` (`float`) - The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
      * `diskType` (`str`) - The type of data disk: PD_SSD or PD_HDD.
      * `ip_configuration` (`dict`)
        * `authorizedNetworks` (`list`)
          * `expiration_time` (`str`) - The [RFC 3339](https://tools.ietf.org/html/rfc3339)
            formatted date time string indicating when this whitelist expires.
          * `name` (`str`) - A name for this whitelist entry.
          * `value` (`str`) - A CIDR notation IPv4 or IPv6 address that is allowed to
            access this instance. Must be set even if other two attributes are not for
            the whitelist to become active.

        * `ipv4Enabled` (`bool`) - Whether this Cloud SQL instance should be assigned
          a public IPV4 address. Either `ipv4_enabled` must be enabled or a
          `private_network` must be configured.
        * `privateNetwork` (`str`) - The VPC network from which the Cloud SQL
          instance is accessible for private IP. For example, projects/myProject/global/networks/default.
          Specifying a network enables private IP.
          Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
          This setting can be updated, but it cannot be removed after it is set.
        * `requireSsl` (`bool`) - True if mysqld should default to `REQUIRE X509`
          for users connecting over IP.

      * `locationPreference` (`dict`)
        * `followGaeApplication` (`str`) - A GAE application whose zone to remain
          in. Must be in the same region as this instance.
        * `zone` (`str`) - The preferred compute engine
          [zone](https://cloud.google.com/compute/docs/zones?hl=en).

      * `maintenanceWindow` (`dict`)
        * `day` (`float`) - Day of week (`1-7`), starting on Monday
        * `hour` (`float`) - Hour of day (`0-23`), ignored if `day` not set
        * `updateTrack` (`str`) - Receive updates earlier (`canary`) or later
          (`stable`)

      * `pricingPlan` (`str`) - Pricing plan for this instance, can only be `PER_USE`.
      * `replicationType` (`str`) - This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
      * `tier` (`str`) - The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
      * `user_labels` (`dict`) - A set of key/value user label pairs to assign to the instance.
      * `version` (`float`)
    """
    def __init__(__self__, resource_name, opts=None, database_version=None, encryption_key_name=None, master_instance_name=None, name=None, project=None, region=None, replica_configuration=None, root_password=None, settings=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates a new Google SQL Database Instance. For more information, see the [official documentation](https://cloud.google.com/sql/),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/instances).

        > **NOTE on `sql.DatabaseInstance`:** - First-generation instances have been
        deprecated and should no longer be created, see [upgrade docs](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for more details.
        To upgrade your First-generation instance, update your config that the instance has
        * `settings.ip_configuration.ipv4_enabled=true`
        * `settings.backup_configuration.enabled=true`
        * `settings.backup_configuration.binary_log_enabled=true`.  
        Apply the config, then upgrade the instance in the console as described in the documentation.
        Once upgraded, update the following attributes in your config to the correct value according to
        the above documentation:
        * `region`
        * `database_version` (if applicable)
        * `tier`  
        Remove any fields that are not applicable to Second-generation instances:
        * `settings.crash_safe_replication`
        * `settings.replication_type`
        * `settings.authorized_gae_applications`
        And change values to appropriate values for Second-generation instances for:
        * `activation_policy` ("ON_DEMAND" is no longer an option)
        * `pricing_plan` ("PER_USE" is now the only valid option)
        Change `settings.backup_configuration.enabled` attribute back to its desired value and apply as necessary.

        > **NOTE on `sql.DatabaseInstance`:** - Second-generation instances include a
        default 'root'@'%' user with no password. This user will be deleted by the provider on
        instance creation. You should use `sql.User` to define a custom user with
        a restricted host and strong password.



        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server (beta) version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `POSTGRES_9_6`,`POSTGRES_11`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/sqlserver/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[str] encryption_key_name: 
               The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] master_instance_name: The name of the instance that will act as
               the master in the replication setup. Note, this requires the master to have
               `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: A name for this whitelist entry.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region the instance will sit in. Note, Cloud SQL is not
               available in all regions - choose from one of the options listed [here](https://cloud.google.com/sql/docs/mysql/instance-locations).
               A valid region must be provided to use this resource. If a region is not provided in the resource definition,
               the provider region will be used instead, but this will be an apply-time error for instances if the provider
               region is not supported with Cloud SQL. If you choose not to provide the `region` argument for this resource,
               make sure you understand this.
        :param pulumi.Input[dict] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[str] root_password: Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
        :param pulumi.Input[dict] settings: The settings to use for the database. The
               configuration is detailed below.

        The **replica_configuration** object supports the following:

          * `caCertificate` (`pulumi.Input[str]`) - PEM representation of the trusted CA's x509
            certificate.
          * `clientCertificate` (`pulumi.Input[str]`) - PEM representation of the slave's x509
            certificate.
          * `clientKey` (`pulumi.Input[str]`) - PEM representation of the slave's private key. The
            corresponding public key in encoded in the `client_certificate`.
          * `connectRetryInterval` (`pulumi.Input[float]`) - The number of seconds
            between connect retries.
          * `dumpFilePath` (`pulumi.Input[str]`) - Path to a SQL file in GCS from which slave
            instances are created. Format is `gs://bucket/filename`.
          * `failoverTarget` (`pulumi.Input[bool]`) - Specifies if the replica is the failover target.
            If the field is set to true the replica will be designated as a failover replica.
            If the master instance fails, the replica instance will be promoted as
            the new master instance.
          * `masterHeartbeatPeriod` (`pulumi.Input[float]`) - Time in ms between replication
            heartbeats.
          * `password` (`pulumi.Input[str]`) - Password for the replication connection.
          * `sslCipher` (`pulumi.Input[str]`)
          * `username` (`pulumi.Input[str]`) - Username for replication connection.
          * `verifyServerCertificate` (`pulumi.Input[bool]`) - True if the master's common name
            value is checked during the SSL handshake.

        The **settings** object supports the following:

          * `activationPolicy` (`pulumi.Input[str]`) - This specifies when the instance should be
            active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
          * `authorizedGaeApplications` (`pulumi.Input[list]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            A list of Google App Engine (GAE) project names that are allowed to access this instance.
          * `availabilityType` (`pulumi.Input[str]`) - This specifies whether a PostgreSQL instance
            should be set up for high availability (`REGIONAL`) or single zone (`ZONAL`).
          * `backupConfiguration` (`pulumi.Input[dict]`)
            * `binaryLogEnabled` (`pulumi.Input[bool]`) - True if binary logging is enabled. If
              `settings.backup_configuration.enabled` is false, this must be as well.
              Cannot be used with Postgres.
            * `enabled` (`pulumi.Input[bool]`) - True if backup configuration is enabled.
            * `location` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`) - `HH:MM` format time indicating when backup
              configuration starts.

          * `crashSafeReplication` (`pulumi.Input[bool]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            Specific to read instances, indicates
            when crash-safe replication flags are enabled.
          * `databaseFlags` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - A name for this whitelist entry.
            * `value` (`pulumi.Input[str]`) - A CIDR notation IPv4 or IPv6 address that is allowed to
              access this instance. Must be set even if other two attributes are not for
              the whitelist to become active.

          * `diskAutoresize` (`pulumi.Input[bool]`) - Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
          * `diskSize` (`pulumi.Input[float]`) - The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
          * `diskType` (`pulumi.Input[str]`) - The type of data disk: PD_SSD or PD_HDD.
          * `ip_configuration` (`pulumi.Input[dict]`)
            * `authorizedNetworks` (`pulumi.Input[list]`)
              * `expiration_time` (`pulumi.Input[str]`) - The [RFC 3339](https://tools.ietf.org/html/rfc3339)
                formatted date time string indicating when this whitelist expires.
              * `name` (`pulumi.Input[str]`) - A name for this whitelist entry.
              * `value` (`pulumi.Input[str]`) - A CIDR notation IPv4 or IPv6 address that is allowed to
                access this instance. Must be set even if other two attributes are not for
                the whitelist to become active.

            * `ipv4Enabled` (`pulumi.Input[bool]`) - Whether this Cloud SQL instance should be assigned
              a public IPV4 address. Either `ipv4_enabled` must be enabled or a
              `private_network` must be configured.
            * `privateNetwork` (`pulumi.Input[str]`) - The VPC network from which the Cloud SQL
              instance is accessible for private IP. For example, projects/myProject/global/networks/default.
              Specifying a network enables private IP.
              Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
              This setting can be updated, but it cannot be removed after it is set.
            * `requireSsl` (`pulumi.Input[bool]`) - True if mysqld should default to `REQUIRE X509`
              for users connecting over IP.

          * `locationPreference` (`pulumi.Input[dict]`)
            * `followGaeApplication` (`pulumi.Input[str]`) - A GAE application whose zone to remain
              in. Must be in the same region as this instance.
            * `zone` (`pulumi.Input[str]`) - The preferred compute engine
              [zone](https://cloud.google.com/compute/docs/zones?hl=en).

          * `maintenanceWindow` (`pulumi.Input[dict]`)
            * `day` (`pulumi.Input[float]`) - Day of week (`1-7`), starting on Monday
            * `hour` (`pulumi.Input[float]`) - Hour of day (`0-23`), ignored if `day` not set
            * `updateTrack` (`pulumi.Input[str]`) - Receive updates earlier (`canary`) or later
              (`stable`)

          * `pricingPlan` (`pulumi.Input[str]`) - Pricing plan for this instance, can only be `PER_USE`.
          * `replicationType` (`pulumi.Input[str]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
          * `tier` (`pulumi.Input[str]`) - The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
            for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
            and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
          * `user_labels` (`pulumi.Input[dict]`) - A set of key/value user label pairs to assign to the instance.
          * `version` (`pulumi.Input[float]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['database_version'] = database_version
            __props__['encryption_key_name'] = encryption_key_name
            __props__['master_instance_name'] = master_instance_name
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
            __props__['replica_configuration'] = replica_configuration
            __props__['root_password'] = root_password
            if settings is None:
                raise TypeError("Missing required property 'settings'")
            __props__['settings'] = settings
            __props__['connection_name'] = None
            __props__['first_ip_address'] = None
            __props__['ip_addresses'] = None
            __props__['private_ip_address'] = None
            __props__['public_ip_address'] = None
            __props__['self_link'] = None
            __props__['server_ca_cert'] = None
            __props__['service_account_email_address'] = None
        super(DatabaseInstance, __self__).__init__(
            'gcp:sql/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, connection_name=None, database_version=None, encryption_key_name=None, first_ip_address=None, ip_addresses=None, master_instance_name=None, name=None, private_ip_address=None, project=None, public_ip_address=None, region=None, replica_configuration=None, root_password=None, self_link=None, server_ca_cert=None, service_account_email_address=None, settings=None):
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_name: The connection name of the instance to be used in
               connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        :param pulumi.Input[str] database_version: The MySQL, PostgreSQL or
               SQL Server (beta) version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `POSTGRES_9_6`,`POSTGRES_11`, `SQLSERVER_2017_STANDARD`,
               `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/sqlserver/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[str] encryption_key_name: 
               The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[str] first_ip_address: The first IPv4 address of any type assigned.
        :param pulumi.Input[str] master_instance_name: The name of the instance that will act as
               the master in the replication setup. Note, this requires the master to have
               `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[str] name: A name for this whitelist entry.
        :param pulumi.Input[str] private_ip_address: The first private (`PRIVATE`) IPv4 address assigned. 
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] public_ip_address: The first public (`PRIMARY`) IPv4 address assigned. 
        :param pulumi.Input[str] region: The region the instance will sit in. Note, Cloud SQL is not
               available in all regions - choose from one of the options listed [here](https://cloud.google.com/sql/docs/mysql/instance-locations).
               A valid region must be provided to use this resource. If a region is not provided in the resource definition,
               the provider region will be used instead, but this will be an apply-time error for instances if the provider
               region is not supported with Cloud SQL. If you choose not to provide the `region` argument for this resource,
               make sure you understand this.
        :param pulumi.Input[dict] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[str] root_password: Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] service_account_email_address: The service account email address assigned to the
               instance.
        :param pulumi.Input[dict] settings: The settings to use for the database. The
               configuration is detailed below.

        The **ip_addresses** object supports the following:

          * `ip_address` (`pulumi.Input[str]`)
          * `timeToRetire` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)

        The **replica_configuration** object supports the following:

          * `caCertificate` (`pulumi.Input[str]`) - PEM representation of the trusted CA's x509
            certificate.
          * `clientCertificate` (`pulumi.Input[str]`) - PEM representation of the slave's x509
            certificate.
          * `clientKey` (`pulumi.Input[str]`) - PEM representation of the slave's private key. The
            corresponding public key in encoded in the `client_certificate`.
          * `connectRetryInterval` (`pulumi.Input[float]`) - The number of seconds
            between connect retries.
          * `dumpFilePath` (`pulumi.Input[str]`) - Path to a SQL file in GCS from which slave
            instances are created. Format is `gs://bucket/filename`.
          * `failoverTarget` (`pulumi.Input[bool]`) - Specifies if the replica is the failover target.
            If the field is set to true the replica will be designated as a failover replica.
            If the master instance fails, the replica instance will be promoted as
            the new master instance.
          * `masterHeartbeatPeriod` (`pulumi.Input[float]`) - Time in ms between replication
            heartbeats.
          * `password` (`pulumi.Input[str]`) - Password for the replication connection.
          * `sslCipher` (`pulumi.Input[str]`)
          * `username` (`pulumi.Input[str]`) - Username for replication connection.
          * `verifyServerCertificate` (`pulumi.Input[bool]`) - True if the master's common name
            value is checked during the SSL handshake.

        The **server_ca_cert** object supports the following:

          * `cert` (`pulumi.Input[str]`)
          * `common_name` (`pulumi.Input[str]`)
          * `create_time` (`pulumi.Input[str]`)
          * `expiration_time` (`pulumi.Input[str]`) - The [RFC 3339](https://tools.ietf.org/html/rfc3339)
            formatted date time string indicating when this whitelist expires.
          * `sha1_fingerprint` (`pulumi.Input[str]`)

        The **settings** object supports the following:

          * `activationPolicy` (`pulumi.Input[str]`) - This specifies when the instance should be
            active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
          * `authorizedGaeApplications` (`pulumi.Input[list]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            A list of Google App Engine (GAE) project names that are allowed to access this instance.
          * `availabilityType` (`pulumi.Input[str]`) - This specifies whether a PostgreSQL instance
            should be set up for high availability (`REGIONAL`) or single zone (`ZONAL`).
          * `backupConfiguration` (`pulumi.Input[dict]`)
            * `binaryLogEnabled` (`pulumi.Input[bool]`) - True if binary logging is enabled. If
              `settings.backup_configuration.enabled` is false, this must be as well.
              Cannot be used with Postgres.
            * `enabled` (`pulumi.Input[bool]`) - True if backup configuration is enabled.
            * `location` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`) - `HH:MM` format time indicating when backup
              configuration starts.

          * `crashSafeReplication` (`pulumi.Input[bool]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            Specific to read instances, indicates
            when crash-safe replication flags are enabled.
          * `databaseFlags` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - A name for this whitelist entry.
            * `value` (`pulumi.Input[str]`) - A CIDR notation IPv4 or IPv6 address that is allowed to
              access this instance. Must be set even if other two attributes are not for
              the whitelist to become active.

          * `diskAutoresize` (`pulumi.Input[bool]`) - Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
          * `diskSize` (`pulumi.Input[float]`) - The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
          * `diskType` (`pulumi.Input[str]`) - The type of data disk: PD_SSD or PD_HDD.
          * `ip_configuration` (`pulumi.Input[dict]`)
            * `authorizedNetworks` (`pulumi.Input[list]`)
              * `expiration_time` (`pulumi.Input[str]`) - The [RFC 3339](https://tools.ietf.org/html/rfc3339)
                formatted date time string indicating when this whitelist expires.
              * `name` (`pulumi.Input[str]`) - A name for this whitelist entry.
              * `value` (`pulumi.Input[str]`) - A CIDR notation IPv4 or IPv6 address that is allowed to
                access this instance. Must be set even if other two attributes are not for
                the whitelist to become active.

            * `ipv4Enabled` (`pulumi.Input[bool]`) - Whether this Cloud SQL instance should be assigned
              a public IPV4 address. Either `ipv4_enabled` must be enabled or a
              `private_network` must be configured.
            * `privateNetwork` (`pulumi.Input[str]`) - The VPC network from which the Cloud SQL
              instance is accessible for private IP. For example, projects/myProject/global/networks/default.
              Specifying a network enables private IP.
              Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
              This setting can be updated, but it cannot be removed after it is set.
            * `requireSsl` (`pulumi.Input[bool]`) - True if mysqld should default to `REQUIRE X509`
              for users connecting over IP.

          * `locationPreference` (`pulumi.Input[dict]`)
            * `followGaeApplication` (`pulumi.Input[str]`) - A GAE application whose zone to remain
              in. Must be in the same region as this instance.
            * `zone` (`pulumi.Input[str]`) - The preferred compute engine
              [zone](https://cloud.google.com/compute/docs/zones?hl=en).

          * `maintenanceWindow` (`pulumi.Input[dict]`)
            * `day` (`pulumi.Input[float]`) - Day of week (`1-7`), starting on Monday
            * `hour` (`pulumi.Input[float]`) - Hour of day (`0-23`), ignored if `day` not set
            * `updateTrack` (`pulumi.Input[str]`) - Receive updates earlier (`canary`) or later
              (`stable`)

          * `pricingPlan` (`pulumi.Input[str]`) - Pricing plan for this instance, can only be `PER_USE`.
          * `replicationType` (`pulumi.Input[str]`) - This property is only applicable to First Generation instances.
            First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
            for information on how to upgrade to Second Generation instances.
            Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
          * `tier` (`pulumi.Input[str]`) - The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
            for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
            and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
          * `user_labels` (`pulumi.Input[dict]`) - A set of key/value user label pairs to assign to the instance.
          * `version` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["connection_name"] = connection_name
        __props__["database_version"] = database_version
        __props__["encryption_key_name"] = encryption_key_name
        __props__["first_ip_address"] = first_ip_address
        __props__["ip_addresses"] = ip_addresses
        __props__["master_instance_name"] = master_instance_name
        __props__["name"] = name
        __props__["private_ip_address"] = private_ip_address
        __props__["project"] = project
        __props__["public_ip_address"] = public_ip_address
        __props__["region"] = region
        __props__["replica_configuration"] = replica_configuration
        __props__["root_password"] = root_password
        __props__["self_link"] = self_link
        __props__["server_ca_cert"] = server_ca_cert
        __props__["service_account_email_address"] = service_account_email_address
        __props__["settings"] = settings
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

