/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.ArrayList;
import java.util.List;

public class RuleSetAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.RuleSet);
        return RuleSetAssembler.createRuleSet(a, root);
    }

    public static RuleSet createRuleSet(Assembler a, Resource root) {
        return RuleSet.create(RuleSetAssembler.addRules(new ArrayList<Rule>(), a, root));
    }

    public static List<Rule> addRules(List<Rule> result, Assembler a, Resource root) {
        RuleSetAssembler.addLiteralRules(root, result);
        RuleSetAssembler.addIndirectRules(a, root, result);
        RuleSetAssembler.addExternalRules(root, result);
        return result;
    }

    private static void addIndirectRules(Assembler a, Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rules);
        while (it.hasNext()) {
            Resource r = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(((RuleSet)a.open(r)).getRules());
        }
    }

    private static void addExternalRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rulesFrom);
        while (it.hasNext()) {
            Resource s2 = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(Rule.rulesFromURL(s2.getURI()));
        }
    }

    private static void addLiteralRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rule);
        while (it.hasNext()) {
            String s2 = RuleSetAssembler.getString(it.nextStatement());
            result.addAll(Rule.parseRules(s2));
        }
    }
}

