/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentsMap;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Fragments {
    Set<Node> subjects = new HashSet<Node>();
    Set<Node> predicates = new HashSet<Node>();
    Set<Node> objects = new HashSet<Node>();
    Set<Node> types = new HashSet<Node>();
    private Node anchor;

    public Fragments(Node n) {
        this.anchor = n;
    }

    public Fragments(Node n, Triple t) {
        this(n);
        this.addTriple(t);
    }

    public int size() {
        return this.subjects.size() + this.predicates.size() + this.objects.size() + this.types.size();
    }

    public boolean isComplete() {
        return this.subjects.size() == 1 && this.predicates.size() == 1 && this.objects.size() == 1 && this.types.size() == 1;
    }

    public boolean isEmpty() {
        return this.subjects.isEmpty() && this.predicates.isEmpty() && this.objects.isEmpty() && this.types.isEmpty();
    }

    public void remove(SimpleReifierFragmentHandler w, Node n) {
        w.which.get(this).remove(n);
    }

    public void add(SimpleReifierFragmentHandler w, Node n) {
        w.which.get(this).add(n);
    }

    public void includeInto(GraphAdd g2) {
        this.includeInto(g2, RDF.Nodes.subject, SimpleReifierFragmentsMap.SUBJECTS_index);
        this.includeInto(g2, RDF.Nodes.predicate, SimpleReifierFragmentsMap.PREDICATES_index);
        this.includeInto(g2, RDF.Nodes.object, SimpleReifierFragmentsMap.OBJECTS_index);
        this.includeInto(g2, RDF.Nodes.type, SimpleReifierFragmentsMap.TYPES_index);
    }

    private void includeInto(GraphAdd g2, Node predicate, GetSlot which) {
        Iterator<Node> it = which.get(this).iterator();
        while (it.hasNext()) {
            g2.add(Triple.create(this.anchor, predicate, it.next()));
        }
    }

    public Fragments addTriple(Triple t) {
        this.subjects.add(t.getSubject());
        this.predicates.add(t.getPredicate());
        this.objects.add(t.getObject());
        this.types.add(RDF.Nodes.Statement);
        return this;
    }

    Triple asTriple() {
        return Triple.create(this.only(this.subjects), this.only(this.predicates), this.only(this.objects));
    }

    private Node only(Set<Node> s2) {
        return s2.iterator().next();
    }

    public String toString() {
        return this.anchor + " s:" + this.subjects + " p:" + this.predicates + " o:" + this.objects + " t:" + this.types;
    }

    public static interface GetSlot {
        public Set<Node> get(Fragments var1);
    }
}

