/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class GraphMemBaseQueryHandler
extends SimpleQueryHandler {
    protected final TripleStore store;

    public GraphMemBaseQueryHandler(GraphMemBase graph) {
        super(graph);
        this.store = graph.store;
    }

    @Override
    public ExtendedIterator<Node> objectsFor(Node s2, Node p) {
        return this.bothANY(s2, p) ? this.findObjects() : super.objectsFor(s2, p);
    }

    @Override
    public ExtendedIterator<Node> predicatesFor(Node s2, Node o) {
        return this.bothANY(s2, o) ? this.findPredicates() : super.predicatesFor(s2, o);
    }

    @Override
    public ExtendedIterator<Node> subjectsFor(Node p, Node o) {
        return this.bothANY(p, o) ? this.findSubjects() : super.subjectsFor(p, o);
    }

    private boolean bothANY(Node a, Node b) {
        return !(a != null && !a.equals(Node.ANY) || b != null && !b.equals(Node.ANY));
    }

    public ExtendedIterator<Node> findPredicates() {
        return this.store.listPredicates();
    }

    public ExtendedIterator<Node> findObjects() {
        return this.store.listObjects();
    }

    public ExtendedIterator<Node> findSubjects() {
        return this.store.listSubjects();
    }
}

