/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.GraphTripleStoreBase;
import com.hp.hpl.jena.mem.NodeToTriplesMapMem;
import com.hp.hpl.jena.mem.ProcessedTriple;
import java.util.Iterator;

public class GraphTripleStoreMem
extends GraphTripleStoreBase
implements TripleStore {
    public GraphTripleStoreMem(Graph parent) {
        super(parent, new NodeToTriplesMapMem(Triple.Field.fieldSubject, Triple.Field.fieldPredicate, Triple.Field.fieldObject), new NodeToTriplesMapMem(Triple.Field.fieldPredicate, Triple.Field.fieldObject, Triple.Field.fieldSubject), new NodeToTriplesMapMem(Triple.Field.fieldObject, Triple.Field.fieldSubject, Triple.Field.fieldPredicate));
    }

    public NodeToTriplesMapMem getSubjects() {
        return (NodeToTriplesMapMem)this.subjects;
    }

    public NodeToTriplesMapMem getPredicates() {
        return (NodeToTriplesMapMem)this.predicates;
    }

    public NodeToTriplesMapMem getObjects() {
        return (NodeToTriplesMapMem)this.objects;
    }

    public Applyer createApplyer(ProcessedTriple pt) {
        if (pt.hasNoVariables()) {
            return this.containsApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Fixed) {
            return this.getSubjects().createFixedSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Fixed) {
            return this.getObjects().createFixedOApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Bound) {
            return this.getSubjects().createBoundSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Bound) {
            return this.getObjects().createBoundOApplyer(pt);
        }
        return this.varSvarOApplyer(pt);
    }

    protected Applyer containsApplyer(final ProcessedTriple pt) {
        return new Applyer(){

            @Override
            public void applyToTriples(Domain d, Matcher m3, StageElement next) {
                Triple t = new Triple(pt.S.finder(d), pt.P.finder(d), pt.O.finder(d));
                if (GraphTripleStoreMem.this.objects.containsBySameValueAs(t)) {
                    next.run(d);
                }
            }
        };
    }

    protected Applyer varSvarOApplyer(final QueryTriple pt) {
        return new Applyer(){
            protected final QueryNode p;
            {
                this.p = pt.P;
            }

            public Iterator<Triple> find(Domain d) {
                Node P = this.p.finder(d);
                if (P.isConcrete()) {
                    return GraphTripleStoreMem.this.predicates.iterator(P, Node.ANY, Node.ANY);
                }
                return GraphTripleStoreMem.this.subjects.iterateAll();
            }

            @Override
            public void applyToTriples(Domain d, Matcher m3, StageElement next) {
                Iterator<Triple> it = this.find(d);
                while (it.hasNext()) {
                    if (!m3.match(d, it.next())) continue;
                    next.run(d);
                }
            }
        };
    }
}

