/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.OneToManyMap;
import java.util.Iterator;

public abstract class AbstractProfile
implements Profile {
    protected OneToManyMap<Resource, Resource> m_aliasesMap;

    @Override
    public boolean hasAliasFor(Resource res) {
        return this.aliasMap().containsKey(res);
    }

    @Override
    public Resource getAliasFor(Resource res) {
        return this.aliasMap().get(res);
    }

    @Override
    public Iterator<Resource> listAliasesFor(Resource res) {
        return this.aliasMap().getAll(res);
    }

    public static boolean containsSome(EnhGraph g2, Node n, Property p) {
        return g2.asGraph().contains(n, p.asNode(), Node.ANY);
    }

    protected abstract Resource[][] aliasTable();

    protected OneToManyMap<Resource, Resource> aliasMap() {
        if (this.m_aliasesMap == null) {
            this.m_aliasesMap = new OneToManyMap();
            Resource[][] aliases = this.aliasTable();
            for (int i = 0; i < aliases.length; ++i) {
                this.m_aliasesMap.put(aliases[i][0], aliases[i][1]);
                this.m_aliasesMap.put(aliases[i][1], aliases[i][0]);
            }
        }
        return this.m_aliasesMap;
    }
}

