/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class IndividualImpl
extends OntResourceImpl
implements Individual {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new IndividualImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to Individual");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, Individual.class);
        }
    };

    public IndividualImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOntClass(Resource cls) {
        this.setRDFType(cls);
    }

    @Override
    public void addOntClass(Resource cls) {
        this.addRDFType(cls);
    }

    @Override
    public OntClass getOntClass() {
        return this.getOntClass(false);
    }

    @Override
    public OntClass getOntClass(boolean direct) {
        return this.getRDFType(direct).as(OntClass.class);
    }

    @Override
    public <T extends OntClass> ExtendedIterator<T> listOntClasses(boolean direct) {
        ExtendedIterator iter = this.listRDFTypes(direct).mapWith(new OntResourceImpl.ResourceAsMapper<OntClass>(OntClass.class));
        return iter;
    }

    @Override
    public boolean hasOntClass(Resource ontClass, boolean direct) {
        return this.hasRDFType(ontClass, direct);
    }

    @Override
    public boolean hasOntClass(Resource ontClass) {
        return this.hasOntClass(ontClass, false);
    }

    @Override
    public boolean hasOntClass(String uri) {
        return this.hasRDFType(uri);
    }

    @Override
    public void removeOntClass(Resource ontClass) {
        this.removeRDFType(ontClass);
    }
}

