/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OWLLiteProfile
extends OWLProfile {
    protected static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            Iterator<Resource> i = ((OntModel)((Object)g2)).getProfile().getAnnotationProperties();
            while (i.hasNext()) {
                if (!i.next().asNode().equals(n)) continue;
                return true;
            }
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph eg) {
            Graph g2 = eg.asGraph();
            Node rdfTypeNode = RDF.type.asNode();
            return this.hasType(n, eg, new Resource[]{OWL.Class, OWL.Restriction, RDFS.Class, RDFS.Datatype}) || n.equals(OWL.Thing.asNode()) || g2.contains(Node.ANY, RDFS.domain.asNode(), n) || g2.contains(Node.ANY, RDFS.range.asNode(), n) || g2.contains(n, OWL.intersectionOf.asNode(), Node.ANY);
        }
    }}, {DatatypeProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return this.hasType(n, g2, new Resource[]{OWL.ObjectProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty});
        }
    }}, {FunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {RDFList.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return n.equals(RDF.nil.asNode()) || g2.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return this.hasType(n, g2, new Resource[]{RDF.Property, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty, OWL.FunctionalProperty});
        }
    }}, {Ontology.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {AllValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g2, n, OWL.allValuesFrom) && OWLLiteProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g2, n, OWL.someValuesFrom) && OWLLiteProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g2, n, OWL.cardinality) && OWLLiteProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g2, n, OWL.minCardinality) && OWLLiteProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g2, n, OWL.maxCardinality) && OWLLiteProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            if (n instanceof Node_URI || n instanceof Node_Blank) {
                return !this.hasType(n, g2, new Resource[]{RDFS.Class, RDF.Property, OWL.Class, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.TransitiveProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty});
            }
            return false;
        }
    }}};
    private static Map<Class<?>, OWLProfile.SupportsCheck> s_supportsChecks = new HashMap();

    @Override
    public Resource DATARANGE() {
        return null;
    }

    @Override
    public Resource NOTHING() {
        return null;
    }

    @Override
    public Property COMPLEMENT_OF() {
        return null;
    }

    @Override
    public Property DISJOINT_WITH() {
        return null;
    }

    @Override
    public Property HAS_VALUE() {
        return null;
    }

    @Override
    public Property ONE_OF() {
        return null;
    }

    @Override
    public Property UNION_OF() {
        return null;
    }

    @Override
    public Property SAME_AS() {
        return null;
    }

    @Override
    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    @Override
    public String getLabel() {
        return "OWL Lite";
    }

    public static boolean containsSome(EnhGraph g2, Node n, Property p) {
        return AbstractProfile.containsSome(g2, n, p);
    }

    @Override
    protected Map<Class<?>, OWLProfile.SupportsCheck> getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (int i = 0; i < s_supportsCheckData.length; ++i) {
            s_supportsChecks.put((Class)s_supportsCheckData[i][0], (OWLProfile.SupportsCheck)s_supportsCheckData[i][1]);
        }
    }
}

