/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.DisjointUnion;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RSIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.Iterator;

public class ModelReifier {
    private ModelCom model;
    public Reifier reifier;
    private static boolean copyingReifications = false;
    protected final Map1<Node, ReifiedStatement> mapToRS = new Map1<Node, ReifiedStatement>(){

        @Override
        public ReifiedStatement map1(Node node) {
            return ModelReifier.this.getRS(node);
        }
    };

    public ModelReifier(ModelCom model) {
        this.model = model;
        this.reifier = model.asGraph().getReifier();
    }

    public ReificationStyle getReificationStyle() {
        return this.reifier.getStyle();
    }

    public static Model withHiddenStatements(Model m3) {
        Graph mGraph = m3.getGraph();
        Graph hiddenTriples = ModelReifier.getHiddenTriples(m3);
        return new ModelCom(new DisjointUnion(mGraph, hiddenTriples));
    }

    protected static Graph getHiddenTriples(Model m3) {
        Graph mGraph = m3.getGraph();
        final Reifier r = mGraph.getReifier();
        return new GraphBase(){

            @Override
            public ExtendedIterator<Triple> graphBaseFind(TripleMatch m3) {
                return r.findEither(m3, true);
            }
        };
    }

    public Model getHiddenStatements() {
        return new ModelCom(ModelReifier.getHiddenTriples(this.model));
    }

    public ReifiedStatement createReifiedStatement(Statement s2) {
        return this.createReifiedStatement(null, s2);
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s2) {
        return ReifiedStatementImpl.create(this.model, uri, s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement s2) {
        RSIterator it = this.listReifiedStatements(s2);
        if (it.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = it.nextRS();
                return reifiedStatement;
            }
            finally {
                it.close();
            }
        }
        return this.createReifiedStatement(s2);
    }

    public boolean isReified(FrontsTriple s2) {
        return this.reifier.hasTriple(s2.asTriple());
    }

    public void removeAllReifications(FrontsTriple s2) {
        this.reifier.remove(s2.asTriple());
    }

    public void removeReification(ReifiedStatement rs) {
        this.reifier.remove(rs.asNode(), rs.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements());
    }

    public RSIterator listReifiedStatements(FrontsTriple s2) {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements(s2.asTriple()));
    }

    public void noteIfReified(RDFNode s2, RDFNode p, RDFNode o) {
        if (copyingReifications) {
            this.noteIfReified(s2);
            this.noteIfReified(p);
            this.noteIfReified(o);
        }
    }

    private void noteIfReified(RDFNode n) {
        if (n.canAs(ReifiedStatement.class)) {
            ReifiedStatement rs = n.as(ReifiedStatement.class);
            this.createReifiedStatement(rs.getURI(), rs.getStatement());
        }
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements() {
        return this.reifier.allNodes().mapWith(this.mapToRS);
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements(Triple t) {
        return this.reifier.allNodes(t).mapWith(this.mapToRS);
    }

    private ReifiedStatement getRS(Node n) {
        return ReifiedStatementImpl.createExistingReifiedStatement(this.model, n);
    }
}

