/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    static Logger log = LoggerFactory.getLogger(LocationMapper.class);
    public static final String DEFAULT_PATH = "file:location-mapping.rdf;file:location-mapping.n3;file:location-mapping.ttl;file:etc/location-mapping.rdf;file:etc/location-mapping.n3;file:etc/location-mapping.ttl";
    public static final String GlobalMapperSystemProperty1 = "http://jena.hpl.hp.com/2004/08/LocationMap";
    public static final String GlobalMapperSystemProperty2 = "LocationMap";
    static String s_globalMapperPath = null;
    Map<String, String> altLocations = new HashMap<String, String>();
    Map<String, String> altPrefixes = new HashMap<String, String>();
    static LocationMapper theMapper = null;

    public static LocationMapper get() {
        if (theMapper == null) {
            theMapper = new LocationMapper();
            if (LocationMapper.getGlobalConfigPath() != null) {
                theMapper.initFromPath(LocationMapper.getGlobalConfigPath(), false);
            }
        }
        return theMapper;
    }

    public static void setGlobalLocationMapper(LocationMapper globalLocationMapper) {
        theMapper = globalLocationMapper;
    }

    public static LocationMapper makeGlobal() {
        LocationMapper lMap = new LocationMapper();
        if (LocationMapper.getGlobalConfigPath() != null) {
            lMap.initFromPath(LocationMapper.getGlobalConfigPath(), false);
        }
        return lMap;
    }

    public LocationMapper() {
    }

    public LocationMapper(LocationMapper locMapper) {
        this.altLocations.putAll(locMapper.altLocations);
        this.altPrefixes.putAll(locMapper.altPrefixes);
    }

    public LocationMapper(Model model) {
        this.processConfig(model);
    }

    public LocationMapper(String config) {
        this.initFromPath(config, true);
    }

    private void initFromPath(String configPath, boolean configMustExist) {
        if (configPath == null || configPath.length() == 0) {
            log.warn("Null configuration");
            return;
        }
        FileManager fm = new FileManager();
        fm.addLocatorFile();
        fm.addLocatorClassLoader(fm.getClass().getClassLoader());
        try {
            String uri;
            String uriConfig = null;
            InputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (pathElems.hasMoreTokens() && (uri = pathElems.nextToken()) != null && uri.length() != 0) {
                in = fm.openNoMap(uri);
                if (in == null) continue;
                uriConfig = uri;
                break;
            }
            if (in == null) {
                if (!configMustExist) {
                    log.debug("Failed to find configuration: " + configPath);
                }
                return;
            }
            String syntax = FileUtils.guessLang(uriConfig);
            Model model = ModelFactory.createDefaultModel();
            model.read(in, uriConfig, syntax);
            this.processConfig(model);
        }
        catch (JenaException ex) {
            LoggerFactory.getLogger(LocationMapper.class).warn("Error in configuration file: " + ex.getMessage());
        }
    }

    public String altMapping(String uri) {
        return this.altMapping(uri, uri);
    }

    public String altMapping(String uri, String otherwise) {
        if (this.altLocations.containsKey(uri)) {
            return this.altLocations.get(uri);
        }
        String newStart = null;
        String oldStart = null;
        for (String prefix : this.altPrefixes.keySet()) {
            if (!uri.startsWith(prefix)) continue;
            String s2 = this.altPrefixes.get(prefix);
            if (newStart != null && newStart.length() >= s2.length()) continue;
            oldStart = prefix;
            newStart = s2;
        }
        if (newStart != null) {
            return newStart + uri.substring(oldStart.length());
        }
        return otherwise;
    }

    public void addAltEntry(String uri, String alt) {
        this.altLocations.put(uri, alt);
    }

    public void addAltPrefix(String uriPrefix, String altPrefix) {
        this.altPrefixes.put(uriPrefix, altPrefix);
    }

    public Iterator<String> listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator<String> listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String uri) {
        this.altLocations.remove(uri);
    }

    public void removeAltPrefix(String uriPrefix) {
        this.altPrefixes.remove(uriPrefix);
    }

    public String getAltEntry(String uri) {
        return this.altLocations.get(uri);
    }

    public String getAltPrefix(String uriPrefix) {
        return this.altPrefixes.get(uriPrefix);
    }

    private static String getGlobalConfigPath() {
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty1, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty2, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = DEFAULT_PATH;
        }
        return s_globalMapperPath;
    }

    public int hashCode() {
        String v;
        int x = 0;
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            x = x ^ k.hashCode() ^ v.hashCode();
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            x = x ^ k.hashCode() ^ v.hashCode();
        }
        return x;
    }

    public boolean equals(Object obj) {
        String v;
        if (!(obj instanceof LocationMapper)) {
            return false;
        }
        LocationMapper other = (LocationMapper)obj;
        if (this.altLocations.size() != other.altLocations.size()) {
            return false;
        }
        if (this.altPrefixes.size() != other.altPrefixes.size()) {
            return false;
        }
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            if (other.altLocations.get(k).equals(v)) continue;
            return false;
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            if (other.altPrefixes.get(k).equals(v)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String v;
        String s2 = "";
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            s2 = s2 + "(Loc:" + k + "=>" + v + ") ";
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            s2 = s2 + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s2;
    }

    public Model toModel() {
        Model m3 = ModelFactory.createDefaultModel();
        m3.setNsPrefix("lmap", "http://jena.hpl.hp.com/2004/08/location-mapping#");
        this.toModel(m3);
        return m3;
    }

    public void toModel(Model model) {
        String v;
        String k;
        Resource e;
        Resource r;
        Iterator<String> iter = this.altLocations.keySet().iterator();
        while (iter.hasNext()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e);
            k = iter.next();
            v = this.altLocations.get(k);
            model.add(e, LocationMappingVocab.name, k);
            model.add(e, LocationMappingVocab.altName, v);
        }
        iter = this.altPrefixes.keySet().iterator();
        while (iter.hasNext()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e);
            k = iter.next();
            v = this.altPrefixes.get(k);
            model.add(e, LocationMappingVocab.prefix, k);
            model.add(e, LocationMappingVocab.altPrefix, v);
        }
    }

    public void processConfig(Model m3) {
        StmtIterator mappings = m3.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (mappings.hasNext()) {
            Statement s2 = mappings.nextStatement();
            Resource mapping = s2.getResource();
            if (mapping.hasProperty(LocationMappingVocab.name)) {
                try {
                    String name = mapping.getRequiredProperty(LocationMappingVocab.name).getString();
                    String altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                    this.addAltEntry(name, altName);
                    log.debug("Mapping: " + name + " => " + altName);
                }
                catch (JenaException ex) {
                    log.warn("Error processing name mapping: " + ex.getMessage());
                    return;
                }
            }
            if (!mapping.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                String prefix = mapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                String altPrefix = mapping.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                this.addAltPrefix(prefix, altPrefix);
                log.debug("Prefix mapping: " + prefix + " => " + altPrefix);
            }
            catch (JenaException ex) {
                log.warn("Error processing prefix mapping: " + ex.getMessage());
                return;
            }
        }
    }
}

