/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

class XPointer {
    private XPointer() {
    }

    static Nodes query(Document document, String string) throws XPointerSyntaxException, XPointerResourceException {
        Nodes nodes = new Nodes();
        boolean bl = false;
        try {
            new Element(string, "http://www.example.com");
            Element element = XPointer.findByID(document.getRootElement(), string);
            if (element != null) {
                nodes.append(element);
                return nodes;
            }
        }
        catch (IllegalNameException illegalNameException) {
            List<String> list = XPointer.findElementSchemeData(string);
            if (list.isEmpty()) {
                throw new XPointerSyntaxException("No supported XPointer schemes found");
            }
            for (String string2 : list) {
                Object object;
                int[] nArray = new int[]{};
                ParentNode parentNode = document;
                if (string2.indexOf(47) == -1) {
                    try {
                        new Element(string2);
                    }
                    catch (IllegalNameException illegalNameException2) {
                        continue;
                    }
                    object = XPointer.findByID(document.getRootElement(), string2);
                    if (object != null) {
                        if (!bl) {
                            nodes.append((Node)object);
                        }
                        bl = true;
                    }
                } else if (!string2.startsWith("/")) {
                    object = string2.substring(0, string2.indexOf(47));
                    try {
                        new Element((String)object);
                    }
                    catch (XMLException xMLException) {
                        continue;
                    }
                    parentNode = XPointer.findByID(document.getRootElement(), (String)object);
                    nArray = XPointer.split(string2.substring(string2.indexOf(47)));
                    if (parentNode == null) {
                        continue;
                    }
                } else {
                    nArray = XPointer.split(string2);
                }
                for (int i = 0; i < nArray.length && (parentNode = XPointer.findNthChildElement(parentNode, nArray[i])) != null; ++i) {
                }
                if (parentNode == document || parentNode == null) continue;
                if (!bl) {
                    nodes.append(parentNode);
                }
                bl = true;
            }
        }
        if (bl) {
            return nodes;
        }
        throw new XPointerResourceException("XPointer " + string + " did not locate any nodes in the document " + document.getBaseURI());
    }

    private static Element findNthChildElement(ParentNode parentNode, int n) {
        int n2 = 1;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            Node node = parentNode.getChild(i);
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private static int[] split(String string) throws XPointerSyntaxException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(3);
        try {
            for (int i = 1; i < string.length(); ++i) {
                if (string.charAt(i) == '/') {
                    nArray[n2] = Integer.parseInt(stringBuffer.toString());
                    ++n2;
                    stringBuffer = new StringBuffer(3);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            nArray[nArray.length - 1] = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            XPointerSyntaxException xPointerSyntaxException = new XPointerSyntaxException(string + " is not syntactically correct", numberFormatException);
            throw xPointerSyntaxException;
        }
        return nArray;
    }

    private static List<String> findElementSchemeData(String string) throws XPointerSyntaxException {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n2 = 0; n2 < stringBuffer.length() && (n = stringBuffer.charAt(n2)) != 40; ++n2) {
            stringBuffer2.append((char)n);
        }
        try {
            new Element(stringBuffer2.toString(), "http://www.example.com/");
        }
        catch (IllegalNameException illegalNameException) {
            throw new XPointerSyntaxException(illegalNameException.getMessage());
        }
        n = 1;
        ++n2;
        StringBuffer stringBuffer3 = new StringBuffer();
        try {
            while (n > 0) {
                char c = stringBuffer.charAt(n2);
                if (c == '^') {
                    c = stringBuffer.charAt(n2 + 1);
                    stringBuffer3.append(c);
                    if (c != '^' && c != '(' && c != ')') {
                        throw new XPointerSyntaxException("Illegal XPointer escape sequence");
                    }
                    ++n2;
                } else if (c == '(') {
                    stringBuffer3.append(c);
                    ++n;
                } else if (c == ')') {
                    if (--n > 0) {
                        stringBuffer3.append(c);
                    }
                } else {
                    stringBuffer3.append(c);
                }
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XPointerSyntaxException("Unbalanced parentheses");
        }
        if (stringBuffer2.toString().equals("element")) {
            arrayList.add(stringBuffer3.toString());
        }
        if (n2 + 1 < stringBuffer.length()) {
            arrayList.addAll(XPointer.findElementSchemeData(stringBuffer.substring(n2)));
        }
        return arrayList;
    }

    static Element findByID(Element element, String string) {
        Node node = element;
        boolean bl = false;
        int n = -1;
        while (true) {
            ParentNode parentNode;
            if (node instanceof Element) {
                parentNode = node;
                for (int i = 0; i < ((Element)parentNode).getAttributeCount(); ++i) {
                    Attribute attribute = ((Element)parentNode).getAttribute(i);
                    if (attribute.getType() != Attribute.Type.ID || !attribute.getValue().trim().equals(string)) continue;
                    return parentNode;
                }
            }
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n = 0;
                continue;
            }
            if (bl && node == element) break;
            bl = false;
            parentNode = node.getParent();
            if (parentNode.getChildCount() - 1 == n) {
                node = parentNode;
                if (node != element) {
                    parentNode = node.getParent();
                    n = parentNode.indexOf(node);
                }
                bl = true;
                continue;
            }
            node = parentNode.getChild(++n);
        }
        return null;
    }
}

