/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.ContinuedFraction;
import org.apache.commons.math.util.FastMath;

public class Beta {
    private static final double DEFAULT_EPSILON = 1.0E-14;

    private Beta() {
    }

    public static double regularizedBeta(double x, double a, double b) throws MathException {
        return Beta.regularizedBeta(x, a, b, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a, double b, double epsilon) throws MathException {
        return Beta.regularizedBeta(x, a, b, epsilon, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a, double b, int maxIterations) throws MathException {
        return Beta.regularizedBeta(x, a, b, 1.0E-14, maxIterations);
    }

    public static double regularizedBeta(double x, final double a, final double b, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            ret = Double.NaN;
        } else if (x > (a + 1.0) / (a + b + 2.0)) {
            ret = 1.0 - Beta.regularizedBeta(1.0 - x, b, a, epsilon, maxIterations);
        } else {
            ContinuedFraction fraction = new ContinuedFraction(){

                protected double getB(int n, double x) {
                    double ret;
                    if (n % 2 == 0) {
                        double m3 = (double)n / 2.0;
                        ret = m3 * (b - m3) * x / ((a + 2.0 * m3 - 1.0) * (a + 2.0 * m3));
                    } else {
                        double m4 = ((double)n - 1.0) / 2.0;
                        ret = -((a + m4) * (a + b + m4) * x) / ((a + 2.0 * m4) * (a + 2.0 * m4 + 1.0));
                    }
                    return ret;
                }

                protected double getA(int n, double x) {
                    return 1.0;
                }
            };
            ret = FastMath.exp(a * FastMath.log(x) + b * FastMath.log(1.0 - x) - FastMath.log(a) - Beta.logBeta(a, b, epsilon, maxIterations)) * 1.0 / fraction.evaluate(x, epsilon, maxIterations);
        }
        return ret;
    }

    public static double logBeta(double a, double b) {
        return Beta.logBeta(a, b, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double logBeta(double a, double b, double epsilon, int maxIterations) {
        double ret = Double.isNaN(a) || Double.isNaN(b) || a <= 0.0 || b <= 0.0 ? Double.NaN : Gamma.logGamma(a) + Gamma.logGamma(b) - Gamma.logGamma(a + b);
        return ret;
    }
}

