/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.xml.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.freehep.graphicsbase.xml.util.XMLCharacterProperties;
import org.freehep.graphicsbase.xml.util.XMLTagWriter;
import org.freehep.util.io.IndentPrintWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter
implements XMLTagWriter {
    protected boolean closed = true;
    private String dtdName = null;
    private Hashtable<String, String> attributes = new Hashtable();
    private Stack<String> openTags = new Stack();
    protected IndentPrintWriter writer;
    protected String defaultNameSpace;

    public XMLWriter(Writer w, String indentString, String defaultNameSpace) {
        this.writer = new IndentPrintWriter(w);
        this.writer.setIndentString(indentString);
        this.defaultNameSpace = defaultNameSpace;
    }

    public XMLWriter(Writer w, String indentString) {
        this(w, indentString, "");
    }

    public XMLWriter(Writer w) {
        this(w, "  ");
    }

    @Override
    public void close() throws IOException {
        this.closeDoc();
        this.writer.close();
    }

    @Override
    public void openDoc() {
        this.openDoc("1.0", "", false);
    }

    @Override
    public void openDoc(String version2, String encoding, boolean standalone) {
        String indentString = this.writer.getIndentString();
        this.writer.setIndentString(indentString);
        this.closed = false;
        if (!XMLCharacterProperties.validVersionNum(version2)) {
            throw new RuntimeException("Invalid version number: " + version2);
        }
        this.writer.print("<?xml version=\"");
        this.writer.print(version2);
        this.writer.print("\" ");
        if (encoding != null && !encoding.equals("")) {
            if (!XMLCharacterProperties.validEncName(encoding)) {
                throw new RuntimeException("Invalid encoding name: " + encoding);
            }
            this.writer.print("encoding=\"");
            this.writer.print(encoding);
            this.writer.print("\" ");
        }
        if (standalone) {
            this.writer.print("standalone=\"yes\" ");
        }
        this.writer.println("?>");
        this.writer.setIndentString(indentString);
    }

    @Override
    public void referToDTD(String name, String pid, String ref) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = name;
        this.writer.println("<!DOCTYPE " + name + " PUBLIC \"" + pid + "\" \"" + ref + "\">");
    }

    @Override
    public void referToDTD(String name, String system) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = name;
        this.writer.println("<!DOCTYPE " + name + " SYSTEM \"" + system + "\">");
    }

    @Override
    public void closeDoc() {
        if (!this.closed) {
            if (!this.openTags.isEmpty()) {
                StringBuffer sb = new StringBuffer("Not all tags were closed before closing XML document:\n");
                while (!this.openTags.isEmpty()) {
                    sb.append("   </");
                    sb.append(this.openTags.pop());
                    sb.append(">\n");
                }
                throw new RuntimeException(sb.toString());
            }
            this.closed = true;
        }
        this.writer.flush();
    }

    @Override
    public void printComment(String comment) {
        if (comment.indexOf("--") >= 0) {
            throw new RuntimeException("'--' sequence not allowed in comment");
        }
        this.writer.print("<!--");
        this.writer.print(XMLWriter.normalizeText(comment));
        this.writer.println("-->");
    }

    @Override
    public void print(String text) {
        this.writer.print(XMLWriter.normalizeText(text));
    }

    public void println(String text) {
        this.print(text);
        this.writer.println();
    }

    @Override
    public void openTag(String namespace, String name) {
        if (namespace.equals(this.defaultNameSpace)) {
            this.openTag(name);
        } else {
            this.openTag(namespace + ":" + name);
        }
    }

    @Override
    public void openTag(String name) {
        this.checkNameValid(name);
        if (this.openTags.isEmpty() && this.dtdName != null && !this.dtdName.equals(name)) {
            throw new RuntimeException("First tag: '" + name + "' not equal to DTD id: '" + this.dtdName + "'");
        }
        this.writer.print("<" + name);
        this.printAttributes(name.length());
        this.writer.println(">");
        this.writer.indent();
        this.openTags.push(name);
    }

    @Override
    public void closeTag() {
        if (this.openTags.isEmpty()) {
            this.writer.close();
            throw new RuntimeException("No open tags");
        }
        String name = this.openTags.pop();
        this.writer.outdent();
        this.writer.print("</");
        this.writer.print((Object)name);
        this.writer.println(">");
    }

    @Override
    public void printTag(String namespace, String name) {
        if (namespace.equals(this.defaultNameSpace)) {
            this.printTag(name);
        } else {
            this.printTag(namespace + ":" + name);
        }
    }

    @Override
    public void printTag(String name) {
        this.checkNameValid(name);
        this.writer.print("<" + name);
        this.printAttributes(name.length());
        this.writer.println("/>");
    }

    @Override
    public void setAttribute(String name, String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    @Override
    public void setAttribute(String namespace, String name, String value) {
        if (namespace != null && name != null) {
            this.attributes.put(namespace + ":" + name, value);
        }
    }

    @Override
    public void setAttribute(String name, byte value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, char value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, short value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, float value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, double value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, Color value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, byte value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, char value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, long value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, int value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, short value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, boolean value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, float value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, double value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String ns, String name, Color value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    protected void printAttributes(int tagLength) {
        int width = tagLength + 1;
        boolean extraIndent = false;
        Enumeration<String> e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            this.checkNameValid(key);
            String value = XMLWriter.normalize(this.attributes.get(key).toString());
            int length = key.length() + value.length() + 3;
            if (width > 0 && width + length + 2 * this.writer.getIndent() > 60) {
                width = 0;
                this.writer.println();
                if (!extraIndent) {
                    this.writer.indent();
                    extraIndent = true;
                }
            } else {
                width += length;
                this.writer.print(' ');
            }
            this.writer.print(key);
            this.writer.print("=\"");
            this.writer.print(value);
            this.writer.print("\"");
        }
        this.attributes.clear();
        if (extraIndent) {
            this.writer.outdent();
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                throw new RuntimeException("No support for printing nodes of type Document");
            }
            case 1: {
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    this.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                NodeList children = node.getChildNodes();
                if (children == null) {
                    this.printTag(node.getNodeName());
                    break;
                }
                this.openTag(node.getNodeName());
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                this.closeTag();
                break;
            }
            case 5: {
                this.writer.print('&');
                this.writer.print(node.getNodeName());
                this.writer.print(';');
                break;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(node.getNodeValue());
                this.writer.print("]]>");
                break;
            }
            case 3: {
                this.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.writer.print(' ');
                    this.writer.print(data);
                }
                this.writer.print("?>");
            }
        }
    }

    public static String normalize(String s2) {
        StringBuffer str = new StringBuffer();
        int len = s2 != null ? s2.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    continue block7;
                }
                default: {
                    if (ch > '\u00ff') {
                        String hex = "0000" + Integer.toHexString(ch);
                        str.append("&#x");
                        str.append(hex.substring(hex.length() - 4));
                        str.append(';');
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String normalizeText(String s2) {
        StringBuffer str = new StringBuffer();
        int len = s2 != null ? s2.length() : 0;
        block5: for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block5;
                }
                case '>': {
                    str.append("&gt;");
                    continue block5;
                }
                case '&': {
                    str.append("&amp;");
                    continue block5;
                }
                default: {
                    if (ch > '\u007f') {
                        String hex = "0000" + Integer.toHexString(ch);
                        str.append("&#x");
                        str.append(hex.substring(hex.length() - 4));
                        str.append(';');
                        continue block5;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    protected void checkNameValid(String s2) {
        if (!XMLCharacterProperties.validName(s2)) {
            throw new RuntimeException("Invalid name: " + s2);
        }
    }
}

