/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Graphics;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestColors
extends TestingPanel {
    public TestColors(String[] args) throws Exception {
        super(args);
        this.setName("Colors");
    }

    @Override
    public void paintComponent(Graphics g2) {
        VectorGraphics vg = VectorGraphics.create(g2);
        vg.setColor(Color.WHITE);
        vg.fillRect(0, 0, this.getWidth(), this.getHeight() / 3);
        vg.setColor(Color.BLACK);
        vg.fillRect(0, this.getHeight() / 3, this.getWidth(), this.getHeight() / 3);
        int radius = 55;
        int dx = this.getWidth() / 4;
        int dy = this.getHeight() / 6;
        int x = dx;
        int y = dy;
        this.drawRGB(x, y, radius, vg);
        this.drawCMY(x += dx * 2, y, radius, vg);
        x = dx;
        this.drawRGB(x, y += dy * 2, radius, vg);
        this.drawCMY(x += dx * 2, y, radius, vg);
        x = dx;
        this.drawRGB(x, y += dy * 2, radius, vg);
        this.drawCMY(x += dx * 2, y, radius, vg);
    }

    private void drawRGB(int x, int y, int radius, VectorGraphics g2) {
        int circleWidth = radius * 2;
        int radius53 = 5 * radius / 3;
        int radius3 = radius / 3;
        g2.setColor(new Color(255, 0, 0, 128));
        g2.fillOval(x - radius53, y - radius53, circleWidth, circleWidth);
        g2.setColor(new Color(0, 255, 0, 128));
        g2.fillOval(x - radius3, y - radius53, circleWidth, circleWidth);
        g2.setColor(new Color(0, 0, 255, 128));
        g2.fillOval(x - radius, y - radius3, circleWidth, circleWidth);
    }

    private void drawCMY(int x, int y, int radius, VectorGraphics g2) {
        int circleWidth = radius * 2;
        int radius53 = 5 * radius / 3;
        int radius3 = radius / 3;
        g2.setColor(new Color(0, 255, 255, 128));
        g2.fillOval(x - radius53, y - radius53, circleWidth, circleWidth);
        g2.setColor(new Color(255, 0, 255, 128));
        g2.fillOval(x - radius3, y - radius53, circleWidth, circleWidth);
        g2.setColor(new Color(255, 255, 0, 128));
        g2.fillOval(x - radius, y - radius3, circleWidth, circleWidth);
    }

    public static void main(String[] args) throws Exception {
        new TestColors(args).runTest();
    }
}

