/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.images.ImageHandler;
import org.freehep.graphicsio.test.TestingPanel;

public class TestImages
extends TestingPanel {
    static final Color bg = Color.ORANGE;
    private Image image;

    public TestImages(String[] args) throws Exception {
        super(args);
        this.setName("Images");
        this.setBackground(bg);
        MediaTracker t = new MediaTracker(this);
        this.image = ImageHandler.getImage("images/transparent-image.gif", TestImages.class);
        t.addImage(this.image, 0);
        try {
            t.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        this.drawComponent(VectorGraphics.create(g2));
    }

    protected void drawComponent(VectorGraphics g2) {
        g2.setBackground(bg);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        int cellWidth = this.getWidth() / 4;
        int cellHeight = this.getHeight() / 2;
        int x = 0;
        int y = 0;
        g2.drawImage(this.image, x, y, Color.black, this);
        g2.drawImage(this.image, (x += cellWidth) + cellWidth / 2, y + cellHeight / 2, cellWidth / 2, cellHeight / 2, Color.black, this);
        g2.drawImage(this.image, x += cellWidth, y, x + 3 * cellWidth / 4, y + 3 * cellHeight / 4, 64, 64, 192, 192, Color.black, this);
        g2.drawImage(this.image, x += cellWidth, y, x + cellWidth / 2, y + cellHeight, 256, 256, 0, 0, Color.black, this);
        x = 0;
        g2.drawImage(this.image, x, y += cellHeight, this);
        g2.drawImage(this.image, (x += cellWidth) + cellWidth / 2, y + cellHeight / 2, cellWidth / 2, cellHeight / 2, this);
        g2.drawImage(this.image, x += cellWidth, y, x + 3 * cellWidth / 4, y + 3 * cellHeight / 4, 64, 64, 192, 192, this);
        g2.drawImage(this.image, x += cellWidth, y, x + cellWidth / 2, y + cellHeight, 256, 256, 0, 0, this);
    }

    public static void main(String[] args) throws Exception {
        new TestImages(args).runTest();
    }
}

