/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsbase.util.images.ImageHandler;
import org.freehep.graphicsio.test.TestingPanel;

public class TestRenderingHints
extends TestingPanel {
    Image image;

    public TestRenderingHints(String[] args) throws Exception {
        super(args);
        this.setName("Rendering Hints");
    }

    @Override
    public void paintComponent(Graphics g2) {
        MediaTracker t = new MediaTracker(this);
        this.image = ImageHandler.getImage("images/BrokenCursor.gif", TestRenderingHints.class);
        t.addImage(this.image, 0);
        try {
            t.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        VectorGraphics vg = VectorGraphics.create(g2);
        AffineTransform at = vg.getTransform();
        vg.setColor(Color.white);
        vg.fillRect(0, 0, this.getWidth(), this.getHeight());
        vg.setColor(Color.black);
        vg.setFont(new Font("Dialog", 2, 20));
        vg.setRenderingHints(new HashMap());
        this.paint(vg, "No Hints");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paint(vg, "ANTIALIAS_ON");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paint(vg, "TEXT_ANTIALIAS_ON");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        this.paint(vg, "STROKE_NORMALIZE");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.paint(vg, "STROKE_PURE");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.paint(vg, "INTERPOLATION_BICUBIC");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.paint(vg, "INTERPOLATION_NEAREST_NEIGHBOR");
        vg.setRenderingHints(new HashMap());
        vg.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        this.paint(vg, "VALUE_DITHER_ENABLE");
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        vg.addRenderingHints(hints);
        this.paint(vg, "VALUE_FRACTIONALMETRICS_ON (added)");
        vg.setTransform(at);
    }

    private void paint(VectorGraphics vg, String text) {
        vg.drawString(text, 20, 30);
        vg.drawLine(20, 35, 200, 50);
        vg.drawLine(20, 50, 200, 35);
        vg.drawImage(this.image, 230, 35, 100, 25, Color.yellow, this);
        BufferedImage ditheredImage = new BufferedImage(200, 2, 13);
        Graphics2D g2 = (Graphics2D)ditheredImage.getGraphics();
        g2.setRenderingHints(vg.getRenderingHints());
        for (int i = 0; i < 20; ++i) {
            double red = 12.75 * (double)i + 2.0;
            g2.setColor(new Color((int)red, 0, 0));
            g2.fillRect(i * 10, 0, 10, 25);
        }
        g2.dispose();
        vg.drawImage(ditheredImage, 360, 35, 200, 25, this);
        vg.translate(0, 60);
    }

    public static void main(String[] args) throws Exception {
        UserProperties p = new UserProperties();
        new TestRenderingHints(args).runTest(p);
    }
}

