/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestShapes
extends TestingPanel {
    static final int maxCharHeight = 15;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    Dimension totalSize;

    public TestShapes(String[] args) throws Exception {
        super(args);
        this.setName("Shapes");
        this.setBackground(bg);
        this.setForeground(fg);
    }

    @Override
    public void paintComponent(Graphics g2) {
        VectorGraphics vg = VectorGraphics.create(g2);
        if (vg != null) {
            this.drawComponent(vg);
        }
    }

    protected void drawComponent(VectorGraphics g2) {
        Dimension d = this.getSize();
        g2.setColor(bg);
        g2.fillRect(0, 0, d.width, d.height);
        int gridWidth = d.width / 6;
        int gridHeight = d.height / 8;
        int x = 5;
        int y = 7;
        int rectWidth = gridWidth - 2 * x;
        int rectHeight = gridHeight - 2 * y;
        this.drawShapes(g2, x, y, rectWidth, rectHeight, gridWidth);
        x = 5;
        this.drawFilledShapes(g2, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        g2.setLineWidth(5.0);
        this.drawShapes(g2, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        this.drawFilledShapes(g2, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        int xp = x;
        int yp = y += gridHeight;
        String saying = "The quick brown fox jumped over the lazy dog.";
        Font thisFont = new Font("SansSerif", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("SansSerif: " + saying, xp, yp);
        thisFont = new Font("SansSerif", 1, 14);
        g2.setFont(thisFont);
        g2.drawString("SansSerif (bold): " + saying, xp, yp += 16);
        thisFont = new Font("SansSerif", 2, 14);
        g2.setFont(thisFont);
        g2.drawString("SansSerif (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("Serif: " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 1, 14);
        g2.setFont(thisFont);
        g2.drawString("Serif (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 2, 14);
        g2.setFont(thisFont);
        g2.drawString("Serif (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("Monospaced: " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 1, 14);
        g2.setFont(thisFont);
        g2.drawString("Monospaced (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 2, 14);
        g2.setFont(thisFont);
        g2.drawString("Monospaced (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("Symbol: " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 1, 14);
        g2.setFont(thisFont);
        g2.drawString("Symbol (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 2, 14);
        g2.setFont(thisFont);
        g2.drawString("Symbol (italic): " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("ZapfDingbats: " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 1, 14);
        g2.setFont(thisFont);
        g2.drawString("ZapfDingbats (bold): " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 2, 14);
        g2.setFont(thisFont);
        g2.drawString("ZapfDingbats (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 0, 14);
        g2.setFont(thisFont);
        g2.drawString("Unbalanced (( )) ))) ((( TEST! )T( (T)", xp, yp += 16);
        yp += 16;
    }

    private void drawShapes(VectorGraphics g2, int x, int y, int rectWidth, int rectHeight, int gridWidth) {
        g2.setColor(Color.red);
        g2.drawLine(x, y + rectHeight - 1, x + rectWidth, y);
        g2.setColor(Color.green);
        g2.drawRect(x += gridWidth, y, rectWidth, rectHeight);
        g2.setColor(Color.blue);
        g2.drawRoundRect(x += gridWidth, y, rectWidth, rectHeight, 50, 50);
        g2.setColor(Color.cyan);
        g2.drawArc(x += gridWidth, y, rectWidth, rectHeight, 90, 135);
        g2.setColor(Color.magenta);
        g2.drawOval(x += gridWidth, y, rectWidth, rectHeight);
        int[] x1Points = new int[]{x += gridWidth, x + rectWidth, x, x + rectWidth};
        int[] y1Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g2.setColor(Color.yellow);
        g2.drawPolygon(x1Points, y1Points, 4);
    }

    private void drawFilledShapes(VectorGraphics g2, int x, int y, int rectWidth, int rectHeight, int gridWidth) {
        int[] x2Points = new int[]{x, x + rectWidth, x, x + rectWidth};
        int[] y2Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g2.setColor(Color.red);
        g2.drawPolyline(x2Points, y2Points, 4);
        g2.setColor(Color.green);
        g2.fillRect(x += gridWidth, y, rectWidth, rectHeight);
        g2.setColor(fg);
        g2.drawRect(x, y, rectWidth, rectHeight);
        g2.setColor(Color.blue);
        g2.fillRoundRect(x += gridWidth, y, rectWidth, rectHeight, 50, 50);
        g2.setColor(fg);
        g2.setColor(Color.cyan);
        g2.fillArc(x += gridWidth, y, rectWidth, rectHeight, 90, 135);
        g2.setColor(fg);
        g2.setColor(Color.magenta);
        g2.fillOval(x += gridWidth, y, rectWidth, rectHeight);
        g2.setColor(fg);
        int[] x3Points = new int[]{x += gridWidth, x + rectWidth, x, x + rectWidth};
        int[] y3Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g2.setColor(Color.yellow);
        g2.fillPolygon(x3Points, y3Points, 4);
        g2.setColor(fg);
        g2.drawPolygon(x3Points, y3Points, 4);
    }

    public static void main(String[] args) throws Exception {
        new TestShapes(args).runTest();
    }
}

