/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.interfaces.IAtom;

public class Association
extends ElectronContainer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9138919895942850167L;
    protected final int electronCount = 0;
    protected IAtom[] atoms;
    protected int atomCount;

    public Association(IAtom atom1, IAtom atom2) {
        this.atoms = new IAtom[2];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.atomCount = 2;
    }

    public Association() {
        this.atoms = new Atom[2];
        this.atomCount = 0;
    }

    public IAtom[] getAtoms() {
        IAtom[] returnAtoms = new Atom[this.atomCount];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
        this.notifyChanged();
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public Integer getElectronCount() {
        return 0;
    }

    public IAtom getAtomAt(int position) {
        return this.atoms[position];
    }

    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.atoms[i].equals(atom)) continue;
            return true;
        }
        return false;
    }

    public void setAtomAt(IAtom atom, int position) {
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("Association(");
        s2.append(this.hashCode());
        for (int i = 0; i < this.atomCount; ++i) {
            s2.append(", ").append(this.atoms[i].toString());
        }
        s2.append(')');
        return s2.toString();
    }
}

