/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IntArrayCountFingerprint;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class FingerprinterTool {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(FingerprinterTool.class);

    public static boolean isSubset(BitSet bs1, BitSet bs2) {
        BitSet clone = (BitSet)bs1.clone();
        clone.and(bs2);
        return clone.equals(bs2);
    }

    public static List<Integer> listDifferences(BitSet bs1, BitSet bs2) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        LOGGER.debug("Listing bit positions set in bs2 but not in bs1");
        for (int f = 0; f < bs2.size(); ++f) {
            if (!bs2.get(f) || bs1.get(f)) continue;
            l.add(f);
            LOGGER.debug("Bit " + f + " not set in bs1");
        }
        return l;
    }

    public static Set<Integer> differences(BitSet s2, BitSet t) {
        BitSet u = (BitSet)s2.clone();
        u.xor(t);
        TreeSet<Integer> differences = new TreeSet<Integer>();
        int i = u.nextSetBit(0);
        while (i >= 0) {
            differences.add(i);
            i = u.nextSetBit(i + 1);
        }
        return differences;
    }

    public static IBitFingerprint makeBitFingerprint(Map<String, Integer> features) {
        return FingerprinterTool.makeBitFingerprint(features, 1024, 1);
    }

    public static IBitFingerprint makeBitFingerprint(Map<String, Integer> features, int len) {
        return FingerprinterTool.makeBitFingerprint(features, len, 1);
    }

    public static IBitFingerprint makeBitFingerprint(Map<String, Integer> features, int len, int bits) {
        BitSetFingerprint fingerprint = new BitSetFingerprint(len);
        Random rand = new Random();
        for (String feature : features.keySet()) {
            int hash = feature.hashCode();
            fingerprint.set(Math.abs(hash % len));
            for (int i = 1; i < bits; ++i) {
                rand.setSeed(hash);
                hash = rand.nextInt(len);
                fingerprint.set(hash);
            }
        }
        return fingerprint;
    }

    public static ICountFingerprint makeCountFingerprint(Map<String, Integer> features) {
        return new IntArrayCountFingerprint(features);
    }
}

