/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.group.Permutation;

public class PermutationGroup {
    private Permutation[][] permutations;
    private final int size;
    private Permutation base;

    public PermutationGroup(int size) {
        this(new Permutation(size));
    }

    public PermutationGroup(Permutation base) {
        this.size = base.size();
        this.base = new Permutation(base);
        this.permutations = new Permutation[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            this.permutations[i][this.base.get((int)i)] = new Permutation(this.size);
        }
    }

    public PermutationGroup(int size, List<Permutation> generators) {
        this(new Permutation(size));
        for (Permutation generator : generators) {
            this.enter(generator);
        }
    }

    public static PermutationGroup makeSymN(int size) {
        ArrayList<Permutation> generators = new ArrayList<Permutation>();
        int[] p1 = new int[size];
        p1[0] = 1;
        p1[1] = 0;
        for (int i = 2; i < size; ++i) {
            p1[i] = i;
        }
        int[] p2 = new int[size];
        p2[0] = 1;
        for (int i = 1; i < size - 1; ++i) {
            p2[i] = i + 1;
        }
        p2[size - 1] = 0;
        generators.add(new Permutation(p1));
        generators.add(new Permutation(p2));
        return new PermutationGroup(size, generators);
    }

    public int getSize() {
        return this.size;
    }

    public long order() {
        long total = 1L;
        for (int i = 0; i < this.size; ++i) {
            int sum = 0;
            for (int j = 0; j < this.size; ++j) {
                if (this.permutations[i][j] == null) continue;
                ++sum;
            }
            total *= (long)sum;
        }
        return total;
    }

    public Permutation get(int uIndex, int uSubIndex) {
        return this.permutations[uIndex][uSubIndex];
    }

    public List<Permutation> getLeftTransversal(int index) {
        ArrayList<Permutation> traversal = new ArrayList<Permutation>();
        for (int subIndex = 0; subIndex < this.size; ++subIndex) {
            if (this.permutations[index][subIndex] == null) continue;
            traversal.add(this.permutations[index][subIndex]);
        }
        return traversal;
    }

    public List<Permutation> transversal(final PermutationGroup subgroup) {
        final long m3 = this.order() / subgroup.order();
        final ArrayList<Permutation> results = new ArrayList<Permutation>();
        Backtracker transversalBacktracker = new Backtracker(){
            private boolean finished = false;

            @Override
            public void applyTo(Permutation p) {
                for (Permutation f : results) {
                    Permutation h2 = f.invert().multiply(p);
                    if (subgroup.test(h2) != PermutationGroup.this.size) continue;
                    return;
                }
                results.add(p);
                if ((long)results.size() >= m3) {
                    this.finished = true;
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        this.apply(transversalBacktracker);
        return results;
    }

    public void apply(Backtracker backtracker) {
        this.backtrack(0, new Permutation(this.size), backtracker);
    }

    private void backtrack(int l, Permutation g2, Backtracker backtracker) {
        if (backtracker.isFinished()) {
            return;
        }
        if (l == this.size) {
            backtracker.applyTo(g2);
        } else {
            for (int i = 0; i < this.size; ++i) {
                Permutation h2 = this.permutations[l][i];
                if (h2 == null) continue;
                this.backtrack(l + 1, g2.multiply(h2), backtracker);
            }
        }
    }

    public List<Permutation> all() {
        final ArrayList<Permutation> permutations = new ArrayList<Permutation>();
        Backtracker counter = new Backtracker(){

            @Override
            public void applyTo(Permutation p) {
                permutations.add(p);
            }

            @Override
            public boolean isFinished() {
                return false;
            }
        };
        this.apply(counter);
        return permutations;
    }

    public void changeBase(Permutation newBase) {
        Permutation g2;
        int a;
        int firstDiffIndex;
        int j;
        PermutationGroup h2 = new PermutationGroup(newBase);
        for (j = firstDiffIndex = this.base.firstIndexOfDifference(newBase); j < this.size; ++j) {
            for (a = 0; a < this.size; ++a) {
                g2 = this.permutations[j][a];
                if (g2 == null) continue;
                h2.enter(g2);
            }
        }
        for (j = 0; j < firstDiffIndex; ++j) {
            for (a = 0; a < this.size; ++a) {
                g2 = this.permutations[j][a];
                if (g2 == null) continue;
                int hj = h2.base.get(j);
                int x = g2.get(hj);
                h2.permutations[j][x] = new Permutation(g2);
            }
        }
        this.base = new Permutation(h2.base);
        this.permutations = (Permutation[][])h2.permutations.clone();
    }

    public void enter(Permutation g2) {
        int deg = this.size;
        int i = this.test(g2);
        if (i == deg) {
            return;
        }
        this.permutations[i][g2.get((int)this.base.get((int)i))] = new Permutation(g2);
        for (int j = 0; j <= i; ++j) {
            for (int a = 0; a < deg; ++a) {
                Permutation h2 = this.permutations[j][a];
                if (h2 == null) continue;
                Permutation f = g2.multiply(h2);
                this.enter(f);
            }
        }
    }

    public int test(Permutation permutation) {
        for (int i = 0; i < this.size; ++i) {
            int x = permutation.get(this.base.get(i));
            Permutation h2 = this.permutations[i][x];
            if (h2 == null) {
                return i;
            }
            permutation.setTo(h2.invert().multiply(permutation));
        }
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Base = ").append(this.base).append('\n');
        for (int i = 0; i < this.size; ++i) {
            sb.append('U').append(i).append(" = ");
            for (int j = 0; j < this.size; ++j) {
                sb.append(this.permutations[i][j]).append(' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static interface Backtracker {
        public void applyTo(Permutation var1);

        public boolean isFinished();
    }
}

