/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.HINFormat;
import org.openscience.cdk.io.formats.IResourceFormat;

public class HINReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public HINReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public HINReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public HINReader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return HINFormat.getInstance();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IChemFile.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private String getMolName(String line) {
        if (line == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        int ntok = st.countTokens();
        String[] toks = new String[ntok];
        for (int j = 0; j < ntok; ++j) {
            toks[j] = st.nextToken();
        }
        if (toks.length == 3) {
            return toks[2];
        }
        return "";
    }

    private IChemFile readChemFile(IChemFile file) {
        IChemSequence chemSequence = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet setOfMolecules = file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        ArrayList<String> aroringText = new ArrayList<String>();
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        try {
            String line;
            while (!(line = this.input.readLine()).startsWith("mol")) {
            }
            String info = this.getMolName(line);
            line = this.input.readLine();
            while (line != null) {
                if (line.startsWith(";")) continue;
                if (line.startsWith("mol")) {
                    info = this.getMolName(line);
                    line = this.input.readLine();
                }
                IAtomContainer m3 = file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                m3.setTitle(info);
                ArrayList cons = new ArrayList();
                int atomSerial = 0;
                while (line != null && !line.contains("endmol")) {
                    if (line.startsWith(";")) continue;
                    StringTokenizer tokenizer = new StringTokenizer(line, " ");
                    int ntoken = tokenizer.countTokens();
                    String[] stringArray = new String[ntoken];
                    for (int i = 0; i < ntoken; ++i) {
                        stringArray[i] = tokenizer.nextToken();
                    }
                    String sym2 = stringArray[3];
                    double charge = Double.parseDouble(stringArray[6]);
                    double x = Double.parseDouble(stringArray[7]);
                    double y = Double.parseDouble(stringArray[8]);
                    double z = Double.parseDouble(stringArray[9]);
                    int nbond = Integer.parseInt(stringArray[10]);
                    IAtom atom = file.getBuilder().newInstance(IAtom.class, sym2, new Point3d(x, y, z));
                    atom.setCharge(charge);
                    IBond.Order bo = IBond.Order.SINGLE;
                    for (int j = 11; j < 11 + nbond * 2; j += 2) {
                        int s2 = Integer.parseInt(stringArray[j]) - 1;
                        char bt = stringArray[j + 1].charAt(0);
                        switch (bt) {
                            case 's': {
                                bo = IBond.Order.SINGLE;
                                break;
                            }
                            case 'd': {
                                bo = IBond.Order.DOUBLE;
                                break;
                            }
                            case 't': {
                                bo = IBond.Order.TRIPLE;
                                break;
                            }
                            case 'a': {
                                bo = IBond.Order.QUADRUPLE;
                            }
                        }
                        ArrayList<Object> ar = new ArrayList<Object>(3);
                        ar.add(atomSerial);
                        ar.add(s2);
                        ar.add((Object)bo);
                        cons.add(ar);
                    }
                    m3.addAtom(atom);
                    ++atomSerial;
                    line = this.input.readLine();
                }
                for (List list : cons) {
                    IAtom s3 = m3.getAtom((Integer)list.get(0));
                    IAtom e = m3.getAtom((Integer)list.get(1));
                    IBond.Order bo = (IBond.Order)((Object)list.get(2));
                    if (this.isConnected(m3, s3, e)) continue;
                    m3.addBond(file.getBuilder().newInstance(IBond.class, new Object[]{s3, e, bo}));
                }
                mols.add(m3);
                while ((line = this.input.readLine()) != null && !line.startsWith("mol")) {
                    if (!line.startsWith("aromaticring")) continue;
                    aroringText.add(line.trim());
                }
            }
        }
        catch (IOException e) {
            file = null;
        }
        if (aroringText.size() > 0) {
            for (String line : aroringText) {
                String[] toks = line.split(" ");
                int natom = Integer.parseInt(toks[1]);
                int n = 0;
                for (int i = 2; i < toks.length; i += 2) {
                    int molnum = Integer.parseInt(toks[i]);
                    int atnum = Integer.parseInt(toks[i + 1]);
                    ((IAtomContainer)mols.get(molnum - 1)).getAtom(atnum - 1).setFlag(32, true);
                    ++n;
                }
                assert (n == natom);
            }
        }
        for (IAtomContainer mol2 : mols) {
            setOfMolecules.addAtomContainer(mol2);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        file.addChemSequence(chemSequence);
        return file;
    }

    private boolean isConnected(IAtomContainer atomContainer, IAtom atom1, IAtom atom2) {
        for (IBond bond : atomContainer.bonds()) {
            if (!bond.contains(atom1) || !bond.contains(atom2)) continue;
            return true;
        }
        return false;
    }
}

