/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class MDLV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private Pattern keyValueTuple;
    private Pattern keyValueTuple2;
    private int lineNumber;

    public MDLV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
        this.keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
        this.keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
        this.lineNumber = 0;
    }

    public MDLV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineNumber = 0;
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule(object.getBuilder());
        }
        throw new CDKException("Only supports AtomContainer objects.");
    }

    public IAtomContainer readMolecule(IChemObjectBuilder builder) throws CDKException {
        return this.readConnectionTable(builder);
    }

    public IAtomContainer readConnectionTable(IChemObjectBuilder builder) throws CDKException {
        IAtomContainer readData;
        block27: {
            boolean chiral;
            block28: {
                int n;
                chiral = false;
                HashMap<Integer, Integer> stereoflags = null;
                logger.info("Reading CTAB block");
                readData = builder.newAtomContainer();
                boolean foundEND = false;
                String lastLine = this.readHeader(readData);
                while (this.isReady() && !foundEND) {
                    String command = this.readCommand(lastLine);
                    logger.debug("command found: " + command);
                    if ("END CTAB".equals(command)) {
                        foundEND = true;
                    } else if (!"BEGIN CTAB".equals(command)) {
                        if (command.startsWith("COUNTS ")) {
                            String[] counts = command.split(" ");
                            chiral = counts.length >= 6 && counts[5].equals("1");
                        } else if ("BEGIN ATOM".equals(command)) {
                            this.readAtomBlock(readData);
                        } else if ("BEGIN BOND".equals(command)) {
                            this.readBondBlock(readData);
                        } else if ("BEGIN SGROUP".equals(command)) {
                            this.readSGroup(readData);
                        } else if ("BEGIN COLLECTION".equals(command)) {
                            if (stereoflags == null) {
                                stereoflags = new HashMap<Integer, Integer>();
                            }
                            this.readCollection(readData, stereoflags);
                        } else {
                            logger.warn("Unrecognized command: " + command);
                        }
                    }
                    lastLine = this.readLine();
                }
                boolean isQuery = readData instanceof IQueryAtomContainer;
                for (IAtom iAtom : readData.atoms()) {
                    int valence = 0;
                    for (IBond bond : readData.getConnectedBondsList(iAtom)) {
                        if (bond instanceof IQueryBond || bond.getOrder() == IBond.Order.UNSET) {
                            valence = -1;
                            break;
                        }
                        valence += bond.getOrder().numeric().intValue();
                    }
                    if (valence < 0) {
                        isQuery = true;
                        logger.warn("Cannot set valence for atom with query bonds");
                        continue;
                    }
                    int unpaired = readData.getConnectedSingleElectronsCount(iAtom);
                    this.applyMDLValenceModel(iAtom, valence + unpaired, unpaired);
                }
                if (isQuery) break block27;
                boolean is3d = true;
                for (IAtom atom : readData.atoms()) {
                    if (atom.getPoint3d() != null) continue;
                    is3d = false;
                }
                if (is3d) {
                    readData.setStereoElements(StereoElementFactory.using3DCoordinates(readData).createAll());
                } else {
                    readData.setStereoElements(StereoElementFactory.using2DCoordinates(readData).createAll());
                }
                if (stereoflags == null || stereoflags.isEmpty()) break block28;
                boolean bl = false;
                if (!chiral) {
                    int max = 0;
                    for (Integer val : stereoflags.values()) {
                        int num;
                        if ((val & 0x30000) != 65536 || (num = val >>> 18) <= max) continue;
                        max = num;
                    }
                    n = 0x10000 | max + 1 << 18;
                }
                for (IStereoElement se : readData.stereoElements()) {
                    IAtom focus;
                    int idx;
                    if (se.getConfigClass() != 16896 || (idx = readData.indexOf(focus = (IAtom)se.getFocus())) < 0) continue;
                    Integer grpinfo = (Integer)stereoflags.get(idx);
                    if (grpinfo != null) {
                        se.setGroupInfo(grpinfo);
                        continue;
                    }
                    if (chiral) continue;
                    se.setGroupInfo(n);
                }
                break block27;
            }
            if (chiral) break block27;
            for (IStereoElement se : readData.stereoElements()) {
                if (se.getConfigClass() != 16896) continue;
                se.setGroupInfo(327680);
            }
        }
        return readData;
    }

    boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private void parseStereoGroup(Map<Integer, Integer> flags, String str, int type) {
        char ch;
        int i;
        int len = str.length();
        int num = 0;
        for (i = "MDLV30/STE???".length(); i < len && this.isDigit(ch = str.charAt(i)); ++i) {
            num = 10 * num + (ch - 48);
        }
        type |= num << 18;
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        if (str.startsWith("ATOMS=(", i)) {
            i += "ATOMS=(".length();
        }
        while (i < len && this.isDigit(str.charAt(i))) {
            ++i;
        }
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        while (i < len) {
            int val = 0;
            while (i < len && this.isDigit(ch = str.charAt(i))) {
                val = 10 * val + (ch - 48);
                ++i;
            }
            if (val > 0) {
                flags.put(val - 1, type);
            }
            while (i < len && str.charAt(i) == ' ') {
                ++i;
            }
            if (i >= len || str.charAt(i) != ')') continue;
            break;
        }
    }

    private void readCollection(IAtomContainer mol2, Map<Integer, Integer> flags) throws CDKException {
        String command;
        String line;
        while ((line = this.readLine()) != null && !(command = this.readCommand(line)).startsWith("END COLLECTION")) {
            if (command.startsWith("MDLV30/STERAC")) {
                this.parseStereoGroup(flags, command, 65536);
                continue;
            }
            if (command.startsWith("MDLV30/STEREL")) {
                this.parseStereoGroup(flags, command, 131072);
                continue;
            }
            if (!command.startsWith("MDLV30/STEABS")) continue;
            this.parseStereoGroup(flags, command, 0);
        }
    }

    public String readHeader(IAtomContainer readData) throws CDKException {
        String line4;
        String line1 = this.readLine();
        if (line1 == null) {
            throw new CDKException("Expected a header line, but found nothing.");
        }
        if (line1.length() > 0) {
            if (line1.startsWith("M  V30")) {
                return line1;
            }
            readData.setTitle(line1);
        }
        this.readLine();
        String line3 = this.readLine();
        if (line3.length() > 0) {
            readData.setProperty("cdk:Comment", line3);
        }
        if (!(line4 = this.readLine()).contains("3000")) {
            throw new CDKException("This file is not a MDL V3000 molfile.");
        }
        return this.readLine();
    }

    public void readAtomBlock(IAtomContainer readData) throws CDKException {
        Isotopes isotopeFactory;
        logger.info("Reading ATOM block");
        try {
            isotopeFactory = Isotopes.getInstance();
        }
        catch (IOException exception) {
            throw new CDKException("Could not initiate the IsotopeFactory.", exception);
        }
        int RGroupCounter = 1;
        int Rnumber = 0;
        String[] rGroup = null;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing atom from: " + command);
            IAtom atom = readData.getBuilder().newAtom();
            StringTokenizer tokenizer = new StringTokenizer(command);
            try {
                atom.setID(tokenizer.nextToken());
            }
            catch (Exception exception) {
                String error = "Error while parsing atom index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            String element = tokenizer.nextToken();
            if (isotopeFactory.isElement(element)) {
                atom.setSymbol(element);
                isotopeFactory.configure(atom);
            } else if ("A".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("Q".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("*".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("LP".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("L".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if (element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    try {
                        RGroupCounter = Rnumber = Integer.valueOf(rGroup[rGroup.length - 1]).intValue();
                    }
                    catch (Exception ex) {
                        Rnumber = RGroupCounter++;
                    }
                    element = "R" + Rnumber;
                }
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                }
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
                atom.setSymbol(element);
            }
            try {
                String xString = tokenizer.nextToken();
                String yString = tokenizer.nextToken();
                String zString = tokenizer.nextToken();
                double x = Double.parseDouble(xString);
                double y = Double.parseDouble(yString);
                double z = Double.parseDouble(zString);
                atom.setPoint3d(new Point3d(x, y, z));
                atom.setPoint2d(new Point2d(x, y));
            }
            catch (Exception exception) {
                String error = "Error while parsing atom coordinates";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                logger.warn("Skipping atom-atom mapping: " + mapping);
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block23: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CHG": {
                                int charge = Integer.parseInt(value);
                                if (charge == 0) continue block23;
                                atom.setFormalCharge(charge);
                                break;
                            }
                            case "RAD": {
                                MDLV2000Writer.SPIN_MULTIPLICITY spinMultiplicity = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(Integer.parseInt(value));
                                int numElectons = spinMultiplicity.getSingleElectrons();
                                atom.setProperty("cdk:SpinMultiplicity", (Object)spinMultiplicity);
                                while (numElectons-- > 0) {
                                    readData.addSingleElectron(readData.getBuilder().newInstance(ISingleElectron.class, atom));
                                }
                                continue block23;
                            }
                            case "VAL": {
                                if (!(atom instanceof IPseudoAtom)) {
                                    try {
                                        int valence = Integer.parseInt(value);
                                        if (valence == 0) continue block23;
                                        if (valence == 15) {
                                            atom.setValency(0);
                                            break;
                                        }
                                        atom.setValency(valence);
                                    }
                                    catch (Exception exception) {
                                        this.handleError("Could not parse valence information field", this.lineNumber, 0, 0, exception);
                                    }
                                    break;
                                }
                                logger.error("Cannot set valence information for a non-element!");
                                break;
                            }
                            default: {
                                logger.warn("Not parsing key: " + key);
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error);
                        logger.debug(exception);
                        throw new CDKException(error, exception);
                    }
                }
            }
            readData.addAtom(atom);
            logger.debug("Added atom: " + atom);
        }
    }

    public void readBondBlock(IAtomContainer readData) throws CDKException {
        logger.info("Reading BOND block");
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String error;
            String command = this.readCommand(this.readLine());
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing bond from: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            IBond bond = readData.getBuilder().newBond();
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            try {
                String orderString = tokenizer.nextToken();
                int order = Integer.parseInt(orderString);
                if (order >= 4) {
                    bond.setOrder(IBond.Order.UNSET);
                    logger.warn("Query order types are not supported (yet). File a bug if you need it");
                } else {
                    bond.setOrder(BondManipulator.createBondOrder(order));
                }
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                IAtom atom1 = readData.getAtom(indexAtom1 - 1);
                bond.setAtom(atom1, 0);
            }
            catch (Exception exception) {
                String error2 = "Error while parsing index atom 1 in bond";
                logger.error(error2);
                logger.debug(exception);
                throw new CDKException(error2, exception);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                IAtom atom2 = readData.getAtom(indexAtom2 - 1);
                bond.setAtom(atom2, 1);
            }
            catch (Exception exception) {
                String error3 = "Error while parsing index atom 2 in bond";
                logger.error(error3);
                logger.debug(exception);
                throw new CDKException(error3, exception);
            }
            ArrayList<IAtom> endpts = new ArrayList<IAtom>();
            String attach = null;
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block21: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CFG": {
                                int configuration = Integer.parseInt(value);
                                if (configuration == 0) {
                                    bond.setStereo(IBond.Stereo.NONE);
                                    break;
                                }
                                if (configuration == 1) {
                                    bond.setStereo(IBond.Stereo.UP);
                                    break;
                                }
                                if (configuration == 2) {
                                    bond.setStereo(IBond.Stereo.UP_OR_DOWN);
                                    break;
                                }
                                if (configuration != 3) continue block21;
                                bond.setStereo(IBond.Stereo.DOWN);
                                break;
                            }
                            case "ENDPTS": {
                                String[] endptStr = value.split(" ");
                                for (int i = 1; i < endptStr.length; ++i) {
                                    endpts.add(readData.getAtom(Integer.parseInt(endptStr[i]) - 1));
                                }
                                continue block21;
                            }
                            case "ATTACH": {
                                attach = value;
                                break;
                            }
                            default: {
                                logger.warn("Not parsing key: " + key);
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error4 = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error4);
                        logger.debug(exception);
                        throw new CDKException(error4, exception);
                    }
                }
            }
            readData.addBond(bond);
            if ("ANY".equals(attach)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                sgroup.addAtom(bond.getBegin());
                sgroup.addBond(bond);
                for (IAtom endpt : endpts) {
                    sgroup.addAtom(endpt);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty("cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>(4);
                    readData.setProperty("cdk:CtabSgroups", sgroups);
                }
                sgroups.add(sgroup);
            }
            logger.debug("Added bond: " + bond);
        }
    }

    public void readSGroup(IAtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing Sgroup line: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            logger.warn("Skipping external index: " + indexString);
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            logger.warn("Skipping external index: " + externalIndexString);
            Map<Object, Object> options = new Hashtable();
            if (command.indexOf(61) != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            Sgroup sgroup = new Sgroup();
            if (type.startsWith("SUP")) {
                sgroup.setType(SgroupType.CtabAbbreviation);
                Iterator<Object> keys = options.keySet().iterator();
                String label = "";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = (String)options.get(key);
                    try {
                        int nExpected;
                        if (key.equals("ATOMS")) {
                            StringTokenizer atomsTokenizer = new StringTokenizer(value);
                            nExpected = Integer.parseInt(atomsTokenizer.nextToken());
                            while (atomsTokenizer.hasMoreTokens()) {
                                sgroup.addAtom(readData.getAtom(Integer.parseInt(atomsTokenizer.nextToken()) - 1));
                            }
                        } else if (key.equals("XBONDS")) {
                            StringTokenizer xbonds = new StringTokenizer(value);
                            nExpected = Integer.parseInt(xbonds.nextToken());
                            while (xbonds.hasMoreTokens()) {
                                sgroup.addBond(readData.getBond(Integer.parseInt(xbonds.nextToken()) - 1));
                            }
                        } else if (key.equals("LABEL")) {
                            label = value;
                        } else {
                            logger.warn("Not parsing key: " + key);
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error);
                        logger.debug(exception);
                        throw new CDKException(error, exception);
                    }
                    if (sgroup.getAtoms().isEmpty() || label.length() <= 0) continue;
                    sgroup.setSubscript(label);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty("cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>();
                }
                sgroups.add(sgroup);
                readData.setProperty("cdk:CtabSgroups", sgroups);
                continue;
            }
            logger.warn("Skipping unrecognized SGROUP type: " + type);
        }
    }

    private String readCommand(String line) throws CDKException {
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand(this.readLine());
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Map<String, String> parseOptions(String string) throws CDKException {
        Hashtable<String, String> keyValueTuples = new Hashtable<String, String>();
        while (string.length() >= 3) {
            logger.debug("Matching remaining option string: " + string);
            Matcher tuple1Matcher = this.keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                logger.debug("Found key: " + key);
                logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = this.keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                logger.debug("Found key: " + key);
                logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            logger.warn("Quiting; could not parse: " + string + ".");
            string = "";
        }
        return keyValueTuples;
    }

    public String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(' ');
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String readLine() throws CDKException {
        String line = null;
        try {
            line = this.input.readLine();
            ++this.lineNumber;
            logger.debug("read line " + this.lineNumber + ":", line);
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return line;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(atom.getValency() - (explicitValence - unpaired));
            } else {
                atom.setImplicitHydrogenCount(0);
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(explicitValence);
                atom.setImplicitHydrogenCount(0);
            } else {
                atom.setValency(implicitValence);
                atom.setImplicitHydrogenCount(implicitValence - explicitValence);
            }
        }
    }
}

