/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CDKOWLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.jena.Convertor;

public class CDKOWLWriter
extends DefaultChemObjectWriter {
    private Writer output;

    public CDKOWLWriter(Writer output) {
        this.output = output;
    }

    public CDKOWLWriter() {
        this.output = null;
    }

    @Override
    public IResourceFormat getFormat() {
        return CDKOWLFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.output = out;
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.output = new OutputStreamWriter(output);
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                this.writeMolecule((IAtomContainer)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing HIN file: " + ex.getMessage(), ex);
            }
        } else {
            throw new CDKException("CDKOWLWriter only supports output of IAtomContainer classes.");
        }
    }

    private void writeMolecule(IAtomContainer mol2) {
        Model model = Convertor.molecule2Model(mol2);
        model.write(this.output, "N3");
    }
}

