/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class LongestAliphaticChainDescriptor
extends AbstractMolecularDescriptor {
    public static final String CHECK_RING_SYSTEM = "checkRingSystem";
    private boolean checkRingSystem = false;
    private static final String[] NAMES = new String[]{"nAtomLAC"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#longestAliphaticChain", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("LongestAliphaticChainDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Expected parameter of type " + Boolean.class);
        }
        this.checkRingSystem = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkRingSystem};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    private static boolean isAcyclicCarbon(IAtom atom) {
        return atom.getAtomicNumber() == 6 && !atom.isInRing();
    }

    private static int getMaxDepth(int[][] adjlist, int v, int prev) {
        int longest = 0;
        for (int w : adjlist[v]) {
            int length;
            if (w == prev || (length = LongestAliphaticChainDescriptor.getMaxDepth(adjlist, w, v)) <= longest) continue;
            longest = length;
        }
        return 1 + longest;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer mol2) {
        if (this.checkRingSystem) {
            Cycles.markRingAtomsAndBonds(mol2);
        }
        IAtomContainer aliphaticParts = mol2.getBuilder().newAtomContainer();
        for (IAtom atom : mol2.atoms()) {
            if (!LongestAliphaticChainDescriptor.isAcyclicCarbon(atom)) continue;
            aliphaticParts.addAtom(atom);
        }
        for (IBond bond : mol2.bonds()) {
            if (!LongestAliphaticChainDescriptor.isAcyclicCarbon(bond.getBegin()) || !LongestAliphaticChainDescriptor.isAcyclicCarbon(bond.getEnd())) continue;
            aliphaticParts.addBond(bond);
        }
        int longest = 0;
        int[][] adjlist = GraphUtil.toAdjList(aliphaticParts);
        for (int i = 0; i < adjlist.length; ++i) {
            int length;
            if (adjlist[i].length != 1 || (length = LongestAliphaticChainDescriptor.getMaxDepth(adjlist, i, -1)) <= longest) continue;
            longest = length;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(longest), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{CHECK_RING_SYSTEM};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if (name.equals(CHECK_RING_SYSTEM)) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("No parameter for name: " + name);
    }
}

