/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class WHIMDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    static ILoggingTool logger = LoggingToolFactory.createLoggingTool(WHIMDescriptor.class);
    String type = "unity";
    Map<String, Double> hashatwt = new HashMap<String, Double>();
    Map<String, Double> hashvdw = new HashMap<String, Double>();
    Map<String, Double> hasheneg = new HashMap<String, Double>();
    Map<String, Double> hashpol = new HashMap<String, Double>();

    public WHIMDescriptor() {
        this.hashatwt.put("H", new Double(0.084));
        this.hashatwt.put("B", new Double(0.9));
        this.hashatwt.put("C", new Double(1.0));
        this.hashatwt.put("N", new Double(1.166));
        this.hashatwt.put("O", new Double(1.332));
        this.hashatwt.put("F", new Double(1.582));
        this.hashatwt.put("Al", new Double(2.246));
        this.hashatwt.put("Si", new Double(2.339));
        this.hashatwt.put("P", new Double(2.579));
        this.hashatwt.put("S", new Double(2.67));
        this.hashatwt.put("Cl", new Double(2.952));
        this.hashatwt.put("Fe", new Double(4.65));
        this.hashatwt.put("Co", new Double(4.907));
        this.hashatwt.put("Ni", new Double(4.887));
        this.hashatwt.put("Cu", new Double(5.291));
        this.hashatwt.put("Zn", new Double(5.445));
        this.hashatwt.put("Br", new Double(6.653));
        this.hashatwt.put("Sn", new Double(9.884));
        this.hashatwt.put("I", new Double(10.566));
        this.hashvdw.put("H", new Double(0.299));
        this.hashvdw.put("B", new Double(0.796));
        this.hashvdw.put("C", new Double(1.0));
        this.hashvdw.put("N", new Double(0.695));
        this.hashvdw.put("O", new Double(0.512));
        this.hashvdw.put("F", new Double(0.41));
        this.hashvdw.put("Al", new Double(1.626));
        this.hashvdw.put("Si", new Double(1.424));
        this.hashvdw.put("P", new Double(1.181));
        this.hashvdw.put("S", new Double(1.088));
        this.hashvdw.put("Cl", new Double(1.035));
        this.hashvdw.put("Fe", new Double(1.829));
        this.hashvdw.put("Co", new Double(1.561));
        this.hashvdw.put("Ni", new Double(0.764));
        this.hashvdw.put("Cu", new Double(0.512));
        this.hashvdw.put("Zn", new Double(1.708));
        this.hashvdw.put("Br", new Double(1.384));
        this.hashvdw.put("Sn", new Double(2.042));
        this.hashvdw.put("I", new Double(1.728));
        this.hasheneg.put("H", new Double(0.944));
        this.hasheneg.put("B", new Double(0.828));
        this.hasheneg.put("C", new Double(1.0));
        this.hasheneg.put("N", new Double(1.163));
        this.hasheneg.put("O", new Double(1.331));
        this.hasheneg.put("F", new Double(1.457));
        this.hasheneg.put("Al", new Double(0.624));
        this.hasheneg.put("Si", new Double(0.779));
        this.hasheneg.put("P", new Double(0.916));
        this.hasheneg.put("S", new Double(1.077));
        this.hasheneg.put("Cl", new Double(1.265));
        this.hasheneg.put("Fe", new Double(0.728));
        this.hasheneg.put("Co", new Double(0.728));
        this.hasheneg.put("Ni", new Double(0.728));
        this.hasheneg.put("Cu", new Double(0.74));
        this.hasheneg.put("Zn", new Double(0.81));
        this.hasheneg.put("Br", new Double(1.172));
        this.hasheneg.put("Sn", new Double(0.837));
        this.hasheneg.put("I", new Double(1.012));
        this.hashpol.put("H", new Double(0.379));
        this.hashpol.put("B", new Double(1.722));
        this.hashpol.put("C", new Double(1.0));
        this.hashpol.put("N", new Double(0.625));
        this.hashpol.put("O", new Double(0.456));
        this.hashpol.put("F", new Double(0.316));
        this.hashpol.put("Al", new Double(3.864));
        this.hashpol.put("Si", new Double(3.057));
        this.hashpol.put("P", new Double(2.063));
        this.hashpol.put("S", new Double(1.648));
        this.hashpol.put("Cl", new Double(1.239));
        this.hashpol.put("Fe", new Double(4.773));
        this.hashpol.put("Co", new Double(4.261));
        this.hashpol.put("Ni", new Double(3.864));
        this.hashpol.put("Cu", new Double(3.466));
        this.hashpol.put("Zn", new Double(4.034));
        this.hashpol.put("Br", new Double(1.733));
        this.hashpol.put("Sn", new Double(4.375));
        this.hashpol.put("I", new Double(3.04));
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#WHIM", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("WHIMDescriptor requires 1 parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("Parameters must be of type String");
        }
        this.type = (String)params[0];
        if (!(this.type.equals("unity") || this.type.equals("mass") || this.type.equals("volume") || this.type.equals("eneg") || this.type.equals("polar"))) {
            throw new CDKException("Weighting scheme must be one of those specified in the API");
        }
    }

    @Override
    public Object[] getParameters() {
        Object[] o = new Object[]{this.type};
        return o;
    }

    @Override
    public String[] getDescriptorNames() {
        String[] names = new String[]{"Wlambda1", "Wlambda2", "Wlambda3", "Wnu1", "Wnu2", "Wgamma1", "Wgamma2", "Wgamma3", "Weta1", "Weta2", "Weta3", "WT", "WA", "WV", "WK", "WG", "WD"};
        int i = 0;
        while (i < names.length) {
            int n = i++;
            names[n] = names[n] + "." + this.type;
        }
        return names;
    }

    @Override
    public String[] getParameterNames() {
        String[] pname = new String[]{"type"};
        return pname;
    }

    @Override
    public Object getParameterType(String name) {
        return "";
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        int i;
        int i2;
        int i3;
        int i4;
        IAtomContainer ac;
        if (!GeometryUtil.has3DCoordinates(container)) {
            return this.getDummyDescriptorValue(new CDKException("Molecule must have 3D coordinates"));
        }
        double sum = 0.0;
        try {
            ac = container.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        double[][] cmat = new double[ac.getAtomCount()][3];
        for (int i5 = 0; i5 < ac.getAtomCount(); ++i5) {
            Point3d coords = ac.getAtom(i5).getPoint3d();
            cmat[i5][0] = coords.x;
            cmat[i5][1] = coords.y;
            cmat[i5][2] = coords.z;
        }
        Map<String, Double> hash = null;
        double[] wt = new double[ac.getAtomCount()];
        if (this.type.equals("unity")) {
            for (i4 = 0; i4 < ac.getAtomCount(); ++i4) {
                wt[i4] = 1.0;
            }
        } else {
            if (this.type.equals("mass")) {
                hash = this.hashatwt;
            } else if (this.type.equals("volume")) {
                hash = this.hashvdw;
            } else if (this.type.equals("eneg")) {
                hash = this.hasheneg;
            } else if (this.type.equals("polar")) {
                hash = this.hashpol;
            }
            for (i4 = 0; i4 < ac.getAtomCount(); ++i4) {
                String sym2 = ac.getAtom(i4).getSymbol();
                wt[i4] = hash.get(sym2);
            }
        }
        PCA pcaobject = null;
        try {
            pcaobject = new PCA(cmat, wt);
        }
        catch (CDKException cdke) {
            logger.debug(cdke);
        }
        double[] lambda = pcaobject.getEigenvalues();
        double[] gamma = new double[3];
        double[] nu = new double[3];
        double[] eta = new double[3];
        for (i3 = 0; i3 < 3; ++i3) {
            sum += lambda[i3];
        }
        for (i3 = 0; i3 < 3; ++i3) {
            nu[i3] = lambda[i3] / sum;
        }
        double[][] scores = pcaobject.getScores();
        for (i2 = 0; i2 < 3; ++i2) {
            sum = 0.0;
            for (int j = 0; j < ac.getAtomCount(); ++j) {
                sum += scores[j][i2] * scores[j][i2] * scores[j][i2] * scores[j][i2];
            }
            eta[i2] = 1.0 / (sum /= lambda[i2] * lambda[i2] * (double)ac.getAtomCount());
        }
        for (i2 = 0; i2 < 3; ++i2) {
            double ns = 0.0;
            double na = 0.0;
            for (int j = 0; j < ac.getAtomCount(); ++j) {
                boolean foundmatch = false;
                for (int k = 0; k < ac.getAtomCount(); ++k) {
                    if (k == j || scores[j][i2] != -1.0 * scores[k][i2]) continue;
                    ns += 1.0;
                    foundmatch = true;
                    break;
                }
                if (foundmatch) continue;
                na += 1.0;
            }
            double n = ac.getAtomCount();
            gamma[i2] = -1.0 * (ns / n * Math.log(ns / n) / Math.log(2.0) + na / n * Math.log(1.0 / n) / Math.log(2.0));
            gamma[i2] = 1.0 / (1.0 + gamma[i2]);
        }
        double t = lambda[0] + lambda[1] + lambda[2];
        double a = lambda[0] * lambda[1] + lambda[0] * lambda[2] + lambda[1] * lambda[2];
        double v = t + a + lambda[0] * lambda[1] * lambda[2];
        double k = 0.0;
        sum = 0.0;
        for (i = 0; i < 3; ++i) {
            sum += lambda[i];
        }
        for (i = 0; i < 3; ++i) {
            k = lambda[i] / sum - 0.3333333333333333;
        }
        k /= 1.3333333333333333;
        double g2 = Math.pow(gamma[0] * gamma[1] * gamma[2], 0.3333333333333333);
        double d = eta[0] + eta[1] + eta[2];
        DoubleArrayResult retval = new DoubleArrayResult(17);
        retval.add(lambda[0]);
        retval.add(lambda[1]);
        retval.add(lambda[2]);
        retval.add(nu[0]);
        retval.add(nu[1]);
        retval.add(gamma[0]);
        retval.add(gamma[1]);
        retval.add(gamma[2]);
        retval.add(eta[0]);
        retval.add(eta[1]);
        retval.add(eta[2]);
        retval.add(t);
        retval.add(a);
        retval.add(v);
        retval.add(k);
        retval.add(g2);
        retval.add(d);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(17);
    }

    class PCA {
        Matrix evec;
        Matrix t;
        double[] eval;

        public PCA(double[][] cmat, double[] wt) throws CDKException {
            int i;
            int i2;
            int ncol = 3;
            int nrow = wt.length;
            if (cmat.length != wt.length) {
                throw new CDKException("WHIMDescriptor: number of weights should be equal to number of atoms");
            }
            double[][] d = new double[nrow][ncol];
            for (i2 = 0; i2 < nrow; ++i2) {
                for (int j = 0; j < ncol; ++j) {
                    d[i2][j] = cmat[i2][j];
                }
            }
            for (i2 = 0; i2 < ncol; ++i2) {
                int j;
                double mean = 0.0;
                for (j = 0; j < nrow; ++j) {
                    mean += d[j][i2];
                }
                mean /= (double)nrow;
                for (j = 0; j < nrow; ++j) {
                    d[j][i2] = d[j][i2] - mean;
                }
            }
            double[][] covmat = new double[ncol][ncol];
            double sumwt = 0.0;
            for (i = 0; i < nrow; ++i) {
                sumwt += wt[i];
            }
            for (i = 0; i < ncol; ++i) {
                double meanx = 0.0;
                for (int k = 0; k < nrow; ++k) {
                    meanx += d[k][i];
                }
                meanx /= (double)nrow;
                for (int j = 0; j < ncol; ++j) {
                    double meany = 0.0;
                    for (int k = 0; k < nrow; ++k) {
                        meany += d[k][j];
                    }
                    meany /= (double)nrow;
                    double sum = 0.0;
                    for (int k = 0; k < nrow; ++k) {
                        sum += wt[k] * (d[k][i] - meanx) * (d[k][j] - meany);
                    }
                    covmat[i][j] = sum / sumwt;
                }
            }
            Matrix m3 = new Matrix(covmat);
            EigenvalueDecomposition ed = m3.eig();
            this.eval = ed.getRealEigenvalues();
            this.evec = ed.getV();
            Matrix x = new Matrix(d);
            this.t = x.times(this.evec);
        }

        double[] getEigenvalues() {
            return this.eval;
        }

        double[][] getScores() {
            return this.t.getArray();
        }
    }
}

