/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;

public final class MarkedElement
implements IRenderingElement {
    public static final String ID_KEY = MarkedElement.class.getName() + "_ID";
    public static final String CLASS_KEY = MarkedElement.class.getName() + "_CLS";
    final IRenderingElement elem;
    private String id;
    private final List<String> classes = new ArrayList<String>(5);

    private MarkedElement(IRenderingElement elem) {
        this.elem = elem;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void aggClass(String cls) {
        if (cls != null) {
            this.classes.add(cls);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    @Override
    public void accept(IRenderingVisitor visitor) {
        visitor.visit(this);
    }

    public IRenderingElement element() {
        return this.elem;
    }

    public static MarkedElement markup(IRenderingElement elem, String ... classes) {
        assert (elem != null);
        MarkedElement tagElem = new MarkedElement(elem);
        for (String cls : classes) {
            tagElem.aggClass(cls);
        }
        return tagElem;
    }

    private static MarkedElement markupChemObj(IRenderingElement elem, IChemObject chemObj) {
        assert (elem != null);
        MarkedElement tagElem = new MarkedElement(elem);
        if (chemObj != null) {
            tagElem.setId(chemObj.getProperty(ID_KEY, String.class));
            tagElem.aggClass(chemObj.getProperty(CLASS_KEY, String.class));
        }
        return tagElem;
    }

    public static MarkedElement markupMol(IRenderingElement elem, IAtomContainer mol2) {
        assert (elem != null);
        MarkedElement tagElem = MarkedElement.markupChemObj(elem, mol2);
        tagElem.aggClass("mol");
        return tagElem;
    }

    public static MarkedElement markupAtom(IRenderingElement elem, IAtom atom) {
        if (elem == null) {
            return null;
        }
        MarkedElement tagElem = MarkedElement.markupChemObj(elem, atom);
        tagElem.aggClass("atom");
        return tagElem;
    }

    public static MarkedElement markupBond(IRenderingElement elem, IBond bond) {
        assert (elem != null);
        MarkedElement tagElem = MarkedElement.markupChemObj(elem, bond);
        tagElem.aggClass("bond");
        return tagElem;
    }
}

