/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.smiles.CDKToBeam;
import org.openscience.cdk.smiles.CxSmilesGenerator;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.smiles.SmiFlavor;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.beam.Functions;
import uk.ac.ebi.beam.Graph;

public final class SmilesGenerator {
    private final int flavour;

    @Deprecated
    public SmilesGenerator() {
        this(12551944);
    }

    public SmilesGenerator(int flavour) {
        this.flavour = flavour;
    }

    public SmilesGenerator aromatic() {
        return new SmilesGenerator(this.flavour | 0x10);
    }

    @Deprecated
    public SmilesGenerator withAtomClasses() {
        return new SmilesGenerator(this.flavour | 4);
    }

    public static SmilesGenerator generic() {
        return new SmilesGenerator(0);
    }

    public static SmilesGenerator isomeric() {
        return new SmilesGenerator(1800);
    }

    public static SmilesGenerator unique() {
        return new SmilesGenerator(1);
    }

    public static SmilesGenerator absolute() {
        return new SmilesGenerator(1801);
    }

    @Deprecated
    public String createSMILES(IAtomContainer molecule) {
        try {
            return this.create(molecule);
        }
        catch (CDKException e) {
            throw new IllegalArgumentException("SMILES could not be generated, please use the new API method 'create()'to catch the checked exception", e);
        }
    }

    @Deprecated
    public String createSMILES(IReaction reaction) {
        try {
            return this.createReactionSMILES(reaction);
        }
        catch (CDKException e) {
            throw new IllegalArgumentException("SMILES could not be generated, please use the new API method 'create()'to catch the checked exception", e);
        }
    }

    public String create(IAtomContainer molecule) throws CDKException {
        return this.create(molecule, new int[molecule.getAtomCount()]);
    }

    public String create(IAtomContainer molecule, int[] order) throws CDKException {
        return SmilesGenerator.create(molecule, this.flavour, order);
    }

    public static String create(IAtomContainer molecule, int flavour, int[] order) throws CDKException {
        try {
            if (order.length != molecule.getAtomCount()) {
                throw new IllegalArgumentException("the array for storing output order should bethe same length as the number of atoms");
            }
            Graph g2 = CDKToBeam.toBeamGraph(molecule, flavour);
            if (SmiFlavor.isSet(flavour, 1)) {
                int[] labels = SmilesGenerator.labels(flavour, molecule);
                g2 = g2.permute(labels);
                if ((flavour & 0x2000005) == 0x2000005) {
                    g2 = Functions.renumberAtomMaps(g2);
                }
                if (!SmiFlavor.isSet(flavour, 16)) {
                    g2 = g2.resonate();
                }
                if (SmiFlavor.isSet(flavour, 512)) {
                    g2.sort(new Graph.VisitHighOrderFirst());
                    g2 = Functions.normaliseDirectionalLabels(g2);
                    g2.sort(new Graph.VisitHighOrderFirst()).sort(new Graph.VisitHydrogenFirst());
                }
                String smiles = g2.toSmiles(order);
                int[] canorder = new int[order.length];
                for (int i = 0; i < labels.length; ++i) {
                    canorder[i] = order[labels[i]];
                }
                System.arraycopy(canorder, 0, order, 0, order.length);
                if (SmiFlavor.isSet(flavour, 12562688)) {
                    smiles = smiles + CxSmilesGenerator.generate(SmilesGenerator.getCxSmilesState(flavour, molecule), flavour, null, order);
                }
                return smiles;
            }
            String smiles = g2.toSmiles(order);
            if (SmiFlavor.isSet(flavour, 12562688)) {
                smiles = smiles + CxSmilesGenerator.generate(SmilesGenerator.getCxSmilesState(flavour, molecule), flavour, null, order);
            }
            return smiles;
        }
        catch (IOException e) {
            throw new CDKException(e.getMessage());
        }
    }

    @Deprecated
    public String createReactionSMILES(IReaction reaction) throws CDKException {
        return this.create(reaction);
    }

    public String create(IReaction reaction) throws CDKException {
        return this.create(reaction, new int[ReactionManipulator.getAtomCount(reaction)]);
    }

    private void safeAddSgroups(List<Sgroup> sgroups, IAtomContainer mol2) {
        List molSgroups = (List)mol2.getProperty("cdk:CtabSgroups");
        if (molSgroups != null) {
            sgroups.addAll(molSgroups);
        }
    }

    public String create(IReaction reaction, int[] ordering) throws CDKException {
        int[] productOrder;
        int[] agentOrder;
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet agents = reaction.getAgents();
        IAtomContainerSet products = reaction.getProducts();
        IAtomContainer reactantPart = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer agentPart = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer productPart = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (IAtomContainer reactant : reactants.atomContainers()) {
            reactantPart.add(reactant);
            this.safeAddSgroups(sgroups, reactant);
        }
        for (IAtomContainer agent : agents.atomContainers()) {
            agentPart.add(agent);
            this.safeAddSgroups(sgroups, agent);
        }
        for (IAtomContainer product : products.atomContainers()) {
            productPart.add(product);
            this.safeAddSgroups(sgroups, product);
        }
        int[] reactantOrder = new int[reactantPart.getAtomCount()];
        int expectedSize = reactantOrder.length + (agentOrder = new int[agentPart.getAtomCount()]).length + (productOrder = new int[productPart.getAtomCount()]).length;
        if (expectedSize != ordering.length) {
            throw new CDKException("Output ordering array does not have correct amount of space: " + ordering.length + " expected: " + expectedSize);
        }
        String smi = SmilesGenerator.create(reactantPart, this.flavour & 0xFF404EFF, reactantOrder) + ">" + SmilesGenerator.create(agentPart, this.flavour & 0xFF404EFF, agentOrder) + ">" + SmilesGenerator.create(productPart, this.flavour & 0xFF404EFF, productOrder);
        int agentBeg = reactantOrder.length;
        int agentEnd = reactantOrder.length + agentOrder.length;
        int prodEnd = reactantOrder.length + agentOrder.length + productOrder.length;
        System.arraycopy(reactantOrder, 0, ordering, 0, agentBeg);
        System.arraycopy(agentOrder, 0, ordering, agentBeg, agentEnd - agentBeg);
        System.arraycopy(productOrder, 0, ordering, agentEnd, prodEnd - agentEnd);
        int i = agentBeg;
        while (i < agentEnd) {
            int n = i++;
            ordering[n] = ordering[n] + agentBeg;
        }
        i = agentEnd;
        while (i < prodEnd) {
            int n = i++;
            ordering[n] = ordering[n] + agentEnd;
        }
        if (SmiFlavor.isSet(this.flavour, 12562688)) {
            IAtomContainer unified = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            unified.add(reactantPart);
            unified.add(agentPart);
            unified.add(productPart);
            unified.setProperty("cdk:CtabSgroups", sgroups);
            CxSmilesState cxstate = SmilesGenerator.getCxSmilesState(this.flavour, unified);
            int[] components = null;
            if (SmiFlavor.isSet(this.flavour, 0x100000)) {
                int i2;
                cxstate.fragGroups = new ArrayList<List<Integer>>();
                components = new ConnectedComponents(GraphUtil.toAdjList(unified)).components();
                HashSet<Integer> tmp = new HashSet<Integer>();
                int beg = 0;
                int end = 0;
                for (IAtomContainer mol2 : reactants.atomContainers()) {
                    end += mol2.getAtomCount();
                    tmp.clear();
                    for (i2 = beg; i2 < end; ++i2) {
                        tmp.add(components[i2]);
                    }
                    if (tmp.size() > 1) {
                        cxstate.fragGroups.add(new ArrayList(tmp));
                    }
                    beg = end;
                }
                for (IAtomContainer mol2 : agents.atomContainers()) {
                    end += mol2.getAtomCount();
                    tmp.clear();
                    for (i2 = beg; i2 < end; ++i2) {
                        tmp.add(components[i2]);
                    }
                    if (tmp.size() > 1) {
                        cxstate.fragGroups.add(new ArrayList(tmp));
                    }
                    beg = end;
                }
                for (IAtomContainer mol2 : products.atomContainers()) {
                    end += mol2.getAtomCount();
                    tmp.clear();
                    for (i2 = beg; i2 < end; ++i2) {
                        tmp.add(components[i2]);
                    }
                    if (tmp.size() > 1) {
                        cxstate.fragGroups.add(new ArrayList(tmp));
                    }
                    beg = end;
                }
            }
            smi = smi + CxSmilesGenerator.generate(cxstate, this.flavour, components, ordering);
        }
        return smi;
    }

    @Deprecated
    public void setUseAromaticityFlag(boolean useAromaticityFlag) {
    }

    private static int[] labels(int flavour, IAtomContainer molecule) throws CDKException {
        long[] labels = SmiFlavor.isSet(flavour, 1800) ? SmilesGenerator.inchiNumbers(molecule) : Canon.label(molecule, GraphUtil.toAdjList(molecule), SmilesGenerator.createComparator(molecule, flavour));
        int[] cpy = new int[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            cpy[i] = (int)labels[i] - 1;
        }
        return cpy;
    }

    private static long[] inchiNumbers(IAtomContainer container) throws CDKException {
        String cname = "org.openscience.cdk.graph.invariant.InChINumbersTools";
        String mname = "getUSmilesNumbers";
        List<IAtom> rgrps = SmilesGenerator.getRgrps(container, Elements.Rutherfordium);
        for (IAtom rgrp : rgrps) {
            rgrp.setAtomicNumber(Elements.Rutherfordium.number());
            rgrp.setSymbol(Elements.Rutherfordium.symbol());
        }
        try {
            Class<?> c = Class.forName(cname);
            Method method = c.getDeclaredMethod("getUSmilesNumbers", IAtomContainer.class);
            long[] lArray = (long[])method.invoke(c, container);
            return lArray;
        }
        catch (ClassNotFoundException e) {
            throw new CDKException("The cdk-inchi module is not loaded, this module is need when generating absolute SMILES.");
        }
        catch (NoSuchMethodException e) {
            throw new CDKException("The method " + mname + " was not found", e);
        }
        catch (InvocationTargetException e) {
            throw new CDKException("An InChI could not be generated and used to canonise SMILES: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new CDKException("Could not access method to obtain InChI numbers.");
        }
        finally {
            for (IAtom rgrp : rgrps) {
                rgrp.setAtomicNumber(Elements.Unknown.number());
                rgrp.setSymbol("*");
            }
        }
    }

    private static List<IAtom> getRgrps(IAtomContainer container, Elements reversed) {
        ArrayList<IAtom> res = new ArrayList<IAtom>();
        for (IAtom atom : container.atoms()) {
            if (atom.getAtomicNumber() == 0) {
                res.add(atom);
                continue;
            }
            if (atom.getAtomicNumber().intValue() != reversed.number()) continue;
            return Collections.emptyList();
        }
        return res;
    }

    private static Integer ensureNotNull(Integer x) {
        if (x == null) {
            throw new IllegalStateException("Inconsistent CXSMILES state! Check the SGroups.");
        }
        return x;
    }

    private static List<Integer> toAtomIdxs(Collection<IAtom> atoms, Map<IAtom, Integer> atomidx) {
        ArrayList<Integer> idxs = new ArrayList<Integer>(atoms.size());
        for (IAtom atom : atoms) {
            idxs.add(SmilesGenerator.ensureNotNull(atomidx.get(atom)));
        }
        return idxs;
    }

    /*
     * WARNING - void declaration
     */
    private static CxSmilesState getCxSmilesState(int flavour, IAtomContainer mol2) {
        CxSmilesState state = new CxSmilesState();
        state.atomCoords = new ArrayList<double[]>();
        state.coordFlag = false;
        HashMap<IAtom, Integer> atomidx = new HashMap<IAtom, Integer>();
        for (int idx = 0; idx < mol2.getAtomCount(); ++idx) {
            Object comment;
            IAtom atom = mol2.getAtom(idx);
            if (atom instanceof IPseudoAtom) {
                IPseudoAtom pseudo;
                if (state.atomLabels == null) {
                    state.atomLabels = new HashMap<Integer, String>();
                }
                if ((pseudo = (IPseudoAtom)atom).getAttachPointNum() > 0) {
                    state.atomLabels.put(idx, "_AP" + pseudo.getAttachPointNum());
                } else if (!"*".equals(pseudo.getLabel())) {
                    state.atomLabels.put(idx, pseudo.getLabel());
                }
            }
            if ((comment = atom.getProperty("cdk:Comment")) != null) {
                if (state.atomValues == null) {
                    state.atomValues = new HashMap<Integer, String>();
                }
                state.atomValues.put(idx, comment.toString());
            }
            atomidx.put(atom, idx);
            Point2d p2 = atom.getPoint2d();
            Point3d p3 = atom.getPoint3d();
            if (SmiFlavor.isSet(flavour, 4096) && p2 != null) {
                state.atomCoords.add(new double[]{p2.x, p2.y, 0.0});
                state.coordFlag = true;
                continue;
            }
            if (SmiFlavor.isSet(flavour, 8192) && p3 != null) {
                state.atomCoords.add(new double[]{p3.x, p3.y, p3.z});
                state.coordFlag = true;
                continue;
            }
            if (!SmiFlavor.isSet(flavour, 12288)) continue;
            state.atomCoords.add(new double[3]);
        }
        if (!state.coordFlag) {
            state.atomCoords = null;
        }
        if (mol2.getSingleElectronCount() > 0) {
            state.atomRads = new HashMap<Integer, CxSmilesState.Radical>();
            for (ISingleElectron radical : mol2.singleElectrons()) {
                Object val = state.atomRads.get(SmilesGenerator.ensureNotNull((Integer)atomidx.get(radical.getAtom())));
                if (val == null) {
                    val = CxSmilesState.Radical.Monovalent;
                } else if (val == CxSmilesState.Radical.Monovalent) {
                    val = CxSmilesState.Radical.Divalent;
                } else if (val == CxSmilesState.Radical.Divalent) {
                    val = CxSmilesState.Radical.Trivalent;
                } else if (val == CxSmilesState.Radical.Trivalent) {
                    throw new IllegalArgumentException("Invalid radical state, can not be more than trivalent");
                }
                state.atomRads.put((Integer)atomidx.get(radical.getAtom()), (CxSmilesState.Radical)((Object)val));
            }
        }
        List sgroups = (List)mol2.getProperty("cdk:CtabSgroups");
        HashMap<Sgroup, Object> mapping = new HashMap<Sgroup, Object>();
        if (sgroups != null) {
            state.mysgroups = new ArrayList<CxSmilesState.CxSgroup>();
            state.positionVar = new HashMap<Integer, List<Integer>>();
            state.ligandOrdering = new HashMap<Integer, List<Integer>>();
            for (Sgroup sgroup : sgroups) {
                switch (sgroup.getType()) {
                    case CtabStructureRepeatUnit: 
                    case CtabMonomer: 
                    case CtabMer: 
                    case CtabCopolymer: 
                    case CtabCrossLink: 
                    case CtabModified: 
                    case CtabMixture: 
                    case CtabFormulation: 
                    case CtabAnyPolymer: 
                    case CtabGeneric: 
                    case CtabComponent: 
                    case CtabGraft: {
                        if ((flavour & 0x80000) == 0) break;
                        String supscript = (String)sgroup.getValue(SgroupKey.CtabConnectivity);
                        CxSmilesState.CxPolymerSgroup cxSgrp = new CxSmilesState.CxPolymerSgroup(SmilesGenerator.getSgroupPolymerKey(sgroup), SmilesGenerator.toAtomIdxs(sgroup.getAtoms(), atomidx), sgroup.getSubscript(), supscript);
                        state.mysgroups.add(cxSgrp);
                        mapping.put(sgroup, cxSgrp);
                        break;
                    }
                    case ExtMulticenter: {
                        void var10_17;
                        Object var10_16 = null;
                        ArrayList<IAtom> ends = new ArrayList<IAtom>();
                        Set<IBond> bonds = sgroup.getBonds();
                        if (bonds.size() != 1) {
                            throw new IllegalArgumentException("Multicenter Sgroup in inconsistent state!");
                        }
                        IBond bond = bonds.iterator().next();
                        for (IAtom atom : sgroup.getAtoms()) {
                            if (bond.contains(atom)) {
                                if (var10_17 != null) {
                                    throw new IllegalArgumentException("Multicenter Sgroup in inconsistent state!");
                                }
                                IAtom iAtom = atom;
                                continue;
                            }
                            ends.add(atom);
                        }
                        state.positionVar.put(SmilesGenerator.ensureNotNull((Integer)atomidx.get(var10_17)), SmilesGenerator.toAtomIdxs(ends, atomidx));
                        break;
                    }
                    case ExtAttachOrdering: {
                        Object var10_19 = null;
                        ArrayList<IAtom> ends = new ArrayList();
                        if (sgroup.getAtoms().size() != 1) {
                            throw new IllegalArgumentException("Attach ordering in inconsistent state!");
                        }
                        IAtom iAtom = sgroup.getAtoms().iterator().next();
                        for (IBond bond : sgroup.getBonds()) {
                            IAtom nbr = bond.getOther(iAtom);
                            if (nbr == null) {
                                throw new IllegalArgumentException("Attach ordering in inconsistent state!");
                            }
                            ends.add(nbr);
                        }
                        state.ligandOrdering.put(SmilesGenerator.ensureNotNull((Integer)atomidx.get(iAtom)), SmilesGenerator.toAtomIdxs(ends, atomidx));
                        break;
                    }
                    case CtabAbbreviation: 
                    case CtabMultipleGroup: {
                        break;
                    }
                    case CtabData: {
                        if ((flavour & 0x400000) == 0) break;
                        CxSmilesState.CxDataSgroup cxDataSgroup = new CxSmilesState.CxDataSgroup(SmilesGenerator.toAtomIdxs(sgroup.getAtoms(), atomidx), (String)sgroup.getValue(SgroupKey.DataFieldName), (String)sgroup.getValue(SgroupKey.Data), null, (String)sgroup.getValue(SgroupKey.DataFieldUnits), null);
                        state.mysgroups.add(cxDataSgroup);
                        mapping.put(sgroup, cxDataSgroup);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Sgroup Polymer");
                    }
                }
            }
            for (Sgroup sgroup : sgroups) {
                CxSmilesState.CxSgroup cxChild = (CxSmilesState.CxSgroup)mapping.get(sgroup);
                if (cxChild == null) continue;
                for (Sgroup sgroup2 : sgroup.getParents()) {
                    CxSmilesState.CxSgroup cxParent = (CxSmilesState.CxSgroup)mapping.get(sgroup2);
                    if (cxParent == null) continue;
                    cxParent.children.add(cxChild);
                }
            }
        }
        HashMap<Integer, Integer> stereoGrps = new HashMap<Integer, Integer>();
        boolean init = false;
        boolean mixed = false;
        int grp = 0;
        for (IStereoElement se : mol2.stereoElements()) {
            if (se.getConfigClass() != 16896) continue;
            IAtom focus = (IAtom)se.getFocus();
            stereoGrps.put((Integer)atomidx.get(focus), se.getGroupInfo());
            if (!init) {
                grp = se.getGroupInfo();
                init = true;
                continue;
            }
            if (grp == se.getGroupInfo()) continue;
            mixed = true;
        }
        if (init) {
            if (mixed) {
                state.stereoGrps = stereoGrps;
            } else {
                int n = grp & 0x30000;
                if (n == 65536) {
                    state.racemic = true;
                } else if (n == 0) {
                    state.racemic = false;
                } else {
                    state.stereoGrps = stereoGrps;
                }
            }
        }
        return state;
    }

    private static String getSgroupPolymerKey(Sgroup sgroup) {
        switch (sgroup.getType()) {
            case CtabStructureRepeatUnit: {
                return "n";
            }
            case CtabMonomer: {
                return "mon";
            }
            case CtabMer: {
                return "mer";
            }
            case CtabCopolymer: {
                String subtype = (String)sgroup.getValue(SgroupKey.CtabSubType);
                if (subtype == null) {
                    return "co";
                }
                switch (subtype) {
                    case "RAN": {
                        return "ran";
                    }
                    case "ALT": {
                        return "alt";
                    }
                    case "BLO": {
                        return "blk";
                    }
                }
            }
            case CtabCrossLink: {
                return "xl";
            }
            case CtabModified: {
                return "mod";
            }
            case CtabMixture: {
                return "mix";
            }
            case CtabFormulation: {
                return "f";
            }
            case CtabAnyPolymer: {
                return "any";
            }
            case CtabGeneric: {
                return "gen";
            }
            case CtabComponent: {
                return "c";
            }
            case CtabGraft: {
                return "grf";
            }
        }
        throw new IllegalArgumentException();
    }

    public static Comparator<IAtom> createComparator(final IAtomContainer mol2, final int flavor) {
        return new Comparator<IAtom>(){

            final int unbox(Integer x) {
                return x != null ? x : 0;
            }

            @Override
            public int compare(IAtom a, IAtom b) {
                int bQ;
                List<IBond> aBonds = mol2.getConnectedBondsList(a);
                List<IBond> bBonds = mol2.getConnectedBondsList(b);
                int aH = this.unbox(a.getImplicitHydrogenCount());
                int bH = this.unbox(b.getImplicitHydrogenCount());
                int cmp = Integer.compare(aBonds.size() + aH, bBonds.size() + bH);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Integer.compare(aBonds.size(), bBonds.size());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Integer.compare(this.unbox(a.getAtomicNumber()), this.unbox(b.getAtomicNumber()));
                if (cmp != 0) {
                    return cmp;
                }
                int aQ = this.unbox(a.getFormalCharge());
                cmp = Integer.compare(aQ >> 31 & 1, (bQ = this.unbox(b.getFormalCharge())) >> 31 & 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Integer.compare(Math.abs(aQ), Math.abs(bQ));
                if (cmp != 0) {
                    return cmp;
                }
                int aTotalH = aH;
                int bTotalH = bH;
                for (IBond bond : aBonds) {
                    aTotalH += bond.getOther(a).getAtomicNumber() == 1 ? 1 : 0;
                }
                for (IBond bond : bBonds) {
                    bTotalH += bond.getOther(b).getAtomicNumber() == 1 ? 1 : 0;
                }
                cmp = Integer.compare(aTotalH, bTotalH);
                if (cmp != 0) {
                    return cmp;
                }
                if (SmiFlavor.isSet(flavor, 1800) && (cmp = Integer.compare(a.getMassNumber(), b.getMassNumber())) != 0) {
                    return cmp;
                }
                if (SmiFlavor.isSet(flavor, 4) && (flavor & 0x2000005) != 0x2000005) {
                    Integer aMapIdx = (Integer)a.getProperty("cdk:AtomAtomMapping");
                    Integer bMapIdx = (Integer)b.getProperty("cdk:AtomAtomMapping");
                    cmp = Integer.compare(this.unbox(aMapIdx), this.unbox(bMapIdx));
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                return 0;
            }
        };
    }
}

