/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.stereo.AbstractStereo;
import org.openscience.cdk.stereo.Atropisomeric;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class AtomContainerManipulator {
    public static final int MolWeight = 1;
    public static final int MolWeightIgnoreSpecified = 2;
    public static final int MonoIsotopic = 3;
    public static final int MostAbundant = 4;
    public static final Comparator<IIsotope> NAT_ABUN_COMP = new Comparator<IIsotope>(){

        @Override
        public int compare(IIsotope o1, IIsotope o2) {
            return -Double.compare(o1.getNaturalAbundance(), o2.getNaturalAbundance());
        }
    };

    public static IAtomContainer extractSubstructure(IAtomContainer atomContainer, int ... atomIndices) throws CloneNotSupportedException {
        IAtomContainer substructure = atomContainer.clone();
        int numberOfAtoms = substructure.getAtomCount();
        IAtom[] atoms = new IAtom[numberOfAtoms];
        for (int atomIndex = 0; atomIndex < numberOfAtoms; ++atomIndex) {
            atoms[atomIndex] = substructure.getAtom(atomIndex);
        }
        Arrays.sort(atomIndices);
        for (int index = 0; index < numberOfAtoms; ++index) {
            if (Arrays.binarySearch(atomIndices, index) >= 0) continue;
            IAtom atom = atoms[index];
            substructure.removeAtom(atom);
        }
        return substructure;
    }

    public static IAtom getAtomById(IAtomContainer ac, String id) throws CDKException {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getID() == null || !ac.getAtom(i).getID().equals(id)) continue;
            return ac.getAtom(i);
        }
        throw new CDKException("no suc atom");
    }

    public static boolean replaceAtomByAtom(IAtomContainer container, IAtom oldAtom, IAtom newAtom) {
        if (oldAtom == null) {
            throw new NullPointerException("Atom to be replaced was null!");
        }
        if (newAtom == null) {
            throw new NullPointerException("Replacement atom was null!");
        }
        int idx = container.indexOf(oldAtom);
        if (idx < 0) {
            return false;
        }
        container.setAtom(idx, newAtom);
        List sgrougs = (List)container.getProperty("cdk:CtabSgroups");
        if (sgrougs != null) {
            boolean updated = false;
            ArrayList<Sgroup> replaced = new ArrayList<Sgroup>();
            for (Sgroup org : sgrougs) {
                if (org.getAtoms().contains(oldAtom)) {
                    updated = true;
                    Sgroup cpy = new Sgroup();
                    for (IAtom atom : org.getAtoms()) {
                        if (!oldAtom.equals(atom)) {
                            cpy.addAtom(atom);
                            continue;
                        }
                        cpy.addAtom(newAtom);
                    }
                    for (IBond bond : org.getBonds()) {
                        cpy.addBond(bond);
                    }
                    for (Sgroup parent : org.getParents()) {
                        cpy.addParent(parent);
                    }
                    for (SgroupKey key : org.getAttributeKeys()) {
                        cpy.putValue(key, org.getValue(key));
                    }
                    replaced.add(cpy);
                    continue;
                }
                replaced.add(org);
            }
            if (updated) {
                container.setProperty("cdk:CtabSgroups", Collections.unmodifiableList(replaced));
            }
        }
        return true;
    }

    public static double getTotalCharge(IAtomContainer atomContainer) {
        double charge = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            Double thisCharge = atom.getCharge();
            if (thisCharge == CDKConstants.UNSET) continue;
            charge += thisCharge.doubleValue();
        }
        return charge;
    }

    private static boolean hasIsotopeSpecified(IIsotope atom) {
        return atom.getMassNumber() != null && atom.getMassNumber() != 0;
    }

    private static double getExactMass(IsotopeFactory isofact, IIsotope atom) {
        if (atom.getExactMass() != null) {
            return atom.getExactMass();
        }
        if (atom.getMassNumber() != null) {
            return isofact.getExactMass(AtomContainerManipulator.getAtomicNum(atom), atom.getMassNumber());
        }
        return isofact.getMajorIsotopeMass(AtomContainerManipulator.getAtomicNum(atom));
    }

    private static double getMassOrAvg(IsotopeFactory isofact, IIsotope atom) {
        if (!AtomContainerManipulator.hasIsotopeSpecified(atom)) {
            return isofact.getNaturalMass(atom);
        }
        return AtomContainerManipulator.getExactMass(isofact, atom);
    }

    private static double getDistMass(IsotopeFactory isofact, IIsotope[] isos, int idx, int count) {
        if (count == 0) {
            return 0.0;
        }
        double frac = 100.0;
        double res = 0.0;
        for (int i = 0; i < idx; ++i) {
            frac -= isos[i].getNaturalAbundance().doubleValue();
        }
        double p = isos[idx].getNaturalAbundance() / frac;
        if (p >= 1.0) {
            return (double)count * isos[idx].getExactMass();
        }
        double kMin = (double)(count + 1) * (1.0 - p) - 1.0;
        double kMax = (double)(count + 1) * (1.0 - p);
        if ((int)Math.ceil(kMin) == (int)Math.floor(kMax)) {
            int k = (int)kMax;
            res = (double)(count - k) * AtomContainerManipulator.getExactMass(isofact, isos[idx]);
            res += AtomContainerManipulator.getDistMass(isofact, isos, idx + 1, k);
        }
        return res;
    }

    private static int getImplHCount(IAtom atom) {
        Integer implh = atom.getImplicitHydrogenCount();
        if (implh == null) {
            throw new IllegalArgumentException("An atom had 'null' implicit hydrogens!");
        }
        return implh;
    }

    private static int getAtomicNum(IElement atom) {
        Integer atno = atom.getAtomicNumber();
        if (atno == null) {
            throw new IllegalArgumentException("An atom had 'null' atomic number!");
        }
        return atno;
    }

    public static double getMass(IAtomContainer mol2, int flav) {
        Isotopes isofact;
        try {
            isofact = Isotopes.getInstance();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load Isotopes!");
        }
        double mass = 0.0;
        int hcnt = 0;
        switch (flav & 0xF) {
            case 1: {
                for (IAtom atom : mol2.atoms()) {
                    mass += AtomContainerManipulator.getMassOrAvg(isofact, atom);
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getNaturalMass(1);
                break;
            }
            case 2: {
                for (IAtom atom : mol2.atoms()) {
                    mass += isofact.getNaturalMass(AtomContainerManipulator.getAtomicNum(atom));
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getNaturalMass(1);
                break;
            }
            case 3: {
                for (IAtom atom : mol2.atoms()) {
                    mass += AtomContainerManipulator.getExactMass(isofact, atom);
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getMajorIsotopeMass(1);
                break;
            }
            case 4: {
                int[] mf = new int[128];
                for (IAtom atom : mol2.atoms()) {
                    if (AtomContainerManipulator.hasIsotopeSpecified(atom)) {
                        mass += AtomContainerManipulator.getExactMass(isofact, atom);
                    } else {
                        int n = AtomContainerManipulator.getAtomicNum(atom);
                        mf[n] = mf[n] + 1;
                    }
                    mf[1] = mf[1] + atom.getImplicitHydrogenCount();
                }
                for (int atno = 0; atno < mf.length; ++atno) {
                    if (mf[atno] == 0) continue;
                    IIsotope[] isotopes = isofact.getIsotopes(atno);
                    Arrays.sort(isotopes, NAT_ABUN_COMP);
                    mass += AtomContainerManipulator.getDistMass(isofact, isotopes, 0, mf[atno]);
                }
                break;
            }
        }
        return mass;
    }

    public static double getMass(IAtomContainer mol2) {
        return AtomContainerManipulator.getMass(mol2, 1);
    }

    public static double getTotalExactMass(IAtomContainer mol2) {
        return AtomContainerManipulator.getMass(mol2, 3);
    }

    public static double getNaturalExactMass(IAtomContainer mol2) {
        return AtomContainerManipulator.getMass(mol2, 2);
    }

    public static double getMolecularWeight(IAtomContainer mol2) {
        return AtomContainerManipulator.getMass(mol2, 1);
    }

    public static double getTotalNaturalAbundance(IAtomContainer atomContainer) {
        try {
            Isotopes isotopes = Isotopes.getInstance();
            double abundance = 1.0;
            double hAbundance = isotopes.getMajorIsotope(1).getNaturalAbundance();
            int nImplH = 0;
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getImplicitHydrogenCount() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) implicit hydrogens");
                }
                abundance *= atom.getNaturalAbundance().doubleValue();
                for (int h2 = 0; h2 < atom.getImplicitHydrogenCount(); ++h2) {
                    abundance *= hAbundance;
                }
                nImplH += atom.getImplicitHydrogenCount().intValue();
            }
            return abundance / Math.pow(100.0, nImplH + atomContainer.getAtomCount());
        }
        catch (IOException e) {
            throw new RuntimeException("Isotopes definitions could not be loaded", e);
        }
    }

    public static int getTotalFormalCharge(IAtomContainer atomContainer) {
        int chargeP = AtomContainerManipulator.getTotalNegativeFormalCharge(atomContainer);
        int chargeN = AtomContainerManipulator.getTotalPositiveFormalCharge(atomContainer);
        return chargeP + chargeN;
    }

    public static int getTotalNegativeFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            int chargeI = atomContainer.getAtom(i).getFormalCharge();
            if (chargeI >= 0) continue;
            charge += chargeI;
        }
        return charge;
    }

    public static int getTotalPositiveFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            int chargeI = atomContainer.getAtom(i).getFormalCharge();
            if (chargeI <= 0) continue;
            charge += chargeI;
        }
        return charge;
    }

    public static int getTotalHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int hydrogens = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit;
            if (Elements.HYDROGEN.getSymbol().equals(atom.getSymbol())) {
                ++hydrogens;
            }
            if ((implicit = atom.getImplicitHydrogenCount()) == null) continue;
            hydrogens += implicit.intValue();
        }
        return hydrogens;
    }

    public static int getImplicitHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int count = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit = atom.getImplicitHydrogenCount();
            if (implicit == null) continue;
            count += implicit.intValue();
        }
        return count;
    }

    public static int countExplicitHydrogens(IAtomContainer atomContainer, IAtom atom) {
        if (atomContainer == null || atom == null) {
            throw new IllegalArgumentException("null container or atom provided");
        }
        int hCount = 0;
        for (IAtom connected : atomContainer.getConnectedAtomsList(atom)) {
            if (!Elements.HYDROGEN.getSymbol().equals(connected.getSymbol())) continue;
            ++hCount;
        }
        return hCount;
    }

    private static final void replaceAtom(IAtom[] atoms, IAtom org, IAtom rep) {
        for (int i = 0; i < atoms.length; ++i) {
            if (!atoms[i].equals(org)) continue;
            atoms[i] = rep;
        }
    }

    public static void convertImplicitToExplicitHydrogens(IAtomContainer atomContainer) {
        ArrayList<IAtom> hydrogens = new ArrayList<IAtom>();
        ArrayList<IBond> newBonds = new ArrayList<IBond>();
        HashMap<IAtom, IAtom> hNeighbor = Maps.newHashMapWithExpectedSize(atomContainer.getAtomCount());
        for (IAtom atom : atomContainer.atoms()) {
            Integer hCount;
            if (atom.getSymbol().equals("H") || (hCount = atom.getImplicitHydrogenCount()) == null) continue;
            for (int i = 0; i < hCount; ++i) {
                IAtom hydrogen = atom.getBuilder().newInstance(IAtom.class, "H");
                hydrogen.setAtomTypeName("H");
                hydrogen.setImplicitHydrogenCount(0);
                hydrogens.add(hydrogen);
                newBonds.add(atom.getBuilder().newInstance(IBond.class, new Object[]{atom, hydrogen, IBond.Order.SINGLE}));
                if (hNeighbor.get(atom) != null) continue;
                hNeighbor.put(atom, hydrogen);
            }
            atom.setImplicitHydrogenCount(0);
        }
        for (IAtom atom : hydrogens) {
            atomContainer.addAtom(atom);
        }
        for (IBond bond : newBonds) {
            atomContainer.addBond(bond);
        }
        ArrayList<IStereoElement> stereos = new ArrayList<IStereoElement>();
        for (IStereoElement stereo : atomContainer.stereoElements()) {
            IAtom[] carriers;
            IAtom focus;
            IStereoElement<IAtom, IAtom> tc;
            if (stereo instanceof ITetrahedralChirality) {
                tc = (ITetrahedralChirality)stereo;
                focus = (IAtom)tc.getFocus();
                carriers = tc.getCarriers().toArray(new IAtom[4]);
                IAtom hydrogen = (IAtom)hNeighbor.get(focus);
                if (hydrogen != null) {
                    AtomContainerManipulator.replaceAtom(carriers, focus, hydrogen);
                    TetrahedralChirality newStereo = new TetrahedralChirality(focus, carriers, tc.getStereo());
                    newStereo.setGroupInfo(tc.getGroupInfo());
                    stereos.add(newStereo);
                    continue;
                }
                stereos.add(stereo);
                continue;
            }
            if (stereo instanceof ExtendedTetrahedral) {
                tc = (ExtendedTetrahedral)stereo;
                focus = (IAtom)((AbstractStereo)tc).getFocus();
                carriers = ((ExtendedTetrahedral)tc).getCarriers().toArray(new IAtom[4]);
                IAtom[] ends = ExtendedTetrahedral.findTerminalAtoms(atomContainer, focus);
                IAtom h1 = (IAtom)hNeighbor.get(ends[0]);
                IAtom h2 = (IAtom)hNeighbor.get(ends[1]);
                if (h1 != null || h2 != null) {
                    if (h1 != null) {
                        AtomContainerManipulator.replaceAtom(carriers, ends[0], h1);
                    }
                    if (h2 != null) {
                        AtomContainerManipulator.replaceAtom(carriers, ends[1], h2);
                    }
                    stereos.add(new ExtendedTetrahedral(focus, carriers, ((ExtendedTetrahedral)tc).getConfigOrder()));
                    continue;
                }
                stereos.add(stereo);
                continue;
            }
            stereos.add(stereo);
        }
        atomContainer.setStereoElements(stereos);
    }

    public static int countHydrogens(IAtomContainer atomContainer, IAtom atom) {
        int hCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        return hCount += AtomContainerManipulator.countExplicitHydrogens(atomContainer, atom);
    }

    public static List<String> getAllIDs(IAtomContainer mol2) {
        ArrayList<String> idList = new ArrayList<String>();
        if (mol2 != null) {
            if (mol2.getID() != null) {
                idList.add(mol2.getID());
            }
            for (IAtom atom : mol2.atoms()) {
                if (atom.getID() == null) continue;
                idList.add(atom.getID());
            }
            for (IBond bond : mol2.bonds()) {
                if (bond.getID() == null) continue;
                idList.add(bond.getID());
            }
        }
        return idList;
    }

    public static IAtomContainer removeNonChiralHydrogens(IAtomContainer org) {
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer cpy = org.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = org.getAtomCount();
        for (int i = 0; i < count; ++i) {
            Object neighbour;
            Integer stereoParity;
            IAtom atom = org.getAtom(i);
            boolean addToRemove = false;
            if (AtomContainerManipulator.suppressibleHydrogen(org, atom) && org.getConnectedAtomsList(atom).size() == 1 && ((stereoParity = (neighbour = org.getConnectedAtomsList(atom).get(0)).getStereoParity()) == null || stereoParity == 0)) {
                addToRemove = true;
                for (IBond bond : org.getConnectedBondsList((IAtom)neighbour)) {
                    IAtom neighboursNeighbour;
                    IBond.Stereo bondStereo = bond.getStereo();
                    if (bondStereo != null && bondStereo != IBond.Stereo.NONE) {
                        addToRemove = false;
                    }
                    if (!(neighboursNeighbour = bond.getOther((IAtom)neighbour)).getSymbol().equals("H") || neighboursNeighbour.equals(atom)) continue;
                    addToRemove = true;
                    break;
                }
            }
            if (addToRemove) {
                remove.add(atom);
                continue;
            }
            AtomContainerManipulator.addClone(atom, cpy, map);
        }
        for (IStereoElement stereoElement : org.stereoElements()) {
            if (stereoElement instanceof ITetrahedralChirality) {
                ITetrahedralChirality tetChirality = (ITetrahedralChirality)stereoElement;
                for (IAtom atom : tetChirality.getLigands()) {
                    if (!atom.getSymbol().equals("H") || !remove.contains(atom)) continue;
                    remove.remove(atom);
                    AtomContainerManipulator.addClone(atom, cpy, map);
                }
                continue;
            }
            if (!(stereoElement instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)stereoElement;
            IBond stereoBond = dbs.getStereoBond();
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getBegin())) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getEnd())) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
        }
        count = org.getBondCount();
        for (int i = 0; i < count; ++i) {
            IBond bond = org.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = org.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{(IAtom)map.get(bond.getBegin()), (IAtom)map.get(bond.getEnd())});
            cpy.addBond(clone);
        }
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : org.getConnectedAtomsList(aRemove)) {
                IAtom neighb = (IAtom)map.get(iAtom);
                if (neighb == null) continue;
                neighb.setImplicitHydrogenCount((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1);
            }
        }
        for (IAtom atom : cpy.atoms()) {
            if (atom.getImplicitHydrogenCount() != null) continue;
            atom.setImplicitHydrogenCount(0);
        }
        cpy.addProperties(org.getProperties());
        cpy.setFlags(org.getFlags());
        return cpy;
    }

    private static void addClone(IAtom atom, IAtomContainer mol2, Map<IAtom, IAtom> map) {
        IAtom clonedAtom = null;
        try {
            clonedAtom = atom.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        mol2.addAtom(clonedAtom);
        map.put(atom, clonedAtom);
    }

    public static IAtomContainer copyAndSuppressedHydrogens(IAtomContainer org) {
        try {
            return AtomContainerManipulator.suppressHydrogens(org.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("atom container could not be cloned");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static IAtomContainer suppressHydrogens(IAtomContainer org) {
        boolean anyHydrogenPresent = false;
        for (IAtom atom : org.atoms()) {
            if (!"H".equals(atom.getSymbol())) continue;
            anyHydrogenPresent = true;
            break;
        }
        if (!anyHydrogenPresent) {
            return org;
        }
        Set xatoms = Collections.emptySet();
        Collection sgroups = (Collection)org.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            xatoms = new HashSet();
            for (Sgroup sgroup : sgroups) {
                for (IBond bond : sgroup.getBonds()) {
                    xatoms.add(bond.getBegin());
                    xatoms.add(bond.getEnd());
                }
            }
        }
        GraphUtil.EdgeToBondMap bondmap = GraphUtil.EdgeToBondMap.withSpaceFor(org);
        int[][] graph = GraphUtil.toAdjList(org, bondmap);
        int nOrgAtoms = org.getAtomCount();
        int nOrgBonds = org.getBondCount();
        int nCpyAtoms = 0;
        int nCpyBonds = 0;
        HashSet<IAtom> hydrogens = new HashSet<IAtom>(nOrgAtoms);
        HashSet<IBond> bondsToHydrogens = new HashSet<IBond>();
        IAtom[] cpyAtoms = new IAtom[nOrgAtoms];
        for (int v = 0; v < nOrgAtoms; ++v) {
            IAtom atom = org.getAtom(v);
            if (AtomContainerManipulator.suppressibleHydrogen(org, graph, bondmap, v) && !xatoms.contains(atom)) {
                hydrogens.add(atom);
                AtomContainerManipulator.incrementImplHydrogenCount(org.getAtom(graph[v][0]));
                continue;
            }
            cpyAtoms[nCpyAtoms++] = atom;
        }
        if (hydrogens.isEmpty()) {
            return org;
        }
        IBond[] cpyBonds = new IBond[nOrgBonds - hydrogens.size()];
        int remaining = hydrogens.size();
        for (IBond iBond : org.bonds()) {
            if (remaining > 0 && (hydrogens.contains(iBond.getBegin()) || hydrogens.contains(iBond.getEnd()))) {
                bondsToHydrogens.add(iBond);
                --remaining;
                continue;
            }
            cpyBonds[nCpyBonds++] = iBond;
        }
        if (nCpyBonds != cpyBonds.length) {
            throw new IllegalArgumentException("number of removed bonds was less than the number of removed hydrogens");
        }
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>();
        for (IStereoElement iStereoElement : org.stereoElements()) {
            if (iStereoElement instanceof ITetrahedralChirality) {
                ITetrahedralChirality iTetrahedralChirality = (ITetrahedralChirality)iStereoElement;
                IAtom iAtom = iTetrahedralChirality.getChiralAtom();
                IAtom[] neighbors = iTetrahedralChirality.getLigands();
                boolean updated = false;
                for (int i = 0; i < neighbors.length; ++i) {
                    if (!hydrogens.contains(neighbors[i])) continue;
                    neighbors[i] = iAtom;
                    updated = true;
                }
                if (!updated) {
                    elements.add(iTetrahedralChirality);
                    continue;
                }
                TetrahedralChirality e = new TetrahedralChirality(iAtom, neighbors, iTetrahedralChirality.getStereo());
                e.setGroupInfo(iTetrahedralChirality.getGroupInfo());
                elements.add(e);
                continue;
            }
            if (iStereoElement instanceof ExtendedTetrahedral) {
                ExtendedTetrahedral extendedTetrahedral = (ExtendedTetrahedral)iStereoElement;
                IAtom iAtom = (IAtom)extendedTetrahedral.getFocus();
                IAtom[] carriers = extendedTetrahedral.getCarriers().toArray(new IAtom[4]);
                IAtom[] ends = ExtendedTetrahedral.findTerminalAtoms(org, iAtom);
                boolean updated = false;
                for (int i = 0; i < carriers.length; ++i) {
                    if (!hydrogens.contains(carriers[i])) continue;
                    carriers[i] = org.getBond(carriers[i], ends[0]) != null ? ends[0] : ends[1];
                    updated = true;
                }
                if (!updated) {
                    elements.add(extendedTetrahedral);
                    continue;
                }
                elements.add(new ExtendedTetrahedral(iAtom, carriers, extendedTetrahedral.getConfigOrder()));
                continue;
            }
            if (iStereoElement instanceof IDoubleBondStereochemistry) {
                void var19_60;
                IDoubleBondStereochemistry iDoubleBondStereochemistry = (IDoubleBondStereochemistry)iStereoElement;
                IDoubleBondStereochemistry.Conformation conformation = iDoubleBondStereochemistry.getStereo();
                IBond orgStereo = iDoubleBondStereochemistry.getStereoBond();
                IBond orgLeft = iDoubleBondStereochemistry.getBonds()[0];
                IBond orgRight = iDoubleBondStereochemistry.getBonds()[1];
                IAtom u = orgStereo.getBegin();
                IAtom v = orgStereo.getEnd();
                IAtom x = orgLeft.getOther(u);
                IAtom y = orgRight.getOther(v);
                IAtom xNew = x;
                IAtom yNew = y;
                if (hydrogens.contains(x)) {
                    IDoubleBondStereochemistry.Conformation conformation2 = conformation.invert();
                    xNew = AtomContainerManipulator.findSingleBond(org, u, x);
                }
                if (hydrogens.contains(y)) {
                    void var19_58;
                    IDoubleBondStereochemistry.Conformation conformation3 = var19_58.invert();
                    yNew = AtomContainerManipulator.findSingleBond(org, v, y);
                }
                if (x == null || y == null || xNew == null || yNew == null) continue;
                if (x.equals(xNew) && y.equals(yNew)) {
                    elements.add(iDoubleBondStereochemistry);
                    continue;
                }
                IBond cpyLeft = !Objects.equals(xNew, x) ? org.getBond(u, xNew) : orgLeft;
                IBond cpyRight = !Objects.equals(yNew, y) ? org.getBond(v, yNew) : orgRight;
                elements.add(new DoubleBondStereochemistry(orgStereo, new IBond[]{cpyLeft, cpyRight}, (IDoubleBondStereochemistry.Conformation)var19_60));
                continue;
            }
            if (iStereoElement instanceof ExtendedCisTrans) {
                int n;
                int n2;
                ExtendedCisTrans extendedCisTrans = (ExtendedCisTrans)iStereoElement;
                int n3 = extendedCisTrans.getConfigOrder();
                IBond focus = (IBond)extendedCisTrans.getFocus();
                IBond orgLeft = (IBond)extendedCisTrans.getCarriers().get(0);
                IBond orgRight = (IBond)extendedCisTrans.getCarriers().get(1);
                IAtom[] ends = ExtendedCisTrans.findTerminalAtoms(org, focus);
                IAtom u = ends[0];
                IAtom v = ends[1];
                IAtom x = orgLeft.getOther(u);
                IAtom y = orgRight.getOther(v);
                IAtom xNew = x;
                IAtom yNew = y;
                if (hydrogens.contains(x)) {
                    n2 = n3 ^ 3;
                    xNew = AtomContainerManipulator.findSingleBond(org, u, x);
                }
                if (hydrogens.contains(y)) {
                    n = n2 ^ 3;
                    yNew = AtomContainerManipulator.findSingleBond(org, v, y);
                }
                if (x == null || y == null || xNew == null || yNew == null) continue;
                if (x.equals(xNew) && y.equals(yNew)) {
                    elements.add(extendedCisTrans);
                    continue;
                }
                IBond cpyLeft = !Objects.equals(xNew, x) ? org.getBond(u, xNew) : orgLeft;
                IBond cpyRight = !Objects.equals(yNew, y) ? org.getBond(v, yNew) : orgRight;
                elements.add(new ExtendedCisTrans(focus, new IBond[]{cpyLeft, cpyRight}, n));
                continue;
            }
            if (!(iStereoElement instanceof Atropisomeric)) continue;
            elements.add(iStereoElement);
        }
        org.setAtoms(Arrays.copyOf(cpyAtoms, nCpyAtoms));
        org.setBonds(cpyBonds);
        org.setStereoElements(elements);
        if (org.getSingleElectronCount() > 0) {
            HashSet<ISingleElectron> hashSet = new HashSet<ISingleElectron>();
            for (ISingleElectron iSingleElectron : org.singleElectrons()) {
                if (!hydrogens.contains(iSingleElectron.getAtom())) continue;
                hashSet.add(iSingleElectron);
            }
            for (ISingleElectron iSingleElectron : hashSet) {
                org.removeSingleElectron(iSingleElectron);
            }
        }
        if (org.getLonePairCount() > 0) {
            HashSet<ILonePair> hashSet = new HashSet<ILonePair>();
            for (ILonePair iLonePair : org.lonePairs()) {
                if (!hydrogens.contains(iLonePair.getAtom())) continue;
                hashSet.add(iLonePair);
            }
            for (ILonePair iLonePair : hashSet) {
                org.removeLonePair(iLonePair);
            }
        }
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getValue(SgroupKey.CtabParentAtomList) != null) {
                    Collection collection = (Collection)sgroup.getValue(SgroupKey.CtabParentAtomList);
                    collection.removeAll(hydrogens);
                }
                for (IAtom iAtom : hydrogens) {
                    sgroup.removeAtom(iAtom);
                }
                for (IBond iBond : bondsToHydrogens) {
                    sgroup.removeBond(iBond);
                }
            }
        }
        return org;
    }

    public static IAtomContainer removeHydrogens(IAtomContainer org) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(org);
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, IAtom atom) {
        if (!"H".equals(atom.getSymbol())) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null) {
            return false;
        }
        if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() != 0) {
            return false;
        }
        List<IAtom> neighbors = container.getConnectedAtomsList(atom);
        return neighbors.size() != 1 || !neighbors.get(0).getSymbol().equals("H") && !(neighbors.get(0) instanceof IPseudoAtom);
    }

    private static void incrementImplHydrogenCount(IAtom atom) {
        Integer hCount = atom.getImplicitHydrogenCount();
        if (hCount == null) {
            if (!(atom instanceof IPseudoAtom)) {
                throw new IllegalArgumentException("a non-pseudo atom had an unset hydrogen count");
            }
            hCount = 0;
        }
        atom.setImplicitHydrogenCount(hCount + 1);
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondmap, int v) {
        IAtom atom = container.getAtom(v);
        if (!"H".equals(atom.getSymbol())) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null) {
            return false;
        }
        if (graph[v].length != 1) {
            return false;
        }
        if (bondmap.get(v, graph[v][0]).getOrder() != IBond.Order.SINGLE) {
            return false;
        }
        if ("H".equals(container.getAtom(graph[v][0]).getSymbol())) {
            return false;
        }
        return !(container.getAtom(graph[v][0]) instanceof IPseudoAtom);
    }

    private static IAtom findSingleBond(IAtomContainer container, IAtom atom, IAtom exclude) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IAtom neighbor;
            if (bond.getOrder() != IBond.Order.SINGLE || (neighbor = bond.getOther(atom)).equals(exclude)) continue;
            return neighbor;
        }
        return null;
    }

    @Deprecated
    public static IAtomContainer removeHydrogensPreserveMultiplyBonded(IAtomContainer ac) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(ac);
    }

    @Deprecated
    private static IAtomContainer removeHydrogens(IAtomContainer ac, List<IAtom> preserve) {
        int i;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer mol2 = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = ac.getAtomCount();
        for (i = 0; i < count; ++i) {
            IAtom atom = ac.getAtom(i);
            if (!AtomContainerManipulator.suppressibleHydrogen(ac, atom) || preserve.contains(atom)) {
                IAtom a = null;
                try {
                    a = atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                a.setImplicitHydrogenCount(0);
                mol2.addAtom(a);
                map.put(atom, a);
                continue;
            }
            remove.add(atom);
        }
        count = ac.getBondCount();
        for (i = 0; i < count; ++i) {
            IBond bond = ac.getBond(i);
            IAtom atom0 = bond.getBegin();
            IAtom atom1 = bond.getEnd();
            boolean remove_bond = false;
            for (IAtom atom : bond.atoms()) {
                if (!remove.contains(atom)) continue;
                remove_bond = true;
                break;
            }
            if (remove_bond) continue;
            IBond clone = null;
            try {
                clone = ac.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            clone.setAtoms(new IAtom[]{(IAtom)map.get(atom0), (IAtom)map.get(atom1)});
            mol2.addBond(clone);
        }
        for (IAtom removeAtom : remove) {
            for (IAtom neighbor : ac.getConnectedAtomsList(removeAtom)) {
                IAtom neighb = (IAtom)map.get(neighbor);
                neighb.setImplicitHydrogenCount(neighb.getImplicitHydrogenCount() + 1);
            }
        }
        return mol2;
    }

    public static void setAtomProperties(IAtomContainer container, Object propKey, Object propVal) {
        if (container != null) {
            for (IAtom atom : container.atoms()) {
                atom.setProperty(propKey, propVal);
            }
        }
    }

    public static void unregisterElectronContainerListeners(IAtomContainer container) {
        for (IElectronContainer electronContainer : container.electronContainers()) {
            electronContainer.removeListener(container);
        }
    }

    public static void unregisterAtomListeners(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.removeListener(container);
        }
    }

    public static IAtomContainer getIntersection(IAtomContainer container1, IAtomContainer container2) {
        int i;
        IAtomContainer intersection = container1.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (i = 0; i < container1.getAtomCount(); ++i) {
            if (!container2.contains(container1.getAtom(i))) continue;
            intersection.addAtom(container1.getAtom(i));
        }
        for (i = 0; i < container1.getElectronContainerCount(); ++i) {
            if (!container2.contains(container1.getElectronContainer(i))) continue;
            intersection.addElectronContainer(container1.getElectronContainer(i));
        }
        return intersection;
    }

    public static IAtom[] getAtomArray(IAtomContainer container) {
        IAtom[] ret = new IAtom[container.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getAtom(i);
        }
        return ret;
    }

    public static IAtom[] getAtomArray(List<IAtom> list) {
        IAtom[] ret = new IAtom[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(IAtomContainer container) {
        IBond[] ret = new IBond[container.getBondCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getBond(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(List<IBond> list) {
        IBond[] ret = new IBond[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(IAtomContainer container) {
        IElectronContainer[] ret = new IElectronContainer[container.getElectronContainerCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getElectronContainer(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(List<IElectronContainer> list) {
        IElectronContainer[] ret = new IElectronContainer[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    public static void percieveAtomTypesAndConfigureUnsetProperties(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configureUnsetProperties(atom, matched);
        }
    }

    public static void clearAtomConfigurations(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.setAtomTypeName((String)CDKConstants.UNSET);
            atom.setMaxBondOrder((IBond.Order)((Object)CDKConstants.UNSET));
            atom.setBondOrderSum((Double)CDKConstants.UNSET);
            atom.setCovalentRadius((Double)CDKConstants.UNSET);
            atom.setValency((Integer)CDKConstants.UNSET);
            atom.setFormalCharge((Integer)CDKConstants.UNSET);
            atom.setHybridization((IAtomType.Hybridization)((Object)CDKConstants.UNSET));
            atom.setFormalNeighbourCount((Integer)CDKConstants.UNSET);
            atom.setFlag(512, false);
            atom.setFlag(256, false);
            atom.setProperty("cdk:Chemical Group", CDKConstants.UNSET);
            atom.setFlag(32, false);
            atom.setProperty("org.openscience.cdk.renderer.color", CDKConstants.UNSET);
            atom.setExactMass((Double)CDKConstants.UNSET);
        }
    }

    public static int getSingleBondEquivalentSum(IAtomContainer container) {
        int sum = 0;
        for (IBond bond : container.bonds()) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            sum += order.numeric().intValue();
        }
        return sum;
    }

    public static IBond.Order getMaximumBondOrder(IAtomContainer container) {
        return BondManipulator.getMaximumBondOrder(container.bonds().iterator());
    }

    public static List<IAtom> getHeavyAtoms(IAtomContainer container) {
        ArrayList<IAtom> newAc = new ArrayList<IAtom>();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            if (container.getAtom(f).getSymbol().equals("H")) continue;
            newAc.add(container.getAtom(f));
        }
        return newAc;
    }

    public static IAtomContainer createAllCarbonAllSingleNonAromaticBondAtomContainer(IAtomContainer atomContainer) throws CloneNotSupportedException {
        IAtomContainer query2 = atomContainer.clone();
        for (int i = 0; i < query2.getBondCount(); ++i) {
            query2.getBond(i).setOrder(IBond.Order.SINGLE);
            query2.getBond(i).setFlag(32, false);
            query2.getBond(i).setFlag(4096, false);
            query2.getBond(i).getBegin().setSymbol("C");
            query2.getBond(i).getBegin().setHybridization(null);
            query2.getBond(i).getEnd().setSymbol("C");
            query2.getBond(i).getEnd().setHybridization(null);
            query2.getBond(i).getBegin().setFlag(32, false);
            query2.getBond(i).getEnd().setFlag(32, false);
        }
        return query2;
    }

    public static IAtomContainer anonymise(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = builder.newAtom();
            atoms[i].setAtomicNumber(6);
            atoms[i].setSymbol("C");
            atoms[i].setImplicitHydrogenCount(0);
            IAtom srcAtom = src.getAtom(i);
            if (srcAtom.getPoint2d() != null) {
                atoms[i].setPoint2d(new Point2d(srcAtom.getPoint2d()));
            }
            if (srcAtom.getPoint3d() == null) continue;
            atoms[i].setPoint3d(new Point3d(srcAtom.getPoint3d()));
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.indexOf(bond.getBegin());
            int v = src.indexOf(bond.getEnd());
            bonds[i] = builder.newInstance(IBond.class, atoms[u], atoms[v]);
        }
        IAtomContainer dest = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static IAtomContainer skeleton(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = builder.newInstance(IAtom.class, src.getAtom(i).getAtomicNumber());
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.indexOf(bond.getBegin());
            int v = src.indexOf(bond.getEnd());
            bonds[i] = builder.newInstance(IBond.class, atoms[u], atoms[v]);
        }
        IAtomContainer dest = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static double getBondOrderSum(IAtomContainer container, IAtom atom) {
        double count = 0.0;
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            count += (double)order.numeric().intValue();
        }
        return count;
    }

    public static IAtomContainer setSingleOrDoubleFlags(IAtomContainer ac) {
        RingSearch rs = new RingSearch(ac);
        boolean singleOrDouble = false;
        for (IBond bond : rs.ringFragments().bonds()) {
            if (!bond.getFlag(32)) continue;
            bond.setFlag(4096, true);
            bond.getBegin().setFlag(4096, true);
            bond.getEnd().setFlag(4096, true);
            singleOrDouble |= true;
        }
        if (singleOrDouble) {
            ac.setFlag(4096, true);
        }
        return ac;
    }
}

