/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLElementType
implements CMLConstants {
    private Element complexType;
    private Element simpleType;
    private Element extension;
    private List<CMLAttribute> attributeList;
    private List<String> attributeGroupNameList;
    private List<CMLElementType> elementTypeList;
    private Element xsdElement;
    private String name;
    private CMLType simpleContentType;

    public CMLElementType(Element xsdElement) {
        this.init();
        this.xsdElement = xsdElement;
        this.name = xsdElement.getAttributeValue("name");
        this.processContentTypes();
    }

    private void processContentTypes() {
        List<Node> complexTypes = CMLUtil.getQueryNodes(this.xsdElement, "./xsd:complexType", XPATH_XSD);
        if (complexTypes.size() == 1) {
            this.complexType = (Element)complexTypes.get(0);
        }
        if (this.complexType == null) {
            throw new RuntimeException("No complexType for: " + this.name);
        }
        List<Node> simpleTypes = CMLUtil.getQueryNodes(this.complexType, "./xsd:simpleContent", XPATH_XSD);
        if (simpleTypes.size() == 1) {
            this.simpleType = (Element)simpleTypes.get(0);
        }
    }

    void init() {
        this.attributeList = new ArrayList<CMLAttribute>();
        this.attributeGroupNameList = new ArrayList<String>();
        this.elementTypeList = new ArrayList<CMLElementType>();
    }

    public void processAttributes(Map<String, CMLAttribute> attributeGroupMap) {
        List<Node> attributes;
        Element contentType = this.complexType;
        if (this.simpleType != null) {
            List<Node> extensions = CMLUtil.getQueryNodes(this.simpleType, "./xsd:extension", XPATH_XSD);
            if (extensions.size() == 0) {
                throw new RuntimeException("Expected extension children for simpleContent for " + this.name);
            }
            contentType = this.extension = (Element)extensions.get(0);
        }
        if ((attributes = CMLUtil.getQueryNodes(contentType, "./xsd:attribute", XPATH_XSD)).size() != 0) {
            throw new RuntimeException("Use attributeGroups instead of attributes for " + this.name);
        }
        List<Node> attributeGroups = CMLUtil.getQueryNodes(contentType, "./xsd:attributeGroup", XPATH_XSD);
        if (attributeGroups.size() == 0) {
            throw new RuntimeException("NOTE: no attributeGroups for " + this.name);
        }
        for (Node node : attributeGroups) {
            Element attributeGroup = (Element)node;
            String attributeGroupRef = attributeGroup.getAttributeValue("ref");
            CMLAttribute attribute = attributeGroupMap.get(attributeGroupRef);
            if (attribute == null) {
                throw new RuntimeException("cannot find attributeGroup: " + attributeGroupRef);
            }
            this.attributeList.add(attribute);
            this.attributeGroupNameList.add(attributeGroupRef);
        }
    }

    public void processComplexContent(Map<String, CMLElementType> elementTypeMap) {
        if (this.simpleType == null) {
            List<Node> elements = CMLUtil.getQueryNodes(this.complexType, ".//xsd:element[@ref]", XPATH_XSD);
            if (elements.size() == 0) {
                // empty if block
            }
            for (Node node : elements) {
                Element xsdElement = (Element)node;
                String ref = xsdElement.getAttributeValue("ref");
                if (ref == null) {
                    throw new RuntimeException("No ref attribute for child element in " + this.name);
                }
                CMLElementType elementType = elementTypeMap.get(ref);
                if (elementType == null) {
                    throw new RuntimeException("No element known for " + ref);
                }
                this.elementTypeList.add(elementType);
            }
        }
    }

    public void processSimpleContent(Map<String, CMLType> typeMap) {
        if (this.extension != null) {
            String base = this.extension.getAttributeValue("base");
            if (base == null) {
                throw new RuntimeException("No base given for extension in " + this.name);
            }
            this.simpleContentType = typeMap.get(base);
            if (this.simpleContentType == null) {
                throw new RuntimeException("No type found for: " + base);
            }
        }
    }

    public List<CMLAttribute> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<CMLAttribute> attributeList) {
        this.attributeList = attributeList;
    }

    public List<String> getAttributeGroupNameList() {
        return this.attributeGroupNameList;
    }

    public void setAttributeGroupNameList(List<String> attributeGroupNameList) {
        this.attributeGroupNameList = attributeGroupNameList;
    }

    public Element getComplexType() {
        return this.complexType;
    }

    public void setComplexType(Element complexType) {
        this.complexType = complexType;
    }

    public Element getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(Element simpleType) {
        this.simpleType = simpleType;
    }

    public List<CMLElementType> getElementTypeList() {
        return this.elementTypeList;
    }

    public void setElementTypeList(List<CMLElementType> elementTypeList) {
        this.elementTypeList = elementTypeList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Element getXsdElement() {
        return this.xsdElement;
    }

    public void setXsdElement(Element xsdElement) {
        this.xsdElement = xsdElement;
    }

    public CMLType getSimpleContentType() {
        return this.simpleContentType;
    }

    public void setSimpleContentType(CMLType simpleContentType) {
        this.simpleContentType = simpleContentType;
    }

    public Element getExtension() {
        return this.extension;
    }

    public void setExtension(Element extension) {
        this.extension = extension;
    }

    public String toString() {
        String s2 = "";
        if (this.simpleContentType != null) {
            s2 = s2 + this.simpleContentType.listDataType() + "\n";
        } else {
            for (CMLElementType elementType : this.elementTypeList) {
                s2 = s2 + " + " + elementType.getName() + "\n";
            }
        }
        int i = 0;
        for (CMLAttribute attribute : this.attributeList) {
            s2 = s2 + "  " + attribute.getLocalName();
            if (++i % 6 != 0) continue;
            s2 = s2 + "\n";
        }
        s2 = s2 + "\n";
        return s2;
    }
}

