/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractBondSet;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomSet;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLBondSet
extends AbstractBondSet {
    public static final String NS = "cml:bondSet";
    protected Set<CMLBond> set = new LinkedHashSet<CMLBond>();
    protected HashMap<String, CMLBond> idTable;
    protected Map<String, CMLBond> atomRefs2Table;
    protected CMLMolecule molecule = null;

    public CMLBondSet() {
        this.init();
    }

    public CMLBondSet(CMLBondSet old) {
        super(old);
        this.init();
        for (CMLBond bond : old.set) {
            this.addBond(bond);
        }
    }

    @Override
    public Node copy() {
        return new CMLBondSet(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLBondSet();
    }

    public CMLBondSet(CMLMolecule mol2) {
        this();
        try {
            for (CMLBond bond : mol2.getBonds()) {
                this.addBond(bond);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CMLBondSet(List<CMLBond> bonds) {
        this();
        this.addBonds(bonds);
    }

    public static CMLBondSet createFromBonds(List<CMLBond> bonds) {
        CMLBondSet bondSet = new CMLBondSet();
        bondSet.addBonds(bonds);
        return bondSet;
    }

    public CMLBondSet(CMLBond[] bonds) throws RuntimeException {
        this();
        this.addBonds(bonds);
    }

    void init() {
        this.set = new LinkedHashSet<CMLBond>();
        this.idTable = new HashMap();
        this.setSize(0);
        this.setXMLContent("");
    }

    public CMLBondSet(CMLMolecule mol2, String[] bondId) {
        this();
        for (int i = 0; i < bondId.length; ++i) {
            CMLBond bond = mol2.getBondById(bondId[i]);
            if (bond == null) continue;
            this.addBond(bond);
        }
    }

    public void addBonds(CMLBond[] bonds) {
        if (bonds != null) {
            for (CMLBond b : bonds) {
                this.addBond(b);
            }
        }
    }

    public void addBonds(List<CMLBond> bonds) throws RuntimeException {
        for (CMLBond b : bonds) {
            this.addBond(b);
        }
    }

    public void addBond(CMLBond bond) throws RuntimeException {
        String id;
        if (bond == null) {
            throw new RuntimeException("Cannot add null bond");
        }
        if (this.set.contains(bond)) {
            throw new RuntimeException("duplicate bond in bondSet: " + bond.getId());
        }
        this.set.add(bond);
        if (this.idTable == null) {
            this.idTable = new HashMap();
        }
        if (this.atomRefs2Table == null) {
            this.atomRefs2Table = new HashMap<String, CMLBond>();
        }
        if ((id = bond.getId()) == null) {
            throw new RuntimeException("Bond in bondSet must have id");
        }
        if (this.getBondById(id) != null) {
            throw new RuntimeException("duplicate bond in bondSet: " + id);
        }
        this.idTable.put(bond.getId(), bond);
        this.addBondId(bond.getId());
        this.atomRefs2Table.put(CMLBond.atomHash(bond), bond);
    }

    void addBondId(String id) {
        String[] content = new String[]{};
        int size = 0;
        if (this.getSizeAttribute() != null) {
            content = this.getXMLContent();
            size = this.getSize();
        }
        this.setXMLContent(Util.addElementToStringArray(content, id));
        this.setSize(size + 1);
    }

    public void addBondSet(CMLBondSet bondSet) throws RuntimeException {
        this.addBonds(bondSet.getBonds());
    }

    public CMLBond getBond(int i) {
        List<CMLBond> bondList = this.getBonds();
        return bondList == null || i < 0 || i >= bondList.size() ? null : bondList.get(i);
    }

    public List<CMLBond> getBonds() {
        ArrayList<CMLBond> bonds = new ArrayList<CMLBond>();
        for (CMLBond bond : this.set) {
            bonds.add(bond);
        }
        return bonds;
    }

    public CMLAtomSet getAtomSet() {
        this.getMolecule();
        List<CMLBond> bonds = this.getBonds();
        CMLAtomSet atomSet = new CMLAtomSet();
        for (CMLBond bond : bonds) {
            List<CMLAtom> atoms = null;
            atoms = bond.getAtoms();
            atomSet.addAtoms(atoms);
        }
        return atomSet;
    }

    public boolean contains(CMLBond bond) {
        return this.set.contains(bond);
    }

    public int size() {
        this.getBonds();
        return this.set.size();
    }

    public List<String> getBondIDs() {
        List<CMLBond> bonds = this.getBonds();
        ArrayList<String> bondIDs = new ArrayList<String>();
        if (bonds != null) {
            for (CMLBond bond : bonds) {
                bondIDs.add(bond.getId());
            }
        }
        return bondIDs;
    }

    public CMLBondSet getBondsById(String[] ids) throws RuntimeException {
        CMLBondSet bondSet = new CMLBondSet();
        for (String id : ids) {
            CMLBond bond = this.getBondById(id);
            if (bond == null) {
                throw new RuntimeException("Cannot find bond: " + id);
            }
            bondSet.addBond(bond);
        }
        return bondSet;
    }

    public CMLBond getBondById(String id) {
        return this.idTable.get(id);
    }

    public boolean hasContentEqualTo(CMLBondSet otherBondSet) {
        boolean result = false;
        if (otherBondSet != null && this.size() == otherBondSet.size()) {
            CMLBondSet bondSet = this.complement(otherBondSet);
            result = bondSet.size() == 0;
        }
        return result;
    }

    public CMLBondSet complement(CMLBondSet bondSet2) {
        if (bondSet2 == null) {
            return this;
        }
        CMLBondSet newBondSet = new CMLBondSet();
        List<CMLBond> bonds = this.getBonds();
        for (int i = 0; i < bonds.size(); ++i) {
            if (bondSet2.contains(bonds.get(i))) continue;
            newBondSet.addBond(bonds.get(i));
        }
        return newBondSet;
    }

    public CMLBondSet union(CMLBondSet bondSet2) throws RuntimeException {
        CMLBondSet newBondSet = new CMLBondSet();
        List<CMLBond> bonds = this.getBonds();
        newBondSet.addBonds(bonds);
        List<CMLBond> bonds2 = bondSet2.getBonds();
        for (CMLBond bond2 : bonds2) {
            if (newBondSet.contains(bond2)) continue;
            newBondSet.addBond(bond2);
        }
        return newBondSet;
    }

    public CMLBondSet intersection(CMLBondSet bondSet2) throws RuntimeException {
        CMLBondSet newBondSet = new CMLBondSet();
        List<CMLBond> bonds2 = bondSet2.getBonds();
        for (CMLBond bond2 : bonds2) {
            if (!this.contains(bond2)) continue;
            newBondSet.addBond(bond2);
        }
        return newBondSet;
    }

    public CMLBondSet symmetricDifference(CMLBondSet bondSet2) {
        CMLBondSet newBondSet = new CMLBondSet();
        List<CMLBond> bonds = this.getBonds();
        for (int i = 0; i < bonds.size(); ++i) {
            if (bondSet2.contains(bonds.get(i))) continue;
            newBondSet.addBond(bonds.get(i));
        }
        List<CMLBond> bonds2 = bondSet2.getBonds();
        for (int i = 0; i < bonds2.size(); ++i) {
            CMLBond bond = bonds2.get(i);
            if (this.contains(bond)) continue;
            newBondSet.addBond(bond);
        }
        return newBondSet;
    }

    public CMLMolecule getMolecule() {
        if (this.molecule == null) {
            List<CMLBond> bonds = this.getBonds();
            if (bonds.size() > 0) {
                this.molecule = CMLMolecule.getMoleculeAncestor(bonds.get(0));
            } else {
                throw new RuntimeException("NO bonds in set...");
            }
        }
        return this.molecule;
    }

    public void removeBond(CMLBond bond) throws RuntimeException {
        if (bond != null) {
            if (!this.set.contains(bond)) {
                throw new RuntimeException("Bond not in set:" + bond.getId() + ":" + Util.concatenate(this.getXMLContent(), "/"));
            }
            this.set.remove(bond);
            String id = bond.getId();
            this.idTable.remove(id);
            String[] content = this.getXMLContent();
            content = Util.removeElementFromStringArray(content, id);
            this.setXMLContent(content);
            int c = this.getSize();
            this.setSize(c - 1);
        }
    }

    public void removeBondById(String id) throws RuntimeException {
        this.removeBond(this.getBondById(id));
    }

    public void removeBondSet(CMLBondSet bondSet) throws RuntimeException {
        if (bondSet != null) {
            for (CMLBond bond : bondSet.getBonds()) {
                if (!this.contains(bond)) continue;
                this.removeBond(bond);
            }
        }
    }

    public double getAverage2DBondLength(String[] excludeElements, String[] includeElements) {
        double sum = 0.0;
        int count = 0;
        List<CMLBond> bonds = this.getBonds();
        for (CMLBond bond : bonds) {
            String elem0 = bond.getAtom(0).getElementType();
            String elem1 = bond.getAtom(1).getElementType();
            boolean skip = false;
            if (excludeElements != null) {
                skip = Util.containsString(excludeElements, elem0) || Util.containsString(excludeElements, elem1);
            } else if (includeElements != null) {
                boolean bl = skip = !Util.containsString(includeElements, elem0) || !Util.containsString(excludeElements, elem1);
            }
            if (skip) continue;
            double length = bond.calculateBondLength(CMLElement.CoordinateType.TWOD);
            sum += length;
            ++count;
        }
        return count == 0 ? Double.NaN : sum / (double)count;
    }
}

