/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.attribute.DelimiterAttribute;
import org.xmlcml.cml.attribute.NamespaceRefAttribute;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.element.AbstractMatrix;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasDelimiter;
import org.xmlcml.cml.interfacex.HasDictRef;
import org.xmlcml.cml.interfacex.HasUnits;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntMatrix;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Util;

public class CMLMatrix
extends AbstractMatrix
implements HasUnits,
HasDataType,
HasDictRef,
HasDelimiter {
    public static final String NS = "cml:matrix";
    private DelimiterAttribute delimiterAttribute = null;

    public CMLMatrix() {
    }

    public CMLMatrix(CMLMatrix old) {
        super(old);
    }

    public Node copy() {
        return new CMLMatrix(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLMatrix();
    }

    private void ensureDelimiterAttribute() {
        if (this.delimiterAttribute == null) {
            this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        }
        if (this.delimiterAttribute == null) {
            this.delimiterAttribute = new DelimiterAttribute(" ");
        }
    }

    public CMLMatrix(double[][] matrix) {
        this.setMatrix(matrix);
    }

    public CMLMatrix(int[][] matrix) {
        this.setMatrix(matrix);
    }

    public CMLMatrix(int rows, int columns, double[] array) {
        this.setArray(rows, columns, array);
    }

    public CMLMatrix(int rows, int columns, int[] array) throws RuntimeException {
        this.setArray(rows, columns, array);
    }

    public static CMLMatrix createSquareMatrix(RealArray array, int rows, Type type) {
        CMLMatrix matrix = null;
        int n = array.size();
        RealSquareMatrix rsm = null;
        if (type == Type.SQUARE || type == Type.SQUARE_SYMMETRIC) {
            if (rows * rows != n) {
                throw new RuntimeException("square array size (" + n + ") incompatible with rows: " + rows);
            }
            matrix = new CMLMatrix(rows, rows, array.getArray());
        } else if (type == Type.SQUARE_SYMMETRIC_LT) {
            if (rows * (rows + 1) / 2 != n) {
                throw new RuntimeException("triangular array size (" + n + ") incompatible with rows: " + rows);
            }
            rsm = RealSquareMatrix.fromLowerTriangle(array);
        } else if (type == Type.SQUARE_SYMMETRIC_UT) {
            rsm = RealSquareMatrix.fromUpperTriangle(array);
        }
        if (rsm != null) {
            if (rsm.getRows() != rows) {
                throw new RuntimeException("array size (" + n + ") incompatible with rows: " + rows);
            }
            matrix = new CMLMatrix(rows, rows, rsm.getMatrixAsArray());
        }
        return matrix;
    }

    public int getRows() {
        if (super.getRowsAttribute() == null) {
            throw new RuntimeException("rows attribute must be set");
        }
        return super.getRows();
    }

    public int getColumns() {
        if (super.getColumnsAttribute() == null) {
            throw new RuntimeException("columns attribute must be set");
        }
        return super.getColumns();
    }

    String[] getStrings() {
        String[] ss = this.getSplitContent();
        return ss;
    }

    private String[] getSplitContent() throws RuntimeException {
        String content = this.getXMLContent().trim();
        this.ensureDelimiterAttribute();
        String[] ss = new String[]{};
        content = content.trim();
        if (content.length() > 0) {
            this.ensureDelimiterAttribute();
            ss = this.delimiterAttribute.getSplitContent(content);
        }
        this.removeWhitespaceDelimiterAttribute();
        return ss;
    }

    String[] getStringMatrixElements() throws RuntimeException {
        String regex;
        String delimiter = this.getDelimiter();
        int rows = this.getRows();
        int cols = this.getColumns();
        String content = this.getXMLContent();
        String[] stringArray = content.split(regex = delimiter == null || delimiter.trim().equals("") ? "\\s+" : delimiter);
        if (stringArray.length != rows * cols) {
            throw new RuntimeException("Bad array shape rows: " + rows + " cols: " + cols + " incompatible with elements: " + stringArray.length);
        }
        return stringArray;
    }

    static CMLMatrix createCMLMatrix(RealMatrix realMatrix) {
        CMLMatrix cmlMatrix = null;
        String delimiter = " ";
        cmlMatrix = new CMLMatrix();
        CMLMatrix.setXMLContent(cmlMatrix, delimiter, realMatrix.getMatrixAsArray());
        cmlMatrix.setColumns(realMatrix.getCols());
        cmlMatrix.setRows(realMatrix.getRows());
        cmlMatrix.setDelimiter(delimiter);
        cmlMatrix.removeWhitespaceDelimiterAttribute();
        return cmlMatrix;
    }

    static CMLMatrix createCMLMatrix(IntMatrix intMatrix) {
        CMLMatrix cmlMatrix = null;
        String delimiter = " ";
        cmlMatrix = new CMLMatrix();
        CMLMatrix.setXMLContent(cmlMatrix, delimiter, intMatrix.getMatrixAsArray());
        cmlMatrix.setColumns(intMatrix.getCols());
        cmlMatrix.setRows(intMatrix.getRows());
        cmlMatrix.setDelimiter(delimiter);
        cmlMatrix.removeWhitespaceDelimiterAttribute();
        return cmlMatrix;
    }

    static void setXMLContent(CMLMatrix cmlMatrix, String delimiter, double[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        cmlMatrix.setXMLContent(sb.toString());
    }

    static void setXMLContent(CMLMatrix cmlMatrix, String delimiter, int[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        cmlMatrix.setXMLContent(sb.toString());
    }

    public RealMatrix getEuclidRealMatrix() {
        RealMatrix rm = new RealMatrix(this.getRows(), this.getColumns(), this.getDoubleArray());
        return rm;
    }

    public IntMatrix getEuclidIntMatrix() {
        return new IntMatrix(this.getRows(), this.getColumns(), this.getIntegerArray());
    }

    public void setMatrix(double[][] mat) {
        RealMatrix mm3 = new RealMatrix(mat);
        String content = Util.concatenate(mm3.getMatrixAsArray(), " ");
        this.setRows(mm3.getRows());
        this.setColumns(mm3.getCols());
        this.setDataType("xsd:double");
        this.setXMLContent(content);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setMatrix(int[][] mat) {
        IntMatrix mm3 = new IntMatrix(mat);
        String content = Util.concatenate(mm3.getMatrixAsArray(), " ");
        this.setRows(mm3.getRows());
        this.setColumns(mm3.getCols());
        this.setDataType("xsd:integer");
        this.setXMLContent(content);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(int rows, int columns, double[] array) {
        RealMatrix euclRealMatrix = new RealMatrix(rows, columns, array);
        this.setRows(rows);
        this.setColumns(columns);
        this.setDataType("xsd:double");
        this.setXMLContent(Util.concatenate(euclRealMatrix.getMatrixAsArray(), " "));
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(int rows, int columns, int[] array) throws RuntimeException {
        IntMatrix euclIntMatrix = new IntMatrix(rows, columns, array);
        this.setRows(rows);
        this.setColumns(columns);
        this.setDataType("xsd:integer");
        this.setXMLContent(Util.concatenate(euclIntMatrix.getMatrixAsArray(), " "));
        this.removeWhitespaceDelimiterAttribute();
    }

    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return CMLType.getNormalizedValue(dataType);
    }

    public double[] getDoubleArray() {
        double[] dd = null;
        if (this.getDataType().equals("xsd:double") || this.getDataType().equals("fpx:real")) {
            dd = Util.splitToDoubleArray(this.getXMLContent(), "\\s+");
        }
        return dd;
    }

    public int[] getIntegerArray() {
        int[] ii = null;
        if ("xsd:integer".equals(this.getDataType())) {
            try {
                ii = Util.splitToIntArray(this.getXMLContent(), "\\s+");
            }
            catch (EuclidRuntimeException e) {
                throw new RuntimeException("bug " + e);
            }
        }
        return ii;
    }

    public double[][] getDoubleMatrix() {
        double[][] ddd = null;
        double[] dd = this.getDoubleArray();
        int count = 0;
        if (dd != null) {
            int rows = this.getRows();
            int columns = this.getColumns();
            ddd = new double[rows][columns];
            for (int i = 0; i < rows; ++i) {
                System.arraycopy(dd, count, ddd[i], 0, columns);
                count += columns;
            }
        }
        return ddd;
    }

    public int[][] getIntegerMatrix() {
        int[][] iii = null;
        int[] ii = this.getIntegerArray();
        int count = 0;
        if (ii != null) {
            int rows = this.getRows();
            int columns = this.getColumns();
            iii = new int[rows][columns];
            for (int i = 0; i < rows; ++i) {
                System.arraycopy(ii, count, iii[i], 0, columns);
                count += columns;
            }
        }
        return iii;
    }

    public CMLScalar getElementAt(int row, int col) {
        CMLScalar scalar = null;
        if (row >= 0 && row < this.getRows() && col >= 0 && col < this.getColumns()) {
            String dataType = this.getDataType();
            if (dataType == null) {
                dataType = "xsd:string";
            }
            if (dataType.equals("xsd:double")) {
                Double d = this.getDoubleMatrix()[row][col];
                scalar = new CMLScalar(d);
            } else if (dataType.equals("xsd:integer")) {
                Integer ii = this.getIntegerMatrix()[row][col];
                scalar = new CMLScalar(ii);
            }
            CMLArray.copyAttributesFromTo(this, scalar);
        }
        return scalar;
    }

    public boolean isSquare() {
        return this.getRows() == this.getColumns();
    }

    public boolean isEqualTo(CMLMatrix matrix, double eps) {
        return this.getRows() == matrix.getRows() && this.getColumns() == matrix.getColumns() && Util.isEqual(this.getDoubleArray(), matrix.getDoubleArray(), eps);
    }

    public CMLMatrix multiply(CMLMatrix m22) {
        RealMatrix t = null;
        int m2r = m22.getRows();
        int m2c = m22.getColumns();
        RealMatrix teucl3 = new RealMatrix(m2r, m2c, this.getDoubleArray());
        t = teucl3.multiply(m22.getEuclidRealMatrix());
        CMLMatrix newMatrix = new CMLMatrix(m2r, m2c, t.getMatrixAsArray());
        newMatrix.removeWhitespaceDelimiterAttribute();
        return newMatrix;
    }

    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }

    public void removeWhitespaceDelimiterAttribute() {
        CMLArray.removeWhitespaceDelimiterAttribute(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        RECTANGULAR("rectangular"),
        SQUARE("square"),
        SQUARE_SYMMETRIC("squareSymmetric"),
        SQUARE_SYMMETRIC_LT("squareSymmetricLT"),
        SQUARE_SYMMETRIC_UT("squareSymmetricUT"),
        SQUARE_ANTISYMMETRIC("squareAntisymmetric"),
        SQUARE_ANTISYMMETRIC_LT("squareAntisymmetricLT"),
        SQUARE_ANTISYMMETRIC_UT("squareAntisymmetricUT"),
        DIAGONAL("diagonal"),
        UPPER_TRIANGULAR("upperTriangular"),
        UPPER_TRIANGULAR_UT("upperTriangularUT"),
        LOWER_TRIANGULAR("lowerTriangular"),
        LOWER_TRIANGULAR_LT("lowerTriangularLT"),
        UNIT("unit"),
        UNITARY("unitary"),
        ROW_EIGENVECTORS("rowEigenvectors"),
        ROTATION22("rotation22"),
        ROTATION_TRANSLATION32("rotationTranslation32"),
        HOMOGENEOUS33("homogeneous33"),
        ROTATION33("rotation33"),
        ROTATION_TRANSLATION43("rotationTranslation43"),
        HOMOGENEOUS44("homogeneous44");

        public String value;

        private Type(String v) {
            this.value = v;
        }
    }
}

