/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.List;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Array;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Real2Vector
implements EuclidConstants {
    List<Real2> vector = new ArrayList<Real2>();
    private static final long serialVersionUID = 3834026952770990647L;

    public Real2Vector() {
    }

    public Real2Vector(double[] flarray) throws EuclidRuntimeException {
        this();
        int count = 0;
        int n = flarray.length / 2;
        if (flarray.length != 2 * n) {
            throw new EuclidRuntimeException("size must be multiple of 2");
        }
        for (int i = 0; i < n; ++i) {
            Real2 p = new Real2(flarray[count++], flarray[count++]);
            this.vector.add(p);
        }
    }

    public Real2Vector(int n, double[] x, double[] y) throws EuclidRuntimeException {
        this();
        Util.check(x, n);
        Util.check(y, n);
        for (int i = 0; i < n; ++i) {
            this.vector.add(new Real2(x[i], y[i]));
        }
    }

    public Real2Vector(Real2Array r2a) {
        this(r2a.size(), r2a.getXArray().getArray(), r2a.getYArray().getArray());
    }

    public Real2Vector(RealArray m3) throws EuclidRuntimeException {
        this();
        int count = m3.size() / 2;
        if (m3.size() != count * 2) {
            throw new EuclidRuntimeException("size must be multiple of 2");
        }
        double[] marray = m3.getArray();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            this.vector.add(new Real2(marray[j++], marray[j++]));
        }
    }

    public Real2Vector(Real2Vector pv) {
        this();
        for (int i = 0; i < pv.size(); ++i) {
            this.vector.add(new Real2(pv.get(i)));
        }
    }

    public Real2Vector(List<Real2> rList) {
        this();
        for (Real2 r : rList) {
            this.add(r);
        }
    }

    public void add(Real2 p) {
        this.vector.add(p);
    }

    public Real2 get(int i) {
        return this.vector.get(i);
    }

    public void set(int i, Real2 v) throws EuclidRuntimeException {
        this.vector.set(i, v);
    }

    public int size() {
        return this.vector.size();
    }

    public List<Real2> getVector() {
        return this.vector;
    }

    public RealRange getRange(Axis.Axis2 ax) {
        RealArray temp = new RealArray(this.vector.size());
        double[] dd = temp.getArray();
        int i = 0;
        for (Real2 p : this.vector) {
            dd[i++] = ax.equals((Object)Axis.Axis2.X) ? p.getX() : p.getY();
        }
        RealRange range = new RealRange();
        if (this.size() > 0) {
            range.add(temp.smallestElement());
            range.add(temp.largestElement());
        }
        return range;
    }

    public Real2Range getRange2() {
        Axis.Axis2[] axes = Axis.Axis2.values();
        Real2Range range2 = new Real2Range();
        for (Axis.Axis2 ax : axes) {
            RealRange range = this.getRange(ax);
            range2.add(ax, range);
        }
        return range2;
    }

    public Real2Vector subArray(IntSet is) throws EuclidRuntimeException {
        Real2Vector sub = new Real2Vector();
        for (int i = 0; i < is.size(); ++i) {
            int ix = is.elementAt(i);
            if (ix < 0 || ix >= this.vector.size()) {
                throw new EuclidRuntimeException("index out of range " + ix);
            }
            sub.add(new Real2(this.getReal2(ix)));
        }
        return sub;
    }

    public IntSet subSet(Real2Range r) {
        IntSet is = new IntSet();
        for (int i = 0; i < this.size(); ++i) {
            Real2 point = this.vector.get(i);
            if (!r.includes(point)) continue;
            is.addElement(i);
        }
        return is;
    }

    public int getClosestPoint(Real2 p) {
        double dist2 = Double.POSITIVE_INFINITY;
        int ipoint = -1;
        for (int i = 0; i < this.size(); ++i) {
            Real2 point = this.get(i);
            double dx = p.x - point.x;
            double dy = p.y - point.y;
            double d2 = dx * dx + dy * dy;
            if (!(d2 < dist2)) continue;
            dist2 = d2;
            ipoint = i;
        }
        return ipoint;
    }

    public int getPoint(Real2 p, double width, double height) {
        double hwidth = width / 2.0;
        double hheight = height / 2.0;
        for (int i = 0; i < this.size(); ++i) {
            Real2 point = this.get(i);
            if (!(Math.abs(p.x - point.x) <= hwidth) || !(Math.abs(p.y - point.y) <= hheight)) continue;
            return i;
        }
        return -1;
    }

    public void translateBy(Real2 v) {
        for (int i = 0; i < this.size(); ++i) {
            Real2 p = this.getReal2(i).plus(v);
            this.vector.set(i, p);
        }
    }

    public void plus(Real2 p) {
        this.translateBy(p);
    }

    public void subtract(Real2 v) {
        Real2 v1 = new Real2(v);
        v1.negative();
        this.plus(v1);
    }

    public void multiplyBy(double f) {
        for (int i = 0; i < this.size(); ++i) {
            Real2 p = this.getReal2(i).multiplyBy(f);
            this.vector.set(i, p);
        }
    }

    public double distance(int i1, int i2) {
        Real2 v1 = this.getReal2(i1).subtract(this.getReal2(i2));
        return v1.getLength();
    }

    public double distance(IntSet is) throws EuclidRuntimeException {
        if (is.size() != 2) {
            throw new EuclidRuntimeException("index must be multiple of 2");
        }
        return this.distance(is.elementAt(0), is.elementAt(1));
    }

    public Angle angle(int i1, int i2, int i3) throws EuclidRuntimeException {
        return Real2.getAngle(this.getReal2(i1), this.getReal2(i2), this.getReal2(i3));
    }

    public Angle angle(IntSet is) throws EuclidRuntimeException {
        if (is.size() != 3) {
            throw new EuclidRuntimeException("index must be multiple of 3");
        }
        return this.angle(is.elementAt(0), is.elementAt(1), is.elementAt(2));
    }

    public Real2 getReal2(int i) {
        return this.get(i);
    }

    public List<Real2> getReal2List() {
        return this.vector;
    }

    public RealArray getXY() {
        double[] f = new double[2 * this.size()];
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Real2 p = this.getReal2(i);
            f[count++] = p.getX();
            f[count++] = p.getY();
        }
        return new RealArray(f);
    }

    public RealArray getXArray() {
        double[] f = new double[this.size()];
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Real2 p = this.getReal2(i);
            f[count++] = p.getX();
        }
        return new RealArray(f);
    }

    public RealArray getYArray() {
        double[] f = new double[this.size()];
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Real2 p = this.getReal2(i);
            f[count++] = p.getY();
        }
        return new RealArray(f);
    }

    public Real2Array getReal2Array() {
        return new Real2Array(this.getXArray(), this.getYArray());
    }

    public double getCoordinate(int i, Axis.Axis2 j) {
        return j.value == 0 ? this.getReal2(i).getX() : this.getReal2(i).getY();
    }

    public RealArray getXorY(Axis.Axis2 axis) {
        double[] f = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            f[i] = axis.value == 0 ? this.getReal2(i).getX() : this.getReal2(i).getY();
        }
        return new RealArray(f);
    }

    public void swapXY() {
        for (int i = 0; i < this.size(); ++i) {
            Real2 temp = this.vector.get(i);
            temp.swap();
            this.vector.set(i, temp);
        }
    }

    public Real2Vector sortAscending(Axis.Axis2 ax) {
        IntSet is = this.getXorY(ax).indexSortAscending();
        Real2Vector temp = new Real2Vector();
        for (int i = 0; i < this.size(); ++i) {
            temp.add(this.get(is.elementAt(i)));
        }
        return temp;
    }

    public Real2Vector sortDescending(Axis.Axis2 ax) {
        IntSet is = this.getXorY(ax).indexSortDescending();
        Real2Vector temp = new Real2Vector();
        for (int i = 0; i < this.size(); ++i) {
            temp.add(this.get(is.elementAt(i)));
        }
        return temp;
    }

    public void transformBy(Transform2 t) {
        for (int i = 0; i < this.size(); ++i) {
            Real2 point = this.vector.get(i);
            point.transformBy(t);
            this.vector.set(i, point);
        }
    }

    public double getSquaredDifference(Real2Vector r2v) {
        double sum = Double.NaN;
        if (r2v.size() != 0 && this.vector.size() != 0 && r2v.size() == this.vector.size()) {
            sum = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                Real2 xy1 = this.get(i);
                Real2 xy2 = r2v.get(i);
                double d2 = xy1.getSquaredDistance(xy2);
                sum += d2;
            }
        }
        return sum;
    }

    public double[] getSquaredDistances(Real2Vector r2v) {
        double[] dist2 = null;
        if (r2v.size() == this.vector.size()) {
            dist2 = new double[this.vector.size()];
            for (int i = 0; i < this.size(); ++i) {
                Real2 xy1 = this.get(i);
                Real2 xy2 = r2v.get(i);
                dist2[i] = xy1.getSquaredDistance(xy2);
            }
        }
        return dist2;
    }

    public void rotateAboutCentroid(Angle a) {
        Real2 temp = this.getCentroid();
        Transform2 t2 = new Transform2(a);
        t2 = new Transform2(t2, temp);
        this.transformBy(t2);
    }

    public void flipX() {
        for (Real2 r2 : this.vector) {
            r2.setX(-r2.getX());
        }
    }

    public void flipY() {
        for (Real2 r2 : this.vector) {
            r2.setY(-r2.getY());
        }
    }

    public static Real2Vector regularPolygon(int nsides, double rad, double angle) {
        Real2Vector temp = new Real2Vector();
        double dangle = Math.PI * 2 / new Integer(nsides).doubleValue();
        for (int i = 0; i < nsides; ++i) {
            Real2 p = new Real2(rad * Math.sin(angle), rad * Math.cos(angle));
            temp.add(p);
            angle += dangle;
        }
        return temp;
    }

    public static Real2Vector partOfRegularPolygon(int nsides, int pointn, double dist0n) {
        Real2Vector temp = new Real2Vector();
        double dangle = Math.PI * 2 / new Integer(nsides).doubleValue();
        double sinAngle2 = Math.sin((double)pointn * dangle / 2.0);
        double rad = 0.5 * dist0n / sinAngle2;
        double angle = dangle;
        for (int i = pointn; i <= nsides; ++i) {
            Real2 p = new Real2(rad * Math.sin(angle), rad * Math.cos(angle));
            temp.add(p);
            angle += dangle;
        }
        return temp;
    }

    public static Real2Vector regularPolygon(int nsides, double rad) {
        return Real2Vector.regularPolygon(nsides, rad, 0.0);
    }

    public static Real2Vector regularPolygon(int nsides, Real2 p1, Real2 p2, boolean flip) {
        double halfAngle = Math.PI / (double)nsides;
        Vector2 p1top2 = new Vector2(p2.subtract(p1));
        double halfSidelength = p1top2.getLength() / 2.0;
        double rad = halfSidelength / Math.sin(halfAngle);
        Real2Vector temp = Real2Vector.regularPolygon(nsides, rad);
        if (flip) {
            temp.flipY();
        }
        Angle rot = null;
        rot = p1top2.getAngleMadeWith(new Vector2(0.0, 1.0));
        rot = new Vector2(1.0, 0.0).getAngleMadeWith(p1top2);
        temp.transformBy(new Transform2(rot));
        temp.transformBy(new Transform2(new Angle(-halfAngle)));
        Real2 shift = p1.subtract(new Vector2(temp.get(0)));
        temp.transformBy(new Transform2(new Vector2(shift)));
        return temp;
    }

    public Real2 getCentroid() {
        if (this.vector.size() < 1) {
            return null;
        }
        Real2 p = new Real2();
        for (int j = 0; j < this.vector.size(); ++j) {
            Real2 pp = this.vector.get(j);
            p = p.plus(pp);
        }
        double scale = 1.0 / new Double(this.vector.size());
        p = p.multiplyBy(scale);
        return p;
    }

    public int getSerialOfNearestPoint(Real2 point) {
        double dist = Double.MAX_VALUE;
        int serial = -1;
        for (int j = 0; j < this.vector.size(); ++j) {
            double d = this.get(j).subtract(point).getLength();
            if (!(d < dist)) continue;
            serial = j;
            dist = d;
        }
        return serial;
    }

    public RealMatrix getDistanceMatrix(List<Real2> coords2) {
        int size = this.vector.size();
        int size2 = coords2.size();
        RealMatrix distMatrix = new RealMatrix(size, size2);
        double[][] mat = distMatrix.getMatrix();
        for (int i = 0; i < size; ++i) {
            Real2 ri = this.get(i);
            for (int j = 0; j < size2; ++j) {
                double dij;
                Real2 rj = coords2.get(j);
                mat[i][j] = dij = ri.getDistance(rj);
            }
        }
        return distMatrix;
    }

    public boolean encloses(Real2 point) {
        int nvect = this.vector.size();
        int j = nvect - 1;
        boolean oddNodes = false;
        double x = point.getX();
        double y = point.getY();
        int i = 0;
        while (i < nvect) {
            double xi = this.vector.get(i).getX();
            double yi = this.vector.get(i).getY();
            double xj = this.vector.get(j).getX();
            double yj = this.vector.get(j).getY();
            if ((yi < y && yj >= y || yj < y && yi >= y) && xi + (y - yi) / (yj - yi) * (xj - xi) < x) {
                oddNodes = !oddNodes;
            }
            j = i++;
        }
        return oddNodes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.getReal2(i));
            if (i >= this.size() - 1) continue;
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

