/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Matching;

final class ArbitraryMatching {
    ArbitraryMatching() {
    }

    static int initial(Graph g2, Matching m3, BitSet s2) {
        int nMatched = 0;
        int v = s2.nextSetBit(0);
        while (v >= 0) {
            if (!m3.matched(v)) {
                int d = g2.degree(v);
                for (int j = 0; j < d; ++j) {
                    Edge e = g2.edgeAt(v, j);
                    int w = e.other(v);
                    if (e.bond() == Bond.SINGLE || !m3.unmatched(w) || !s2.get(w)) continue;
                    m3.match(v, w);
                    nMatched += 2;
                    break;
                }
            }
            v = s2.nextSetBit(v + 1);
        }
        return nMatched;
    }

    static int dfs(Graph g2, Matching m3, BitSet s2) {
        int nMatched = 0;
        BitSet unvisited = (BitSet)s2.clone();
        int v = unvisited.nextSetBit(0);
        while (v >= 0) {
            if (!m3.matched(v)) {
                int cnt = 0;
                int d = g2.degree(v);
                while (--d >= 0) {
                    int w = g2.edgeAt(v, d).other(v);
                    if (!unvisited.get(w)) continue;
                    ++cnt;
                }
                if (cnt == 1) {
                    nMatched += ArbitraryMatching.dfsVisit(g2, v, m3, unvisited, true);
                }
            }
            v = unvisited.nextSetBit(v + 1);
        }
        v = unvisited.nextSetBit(0);
        while (v >= 0) {
            if (!m3.matched(v)) {
                nMatched += ArbitraryMatching.dfsVisit(g2, v, m3, unvisited, true);
            }
            v = unvisited.nextSetBit(v + 1);
        }
        return nMatched;
    }

    static int dfsVisit(Graph g2, int v, Matching m3, BitSet unvisited, boolean match) {
        unvisited.clear(v);
        int nMatched = 0;
        int d = g2.degree(v);
        while (--d >= 0) {
            int w = g2.edgeAt(v, d).other(v);
            if (!unvisited.get(w)) continue;
            if (match) {
                m3.match(v, w);
                return 2 + ArbitraryMatching.dfsVisit(g2, w, m3, unvisited, false);
            }
            nMatched += ArbitraryMatching.dfsVisit(g2, w, m3, unvisited, true);
        }
        return nMatched;
    }

    static int augmentOnce(Graph g2, Matching m3, int nMatched, BitSet s2) {
        int vStart = s2.nextSetBit(0);
        while (vStart >= 0 && m3.matched(vStart)) {
            vStart = s2.nextSetBit(vStart + 1);
        }
        int vEnd = s2.nextSetBit(vStart + 1);
        while (vEnd >= 0 && m3.matched(vEnd)) {
            vEnd = s2.nextSetBit(vEnd + 1);
        }
        int[] path = new int[g2.order()];
        int len = ArbitraryMatching.findPath(g2, vStart, vEnd, s2, path, 0, m3, false);
        if (len > 0) {
            for (int i = 0; i < len; i += 2) {
                m3.match(path[i], path[i + 1]);
            }
            nMatched += 2;
        }
        return nMatched;
    }

    static int findPath(Graph g2, int v, int end, BitSet unvisited, int[] path, int len, Matching m3, boolean matchNeeded) {
        unvisited.clear(v);
        path[len++] = v;
        int d = g2.degree(v);
        for (int j = 0; j < d; ++j) {
            int l;
            int w;
            Edge e = g2.edgeAt(v, j);
            if (e.bond() == Bond.SINGLE || !unvisited.get(w = e.other(v))) continue;
            if (w == end) {
                path[len] = w;
                unvisited.set(v);
                return (++len & 1) == 1 ? 0 : len;
            }
            if (m3.other(w) == v != matchNeeded || (l = ArbitraryMatching.findPath(g2, w, end, unvisited, path, len, m3, !matchNeeded)) <= 0) continue;
            unvisited.set(v);
            return l;
        }
        unvisited.set(v);
        return 0;
    }
}

