/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class ExplicitToImplicit
extends AbstractFunction<Graph, Graph> {
    ExplicitToImplicit() {
    }

    @Override
    public Graph apply(Graph g2) {
        int u;
        Graph h2 = new Graph(g2.order());
        for (u = 0; u < g2.order(); ++u) {
            h2.addAtom(g2.atom(u));
            h2.addTopology(g2.topologyOf(u));
        }
        for (u = 0; u < g2.order(); ++u) {
            for (Edge e : g2.edges(u)) {
                if (e.other(u) <= u) continue;
                h2.addEdge(ExplicitToImplicit.toImplicitEdge(g2, e));
            }
        }
        return h2;
    }

    static Edge toImplicitEdge(Graph g2, Edge e) {
        int u = e.either();
        int v = e.other(u);
        if (e.bond() == Bond.SINGLE || e.bond() == Bond.AROMATIC) {
            return new Edge(u, v, ExplicitToImplicit.type(g2.atom(u), g2.atom(v), e.bond()));
        }
        return e;
    }

    static Bond type(Atom u, Atom v, Bond b) {
        if (u.aromatic() && v.aromatic()) {
            return b == Bond.AROMATIC ? Bond.IMPLICIT : b;
        }
        return b == Bond.AROMATIC ? Bond.AROMATIC : Bond.IMPLICIT;
    }
}

