/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

final class FromSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    FromSubsetAtoms() {
    }

    @Override
    public Graph apply(Graph g2) {
        Graph h2 = new Graph(g2.order());
        for (int u = 0; u < g2.order(); ++u) {
            h2.addAtom(FromSubsetAtoms.fromSubset(g2.atom(u), g2.bondedValence(u), g2.degree(u)));
            h2.addTopology(g2.topologyOf(u));
        }
        for (Edge e : g2.edges()) {
            h2.addEdge(e);
        }
        return h2;
    }

    static Atom fromSubset(Atom a, int sum, int deg) {
        if (!a.subset()) {
            return a;
        }
        Element e = a.element();
        if (a.aromatic() && deg <= sum) {
            ++sum;
        }
        int hCount = a.aromatic() ? Element.implicitAromHydrogenCount(e, sum) : Element.implicitHydrogenCount(e, sum);
        return new AtomImpl.BracketAtom(-1, a.element(), hCount, 0, 0, a.aromatic());
    }
}

