/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import uk.ac.ebi.beam.AddDirectionalLabels;
import uk.ac.ebi.beam.ExplicitToImplicit;
import uk.ac.ebi.beam.FromSubsetAtoms;
import uk.ac.ebi.beam.FromTrigonalTopology;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.ImplicitToExplicit;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.NormaliseDirectionalLabels;
import uk.ac.ebi.beam.RenumberAtomMaps;
import uk.ac.ebi.beam.ToSubsetAtoms;
import uk.ac.ebi.beam.ToTrigonalTopology;

public final class Functions {
    private static final ToTrigonalTopology ttt = new ToTrigonalTopology();
    private static final FromTrigonalTopology ftt = new FromTrigonalTopology();
    private static final ExplicitToImplicit eti = new ExplicitToImplicit();
    private static final ImplicitToExplicit ite = new ImplicitToExplicit();
    private static final ToSubsetAtoms tsa = new ToSubsetAtoms();
    private static final FromSubsetAtoms fsa = new FromSubsetAtoms();
    private static final NormaliseDirectionalLabels ndl = new NormaliseDirectionalLabels();
    private static final AddDirectionalLabels adl = new AddDirectionalLabels();

    private Functions() {
    }

    public static Graph randomise(Graph g2) {
        return g2.permute(Functions.random(g2.order()));
    }

    public static Graph reverse(Graph g2) {
        return g2.permute(Functions.reverse(g2.order()));
    }

    public static Graph atomBasedDBStereo(Graph g2) {
        return eti.apply(ttt.apply(ite.apply(g2)));
    }

    public static Graph bondBasedDBStereo(Graph g2) {
        return eti.apply(ftt.apply(ite.apply(g2)));
    }

    public static Graph expand(Graph g2) {
        return eti.apply(fsa.apply(ite.apply(g2)));
    }

    public static Graph collapse(Graph g2) {
        return eti.apply(tsa.apply(ite.apply(g2)));
    }

    public static Graph normaliseDirectionalLabels(Graph g2) throws InvalidSmilesException {
        if (g2.getFlags(8) == 0) {
            return g2;
        }
        return ndl.apply(g2);
    }

    private static int[] ident(int n) {
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        return p;
    }

    public static Graph canonicalize(Graph g2, final long[] labels) {
        Integer[] is = new Integer[g2.order()];
        for (int i = 0; i < is.length; ++i) {
            is[i] = i;
        }
        Arrays.sort(is, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                if (labels[i] > labels[j]) {
                    return 1;
                }
                if (labels[i] < labels[j]) {
                    return -1;
                }
                return 0;
            }
        });
        int[] p = new int[g2.order()];
        for (int i = 0; i < is.length; ++i) {
            p[is[i].intValue()] = i;
        }
        return g2.permute(p);
    }

    public static Graph renumberAtomMaps(Graph g2) {
        RenumberAtomMaps.renumber(g2);
        return g2;
    }

    private static int[] random(int n) {
        int[] p = Functions.ident(n);
        Random rnd = new Random();
        for (int i = n; i > 1; --i) {
            Functions.swap(p, i - 1, rnd.nextInt(i));
        }
        return p;
    }

    private static int[] reverse(int n) {
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = n - i - 1;
        }
        return p;
    }

    private static int[] inv(int[] p) {
        int[] q = (int[])p.clone();
        for (int i = 0; i < p.length; ++i) {
            q[p[i]] = i;
        }
        return q;
    }

    private static void swap(int[] p, int i, int j) {
        int tmp = p[i];
        p[i] = p[j];
        p[j] = tmp;
    }
}

