/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class ImplicitToExplicit
extends AbstractFunction<Graph, Graph> {
    ImplicitToExplicit() {
    }

    @Override
    public Graph apply(Graph g2) {
        int u;
        Graph h2 = new Graph(g2.order());
        for (u = 0; u < g2.order(); ++u) {
            h2.addAtom(g2.atom(u));
            h2.addTopology(g2.topologyOf(u));
        }
        for (u = 0; u < g2.order(); ++u) {
            for (Edge e : g2.edges(u)) {
                if (e.other(u) <= u) continue;
                h2.addEdge(ImplicitToExplicit.toExplicitEdge(g2, e));
            }
        }
        return h2;
    }

    static Edge toExplicitEdge(Graph g2, Edge e) {
        int u = e.either();
        int v = e.other(u);
        if (e.bond() == Bond.IMPLICIT) {
            return new Edge(u, v, ImplicitToExplicit.type(g2.atom(u), g2.atom(v)));
        }
        return e;
    }

    static Bond type(Atom u, Atom v) {
        return u.aromatic() && v.aromatic() ? Bond.AROMATIC : Bond.SINGLE;
    }
}

