/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class RemoveUpDownBonds
extends AbstractFunction<Graph, Graph> {
    RemoveUpDownBonds() {
    }

    @Override
    public Graph apply(Graph g2) throws InvalidSmilesException {
        Graph h2 = new Graph(g2.order());
        for (int u = 0; u < g2.order(); ++u) {
            h2.addAtom(g2.atom(u));
            h2.addTopology(g2.topologyOf(u));
        }
        int[] ordering = new DepthFirstOrder(g2).visited;
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        TreeSet<Integer> dbCentres = new TreeSet<Integer>();
        for (int u = 0; u < g2.order(); ++u) {
            for (Edge e : g2.edges(u)) {
                if (e.other(u) <= u || e.bond() != Bond.DOUBLE) continue;
                this.removeRedundant(g2, e, ordering, replacements);
                dbCentres.add(u);
                dbCentres.add(e.other(u));
            }
        }
        for (Edge e : new HashSet(replacements.keySet())) {
            if (!dbCentres.contains(e.either()) || !dbCentres.contains(e.other(e.either()))) continue;
            replacements.remove(e);
        }
        for (int u = 0; u < g2.order(); ++u) {
            for (Edge e : g2.edges(u)) {
                if (e.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h2.addEdge(e);
            }
        }
        return h2;
    }

    private void removeRedundant(Graph g2, Edge e, int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int u = e.either();
        int v = e.other(u);
        this.replaceImplWithExpl(g2, e, u, ordering, acc);
        this.replaceImplWithExpl(g2, e, v, ordering, acc);
    }

    private void replaceImplWithExpl(Graph g2, Edge e, final int u, final int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        TreeSet<Edge> edges = new TreeSet<Edge>(Collections.reverseOrder(new Comparator<Edge>(){

            @Override
            public int compare(Edge e, Edge f) {
                int w;
                int v = ordering[e.other(u)];
                if (v > (w = ordering[f.other(u)])) {
                    return 1;
                }
                if (v < w) {
                    return -1;
                }
                return 0;
            }
        }));
        for (Edge f : g2.edges(u)) {
            switch (f.bond()) {
                case DOUBLE: {
                    if (f.equals(e)) break;
                    return;
                }
                case UP: 
                case DOWN: {
                    edges.add(f);
                }
            }
        }
        if (edges.size() == 2) {
            Iterator it = edges.iterator();
            Edge explicit = (Edge)it.next();
            int v = explicit.either();
            int w = explicit.other(v);
            acc.put(explicit, new Edge(v, w, Bond.IMPLICIT));
        } else if (edges.size() > 2) {
            throw new InvalidSmilesException("Too many up/down bonds on double bonded atom");
        }
    }

    private static final class DepthFirstOrder {
        private final Graph g;
        private final int[] visited;
        private int i;

        private DepthFirstOrder(Graph g2) {
            this.g = g2;
            this.visited = new int[g2.order()];
            Arrays.fill(this.visited, -1);
            for (int u = 0; u < g2.order(); ++u) {
                if (this.visited[u] >= 0) continue;
                this.visit(u);
            }
        }

        private void visit(int u) {
            ++this.i;
            for (Edge e : this.g.edges(u)) {
                int v = e.other(u);
                if (this.visited[v] >= 0) continue;
                this.visit(v);
            }
        }
    }
}

