/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AtomBuilder;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class RenumberAtomMaps {
    RenumberAtomMaps() {
    }

    private static void traverse(State s2, int idx) {
        s2.visit[idx] = true;
        int mapIdx = s2.g.atom(idx).atomClass();
        if (mapIdx != 0) {
            if (s2.map[mapIdx] == 0) {
                s2.map[mapIdx] = ++s2.nMaps;
            }
            mapIdx = s2.map[mapIdx];
            s2.g.setAtom(idx, AtomBuilder.fromExisting(s2.g.atom(idx)).atomClass(mapIdx).build());
        }
        for (Edge e : s2.g.edges(idx)) {
            int nbr = e.other(idx);
            if (s2.visit[nbr]) continue;
            RenumberAtomMaps.traverse(s2, nbr);
        }
    }

    static void renumber(Graph g2) {
        int maxMapIdx = 0;
        for (int i = 0; i < g2.order(); ++i) {
            maxMapIdx = Math.max(maxMapIdx, g2.atom(i).atomClass());
        }
        if (maxMapIdx == 0) {
            return;
        }
        State state = new State(g2, maxMapIdx);
        for (int i = 0; i < g2.order(); ++i) {
            if (state.visit[i]) continue;
            RenumberAtomMaps.traverse(state, i);
        }
    }

    private static final class State {
        Graph g;
        boolean[] visit;
        int[] map;
        int nMaps;

        public State(Graph g2, int maxidx) {
            this.g = g2;
            this.visit = new boolean[g2.order()];
            this.map = new int[maxidx + 1];
            this.nMaps = 0;
        }
    }
}

