/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], "2.2.0-rc.2");
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
402: function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(1).__importStar(e(403));o.Widgets=r;e(7).register_models(r)},
403: function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var a=r(404);t.AbstractButton=a.AbstractButton;var o=r(407);t.AbstractIcon=o.AbstractIcon;var u=r(408);t.AutocompleteInput=u.AutocompleteInput;var n=r(413);t.Button=n.Button;var i=r(414);t.CheckboxButtonGroup=i.CheckboxButtonGroup;var v=r(416);t.CheckboxGroup=v.CheckboxGroup;var p=r(418);t.ColorPicker=p.ColorPicker;var c=r(419);t.DatePicker=c.DatePicker;var l=r(422);t.DateRangeSlider=l.DateRangeSlider;var d=r(428);t.DateSlider=d.DateSlider;var I=r(429);t.Div=I.Div;var g=r(433);t.Dropdown=g.Dropdown;var S=r(434);t.FileInput=S.FileInput;var P=r(410);t.InputWidget=P.InputWidget;var k=r(430);t.Markup=k.Markup;var x=r(435);t.MultiSelect=x.MultiSelect;var D=r(436);t.Paragraph=D.Paragraph;var b=r(437);t.PasswordInput=b.PasswordInput;var s=r(438);t.MultiChoice=s.MultiChoice;var h=r(441);t.NumericInput=h.NumericInput;var A=r(444);t.PreText=A.PreText;var B=r(445);t.RadioButtonGroup=B.RadioButtonGroup;var C=r(446);t.RadioGroup=C.RadioGroup;var G=r(447);t.RangeSlider=G.RangeSlider;var R=r(448);t.Select=R.Select;var T=r(449);t.Slider=T.Slider;var M=r(450);t.Spinner=M.Spinner;var m=r(409);t.TextInput=m.TextInput;var w=r(451);t.TextAreaInput=w.TextAreaInput;var W=r(452);t.Toggle=W.Toggle;var _=r(472);t.Widget=_.Widget},
404: function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(1),s=i.__importStar(t(18)),o=t(72),l=t(115),r=t(405),_=t(281),c=i.__importDefault(t(283));class u extends r.ControlView{*controls(){yield this.button_el}async lazy_initialize(){await super.lazy_initialize();const{icon:t}=this.model;null!=t&&(this.icon_view=await l.build_view(t,{parent:this}))}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}remove(){null!=this.icon_view&&this.icon_view.remove(),super.remove()}styles(){return[...super.styles(),c.default]}_render_button(...t){return o.button({type:"button",disabled:this.model.disabled,class:[_.bk_btn,_.bk_btn_type(this.model.button_type)]},...t)}render(){super.render(),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",()=>this.click()),null!=this.icon_view&&(o.prepend(this.button_el,this.icon_view.el,o.nbsp()),this.icon_view.render()),this.group_el=o.div({class:_.bk_btn_group},this.button_el),this.el.appendChild(this.group_el)}click(){}}n.AbstractButtonView=u,u.__name__="AbstractButtonView";class a extends r.Control{constructor(t){super(t)}static init_AbstractButton(){this.define({label:[s.String,"Button"],icon:[s.Instance],button_type:[s.ButtonType,"default"]})}}n.AbstractButton=a,a.__name__="AbstractButton",a.init_AbstractButton()},
405: function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(472),n=e(72);class i extends s.WidgetView{connect_signals(){super.connect_signals();const e=this.model.properties;this.on_change(e.disabled,()=>{for(const e of this.controls())n.toggle_attribute(e,"disabled",this.model.disabled)})}}o.ControlView=i,i.__name__="ControlView";class l extends s.Widget{constructor(e){super(e)}}o.Control=l,l.__name__="Control"},
472: function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const o=i(1),n=i(276),r=o.__importStar(i(18));class _ extends n.HTMLBoxView{_width_policy(){return"horizontal"==this.model.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.model.orientation?"fixed":super._height_policy()}box_sizing(){const i=super.box_sizing();return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i}}t.WidgetView=_,_.__name__="WidgetView";class s extends n.HTMLBox{constructor(i){super(i)}static init_Widget(){this.define({orientation:[r.Orientation,"horizontal"],default_size:[r.Number,300]}),this.override({margin:[5,5,5,5]})}}t.Widget=s,s.__name__="Widget",s.init_Widget()},
407: function _(e,t,c){Object.defineProperty(c,"__esModule",{value:!0});const s=e(81),n=e(78);class o extends n.DOMView{}c.AbstractIconView=o,o.__name__="AbstractIconView";class _ extends s.Model{constructor(e){super(e)}}c.AbstractIcon=_,_.__name__="AbstractIcon"},
408: function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const i=e(1),s=e(409),h=e(72),_=i.__importStar(e(18)),o=e(10),u=e(173),r=e(282),c=i.__importDefault(e(284));class l extends s.TextInputView{constructor(){super(...arguments),this._open=!1,this._last_value="",this._hover_index=0}styles(){return[...super.styles(),c.default]}render(){super.render(),this.input_el.addEventListener("keydown",e=>this._keydown(e)),this.input_el.addEventListener("keyup",e=>this._keyup(e)),this.menu=h.div({class:[r.bk_menu,u.bk_below]}),this.menu.addEventListener("click",e=>this._menu_click(e)),this.menu.addEventListener("mouseover",e=>this._menu_hover(e)),this.el.appendChild(this.menu),h.undisplay(this.menu)}change_input(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu())}_update_completions(e){h.empty(this.menu);for(const t of e){const e=h.div({},t);this.menu.appendChild(e)}e.length>0&&this.menu.children[0].classList.add(u.bk_active)}_show_menu(){if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,h.display(this.menu);const e=t=>{const{target:n}=t;n instanceof HTMLElement&&!this.el.contains(n)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,h.undisplay(this.menu))}_menu_click(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())}_menu_hover(e){if(e.target!=e.currentTarget&&e.target instanceof Element){let t=0;for(t=0;t<this.menu.children.length&&this.menu.children[t].textContent!=e.target.textContent;t++);this._bump_hover(t)}}_bump_hover(e){const t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(u.bk_active),this._hover_index=o.clamp(e,0,t-1),this.menu.children[this._hover_index].classList.add(u.bk_active))}_keydown(e){}_keyup(e){switch(e.keyCode){case h.Keys.Enter:this.change_input();break;case h.Keys.Esc:this._hide_menu();break;case h.Keys.Up:this._bump_hover(this._hover_index-1);break;case h.Keys.Down:this._bump_hover(this._hover_index+1);break;default:{const e=this.input_el.value;if(e.length<this.model.min_characters)return void this._hide_menu();const t=[],{case_sensitive:n}=this.model;let i;i=n?e=>e:e=>e.toLowerCase();for(const n of this.model.completions)i(n).startsWith(i(e))&&t.push(n);this._update_completions(t),0==t.length?this._hide_menu():this._show_menu()}}}}n.AutocompleteInputView=l,l.__name__="AutocompleteInputView";class a extends s.TextInput{constructor(e){super(e)}static init_AutocompleteInput(){this.prototype.default_view=l,this.define({completions:[_.Array,[]],min_characters:[_.Int,2],case_sensitive:[_.Boolean,!0]})}}n.AutocompleteInput=a,a.__name__="AutocompleteInput",a.init_AutocompleteInput()},
409: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(410),l=e(72),p=n.__importStar(e(18)),u=e(412);class a extends s.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.value.change,()=>this.input_el.value=this.model.value),this.connect(this.model.properties.value_input.change,()=>this.input_el.value=this.model.value_input),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder)}render(){super.render(),this.input_el=l.input({type:"text",class:u.bk_input,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.input_el.addEventListener("change",()=>this.change_input()),this.input_el.addEventListener("input",()=>this.change_input_oninput()),this.group_el.appendChild(this.input_el)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_oninput(){this.model.value_input=this.input_el.value,super.change_input()}}i.TextInputView=a,a.__name__="TextInputView";class h extends s.InputWidget{constructor(e){super(e)}static init_TextInput(){this.prototype.default_view=a,this.define({value:[p.String,""],value_input:[p.String,""],placeholder:[p.String,""]})}}i.TextInput=h,h.__name__="TextInput",h.init_TextInput()},
410: function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),l=t(405),s=t(72),_=n.__importStar(t(18)),o=n.__importDefault(t(411)),r=t(412);class p extends l.ControlView{*controls(){yield this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.title.change,()=>{this.label_el.textContent=this.model.title})}styles(){return[...super.styles(),o.default]}render(){super.render();const{title:t}=this.model;this.label_el=s.label({style:{display:0==t.length?"none":""}},t),this.group_el=s.div({class:r.bk_input_group},this.label_el),this.el.appendChild(this.group_el)}change_input(){}}i.InputWidgetView=p,p.__name__="InputWidgetView";class u extends l.Control{constructor(t){super(t)}static init_InputWidget(){this.define({title:[_.String,""]})}}i.InputWidget=u,u.__name__="InputWidget",u.init_InputWidget()},
411: function _(n,o,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root .bk-input {\n  display: inline-block;\n  width: 100%;\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  min-height: 31px;\n  padding: 0 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n.bk-root .bk-input:focus {\n  border-color: #66afe9;\n  outline: 0;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.bk-root .bk-input::placeholder,\n.bk-root .bk-input:-ms-input-placeholder,\n.bk-root .bk-input::-moz-placeholder,\n.bk-root .bk-input::-webkit-input-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.bk-root .bk-input[disabled] {\n  cursor: not-allowed;\n  background-color: #eee;\n  opacity: 1;\n}\n.bk-root select:not([multiple]).bk-input,\n.bk-root select:not([size]).bk-input {\n  height: auto;\n  appearance: none;\n  -webkit-appearance: none;\n  background-image: url(\'data:image/svg+xml;utf8,<svg version="1.1" viewBox="0 0 25 20" xmlns="http://www.w3.org/2000/svg"><path d="M 0,0 25,0 12.5,20 Z" fill="black" /></svg>\');\n  background-position: right 0.5em center;\n  background-size: 8px 6px;\n  background-repeat: no-repeat;\n}\n.bk-root select[multiple].bk-input,\n.bk-root select[size].bk-input,\n.bk-root textarea.bk-input {\n  height: auto;\n}\n.bk-root .bk-input-group {\n  width: 100%;\n  height: 100%;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: start;\n  -webkit-align-items: start;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  white-space: nowrap;\n}\n.bk-root .bk-input-group.bk-inline {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-input-group.bk-inline > *:not(:first-child) {\n  margin-left: 5px;\n}\n.bk-root .bk-input-group input[type="checkbox"] + span,\n.bk-root .bk-input-group input[type="radio"] + span {\n  position: relative;\n  top: -2px;\n  margin-left: 3px;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper {\n  display: inherit;\n  width: inherit;\n  height: inherit;\n  position: relative;\n  overflow: hidden;\n  padding: 0;\n  vertical-align: middle;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper input {\n  padding-right: 20px;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn {\n  position: absolute;\n  display: block;\n  height: 50%;\n  min-height: 0;\n  min-width: 0;\n  width: 30px;\n  padding: 0;\n  margin: 0;\n  right: 0;\n  border: none;\n  background: none;\n  cursor: pointer;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn:before {\n  content: "";\n  display: inline-block;\n  transform: translateY(-50%);\n  border-left: 5px solid transparent;\n  border-right: 5px solid transparent;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up {\n  top: 0;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:before {\n  border-bottom: 5px solid black;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:disabled:before {\n  border-bottom-color: grey;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down {\n  bottom: 0;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:before {\n  border-top: 5px solid black;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:disabled:before {\n  border-top-color: grey;\n}\n'},
412: function _(u,e,n){Object.defineProperty(n,"__esModule",{value:!0}),n.bk_input="bk-input",n.bk_input_group="bk-input-group"},
413: function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const o=t(404),i=t(313);class s extends o.AbstractButtonView{click(){this.model.trigger_event(new i.ButtonClick),super.click()}}n.ButtonView=s,s.__name__="ButtonView";class u extends o.AbstractButton{constructor(t){super(t)}static init_Button(){this.prototype.default_view=s,this.override({label:"Button"})}}n.Button=u,u.__name__="Button",u.init_Button()},
414: function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const i=t(1),c=t(415),s=t(72),n=i.__importStar(t(18)),a=t(173);class u extends c.ButtonGroupView{get active(){return new Set(this.model.active)}change_active(t){const{active:e}=this;e.has(t)?e.delete(t):e.add(t),this.model.active=[...e].sort()}_update_active(){const{active:t}=this;this._buttons.forEach((e,o)=>{s.classes(e).toggle(a.bk_active,t.has(o))})}}o.CheckboxButtonGroupView=u,u.__name__="CheckboxButtonGroupView";class r extends c.ButtonGroup{constructor(t){super(t)}static init_CheckboxButtonGroup(){this.prototype.default_view=u,this.define({active:[n.Array,[]]})}}o.CheckboxButtonGroup=r,r.__name__="CheckboxButtonGroup",r.init_CheckboxButtonGroup()},
415: function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),o=t(405),i=t(72),r=n.__importStar(t(18)),_=t(281),u=n.__importDefault(t(283));class a extends o.ControlView{*controls(){yield*this._buttons}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.button_type,()=>this.render()),this.on_change(t.labels,()=>this.render()),this.on_change(t.active,()=>this._update_active())}styles(){return[...super.styles(),u.default]}render(){super.render(),this._buttons=this.model.labels.map((t,e)=>{const s=i.div({class:[_.bk_btn,_.bk_btn_type(this.model.button_type)],disabled:this.model.disabled},t);return s.addEventListener("click",()=>this.change_active(e)),s}),this._update_active();const t=i.div({class:_.bk_btn_group},this._buttons);this.el.appendChild(t)}}s.ButtonGroupView=a,a.__name__="ButtonGroupView";class l extends o.Control{constructor(t){super(t)}static init_ButtonGroup(){this.define({labels:[r.Array,[]],button_type:[r.ButtonType,"default"]})}}s.ButtonGroup=l,l.__name__="ButtonGroup",l.init_ButtonGroup()},
416: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(417),o=e(72),c=e(9),a=n.__importStar(e(18)),l=e(173),d=e(412);class r extends s.InputGroupView{render(){super.render();const e=o.div({class:[d.bk_input_group,this.model.inline?l.bk_inline:null]});this.el.appendChild(e);const{active:t,labels:i}=this.model;this._inputs=[];for(let n=0;n<i.length;n++){const s=o.input({type:"checkbox",value:""+n});s.addEventListener("change",()=>this.change_active(n)),this._inputs.push(s),this.model.disabled&&(s.disabled=!0),c.includes(t,n)&&(s.checked=!0);const a=o.label({},s,o.span({},i[n]));e.appendChild(a)}}change_active(e){const t=new Set(this.model.active);t.has(e)?t.delete(e):t.add(e),this.model.active=[...t].sort()}}i.CheckboxGroupView=r,r.__name__="CheckboxGroupView";class p extends s.InputGroup{constructor(e){super(e)}static init_CheckboxGroup(){this.prototype.default_view=r,this.define({active:[a.Array,[]],labels:[a.Array,[]],inline:[a.Boolean,!1]})}}i.CheckboxGroup=p,p.__name__="CheckboxGroup",p.init_CheckboxGroup()},
417: function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e(1),o=e(405),r=s.__importDefault(e(411));class u extends o.ControlView{*controls(){yield*this._inputs}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}styles(){return[...super.styles(),r.default]}}n.InputGroupView=u,u.__name__="InputGroupView";class _ extends o.Control{constructor(e){super(e)}}n.InputGroup=_,_.__name__="InputGroup"},
418: function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),o=e(410),s=e(72),l=n.__importStar(e(18)),r=e(412);class c extends o.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.color.change,()=>this.input_el.value=this.model.color),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled)}render(){super.render(),this.input_el=s.input({type:"color",class:r.bk_input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){this.model.color=this.input_el.value,super.change_input()}}t.ColorPickerView=c,c.__name__="ColorPickerView";class d extends o.InputWidget{constructor(e){super(e)}static init_ColorPicker(){this.prototype.default_view=c,this.define({color:[l.Color,"#000000"]})}}t.ColorPicker=d,d.__name__="ColorPicker",d.init_ColorPicker()},
419: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=n.__importDefault(e(420)),a=e(410),l=e(72),o=n.__importStar(e(18)),r=e(8),d=e(412),c=n.__importDefault(e(421));function u(e){const t=[];for(const i of e)if(r.isString(i))t.push(i);else{const[e,n]=i;t.push({from:e,to:n})}return t}class _ extends a.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:i,disabled_dates:n,enabled_dates:s,position:a,inline:l}=this.model.properties;this.connect(e.change,()=>{var t;return null===(t=this._picker)||void 0===t?void 0:t.setDate(e.value())}),this.connect(t.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("minDate",t.value())}),this.connect(i.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("maxDate",i.value())}),this.connect(n.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("disable",n.value())}),this.connect(s.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enable",s.value())}),this.connect(a.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("position",a.value())}),this.connect(l.change,()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("inline",l.value())})}remove(){var e;null===(e=this._picker)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),c.default]}render(){null==this._picker&&(super.render(),this.input_el=l.input({type:"text",class:d.bk_input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=s.default(this.input_el,{defaultDate:this.model.value,minDate:this.model.min_date,maxDate:this.model.max_date,inline:this.model.inline,position:this.model.position,disable:u(this.model.disabled_dates),enable:u(this.model.enabled_dates),onChange:(e,t,i)=>this._on_change(e,t,i)}))}_on_change(e,t,i){this.model.value=t,this.change_input()}}i.DatePickerView=_,_.__name__="DatePickerView";class h extends a.InputWidget{constructor(e){super(e)}static init_DatePicker(){this.prototype.default_view=_,this.define({value:[o.Any],min_date:[o.Any],max_date:[o.Any],disabled_dates:[o.Any,[]],enabled_dates:[o.Any,[]],position:[o.CalendarPosition,"auto"],inline:[o.Boolean,!1]})}}i.DatePicker=h,h.__name__="DatePicker",h.init_DatePicker()},
420: function _(e,t,n){
/* flatpickr v4.6.3, @license MIT */var a,i;a=this,i=function(){"use strict";
/*! *****************************************************************************
        Copyright (c) Microsoft Corporation. All rights reserved.
        Licensed under the Apache License, Version 2.0 (the "License"); you may not use
        this file except in compliance with the License. You may obtain a copy of the
        License at http://www.apache.org/licenses/LICENSE-2.0
    
        THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
        KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
        WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
        MERCHANTABLITY OR NON-INFRINGEMENT.
    
        See the Apache Version 2.0 License for specific language governing permissions
        and limitations under the License.
        ***************************************************************************** */var e=function(){return(e=Object.assign||function(e){for(var t,n=1,a=arguments.length;n<a;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)},t=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],n={_disable:[],_enable:[],allowInput:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enable:[],enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var t=new Date(e.getTime());t.setHours(0,0,0,0),t.setDate(t.getDate()+3-(t.getDay()+6)%7);var n=new Date(t.getFullYear(),0,4);return 1+Math.round(((t.getTime()-n.getTime())/864e5-3+(n.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1},a={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var t=e%100;if(t>3&&t<21)return"th";switch(t%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},i=function(e){return("0"+e).slice(-2)},o=function(e){return!0===e?1:0};function r(e,t,n){var a;return void 0===n&&(n=!1),function(){var i=this,o=arguments;null!==a&&clearTimeout(a),a=window.setTimeout((function(){a=null,n||e.apply(i,o)}),t),n&&!a&&e.apply(i,o)}}var l=function(e){return e instanceof Array?e:[e]};function c(e,t,n){if(!0===n)return e.classList.add(t);e.classList.remove(t)}function d(e,t,n){var a=window.document.createElement(e);return t=t||"",n=n||"",a.className=t,void 0!==n&&(a.textContent=n),a}function s(e){for(;e.firstChild;)e.removeChild(e.firstChild)}function u(e,t){var n=d("div","numInputWrapper"),a=d("input","numInput "+e),i=d("span","arrowUp"),o=d("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?a.type="number":(a.type="text",a.pattern="\\d*"),void 0!==t)for(var r in t)a.setAttribute(r,t[r]);return n.appendChild(a),n.appendChild(i),n.appendChild(o),n}var f=function(){},m=function(e,t,n){return n.months[t?"shorthand":"longhand"][e]},g={D:f,F:function(e,t,n){e.setMonth(n.months.longhand.indexOf(t))},G:function(e,t){e.setHours(parseFloat(t))},H:function(e,t){e.setHours(parseFloat(t))},J:function(e,t){e.setDate(parseFloat(t))},K:function(e,t,n){e.setHours(e.getHours()%12+12*o(new RegExp(n.amPM[1],"i").test(t)))},M:function(e,t,n){e.setMonth(n.months.shorthand.indexOf(t))},S:function(e,t){e.setSeconds(parseFloat(t))},U:function(e,t){return new Date(1e3*parseFloat(t))},W:function(e,t,n){var a=parseInt(t),i=new Date(e.getFullYear(),0,2+7*(a-1),0,0,0,0);return i.setDate(i.getDate()-i.getDay()+n.firstDayOfWeek),i},Y:function(e,t){e.setFullYear(parseFloat(t))},Z:function(e,t){return new Date(t)},d:function(e,t){e.setDate(parseFloat(t))},h:function(e,t){e.setHours(parseFloat(t))},i:function(e,t){e.setMinutes(parseFloat(t))},j:function(e,t){e.setDate(parseFloat(t))},l:f,m:function(e,t){e.setMonth(parseFloat(t)-1)},n:function(e,t){e.setMonth(parseFloat(t)-1)},s:function(e,t){e.setSeconds(parseFloat(t))},u:function(e,t){return new Date(parseFloat(t))},w:f,y:function(e,t){e.setFullYear(2e3+parseFloat(t))}},p={D:"(\\w+)",F:"(\\w+)",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"(\\w+)",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"(\\w+)",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},h={Z:function(e){return e.toISOString()},D:function(e,t,n){return t.weekdays.shorthand[h.w(e,t,n)]},F:function(e,t,n){return m(h.n(e,t,n)-1,!1,t)},G:function(e,t,n){return i(h.h(e,t,n))},H:function(e){return i(e.getHours())},J:function(e,t){return void 0!==t.ordinal?e.getDate()+t.ordinal(e.getDate()):e.getDate()},K:function(e,t){return t.amPM[o(e.getHours()>11)]},M:function(e,t){return m(e.getMonth(),!0,t)},S:function(e){return i(e.getSeconds())},U:function(e){return e.getTime()/1e3},W:function(e,t,n){return n.getWeek(e)},Y:function(e){return e.getFullYear()},d:function(e){return i(e.getDate())},h:function(e){return e.getHours()%12?e.getHours()%12:12},i:function(e){return i(e.getMinutes())},j:function(e){return e.getDate()},l:function(e,t){return t.weekdays.longhand[e.getDay()]},m:function(e){return i(e.getMonth()+1)},n:function(e){return e.getMonth()+1},s:function(e){return e.getSeconds()},u:function(e){return e.getTime()},w:function(e){return e.getDay()},y:function(e){return String(e.getFullYear()).substring(2)}},v=function(e){var t=e.config,i=void 0===t?n:t,o=e.l10n,r=void 0===o?a:o;return function(e,t,n){var a=n||r;return void 0!==i.formatDate?i.formatDate(e,t,a):t.split("").map((function(t,n,o){return h[t]&&"\\"!==o[n-1]?h[t](e,a,i):"\\"!==t?t:""})).join("")}},D=function(e){var t=e.config,i=void 0===t?n:t,o=e.l10n,r=void 0===o?a:o;return function(e,t,a,o){if(0===e||e){var l,c=o||r,d=e;if(e instanceof Date)l=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)l=new Date(e);else if("string"==typeof e){var s=t||(i||n).dateFormat,u=String(e).trim();if("today"===u)l=new Date,a=!0;else if(/Z$/.test(u)||/GMT$/.test(u))l=new Date(e);else if(i&&i.parseDate)l=i.parseDate(e,s);else{l=i&&i.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0);for(var f=void 0,m=[],h=0,v=0,D="";h<s.length;h++){var w=s[h],b="\\"===w,C="\\"===s[h-1]||b;if(p[w]&&!C){D+=p[w];var M=new RegExp(D).exec(e);M&&(f=!0)&&m["Y"!==w?"push":"unshift"]({fn:g[w],val:M[++v]})}else b||(D+=".");m.forEach((function(e){var t=e.fn,n=e.val;return l=t(l,n,c)||l}))}l=f?l:void 0}}if(l instanceof Date&&!isNaN(l.getTime()))return!0===a&&l.setHours(0,0,0,0),l;i.errorHandler(new Error("Invalid date provided: "+d))}}};function w(e,t,n){return void 0===n&&(n=!0),!1!==n?new Date(e.getTime()).setHours(0,0,0,0)-new Date(t.getTime()).setHours(0,0,0,0):e.getTime()-t.getTime()}var b=864e5;function C(f,g){var h={config:e({},n,y.defaultConfig),l10n:a};function C(e){return e.bind(h)}function M(){var e=h.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==h.calendarContainer&&(h.calendarContainer.style.visibility="hidden",h.calendarContainer.style.display="block"),void 0!==h.daysContainer){var t=(h.days.offsetWidth+1)*e.showMonths;h.daysContainer.style.width=t+"px",h.calendarContainer.style.width=t+(void 0!==h.weekWrapper?h.weekWrapper.offsetWidth:0)+"px",h.calendarContainer.style.removeProperty("visibility"),h.calendarContainer.style.removeProperty("display")}}))}function x(e){0===h.selectedDates.length&&ne(),void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var t="keydown"===e.type,n=e.target;void 0!==h.amPM&&e.target===h.amPM&&(h.amPM.textContent=h.l10n.amPM[o(h.amPM.textContent===h.l10n.amPM[0])]);var a=parseFloat(n.getAttribute("min")),r=parseFloat(n.getAttribute("max")),l=parseFloat(n.getAttribute("step")),c=parseInt(n.value,10),d=e.delta||(t?38===e.which?1:-1:0),s=c+l*d;if(void 0!==n.value&&2===n.value.length){var u=n===h.hourElement,f=n===h.minuteElement;s<a?(s=r+s+o(!u)+(o(u)&&o(!h.amPM)),f&&Y(void 0,-1,h.hourElement)):s>r&&(s=n===h.hourElement?s-r-o(!h.amPM):a,f&&Y(void 0,1,h.hourElement)),h.amPM&&u&&(1===l?s+c===23:Math.abs(s-c)>l)&&(h.amPM.textContent=h.l10n.amPM[o(h.amPM.textContent===h.l10n.amPM[0])]),n.value=i(s)}}(e);var t=h._input.value;E(),ve(),h._input.value!==t&&h._debouncedChange()}function E(){if(void 0!==h.hourElement&&void 0!==h.minuteElement){var e,t,n=(parseInt(h.hourElement.value.slice(-2),10)||0)%24,a=(parseInt(h.minuteElement.value,10)||0)%60,i=void 0!==h.secondElement?(parseInt(h.secondElement.value,10)||0)%60:0;void 0!==h.amPM&&(e=n,t=h.amPM.textContent,n=e%12+12*o(t===h.l10n.amPM[1]));var r=void 0!==h.config.minTime||h.config.minDate&&h.minDateHasTime&&h.latestSelectedDateObj&&0===w(h.latestSelectedDateObj,h.config.minDate,!0);if(void 0!==h.config.maxTime||h.config.maxDate&&h.maxDateHasTime&&h.latestSelectedDateObj&&0===w(h.latestSelectedDateObj,h.config.maxDate,!0)){var l=void 0!==h.config.maxTime?h.config.maxTime:h.config.maxDate;(n=Math.min(n,l.getHours()))===l.getHours()&&(a=Math.min(a,l.getMinutes())),a===l.getMinutes()&&(i=Math.min(i,l.getSeconds()))}if(r){var c=void 0!==h.config.minTime?h.config.minTime:h.config.minDate;(n=Math.max(n,c.getHours()))===c.getHours()&&(a=Math.max(a,c.getMinutes())),a===c.getMinutes()&&(i=Math.max(i,c.getSeconds()))}I(n,a,i)}}function T(e){var t=e||h.latestSelectedDateObj;t&&I(t.getHours(),t.getMinutes(),t.getSeconds())}function k(){var e=h.config.defaultHour,t=h.config.defaultMinute,n=h.config.defaultSeconds;if(void 0!==h.config.minDate){var a=h.config.minDate.getHours(),i=h.config.minDate.getMinutes();(e=Math.max(e,a))===a&&(t=Math.max(i,t)),e===a&&t===i&&(n=h.config.minDate.getSeconds())}if(void 0!==h.config.maxDate){var o=h.config.maxDate.getHours(),r=h.config.maxDate.getMinutes();(e=Math.min(e,o))===o&&(t=Math.min(r,t)),e===o&&t===r&&(n=h.config.maxDate.getSeconds())}I(e,t,n)}function I(e,t,n){void 0!==h.latestSelectedDateObj&&h.latestSelectedDateObj.setHours(e%24,t,n||0,0),h.hourElement&&h.minuteElement&&!h.isMobile&&(h.hourElement.value=i(h.config.time_24hr?e:(12+e)%12+12*o(e%12==0)),h.minuteElement.value=i(t),void 0!==h.amPM&&(h.amPM.textContent=h.l10n.amPM[o(e>=12)]),void 0!==h.secondElement&&(h.secondElement.value=i(n)))}function S(e){var t=parseInt(e.target.value)+(e.delta||0);(t/1e3>1||"Enter"===e.key&&!/[^\d]/.test(t.toString()))&&V(t)}function O(e,t,n,a){return t instanceof Array?t.forEach((function(t){return O(e,t,n,a)})):e instanceof Array?e.forEach((function(e){return O(e,t,n,a)})):(e.addEventListener(t,n,a),void h._handlers.push({element:e,event:t,handler:n,options:a}))}function _(e){return function(t){1===t.which&&e(t)}}function F(){fe("onChange")}function N(e,t){var n=void 0!==e?h.parseDate(e):h.latestSelectedDateObj||(h.config.minDate&&h.config.minDate>h.now?h.config.minDate:h.config.maxDate&&h.config.maxDate<h.now?h.config.maxDate:h.now),a=h.currentYear,i=h.currentMonth;try{void 0!==n&&(h.currentYear=n.getFullYear(),h.currentMonth=n.getMonth())}catch(e){e.message="Invalid date supplied: "+n,h.config.errorHandler(e)}t&&h.currentYear!==a&&(fe("onYearChange"),B()),!t||h.currentYear===a&&h.currentMonth===i||fe("onMonthChange"),h.redraw()}function P(e){~e.target.className.indexOf("arrow")&&Y(e,e.target.classList.contains("arrowUp")?1:-1)}function Y(e,t,n){var a=e&&e.target,i=n||a&&a.parentNode&&a.parentNode.firstChild,o=me("increment");o.delta=t,i&&i.dispatchEvent(o)}function A(e,t,n,a){var i=Z(t,!0),o=d("span","flatpickr-day "+e,t.getDate().toString());return o.dateObj=t,o.$i=a,o.setAttribute("aria-label",h.formatDate(t,h.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===w(t,h.now)&&(h.todayDateElem=o,o.classList.add("today"),o.setAttribute("aria-current","date")),i?(o.tabIndex=-1,ge(t)&&(o.classList.add("selected"),h.selectedDateElem=o,"range"===h.config.mode&&(c(o,"startRange",h.selectedDates[0]&&0===w(t,h.selectedDates[0],!0)),c(o,"endRange",h.selectedDates[1]&&0===w(t,h.selectedDates[1],!0)),"nextMonthDay"===e&&o.classList.add("inRange")))):o.classList.add("flatpickr-disabled"),"range"===h.config.mode&&function(e){return!("range"!==h.config.mode||h.selectedDates.length<2)&&w(e,h.selectedDates[0])>=0&&w(e,h.selectedDates[1])<=0}(t)&&!ge(t)&&o.classList.add("inRange"),h.weekNumbers&&1===h.config.showMonths&&"prevMonthDay"!==e&&n%7==1&&h.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+h.config.getWeek(t)+"</span>"),fe("onDayCreate",o),o}function j(e){e.focus(),"range"===h.config.mode&&ee(e)}function H(e){for(var t=e>0?0:h.config.showMonths-1,n=e>0?h.config.showMonths:-1,a=t;a!=n;a+=e)for(var i=h.daysContainer.children[a],o=e>0?0:i.children.length-1,r=e>0?i.children.length:-1,l=o;l!=r;l+=e){var c=i.children[l];if(-1===c.className.indexOf("hidden")&&Z(c.dateObj))return c}}function L(e,t){var n=Q(document.activeElement||document.body),a=void 0!==e?e:n?document.activeElement:void 0!==h.selectedDateElem&&Q(h.selectedDateElem)?h.selectedDateElem:void 0!==h.todayDateElem&&Q(h.todayDateElem)?h.todayDateElem:H(t>0?1:-1);return void 0===a?h._input.focus():n?void function(e,t){for(var n=-1===e.className.indexOf("Month")?e.dateObj.getMonth():h.currentMonth,a=t>0?h.config.showMonths:-1,i=t>0?1:-1,o=n-h.currentMonth;o!=a;o+=i)for(var r=h.daysContainer.children[o],l=n-h.currentMonth===o?e.$i+t:t<0?r.children.length-1:0,c=r.children.length,d=l;d>=0&&d<c&&d!=(t>0?c:-1);d+=i){var s=r.children[d];if(-1===s.className.indexOf("hidden")&&Z(s.dateObj)&&Math.abs(e.$i-d)>=Math.abs(t))return j(s)}h.changeMonth(i),L(H(i),0)}(a,t):j(a)}function W(e,t){for(var n=(new Date(e,t,1).getDay()-h.l10n.firstDayOfWeek+7)%7,a=h.utils.getDaysInMonth((t-1+12)%12),i=h.utils.getDaysInMonth(t),o=window.document.createDocumentFragment(),r=h.config.showMonths>1,l=r?"prevMonthDay hidden":"prevMonthDay",c=r?"nextMonthDay hidden":"nextMonthDay",s=a+1-n,u=0;s<=a;s++,u++)o.appendChild(A(l,new Date(e,t-1,s),s,u));for(s=1;s<=i;s++,u++)o.appendChild(A("",new Date(e,t,s),s,u));for(var f=i+1;f<=42-n&&(1===h.config.showMonths||u%7!=0);f++,u++)o.appendChild(A(c,new Date(e,t+1,f%i),f,u));var m=d("div","dayContainer");return m.appendChild(o),m}function R(){if(void 0!==h.daysContainer){s(h.daysContainer),h.weekNumbers&&s(h.weekNumbers);for(var e=document.createDocumentFragment(),t=0;t<h.config.showMonths;t++){var n=new Date(h.currentYear,h.currentMonth,1);n.setMonth(h.currentMonth+t),e.appendChild(W(n.getFullYear(),n.getMonth()))}h.daysContainer.appendChild(e),h.days=h.daysContainer.firstChild,"range"===h.config.mode&&1===h.selectedDates.length&&ee()}}function B(){if(!(h.config.showMonths>1||"dropdown"!==h.config.monthSelectorType)){var e=function(e){return!(void 0!==h.config.minDate&&h.currentYear===h.config.minDate.getFullYear()&&e<h.config.minDate.getMonth()||void 0!==h.config.maxDate&&h.currentYear===h.config.maxDate.getFullYear()&&e>h.config.maxDate.getMonth())};h.monthsDropdownContainer.tabIndex=-1,h.monthsDropdownContainer.innerHTML="";for(var t=0;t<12;t++)if(e(t)){var n=d("option","flatpickr-monthDropdown-month");n.value=new Date(h.currentYear,t).getMonth().toString(),n.textContent=m(t,h.config.shorthandCurrentMonth,h.l10n),n.tabIndex=-1,h.currentMonth===t&&(n.selected=!0),h.monthsDropdownContainer.appendChild(n)}}}function J(){var e,t=d("div","flatpickr-month"),n=window.document.createDocumentFragment();h.config.showMonths>1||"static"===h.config.monthSelectorType?e=d("span","cur-month"):(h.monthsDropdownContainer=d("select","flatpickr-monthDropdown-months"),O(h.monthsDropdownContainer,"change",(function(e){var t=e.target,n=parseInt(t.value,10);h.changeMonth(n-h.currentMonth),fe("onMonthChange")})),B(),e=h.monthsDropdownContainer);var a=u("cur-year",{tabindex:"-1"}),i=a.getElementsByTagName("input")[0];i.setAttribute("aria-label",h.l10n.yearAriaLabel),h.config.minDate&&i.setAttribute("min",h.config.minDate.getFullYear().toString()),h.config.maxDate&&(i.setAttribute("max",h.config.maxDate.getFullYear().toString()),i.disabled=!!h.config.minDate&&h.config.minDate.getFullYear()===h.config.maxDate.getFullYear());var o=d("div","flatpickr-current-month");return o.appendChild(e),o.appendChild(a),n.appendChild(o),t.appendChild(n),{container:t,yearElement:i,monthElement:e}}function K(){s(h.monthNav),h.monthNav.appendChild(h.prevMonthNav),h.config.showMonths&&(h.yearElements=[],h.monthElements=[]);for(var e=h.config.showMonths;e--;){var t=J();h.yearElements.push(t.yearElement),h.monthElements.push(t.monthElement),h.monthNav.appendChild(t.container)}h.monthNav.appendChild(h.nextMonthNav)}function U(){h.weekdayContainer?s(h.weekdayContainer):h.weekdayContainer=d("div","flatpickr-weekdays");for(var e=h.config.showMonths;e--;){var t=d("div","flatpickr-weekdaycontainer");h.weekdayContainer.appendChild(t)}return q(),h.weekdayContainer}function q(){if(h.weekdayContainer){var e=h.l10n.firstDayOfWeek,t=h.l10n.weekdays.shorthand.slice();e>0&&e<t.length&&(t=t.splice(e,t.length).concat(t.splice(0,e)));for(var n=h.config.showMonths;n--;)h.weekdayContainer.children[n].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function $(e,t){void 0===t&&(t=!0);var n=t?e:e-h.currentMonth;n<0&&!0===h._hidePrevMonthArrow||n>0&&!0===h._hideNextMonthArrow||(h.currentMonth+=n,(h.currentMonth<0||h.currentMonth>11)&&(h.currentYear+=h.currentMonth>11?1:-1,h.currentMonth=(h.currentMonth+12)%12,fe("onYearChange"),B()),R(),fe("onMonthChange"),pe())}function z(e){return!(!h.config.appendTo||!h.config.appendTo.contains(e))||h.calendarContainer.contains(e)}function G(e){if(h.isOpen&&!h.config.inline){var t="function"==typeof(r=e).composedPath?r.composedPath()[0]:r.target,n=z(t),a=t===h.input||t===h.altInput||h.element.contains(t)||e.path&&e.path.indexOf&&(~e.path.indexOf(h.input)||~e.path.indexOf(h.altInput)),i="blur"===e.type?a&&e.relatedTarget&&!z(e.relatedTarget):!a&&!n&&!z(e.relatedTarget),o=!h.config.ignoredFocusElements.some((function(e){return e.contains(t)}));i&&o&&(void 0!==h.timeContainer&&void 0!==h.minuteElement&&void 0!==h.hourElement&&x(),h.close(),"range"===h.config.mode&&1===h.selectedDates.length&&(h.clear(!1),h.redraw()))}var r}function V(e){if(!(!e||h.config.minDate&&e<h.config.minDate.getFullYear()||h.config.maxDate&&e>h.config.maxDate.getFullYear())){var t=e,n=h.currentYear!==t;h.currentYear=t||h.currentYear,h.config.maxDate&&h.currentYear===h.config.maxDate.getFullYear()?h.currentMonth=Math.min(h.config.maxDate.getMonth(),h.currentMonth):h.config.minDate&&h.currentYear===h.config.minDate.getFullYear()&&(h.currentMonth=Math.max(h.config.minDate.getMonth(),h.currentMonth)),n&&(h.redraw(),fe("onYearChange"),B())}}function Z(e,t){void 0===t&&(t=!0);var n=h.parseDate(e,void 0,t);if(h.config.minDate&&n&&w(n,h.config.minDate,void 0!==t?t:!h.minDateHasTime)<0||h.config.maxDate&&n&&w(n,h.config.maxDate,void 0!==t?t:!h.maxDateHasTime)>0)return!1;if(0===h.config.enable.length&&0===h.config.disable.length)return!0;if(void 0===n)return!1;for(var a=h.config.enable.length>0,i=a?h.config.enable:h.config.disable,o=0,r=void 0;o<i.length;o++){if("function"==typeof(r=i[o])&&r(n))return a;if(r instanceof Date&&void 0!==n&&r.getTime()===n.getTime())return a;if("string"==typeof r&&void 0!==n){var l=h.parseDate(r,void 0,!0);return l&&l.getTime()===n.getTime()?a:!a}if("object"==typeof r&&void 0!==n&&r.from&&r.to&&n.getTime()>=r.from.getTime()&&n.getTime()<=r.to.getTime())return a}return!a}function Q(e){return void 0!==h.daysContainer&&-1===e.className.indexOf("hidden")&&h.daysContainer.contains(e)}function X(e){var t=e.target===h._input,n=h.config.allowInput,a=h.isOpen&&(!n||!t),i=h.config.inline&&t&&!n;if(13===e.keyCode&&t){if(n)return h.setDate(h._input.value,!0,e.target===h.altInput?h.config.altFormat:h.config.dateFormat),e.target.blur();h.open()}else if(z(e.target)||a||i){var o=!!h.timeContainer&&h.timeContainer.contains(e.target);switch(e.keyCode){case 13:o?(e.preventDefault(),x(),le()):ce(e);break;case 27:e.preventDefault(),le();break;case 8:case 46:t&&!h.config.allowInput&&(e.preventDefault(),h.clear());break;case 37:case 39:if(o||t)h.hourElement&&h.hourElement.focus();else if(e.preventDefault(),void 0!==h.daysContainer&&(!1===n||document.activeElement&&Q(document.activeElement))){var r=39===e.keyCode?1:-1;e.ctrlKey?(e.stopPropagation(),$(r),L(H(1),0)):L(void 0,r)}break;case 38:case 40:e.preventDefault();var l=40===e.keyCode?1:-1;h.daysContainer&&void 0!==e.target.$i||e.target===h.input||e.target===h.altInput?e.ctrlKey?(e.stopPropagation(),V(h.currentYear-l),L(H(1),0)):o||L(void 0,7*l):e.target===h.currentYearElement?V(h.currentYear-l):h.config.enableTime&&(!o&&h.hourElement&&h.hourElement.focus(),x(e),h._debouncedChange());break;case 9:if(o){var c=[h.hourElement,h.minuteElement,h.secondElement,h.amPM].concat(h.pluginElements).filter((function(e){return e})),d=c.indexOf(e.target);if(-1!==d){var s=c[d+(e.shiftKey?-1:1)];e.preventDefault(),(s||h._input).focus()}}else!h.config.noCalendar&&h.daysContainer&&h.daysContainer.contains(e.target)&&e.shiftKey&&(e.preventDefault(),h._input.focus())}}if(void 0!==h.amPM&&e.target===h.amPM)switch(e.key){case h.l10n.amPM[0].charAt(0):case h.l10n.amPM[0].charAt(0).toLowerCase():h.amPM.textContent=h.l10n.amPM[0],E(),ve();break;case h.l10n.amPM[1].charAt(0):case h.l10n.amPM[1].charAt(0).toLowerCase():h.amPM.textContent=h.l10n.amPM[1],E(),ve()}(t||z(e.target))&&fe("onKeyDown",e)}function ee(e){if(1===h.selectedDates.length&&(!e||e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled"))){for(var t=e?e.dateObj.getTime():h.days.firstElementChild.dateObj.getTime(),n=h.parseDate(h.selectedDates[0],void 0,!0).getTime(),a=Math.min(t,h.selectedDates[0].getTime()),i=Math.max(t,h.selectedDates[0].getTime()),o=!1,r=0,l=0,c=a;c<i;c+=b)Z(new Date(c),!0)||(o=o||c>a&&c<i,c<n&&(!r||c>r)?r=c:c>n&&(!l||c<l)&&(l=c));for(var d=0;d<h.config.showMonths;d++)for(var s=h.daysContainer.children[d],u=function(a,i){var c,d,u,f=s.children[a],m=f.dateObj.getTime(),g=r>0&&m<r||l>0&&m>l;return g?(f.classList.add("notAllowed"),["inRange","startRange","endRange"].forEach((function(e){f.classList.remove(e)})),"continue"):o&&!g?"continue":(["startRange","inRange","endRange","notAllowed"].forEach((function(e){f.classList.remove(e)})),void(void 0!==e&&(e.classList.add(t<=h.selectedDates[0].getTime()?"startRange":"endRange"),n<t&&m===n?f.classList.add("startRange"):n>t&&m===n&&f.classList.add("endRange"),m>=r&&(0===l||m<=l)&&(d=n,u=t,(c=m)>Math.min(d,u)&&c<Math.max(d,u))&&f.classList.add("inRange"))))},f=0,m=s.children.length;f<m;f++)u(f)}}function te(){!h.isOpen||h.config.static||h.config.inline||oe()}function ne(){h.setDate(void 0!==h.config.minDate?new Date(h.config.minDate.getTime()):new Date,!0),k(),ve()}function ae(e){return function(t){var n=h.config["_"+e+"Date"]=h.parseDate(t,h.config.dateFormat),a=h.config["_"+("min"===e?"max":"min")+"Date"];void 0!==n&&(h["min"===e?"minDateHasTime":"maxDateHasTime"]=n.getHours()>0||n.getMinutes()>0||n.getSeconds()>0),h.selectedDates&&(h.selectedDates=h.selectedDates.filter((function(e){return Z(e)})),h.selectedDates.length||"min"!==e||T(n),ve()),h.daysContainer&&(re(),void 0!==n?h.currentYearElement[e]=n.getFullYear().toString():h.currentYearElement.removeAttribute(e),h.currentYearElement.disabled=!!a&&void 0!==n&&a.getFullYear()===n.getFullYear())}}function ie(){"object"!=typeof h.config.locale&&void 0===y.l10ns[h.config.locale]&&h.config.errorHandler(new Error("flatpickr: invalid locale "+h.config.locale)),h.l10n=e({},y.l10ns.default,"object"==typeof h.config.locale?h.config.locale:"default"!==h.config.locale?y.l10ns[h.config.locale]:void 0),p.K="("+h.l10n.amPM[0]+"|"+h.l10n.amPM[1]+"|"+h.l10n.amPM[0].toLowerCase()+"|"+h.l10n.amPM[1].toLowerCase()+")",void 0===e({},g,JSON.parse(JSON.stringify(f.dataset||{}))).time_24hr&&void 0===y.defaultConfig.time_24hr&&(h.config.time_24hr=h.l10n.time_24hr),h.formatDate=v(h),h.parseDate=D({config:h.config,l10n:h.l10n})}function oe(e){if(void 0!==h.calendarContainer){fe("onPreCalendarPosition");var t=e||h._positionElement,n=Array.prototype.reduce.call(h.calendarContainer.children,(function(e,t){return e+t.offsetHeight}),0),a=h.calendarContainer.offsetWidth,i=h.config.position.split(" "),o=i[0],r=i.length>1?i[1]:null,l=t.getBoundingClientRect(),d=window.innerHeight-l.bottom,s="above"===o||"below"!==o&&d<n&&l.top>n,u=window.pageYOffset+l.top+(s?-n-2:t.offsetHeight+2);if(c(h.calendarContainer,"arrowTop",!s),c(h.calendarContainer,"arrowBottom",s),!h.config.inline){var f=window.pageXOffset+l.left-(null!=r&&"center"===r?(a-l.width)/2:0),m=window.document.body.offsetWidth-(window.pageXOffset+l.right),g=f+a>window.document.body.offsetWidth,p=m+a>window.document.body.offsetWidth;if(c(h.calendarContainer,"rightMost",g),!h.config.static)if(h.calendarContainer.style.top=u+"px",g)if(p){var v=document.styleSheets[0];if(void 0===v)return;var D=window.document.body.offsetWidth,w=Math.max(0,D/2-a/2),b=v.cssRules.length,C="{left:"+l.left+"px;right:auto;}";c(h.calendarContainer,"rightMost",!1),c(h.calendarContainer,"centerMost",!0),v.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+C,b),h.calendarContainer.style.left=w+"px",h.calendarContainer.style.right="auto"}else h.calendarContainer.style.left="auto",h.calendarContainer.style.right=m+"px";else h.calendarContainer.style.left=f+"px",h.calendarContainer.style.right="auto"}}}function re(){h.config.noCalendar||h.isMobile||(pe(),R())}function le(){h._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(h.close,0):h.close()}function ce(e){e.preventDefault(),e.stopPropagation();var t=function e(t,n){return n(t)?t:t.parentNode?e(t.parentNode,n):void 0}(e.target,(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==t){var n=t,a=h.latestSelectedDateObj=new Date(n.dateObj.getTime()),i=(a.getMonth()<h.currentMonth||a.getMonth()>h.currentMonth+h.config.showMonths-1)&&"range"!==h.config.mode;if(h.selectedDateElem=n,"single"===h.config.mode)h.selectedDates=[a];else if("multiple"===h.config.mode){var o=ge(a);o?h.selectedDates.splice(parseInt(o),1):h.selectedDates.push(a)}else"range"===h.config.mode&&(2===h.selectedDates.length&&h.clear(!1,!1),h.latestSelectedDateObj=a,h.selectedDates.push(a),0!==w(a,h.selectedDates[0],!0)&&h.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()})));if(E(),i){var r=h.currentYear!==a.getFullYear();h.currentYear=a.getFullYear(),h.currentMonth=a.getMonth(),r&&(fe("onYearChange"),B()),fe("onMonthChange")}if(pe(),R(),ve(),h.config.enableTime&&setTimeout((function(){return h.showTimeInput=!0}),50),i||"range"===h.config.mode||1!==h.config.showMonths?void 0!==h.selectedDateElem&&void 0===h.hourElement&&h.selectedDateElem&&h.selectedDateElem.focus():j(n),void 0!==h.hourElement&&void 0!==h.hourElement&&h.hourElement.focus(),h.config.closeOnSelect){var l="single"===h.config.mode&&!h.config.enableTime,c="range"===h.config.mode&&2===h.selectedDates.length&&!h.config.enableTime;(l||c)&&le()}F()}}h.parseDate=D({config:h.config,l10n:h.l10n}),h._handlers=[],h.pluginElements=[],h.loadedPlugins=[],h._bind=O,h._setHoursFromDate=T,h._positionCalendar=oe,h.changeMonth=$,h.changeYear=V,h.clear=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=!0),h.input.value="",void 0!==h.altInput&&(h.altInput.value=""),void 0!==h.mobileInput&&(h.mobileInput.value=""),h.selectedDates=[],h.latestSelectedDateObj=void 0,!0===t&&(h.currentYear=h._initialDate.getFullYear(),h.currentMonth=h._initialDate.getMonth()),h.showTimeInput=!1,!0===h.config.enableTime&&k(),h.redraw(),e&&fe("onChange")},h.close=function(){h.isOpen=!1,h.isMobile||(void 0!==h.calendarContainer&&h.calendarContainer.classList.remove("open"),void 0!==h._input&&h._input.classList.remove("active")),fe("onClose")},h._createElement=d,h.destroy=function(){void 0!==h.config&&fe("onDestroy");for(var e=h._handlers.length;e--;){var t=h._handlers[e];t.element.removeEventListener(t.event,t.handler,t.options)}if(h._handlers=[],h.mobileInput)h.mobileInput.parentNode&&h.mobileInput.parentNode.removeChild(h.mobileInput),h.mobileInput=void 0;else if(h.calendarContainer&&h.calendarContainer.parentNode)if(h.config.static&&h.calendarContainer.parentNode){var n=h.calendarContainer.parentNode;if(n.lastChild&&n.removeChild(n.lastChild),n.parentNode){for(;n.firstChild;)n.parentNode.insertBefore(n.firstChild,n);n.parentNode.removeChild(n)}}else h.calendarContainer.parentNode.removeChild(h.calendarContainer);h.altInput&&(h.input.type="text",h.altInput.parentNode&&h.altInput.parentNode.removeChild(h.altInput),delete h.altInput),h.input&&(h.input.type=h.input._type,h.input.classList.remove("flatpickr-input"),h.input.removeAttribute("readonly"),h.input.value=""),["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete h[e]}catch(e){}}))},h.isEnabled=Z,h.jumpToDate=N,h.open=function(e,t){if(void 0===t&&(t=h._positionElement),!0===h.isMobile)return e&&(e.preventDefault(),e.target&&e.target.blur()),void 0!==h.mobileInput&&(h.mobileInput.focus(),h.mobileInput.click()),void fe("onOpen");if(!h._input.disabled&&!h.config.inline){var n=h.isOpen;h.isOpen=!0,n||(h.calendarContainer.classList.add("open"),h._input.classList.add("active"),fe("onOpen"),oe(t)),!0===h.config.enableTime&&!0===h.config.noCalendar&&(0===h.selectedDates.length&&ne(),!1!==h.config.allowInput||void 0!==e&&h.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return h.hourElement.select()}),50))}},h.redraw=re,h.set=function(e,n){if(null!==e&&"object"==typeof e)for(var a in Object.assign(h.config,e),e)void 0!==de[a]&&de[a].forEach((function(e){return e()}));else h.config[e]=n,void 0!==de[e]?de[e].forEach((function(e){return e()})):t.indexOf(e)>-1&&(h.config[e]=l(n));h.redraw(),ve(!1)},h.setDate=function(e,t,n){if(void 0===t&&(t=!1),void 0===n&&(n=h.config.dateFormat),0!==e&&!e||e instanceof Array&&0===e.length)return h.clear(t);se(e,n),h.showTimeInput=h.selectedDates.length>0,h.latestSelectedDateObj=h.selectedDates[h.selectedDates.length-1],h.redraw(),N(),T(),0===h.selectedDates.length&&h.clear(!1),ve(t),t&&fe("onChange")},h.toggle=function(e){if(!0===h.isOpen)return h.close();h.open(e)};var de={locale:[ie,q],showMonths:[K,M,U],minDate:[N],maxDate:[N]};function se(e,t){var n=[];if(e instanceof Array)n=e.map((function(e){return h.parseDate(e,t)}));else if(e instanceof Date||"number"==typeof e)n=[h.parseDate(e,t)];else if("string"==typeof e)switch(h.config.mode){case"single":case"time":n=[h.parseDate(e,t)];break;case"multiple":n=e.split(h.config.conjunction).map((function(e){return h.parseDate(e,t)}));break;case"range":n=e.split(h.l10n.rangeSeparator).map((function(e){return h.parseDate(e,t)}))}else h.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));h.selectedDates=n.filter((function(e){return e instanceof Date&&Z(e,!1)})),"range"===h.config.mode&&h.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()}))}function ue(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?h.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:h.parseDate(e.from,void 0),to:h.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function fe(e,t){if(void 0!==h.config){var n=h.config[e];if(void 0!==n&&n.length>0)for(var a=0;n[a]&&a<n.length;a++)n[a](h.selectedDates,h.input.value,h,t);"onChange"===e&&(h.input.dispatchEvent(me("change")),h.input.dispatchEvent(me("input")))}}function me(e){var t=document.createEvent("Event");return t.initEvent(e,!0,!0),t}function ge(e){for(var t=0;t<h.selectedDates.length;t++)if(0===w(h.selectedDates[t],e))return""+t;return!1}function pe(){h.config.noCalendar||h.isMobile||!h.monthNav||(h.yearElements.forEach((function(e,t){var n=new Date(h.currentYear,h.currentMonth,1);n.setMonth(h.currentMonth+t),h.config.showMonths>1||"static"===h.config.monthSelectorType?h.monthElements[t].textContent=m(n.getMonth(),h.config.shorthandCurrentMonth,h.l10n)+" ":h.monthsDropdownContainer.value=n.getMonth().toString(),e.value=n.getFullYear().toString()})),h._hidePrevMonthArrow=void 0!==h.config.minDate&&(h.currentYear===h.config.minDate.getFullYear()?h.currentMonth<=h.config.minDate.getMonth():h.currentYear<h.config.minDate.getFullYear()),h._hideNextMonthArrow=void 0!==h.config.maxDate&&(h.currentYear===h.config.maxDate.getFullYear()?h.currentMonth+1>h.config.maxDate.getMonth():h.currentYear>h.config.maxDate.getFullYear()))}function he(e){return h.selectedDates.map((function(t){return h.formatDate(t,e)})).filter((function(e,t,n){return"range"!==h.config.mode||h.config.enableTime||n.indexOf(e)===t})).join("range"!==h.config.mode?h.config.conjunction:h.l10n.rangeSeparator)}function ve(e){void 0===e&&(e=!0),void 0!==h.mobileInput&&h.mobileFormatStr&&(h.mobileInput.value=void 0!==h.latestSelectedDateObj?h.formatDate(h.latestSelectedDateObj,h.mobileFormatStr):""),h.input.value=he(h.config.dateFormat),void 0!==h.altInput&&(h.altInput.value=he(h.config.altFormat)),!1!==e&&fe("onValueUpdate")}function De(e){var t=h.prevMonthNav.contains(e.target),n=h.nextMonthNav.contains(e.target);t||n?$(t?-1:1):h.yearElements.indexOf(e.target)>=0?e.target.select():e.target.classList.contains("arrowUp")?h.changeYear(h.currentYear+1):e.target.classList.contains("arrowDown")&&h.changeYear(h.currentYear-1)}return function(){h.element=h.input=f,h.isOpen=!1,function(){var a=["wrap","weekNumbers","allowInput","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],i=e({},g,JSON.parse(JSON.stringify(f.dataset||{}))),o={};h.config.parseDate=i.parseDate,h.config.formatDate=i.formatDate,Object.defineProperty(h.config,"enable",{get:function(){return h.config._enable},set:function(e){h.config._enable=ue(e)}}),Object.defineProperty(h.config,"disable",{get:function(){return h.config._disable},set:function(e){h.config._disable=ue(e)}});var r="time"===i.mode;if(!i.dateFormat&&(i.enableTime||r)){var c=y.defaultConfig.dateFormat||n.dateFormat;o.dateFormat=i.noCalendar||r?"H:i"+(i.enableSeconds?":S":""):c+" H:i"+(i.enableSeconds?":S":"")}if(i.altInput&&(i.enableTime||r)&&!i.altFormat){var d=y.defaultConfig.altFormat||n.altFormat;o.altFormat=i.noCalendar||r?"h:i"+(i.enableSeconds?":S K":" K"):d+" h:i"+(i.enableSeconds?":S":"")+" K"}i.altInputClass||(h.config.altInputClass=h.input.className+" "+h.config.altInputClass),Object.defineProperty(h.config,"minDate",{get:function(){return h.config._minDate},set:ae("min")}),Object.defineProperty(h.config,"maxDate",{get:function(){return h.config._maxDate},set:ae("max")});var s=function(e){return function(t){h.config["min"===e?"_minTime":"_maxTime"]=h.parseDate(t,"H:i:S")}};Object.defineProperty(h.config,"minTime",{get:function(){return h.config._minTime},set:s("min")}),Object.defineProperty(h.config,"maxTime",{get:function(){return h.config._maxTime},set:s("max")}),"time"===i.mode&&(h.config.noCalendar=!0,h.config.enableTime=!0),Object.assign(h.config,o,i);for(var u=0;u<a.length;u++)h.config[a[u]]=!0===h.config[a[u]]||"true"===h.config[a[u]];for(t.filter((function(e){return void 0!==h.config[e]})).forEach((function(e){h.config[e]=l(h.config[e]||[]).map(C)})),h.isMobile=!h.config.disableMobile&&!h.config.inline&&"single"===h.config.mode&&!h.config.disable.length&&!h.config.enable.length&&!h.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),u=0;u<h.config.plugins.length;u++){var m=h.config.plugins[u](h)||{};for(var p in m)t.indexOf(p)>-1?h.config[p]=l(m[p]).map(C).concat(h.config[p]):void 0===i[p]&&(h.config[p]=m[p])}fe("onParseConfig")}(),ie(),h.input=h.config.wrap?f.querySelector("[data-input]"):f,h.input?(h.input._type=h.input.type,h.input.type="text",h.input.classList.add("flatpickr-input"),h._input=h.input,h.config.altInput&&(h.altInput=d(h.input.nodeName,h.config.altInputClass),h._input=h.altInput,h.altInput.placeholder=h.input.placeholder,h.altInput.disabled=h.input.disabled,h.altInput.required=h.input.required,h.altInput.tabIndex=h.input.tabIndex,h.altInput.type="text",h.input.setAttribute("type","hidden"),!h.config.static&&h.input.parentNode&&h.input.parentNode.insertBefore(h.altInput,h.input.nextSibling)),h.config.allowInput||h._input.setAttribute("readonly","readonly"),h._positionElement=h.config.positionElement||h._input):h.config.errorHandler(new Error("Invalid input element specified")),function(){h.selectedDates=[],h.now=h.parseDate(h.config.now)||new Date;var e=h.config.defaultDate||("INPUT"!==h.input.nodeName&&"TEXTAREA"!==h.input.nodeName||!h.input.placeholder||h.input.value!==h.input.placeholder?h.input.value:null);e&&se(e,h.config.dateFormat),h._initialDate=h.selectedDates.length>0?h.selectedDates[0]:h.config.minDate&&h.config.minDate.getTime()>h.now.getTime()?h.config.minDate:h.config.maxDate&&h.config.maxDate.getTime()<h.now.getTime()?h.config.maxDate:h.now,h.currentYear=h._initialDate.getFullYear(),h.currentMonth=h._initialDate.getMonth(),h.selectedDates.length>0&&(h.latestSelectedDateObj=h.selectedDates[0]),void 0!==h.config.minTime&&(h.config.minTime=h.parseDate(h.config.minTime,"H:i")),void 0!==h.config.maxTime&&(h.config.maxTime=h.parseDate(h.config.maxTime,"H:i")),h.minDateHasTime=!!h.config.minDate&&(h.config.minDate.getHours()>0||h.config.minDate.getMinutes()>0||h.config.minDate.getSeconds()>0),h.maxDateHasTime=!!h.config.maxDate&&(h.config.maxDate.getHours()>0||h.config.maxDate.getMinutes()>0||h.config.maxDate.getSeconds()>0),Object.defineProperty(h,"showTimeInput",{get:function(){return h._showTimeInput},set:function(e){h._showTimeInput=e,h.calendarContainer&&c(h.calendarContainer,"showTimeInput",e),h.isOpen&&oe()}})}(),h.utils={getDaysInMonth:function(e,t){return void 0===e&&(e=h.currentMonth),void 0===t&&(t=h.currentYear),1===e&&(t%4==0&&t%100!=0||t%400==0)?29:h.l10n.daysInMonth[e]}},h.isMobile||function(){var e=window.document.createDocumentFragment();if(h.calendarContainer=d("div","flatpickr-calendar"),h.calendarContainer.tabIndex=-1,!h.config.noCalendar){if(e.appendChild((h.monthNav=d("div","flatpickr-months"),h.yearElements=[],h.monthElements=[],h.prevMonthNav=d("span","flatpickr-prev-month"),h.prevMonthNav.innerHTML=h.config.prevArrow,h.nextMonthNav=d("span","flatpickr-next-month"),h.nextMonthNav.innerHTML=h.config.nextArrow,K(),Object.defineProperty(h,"_hidePrevMonthArrow",{get:function(){return h.__hidePrevMonthArrow},set:function(e){h.__hidePrevMonthArrow!==e&&(c(h.prevMonthNav,"flatpickr-disabled",e),h.__hidePrevMonthArrow=e)}}),Object.defineProperty(h,"_hideNextMonthArrow",{get:function(){return h.__hideNextMonthArrow},set:function(e){h.__hideNextMonthArrow!==e&&(c(h.nextMonthNav,"flatpickr-disabled",e),h.__hideNextMonthArrow=e)}}),h.currentYearElement=h.yearElements[0],pe(),h.monthNav)),h.innerContainer=d("div","flatpickr-innerContainer"),h.config.weekNumbers){var t=function(){h.calendarContainer.classList.add("hasWeeks");var e=d("div","flatpickr-weekwrapper");e.appendChild(d("span","flatpickr-weekday",h.l10n.weekAbbreviation));var t=d("div","flatpickr-weeks");return e.appendChild(t),{weekWrapper:e,weekNumbers:t}}(),n=t.weekWrapper,a=t.weekNumbers;h.innerContainer.appendChild(n),h.weekNumbers=a,h.weekWrapper=n}h.rContainer=d("div","flatpickr-rContainer"),h.rContainer.appendChild(U()),h.daysContainer||(h.daysContainer=d("div","flatpickr-days"),h.daysContainer.tabIndex=-1),R(),h.rContainer.appendChild(h.daysContainer),h.innerContainer.appendChild(h.rContainer),e.appendChild(h.innerContainer)}h.config.enableTime&&e.appendChild(function(){h.calendarContainer.classList.add("hasTime"),h.config.noCalendar&&h.calendarContainer.classList.add("noCalendar"),h.timeContainer=d("div","flatpickr-time"),h.timeContainer.tabIndex=-1;var e=d("span","flatpickr-time-separator",":"),t=u("flatpickr-hour",{"aria-label":h.l10n.hourAriaLabel});h.hourElement=t.getElementsByTagName("input")[0];var n=u("flatpickr-minute",{"aria-label":h.l10n.minuteAriaLabel});if(h.minuteElement=n.getElementsByTagName("input")[0],h.hourElement.tabIndex=h.minuteElement.tabIndex=-1,h.hourElement.value=i(h.latestSelectedDateObj?h.latestSelectedDateObj.getHours():h.config.time_24hr?h.config.defaultHour:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(h.config.defaultHour)),h.minuteElement.value=i(h.latestSelectedDateObj?h.latestSelectedDateObj.getMinutes():h.config.defaultMinute),h.hourElement.setAttribute("step",h.config.hourIncrement.toString()),h.minuteElement.setAttribute("step",h.config.minuteIncrement.toString()),h.hourElement.setAttribute("min",h.config.time_24hr?"0":"1"),h.hourElement.setAttribute("max",h.config.time_24hr?"23":"12"),h.minuteElement.setAttribute("min","0"),h.minuteElement.setAttribute("max","59"),h.timeContainer.appendChild(t),h.timeContainer.appendChild(e),h.timeContainer.appendChild(n),h.config.time_24hr&&h.timeContainer.classList.add("time24hr"),h.config.enableSeconds){h.timeContainer.classList.add("hasSeconds");var a=u("flatpickr-second");h.secondElement=a.getElementsByTagName("input")[0],h.secondElement.value=i(h.latestSelectedDateObj?h.latestSelectedDateObj.getSeconds():h.config.defaultSeconds),h.secondElement.setAttribute("step",h.minuteElement.getAttribute("step")),h.secondElement.setAttribute("min","0"),h.secondElement.setAttribute("max","59"),h.timeContainer.appendChild(d("span","flatpickr-time-separator",":")),h.timeContainer.appendChild(a)}return h.config.time_24hr||(h.amPM=d("span","flatpickr-am-pm",h.l10n.amPM[o((h.latestSelectedDateObj?h.hourElement.value:h.config.defaultHour)>11)]),h.amPM.title=h.l10n.toggleTitle,h.amPM.tabIndex=-1,h.timeContainer.appendChild(h.amPM)),h.timeContainer}()),c(h.calendarContainer,"rangeMode","range"===h.config.mode),c(h.calendarContainer,"animate",!0===h.config.animate),c(h.calendarContainer,"multiMonth",h.config.showMonths>1),h.calendarContainer.appendChild(e);var r=void 0!==h.config.appendTo&&void 0!==h.config.appendTo.nodeType;if((h.config.inline||h.config.static)&&(h.calendarContainer.classList.add(h.config.inline?"inline":"static"),h.config.inline&&(!r&&h.element.parentNode?h.element.parentNode.insertBefore(h.calendarContainer,h._input.nextSibling):void 0!==h.config.appendTo&&h.config.appendTo.appendChild(h.calendarContainer)),h.config.static)){var l=d("div","flatpickr-wrapper");h.element.parentNode&&h.element.parentNode.insertBefore(l,h.element),l.appendChild(h.element),h.altInput&&l.appendChild(h.altInput),l.appendChild(h.calendarContainer)}h.config.static||h.config.inline||(void 0!==h.config.appendTo?h.config.appendTo:window.document.body).appendChild(h.calendarContainer)}(),function(){if(h.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(h.element.querySelectorAll("[data-"+e+"]"),(function(t){return O(t,"click",h[e])}))})),h.isMobile)!function(){var e=h.config.enableTime?h.config.noCalendar?"time":"datetime-local":"date";h.mobileInput=d("input",h.input.className+" flatpickr-mobile"),h.mobileInput.step=h.input.getAttribute("step")||"any",h.mobileInput.tabIndex=1,h.mobileInput.type=e,h.mobileInput.disabled=h.input.disabled,h.mobileInput.required=h.input.required,h.mobileInput.placeholder=h.input.placeholder,h.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",h.selectedDates.length>0&&(h.mobileInput.defaultValue=h.mobileInput.value=h.formatDate(h.selectedDates[0],h.mobileFormatStr)),h.config.minDate&&(h.mobileInput.min=h.formatDate(h.config.minDate,"Y-m-d")),h.config.maxDate&&(h.mobileInput.max=h.formatDate(h.config.maxDate,"Y-m-d")),h.input.type="hidden",void 0!==h.altInput&&(h.altInput.type="hidden");try{h.input.parentNode&&h.input.parentNode.insertBefore(h.mobileInput,h.input.nextSibling)}catch(e){}O(h.mobileInput,"change",(function(e){h.setDate(e.target.value,!1,h.mobileFormatStr),fe("onChange"),fe("onClose")}))}();else{var e=r(te,50);h._debouncedChange=r(F,300),h.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&O(h.daysContainer,"mouseover",(function(e){"range"===h.config.mode&&ee(e.target)})),O(window.document.body,"keydown",X),h.config.inline||h.config.static||O(window,"resize",e),void 0!==window.ontouchstart?O(window.document,"touchstart",G):O(window.document,"mousedown",_(G)),O(window.document,"focus",G,{capture:!0}),!0===h.config.clickOpens&&(O(h._input,"focus",h.open),O(h._input,"mousedown",_(h.open))),void 0!==h.daysContainer&&(O(h.monthNav,"mousedown",_(De)),O(h.monthNav,["keyup","increment"],S),O(h.daysContainer,"mousedown",_(ce))),void 0!==h.timeContainer&&void 0!==h.minuteElement&&void 0!==h.hourElement&&(O(h.timeContainer,["increment"],x),O(h.timeContainer,"blur",x,{capture:!0}),O(h.timeContainer,"mousedown",_(P)),O([h.hourElement,h.minuteElement],["focus","click"],(function(e){return e.target.select()})),void 0!==h.secondElement&&O(h.secondElement,"focus",(function(){return h.secondElement&&h.secondElement.select()})),void 0!==h.amPM&&O(h.amPM,"mousedown",_((function(e){x(e),F()}))))}}(),(h.selectedDates.length||h.config.noCalendar)&&(h.config.enableTime&&T(h.config.noCalendar?h.latestSelectedDateObj||h.config.minDate:void 0),ve(!1)),M(),h.showTimeInput=h.selectedDates.length>0||h.config.noCalendar;var a=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!h.isMobile&&a&&oe(),fe("onReady")}(),h}function M(e,t){for(var n=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<n.length;i++){var o=n[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=C(o,t||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"function"!=typeof Object.assign&&(Object.assign=function(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];if(!e)throw TypeError("Cannot convert undefined or null to object");for(var a=function(t){t&&Object.keys(t).forEach((function(n){return e[n]=t[n]}))},i=0,o=t;i<o.length;i++){var r=o[i];a(r)}return e}),"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return M(this,e)},HTMLElement.prototype.flatpickr=function(e){return M([this],e)});var y=function(e,t){return"string"==typeof e?M(window.document.querySelectorAll(e),t):e instanceof Node?M([e],t):M(e,t)};return y.defaultConfig={},y.l10ns={en:e({},a),default:e({},a)},y.localize=function(t){y.l10ns.default=e({},y.l10ns.default,t)},y.setDefaults=function(t){y.defaultConfig=e({},y.defaultConfig,t)},y.parseDate=D({}),y.formatDate=v({}),y.compareDates=w,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return M(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=y),y},"object"==typeof n&&void 0!==t?t.exports=i():"function"==typeof define&&define.amd?define(i):(a=a||self).flatpickr=i()},
421: function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});e.default='\n.flatpickr-calendar {\n  background: transparent;\n  opacity: 0;\n  display: none;\n  text-align: center;\n  visibility: hidden;\n  padding: 0;\n  -webkit-animation: none;\n  animation: none;\n  direction: ltr;\n  border: 0;\n  font-size: 14px;\n  line-height: 24px;\n  border-radius: 5px;\n  position: absolute;\n  width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -ms-touch-action: manipulation;\n  touch-action: manipulation;\n  background: #fff;\n  -webkit-box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);\n  box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);\n}\n.flatpickr-calendar.open,\n.flatpickr-calendar.inline {\n  opacity: 1;\n  max-height: 640px;\n  visibility: visible;\n}\n.flatpickr-calendar.open {\n  display: inline-block;\n  z-index: 99999;\n}\n.flatpickr-calendar.animate.open {\n  -webkit-animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n  animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n}\n.flatpickr-calendar.inline {\n  display: block;\n  position: relative;\n  top: 2px;\n}\n.flatpickr-calendar.static {\n  position: absolute;\n  top: calc(100% + 2px);\n}\n.flatpickr-calendar.static.open {\n  z-index: 999;\n  display: block;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7) {\n  -webkit-box-shadow: none !important;\n  box-shadow: none !important;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1) {\n  -webkit-box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-calendar .hasWeeks .dayContainer,\n.flatpickr-calendar .hasTime .dayContainer {\n  border-bottom: 0;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.flatpickr-calendar .hasWeeks .dayContainer {\n  border-left: 0;\n}\n.flatpickr-calendar.showTimeInput.hasTime .flatpickr-time {\n  height: 40px;\n  border-top: 1px solid #e6e6e6;\n}\n.flatpickr-calendar.noCalendar.hasTime .flatpickr-time {\n  height: auto;\n}\n.flatpickr-calendar:before,\n.flatpickr-calendar:after {\n  position: absolute;\n  display: block;\n  pointer-events: none;\n  border: solid transparent;\n  content: \'\';\n  height: 0;\n  width: 0;\n  left: 22px;\n}\n.flatpickr-calendar.rightMost:before,\n.flatpickr-calendar.rightMost:after {\n  left: auto;\n  right: 22px;\n}\n.flatpickr-calendar:before {\n  border-width: 5px;\n  margin: 0 -5px;\n}\n.flatpickr-calendar:after {\n  border-width: 4px;\n  margin: 0 -4px;\n}\n.flatpickr-calendar.arrowTop:before,\n.flatpickr-calendar.arrowTop:after {\n  bottom: 100%;\n}\n.flatpickr-calendar.arrowTop:before {\n  border-bottom-color: #e6e6e6;\n}\n.flatpickr-calendar.arrowTop:after {\n  border-bottom-color: #fff;\n}\n.flatpickr-calendar.arrowBottom:before,\n.flatpickr-calendar.arrowBottom:after {\n  top: 100%;\n}\n.flatpickr-calendar.arrowBottom:before {\n  border-top-color: #e6e6e6;\n}\n.flatpickr-calendar.arrowBottom:after {\n  border-top-color: #fff;\n}\n.flatpickr-calendar:focus {\n  outline: 0;\n}\n.flatpickr-wrapper {\n  position: relative;\n  display: inline-block;\n}\n.flatpickr-months {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-months .flatpickr-month {\n  background: transparent;\n  color: rgba(0, 0, 0, 0.9);\n  fill: rgba(0, 0, 0, 0.9);\n  height: 34px;\n  line-height: 1;\n  text-align: center;\n  position: relative;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  overflow: hidden;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\n.flatpickr-months .flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month {\n  text-decoration: none;\n  cursor: pointer;\n  position: absolute;\n  top: 0;\n  height: 34px;\n  padding: 10px;\n  z-index: 3;\n  color: rgba(0, 0, 0, 0.9);\n  fill: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,\n.flatpickr-months .flatpickr-next-month.flatpickr-disabled {\n  display: none;\n}\n.flatpickr-months .flatpickr-prev-month i,\n.flatpickr-months .flatpickr-next-month i {\n  position: relative;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-prev-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  left: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-next-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  right: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month:hover,\n.flatpickr-months .flatpickr-next-month:hover {\n  color: #959ea9;\n}\n.flatpickr-months .flatpickr-prev-month:hover svg,\n.flatpickr-months .flatpickr-next-month:hover svg {\n  fill: #f64747;\n}\n.flatpickr-months .flatpickr-prev-month svg,\n.flatpickr-months .flatpickr-next-month svg {\n  width: 14px;\n  height: 14px;\n}\n.flatpickr-months .flatpickr-prev-month svg path,\n.flatpickr-months .flatpickr-next-month svg path {\n  -webkit-transition: fill 0.1s;\n  transition: fill 0.1s;\n  fill: inherit;\n}\n.numInputWrapper {\n  position: relative;\n  height: auto;\n}\n.numInputWrapper input,\n.numInputWrapper span {\n  display: inline-block;\n}\n.numInputWrapper input {\n  width: 100%;\n}\n.numInputWrapper input::-ms-clear {\n  display: none;\n}\n.numInputWrapper input::-webkit-outer-spin-button,\n.numInputWrapper input::-webkit-inner-spin-button {\n  margin: 0;\n  -webkit-appearance: none;\n}\n.numInputWrapper span {\n  position: absolute;\n  right: 0;\n  width: 14px;\n  padding: 0 4px 0 2px;\n  height: 50%;\n  line-height: 50%;\n  opacity: 0;\n  cursor: pointer;\n  border: 1px solid rgba(57, 57, 57, 0.15);\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.numInputWrapper span:hover {\n  background: rgba(0, 0, 0, 0.1);\n}\n.numInputWrapper span:active {\n  background: rgba(0, 0, 0, 0.2);\n}\n.numInputWrapper span:after {\n  display: block;\n  content: "";\n  position: absolute;\n}\n.numInputWrapper span.arrowUp {\n  top: 0;\n  border-bottom: 0;\n}\n.numInputWrapper span.arrowUp:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-bottom: 4px solid rgba(57, 57, 57, 0.6);\n  top: 26%;\n}\n.numInputWrapper span.arrowDown {\n  top: 50%;\n}\n.numInputWrapper span.arrowDown:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-top: 4px solid rgba(57, 57, 57, 0.6);\n  top: 40%;\n}\n.numInputWrapper span svg {\n  width: inherit;\n  height: auto;\n}\n.numInputWrapper span svg path {\n  fill: rgba(0, 0, 0, 0.5);\n}\n.numInputWrapper:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.numInputWrapper:hover span {\n  opacity: 1;\n}\n.flatpickr-current-month {\n  font-size: 135%;\n  line-height: inherit;\n  font-weight: 300;\n  color: inherit;\n  position: absolute;\n  width: 75%;\n  left: 12.5%;\n  padding: 7.48px 0 0 0;\n  line-height: 1;\n  height: 34px;\n  display: inline-block;\n  text-align: center;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n}\n.flatpickr-current-month span.cur-month {\n  font-family: inherit;\n  font-weight: 700;\n  color: inherit;\n  display: inline-block;\n  margin-left: 0.5ch;\n  padding: 0;\n}\n.flatpickr-current-month span.cur-month:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .numInputWrapper {\n  width: 6ch;\n  width: 7ch\0;\n  display: inline-block;\n}\n.flatpickr-current-month .numInputWrapper span.arrowUp:after {\n  border-bottom-color: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-current-month .numInputWrapper span.arrowDown:after {\n  border-top-color: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-current-month input.cur-year {\n  background: transparent;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: text;\n  padding: 0 0 0 0.5ch;\n  margin: 0;\n  display: inline-block;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  line-height: inherit;\n  height: auto;\n  border: 0;\n  border-radius: 0;\n  vertical-align: initial;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-current-month input.cur-year:focus {\n  outline: 0;\n}\n.flatpickr-current-month input.cur-year[disabled],\n.flatpickr-current-month input.cur-year[disabled]:hover {\n  font-size: 100%;\n  color: rgba(0, 0, 0, 0.5);\n  background: transparent;\n  pointer-events: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months {\n  appearance: menulist;\n  background: transparent;\n  border: none;\n  border-radius: 0;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: pointer;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  height: auto;\n  line-height: inherit;\n  margin: -1px 0 0 0;\n  outline: none;\n  padding: 0 0 0 0.5ch;\n  position: relative;\n  vertical-align: initial;\n  -webkit-box-sizing: border-box;\n  -webkit-appearance: menulist;\n  -moz-appearance: menulist;\n  width: auto;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:focus,\n.flatpickr-current-month .flatpickr-monthDropdown-months:active {\n  outline: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month {\n  background-color: transparent;\n  outline: none;\n  padding: 0;\n}\n.flatpickr-weekdays {\n  background: transparent;\n  text-align: center;\n  overflow: hidden;\n  width: 100%;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -webkit-align-items: center;\n  -ms-flex-align: center;\n  align-items: center;\n  height: 28px;\n}\n.flatpickr-weekdays .flatpickr-weekdaycontainer {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\nspan.flatpickr-weekday {\n  cursor: default;\n  font-size: 90%;\n  background: transparent;\n  color: rgba(0, 0, 0, 0.54);\n  line-height: 1;\n  margin: 0;\n  text-align: center;\n  display: block;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  font-weight: bolder;\n}\n.dayContainer,\n.flatpickr-weeks {\n  padding: 1px 0 0 0;\n}\n.flatpickr-days {\n  position: relative;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: start;\n  -webkit-align-items: flex-start;\n  -ms-flex-align: start;\n  align-items: flex-start;\n  width: 307.875px;\n}\n.flatpickr-days:focus {\n  outline: 0;\n}\n.dayContainer {\n  padding: 0;\n  outline: 0;\n  text-align: left;\n  width: 307.875px;\n  min-width: 307.875px;\n  max-width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  display: inline-block;\n  display: -ms-flexbox;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: flex;\n  -webkit-flex-wrap: wrap;\n  flex-wrap: wrap;\n  -ms-flex-wrap: wrap;\n  -ms-flex-pack: justify;\n  -webkit-justify-content: space-around;\n  justify-content: space-around;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n  opacity: 1;\n}\n.dayContainer + .dayContainer {\n  -webkit-box-shadow: -1px 0 0 #e6e6e6;\n  box-shadow: -1px 0 0 #e6e6e6;\n}\n.flatpickr-day {\n  background: none;\n  border: 1px solid transparent;\n  border-radius: 150px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: #393939;\n  cursor: pointer;\n  font-weight: 400;\n  width: 14.2857143%;\n  -webkit-flex-basis: 14.2857143%;\n  -ms-flex-preferred-size: 14.2857143%;\n  flex-basis: 14.2857143%;\n  max-width: 39px;\n  height: 39px;\n  line-height: 39px;\n  margin: 0;\n  display: inline-block;\n  position: relative;\n  -webkit-box-pack: center;\n  -webkit-justify-content: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n  text-align: center;\n}\n.flatpickr-day.inRange,\n.flatpickr-day.prevMonthDay.inRange,\n.flatpickr-day.nextMonthDay.inRange,\n.flatpickr-day.today.inRange,\n.flatpickr-day.prevMonthDay.today.inRange,\n.flatpickr-day.nextMonthDay.today.inRange,\n.flatpickr-day:hover,\n.flatpickr-day.prevMonthDay:hover,\n.flatpickr-day.nextMonthDay:hover,\n.flatpickr-day:focus,\n.flatpickr-day.prevMonthDay:focus,\n.flatpickr-day.nextMonthDay:focus {\n  cursor: pointer;\n  outline: 0;\n  background: #e6e6e6;\n  border-color: #e6e6e6;\n}\n.flatpickr-day.today {\n  border-color: #959ea9;\n}\n.flatpickr-day.today:hover,\n.flatpickr-day.today:focus {\n  border-color: #959ea9;\n  background: #959ea9;\n  color: #fff;\n}\n.flatpickr-day.selected,\n.flatpickr-day.startRange,\n.flatpickr-day.endRange,\n.flatpickr-day.selected.inRange,\n.flatpickr-day.startRange.inRange,\n.flatpickr-day.endRange.inRange,\n.flatpickr-day.selected:focus,\n.flatpickr-day.startRange:focus,\n.flatpickr-day.endRange:focus,\n.flatpickr-day.selected:hover,\n.flatpickr-day.startRange:hover,\n.flatpickr-day.endRange:hover,\n.flatpickr-day.selected.prevMonthDay,\n.flatpickr-day.startRange.prevMonthDay,\n.flatpickr-day.endRange.prevMonthDay,\n.flatpickr-day.selected.nextMonthDay,\n.flatpickr-day.startRange.nextMonthDay,\n.flatpickr-day.endRange.nextMonthDay {\n  background: #569ff7;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  color: #fff;\n  border-color: #569ff7;\n}\n.flatpickr-day.selected.startRange,\n.flatpickr-day.startRange.startRange,\n.flatpickr-day.endRange.startRange {\n  border-radius: 50px 0 0 50px;\n}\n.flatpickr-day.selected.endRange,\n.flatpickr-day.startRange.endRange,\n.flatpickr-day.endRange.endRange {\n  border-radius: 0 50px 50px 0;\n}\n.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)) {\n  -webkit-box-shadow: -10px 0 0 #569ff7;\n  box-shadow: -10px 0 0 #569ff7;\n}\n.flatpickr-day.selected.startRange.endRange,\n.flatpickr-day.startRange.startRange.endRange,\n.flatpickr-day.endRange.startRange.endRange {\n  border-radius: 50px;\n}\n.flatpickr-day.inRange {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover,\n.flatpickr-day.prevMonthDay,\n.flatpickr-day.nextMonthDay,\n.flatpickr-day.notAllowed,\n.flatpickr-day.notAllowed.prevMonthDay,\n.flatpickr-day.notAllowed.nextMonthDay {\n  color: rgba(57, 57, 57, 0.3);\n  background: transparent;\n  border-color: transparent;\n  cursor: default;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover {\n  cursor: not-allowed;\n  color: rgba(57, 57, 57, 0.1);\n}\n.flatpickr-day.week.selected {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7;\n  box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7;\n}\n.flatpickr-day.hidden {\n  visibility: hidden;\n}\n.rangeMode .flatpickr-day {\n  margin-top: 1px;\n}\n.flatpickr-weekwrapper {\n  float: left;\n}\n.flatpickr-weekwrapper .flatpickr-weeks {\n  padding: 0 12px;\n  -webkit-box-shadow: 1px 0 0 #e6e6e6;\n  box-shadow: 1px 0 0 #e6e6e6;\n}\n.flatpickr-weekwrapper .flatpickr-weekday {\n  float: none;\n  width: 100%;\n  line-height: 28px;\n}\n.flatpickr-weekwrapper span.flatpickr-day,\n.flatpickr-weekwrapper span.flatpickr-day:hover {\n  display: block;\n  width: 100%;\n  max-width: none;\n  color: rgba(57, 57, 57, 0.3);\n  background: transparent;\n  cursor: default;\n  border: none;\n}\n.flatpickr-innerContainer {\n  display: block;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n}\n.flatpickr-rContainer {\n  display: inline-block;\n  padding: 0;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.flatpickr-time {\n  text-align: center;\n  outline: 0;\n  display: block;\n  height: 0;\n  line-height: 40px;\n  max-height: 40px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-time:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.flatpickr-time .numInputWrapper {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  width: 40%;\n  height: 40px;\n  float: left;\n}\n.flatpickr-time .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #393939;\n}\n.flatpickr-time .numInputWrapper span.arrowDown:after {\n  border-top-color: #393939;\n}\n.flatpickr-time.hasSeconds .numInputWrapper {\n  width: 26%;\n}\n.flatpickr-time.time24hr .numInputWrapper {\n  width: 49%;\n}\n.flatpickr-time input {\n  background: transparent;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  border: 0;\n  border-radius: 0;\n  text-align: center;\n  margin: 0;\n  padding: 0;\n  height: inherit;\n  line-height: inherit;\n  color: #393939;\n  font-size: 14px;\n  position: relative;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-time input.flatpickr-hour {\n  font-weight: bold;\n}\n.flatpickr-time input.flatpickr-minute,\n.flatpickr-time input.flatpickr-second {\n  font-weight: 400;\n}\n.flatpickr-time input:focus {\n  outline: 0;\n  border: 0;\n}\n.flatpickr-time .flatpickr-time-separator,\n.flatpickr-time .flatpickr-am-pm {\n  height: inherit;\n  float: left;\n  line-height: inherit;\n  color: #393939;\n  font-weight: bold;\n  width: 2%;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center;\n}\n.flatpickr-time .flatpickr-am-pm {\n  outline: 0;\n  width: 18%;\n  cursor: pointer;\n  text-align: center;\n  font-weight: 400;\n}\n.flatpickr-time input:hover,\n.flatpickr-time .flatpickr-am-pm:hover,\n.flatpickr-time input:focus,\n.flatpickr-time .flatpickr-am-pm:focus {\n  background: #eee;\n}\n.flatpickr-input[readonly] {\n  cursor: pointer;\n}\n@-webkit-keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n@keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n.flatpickr-calendar {\n  background: transparent;\n  opacity: 0;\n  display: none;\n  text-align: center;\n  visibility: hidden;\n  padding: 0;\n  -webkit-animation: none;\n  animation: none;\n  direction: ltr;\n  border: 0;\n  font-size: 14px;\n  line-height: 24px;\n  border-radius: 5px;\n  position: absolute;\n  width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -ms-touch-action: manipulation;\n  touch-action: manipulation;\n  -webkit-box-shadow: 0 3px 13px rgba(0, 0, 0, 0.08);\n  box-shadow: 0 3px 13px rgba(0, 0, 0, 0.08);\n}\n.flatpickr-calendar.open,\n.flatpickr-calendar.inline {\n  opacity: 1;\n  max-height: 640px;\n  visibility: visible;\n}\n.flatpickr-calendar.open {\n  display: inline-block;\n  z-index: 99999;\n}\n.flatpickr-calendar.animate.open {\n  -webkit-animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n  animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n}\n.flatpickr-calendar.inline {\n  display: block;\n  position: relative;\n  top: 2px;\n}\n.flatpickr-calendar.static {\n  position: absolute;\n  top: calc(100% + 2px);\n}\n.flatpickr-calendar.static.open {\n  z-index: 999;\n  display: block;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7) {\n  -webkit-box-shadow: none !important;\n  box-shadow: none !important;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1) {\n  -webkit-box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-calendar .hasWeeks .dayContainer,\n.flatpickr-calendar .hasTime .dayContainer {\n  border-bottom: 0;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.flatpickr-calendar .hasWeeks .dayContainer {\n  border-left: 0;\n}\n.flatpickr-calendar.showTimeInput.hasTime .flatpickr-time {\n  height: 40px;\n  border-top: 1px solid #eceef1;\n}\n.flatpickr-calendar.showTimeInput.hasTime .flatpickr-innerContainer {\n  border-bottom: 0;\n}\n.flatpickr-calendar.showTimeInput.hasTime .flatpickr-time {\n  border: 1px solid #eceef1;\n}\n.flatpickr-calendar.noCalendar.hasTime .flatpickr-time {\n  height: auto;\n}\n.flatpickr-calendar:before,\n.flatpickr-calendar:after {\n  position: absolute;\n  display: block;\n  pointer-events: none;\n  border: solid transparent;\n  content: \'\';\n  height: 0;\n  width: 0;\n  left: 22px;\n}\n.flatpickr-calendar.rightMost:before,\n.flatpickr-calendar.rightMost:after {\n  left: auto;\n  right: 22px;\n}\n.flatpickr-calendar:before {\n  border-width: 5px;\n  margin: 0 -5px;\n}\n.flatpickr-calendar:after {\n  border-width: 4px;\n  margin: 0 -4px;\n}\n.flatpickr-calendar.arrowTop:before,\n.flatpickr-calendar.arrowTop:after {\n  bottom: 100%;\n}\n.flatpickr-calendar.arrowTop:before {\n  border-bottom-color: #eceef1;\n}\n.flatpickr-calendar.arrowTop:after {\n  border-bottom-color: #eceef1;\n}\n.flatpickr-calendar.arrowBottom:before,\n.flatpickr-calendar.arrowBottom:after {\n  top: 100%;\n}\n.flatpickr-calendar.arrowBottom:before {\n  border-top-color: #eceef1;\n}\n.flatpickr-calendar.arrowBottom:after {\n  border-top-color: #eceef1;\n}\n.flatpickr-calendar:focus {\n  outline: 0;\n}\n.flatpickr-wrapper {\n  position: relative;\n  display: inline-block;\n}\n.flatpickr-months {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-months .flatpickr-month {\n  border-radius: 5px 5px 0 0;\n  background: #eceef1;\n  color: #5a6171;\n  fill: #5a6171;\n  height: 34px;\n  line-height: 1;\n  text-align: center;\n  position: relative;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  overflow: hidden;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\n.flatpickr-months .flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month {\n  text-decoration: none;\n  cursor: pointer;\n  position: absolute;\n  top: 0;\n  height: 34px;\n  padding: 10px;\n  z-index: 3;\n  color: #5a6171;\n  fill: #5a6171;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,\n.flatpickr-months .flatpickr-next-month.flatpickr-disabled {\n  display: none;\n}\n.flatpickr-months .flatpickr-prev-month i,\n.flatpickr-months .flatpickr-next-month i {\n  position: relative;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-prev-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  left: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-next-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  right: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month:hover,\n.flatpickr-months .flatpickr-next-month:hover {\n  color: #bbb;\n}\n.flatpickr-months .flatpickr-prev-month:hover svg,\n.flatpickr-months .flatpickr-next-month:hover svg {\n  fill: #f64747;\n}\n.flatpickr-months .flatpickr-prev-month svg,\n.flatpickr-months .flatpickr-next-month svg {\n  width: 14px;\n  height: 14px;\n}\n.flatpickr-months .flatpickr-prev-month svg path,\n.flatpickr-months .flatpickr-next-month svg path {\n  -webkit-transition: fill 0.1s;\n  transition: fill 0.1s;\n  fill: inherit;\n}\n.numInputWrapper {\n  position: relative;\n  height: auto;\n}\n.numInputWrapper input,\n.numInputWrapper span {\n  display: inline-block;\n}\n.numInputWrapper input {\n  width: 100%;\n}\n.numInputWrapper input::-ms-clear {\n  display: none;\n}\n.numInputWrapper input::-webkit-outer-spin-button,\n.numInputWrapper input::-webkit-inner-spin-button {\n  margin: 0;\n  -webkit-appearance: none;\n}\n.numInputWrapper span {\n  position: absolute;\n  right: 0;\n  width: 14px;\n  padding: 0 4px 0 2px;\n  height: 50%;\n  line-height: 50%;\n  opacity: 0;\n  cursor: pointer;\n  border: 1px solid rgba(72, 72, 72, 0.15);\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.numInputWrapper span:hover {\n  background: rgba(0, 0, 0, 0.1);\n}\n.numInputWrapper span:active {\n  background: rgba(0, 0, 0, 0.2);\n}\n.numInputWrapper span:after {\n  display: block;\n  content: "";\n  position: absolute;\n}\n.numInputWrapper span.arrowUp {\n  top: 0;\n  border-bottom: 0;\n}\n.numInputWrapper span.arrowUp:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-bottom: 4px solid rgba(72, 72, 72, 0.6);\n  top: 26%;\n}\n.numInputWrapper span.arrowDown {\n  top: 50%;\n}\n.numInputWrapper span.arrowDown:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-top: 4px solid rgba(72, 72, 72, 0.6);\n  top: 40%;\n}\n.numInputWrapper span svg {\n  width: inherit;\n  height: auto;\n}\n.numInputWrapper span svg path {\n  fill: rgba(90, 97, 113, 0.5);\n}\n.numInputWrapper:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.numInputWrapper:hover span {\n  opacity: 1;\n}\n.flatpickr-current-month {\n  font-size: 135%;\n  line-height: inherit;\n  font-weight: 300;\n  color: inherit;\n  position: absolute;\n  width: 75%;\n  left: 12.5%;\n  padding: 7.48px 0 0 0;\n  line-height: 1;\n  height: 34px;\n  display: inline-block;\n  text-align: center;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n}\n.flatpickr-current-month span.cur-month {\n  font-family: inherit;\n  font-weight: 700;\n  color: inherit;\n  display: inline-block;\n  margin-left: 0.5ch;\n  padding: 0;\n}\n.flatpickr-current-month span.cur-month:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .numInputWrapper {\n  width: 6ch;\n  width: 7ch\0;\n  display: inline-block;\n}\n.flatpickr-current-month .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #5a6171;\n}\n.flatpickr-current-month .numInputWrapper span.arrowDown:after {\n  border-top-color: #5a6171;\n}\n.flatpickr-current-month input.cur-year {\n  background: transparent;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: text;\n  padding: 0 0 0 0.5ch;\n  margin: 0;\n  display: inline-block;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  line-height: inherit;\n  height: auto;\n  border: 0;\n  border-radius: 0;\n  vertical-align: initial;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-current-month input.cur-year:focus {\n  outline: 0;\n}\n.flatpickr-current-month input.cur-year[disabled],\n.flatpickr-current-month input.cur-year[disabled]:hover {\n  font-size: 100%;\n  color: rgba(90, 97, 113, 0.5);\n  background: transparent;\n  pointer-events: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months {\n  appearance: menulist;\n  background: #eceef1;\n  border: none;\n  border-radius: 0;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: pointer;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  height: auto;\n  line-height: inherit;\n  margin: -1px 0 0 0;\n  outline: none;\n  padding: 0 0 0 0.5ch;\n  position: relative;\n  vertical-align: initial;\n  -webkit-box-sizing: border-box;\n  -webkit-appearance: menulist;\n  -moz-appearance: menulist;\n  width: auto;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:focus,\n.flatpickr-current-month .flatpickr-monthDropdown-months:active {\n  outline: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month {\n  background-color: #eceef1;\n  outline: none;\n  padding: 0;\n}\n.flatpickr-weekdays {\n  background: #eceef1;\n  text-align: center;\n  overflow: hidden;\n  width: 100%;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -webkit-align-items: center;\n  -ms-flex-align: center;\n  align-items: center;\n  height: 28px;\n}\n.flatpickr-weekdays .flatpickr-weekdaycontainer {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\nspan.flatpickr-weekday {\n  cursor: default;\n  font-size: 90%;\n  background: #eceef1;\n  color: #5a6171;\n  line-height: 1;\n  margin: 0;\n  text-align: center;\n  display: block;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  font-weight: bolder;\n}\n.dayContainer,\n.flatpickr-weeks {\n  padding: 1px 0 0 0;\n}\n.flatpickr-days {\n  position: relative;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: start;\n  -webkit-align-items: flex-start;\n  -ms-flex-align: start;\n  align-items: flex-start;\n  width: 307.875px;\n  border-left: 1px solid #eceef1;\n  border-right: 1px solid #eceef1;\n}\n.flatpickr-days:focus {\n  outline: 0;\n}\n.dayContainer {\n  padding: 0;\n  outline: 0;\n  text-align: left;\n  width: 307.875px;\n  min-width: 307.875px;\n  max-width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  display: inline-block;\n  display: -ms-flexbox;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: flex;\n  -webkit-flex-wrap: wrap;\n  flex-wrap: wrap;\n  -ms-flex-wrap: wrap;\n  -ms-flex-pack: justify;\n  -webkit-justify-content: space-around;\n  justify-content: space-around;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n  opacity: 1;\n}\n.dayContainer + .dayContainer {\n  -webkit-box-shadow: -1px 0 0 #eceef1;\n  box-shadow: -1px 0 0 #eceef1;\n}\n.flatpickr-day {\n  background: none;\n  border: 1px solid transparent;\n  border-radius: 150px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: #484848;\n  cursor: pointer;\n  font-weight: 400;\n  width: 14.2857143%;\n  -webkit-flex-basis: 14.2857143%;\n  -ms-flex-preferred-size: 14.2857143%;\n  flex-basis: 14.2857143%;\n  max-width: 39px;\n  height: 39px;\n  line-height: 39px;\n  margin: 0;\n  display: inline-block;\n  position: relative;\n  -webkit-box-pack: center;\n  -webkit-justify-content: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n  text-align: center;\n}\n.flatpickr-day.inRange,\n.flatpickr-day.prevMonthDay.inRange,\n.flatpickr-day.nextMonthDay.inRange,\n.flatpickr-day.today.inRange,\n.flatpickr-day.prevMonthDay.today.inRange,\n.flatpickr-day.nextMonthDay.today.inRange,\n.flatpickr-day:hover,\n.flatpickr-day.prevMonthDay:hover,\n.flatpickr-day.nextMonthDay:hover,\n.flatpickr-day:focus,\n.flatpickr-day.prevMonthDay:focus,\n.flatpickr-day.nextMonthDay:focus {\n  cursor: pointer;\n  outline: 0;\n  background: #e2e2e2;\n  border-color: #e2e2e2;\n}\n.flatpickr-day.today {\n  border-color: #bbb;\n}\n.flatpickr-day.today:hover,\n.flatpickr-day.today:focus {\n  border-color: #bbb;\n  background: #bbb;\n  color: #fff;\n}\n.flatpickr-day.selected,\n.flatpickr-day.startRange,\n.flatpickr-day.endRange,\n.flatpickr-day.selected.inRange,\n.flatpickr-day.startRange.inRange,\n.flatpickr-day.endRange.inRange,\n.flatpickr-day.selected:focus,\n.flatpickr-day.startRange:focus,\n.flatpickr-day.endRange:focus,\n.flatpickr-day.selected:hover,\n.flatpickr-day.startRange:hover,\n.flatpickr-day.endRange:hover,\n.flatpickr-day.selected.prevMonthDay,\n.flatpickr-day.startRange.prevMonthDay,\n.flatpickr-day.endRange.prevMonthDay,\n.flatpickr-day.selected.nextMonthDay,\n.flatpickr-day.startRange.nextMonthDay,\n.flatpickr-day.endRange.nextMonthDay {\n  background: #ff5a5f;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  color: #fff;\n  border-color: #ff5a5f;\n}\n.flatpickr-day.selected.startRange,\n.flatpickr-day.startRange.startRange,\n.flatpickr-day.endRange.startRange {\n  border-radius: 50px 0 0 50px;\n}\n.flatpickr-day.selected.endRange,\n.flatpickr-day.startRange.endRange,\n.flatpickr-day.endRange.endRange {\n  border-radius: 0 50px 50px 0;\n}\n.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)) {\n  -webkit-box-shadow: -10px 0 0 #ff5a5f;\n  box-shadow: -10px 0 0 #ff5a5f;\n}\n.flatpickr-day.selected.startRange.endRange,\n.flatpickr-day.startRange.startRange.endRange,\n.flatpickr-day.endRange.startRange.endRange {\n  border-radius: 50px;\n}\n.flatpickr-day.inRange {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;\n  box-shadow: -5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover,\n.flatpickr-day.prevMonthDay,\n.flatpickr-day.nextMonthDay,\n.flatpickr-day.notAllowed,\n.flatpickr-day.notAllowed.prevMonthDay,\n.flatpickr-day.notAllowed.nextMonthDay {\n  color: rgba(72, 72, 72, 0.3);\n  background: transparent;\n  border-color: transparent;\n  cursor: default;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover {\n  cursor: not-allowed;\n  color: rgba(72, 72, 72, 0.1);\n}\n.flatpickr-day.week.selected {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;\n  box-shadow: -5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;\n}\n.flatpickr-day.hidden {\n  visibility: hidden;\n}\n.rangeMode .flatpickr-day {\n  margin-top: 1px;\n}\n.flatpickr-weekwrapper {\n  float: left;\n}\n.flatpickr-weekwrapper .flatpickr-weeks {\n  padding: 0 12px;\n  border-left: 1px solid #eceef1;\n}\n.flatpickr-weekwrapper .flatpickr-weekday {\n  float: none;\n  width: 100%;\n  line-height: 28px;\n}\n.flatpickr-weekwrapper span.flatpickr-day,\n.flatpickr-weekwrapper span.flatpickr-day:hover {\n  display: block;\n  width: 100%;\n  max-width: none;\n  color: rgba(72, 72, 72, 0.3);\n  background: transparent;\n  cursor: default;\n  border: none;\n}\n.flatpickr-innerContainer {\n  display: block;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  background: #fff;\n  border-bottom: 1px solid #eceef1;\n}\n.flatpickr-rContainer {\n  display: inline-block;\n  padding: 0;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.flatpickr-time {\n  text-align: center;\n  outline: 0;\n  display: block;\n  height: 0;\n  line-height: 40px;\n  max-height: 40px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  background: #fff;\n  border-radius: 0 0 5px 5px;\n}\n.flatpickr-time:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.flatpickr-time .numInputWrapper {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  width: 40%;\n  height: 40px;\n  float: left;\n}\n.flatpickr-time .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #484848;\n}\n.flatpickr-time .numInputWrapper span.arrowDown:after {\n  border-top-color: #484848;\n}\n.flatpickr-time.hasSeconds .numInputWrapper {\n  width: 26%;\n}\n.flatpickr-time.time24hr .numInputWrapper {\n  width: 49%;\n}\n.flatpickr-time input {\n  background: transparent;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  border: 0;\n  border-radius: 0;\n  text-align: center;\n  margin: 0;\n  padding: 0;\n  height: inherit;\n  line-height: inherit;\n  color: #484848;\n  font-size: 14px;\n  position: relative;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-time input.flatpickr-hour {\n  font-weight: bold;\n}\n.flatpickr-time input.flatpickr-minute,\n.flatpickr-time input.flatpickr-second {\n  font-weight: 400;\n}\n.flatpickr-time input:focus {\n  outline: 0;\n  border: 0;\n}\n.flatpickr-time .flatpickr-time-separator,\n.flatpickr-time .flatpickr-am-pm {\n  height: inherit;\n  float: left;\n  line-height: inherit;\n  color: #484848;\n  font-weight: bold;\n  width: 2%;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center;\n}\n.flatpickr-time .flatpickr-am-pm {\n  outline: 0;\n  width: 18%;\n  cursor: pointer;\n  text-align: center;\n  font-weight: 400;\n}\n.flatpickr-time input:hover,\n.flatpickr-time .flatpickr-am-pm:hover,\n.flatpickr-time input:focus,\n.flatpickr-time .flatpickr-am-pm:focus {\n  background: #eaeaea;\n}\n.flatpickr-input[readonly] {\n  cursor: pointer;\n}\n@-webkit-keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n@keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\nspan.flatpickr-day.selected {\n  font-weight: bold;\n}\n'},
422: function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const i=e(1).__importDefault(e(186)),r=e(423);class n extends r.AbstractRangeSliderView{}a.DateRangeSliderView=n,n.__name__="DateRangeSliderView";class d extends r.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_DateRangeSlider(){this.prototype.default_view=n,this.override({format:"%d %b %Y"})}_formatter(e,t){return i.default(e,t)}}a.DateRangeSlider=d,d.__name__="DateRangeSlider",d.init_DateRangeSlider()},
423: function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),l=s.__importStar(t(424)),r=t(72),o=t(9),n=t(405),a=t(131),d=t(425),_=t(412),h=s.__importDefault(t(426)),c=s.__importDefault(t(427));class u extends n.ControlView{*controls(){yield this.slider_el}get noUiSlider(){return this.slider_el.noUiSlider}connect_signals(){super.connect_signals();const{direction:t,orientation:e,tooltips:i}=this.model.properties;this.on_change([t,e,i],()=>this.render());const{start:s,end:l,value:r,step:o,title:n}=this.model.properties;this.on_change([s,l,r,o],()=>{const{start:t,end:e,value:i,step:s}=this._calc_to();this.noUiSlider.updateOptions({range:{min:t,max:e},start:i,step:s})});const{bar_color:a}=this.model.properties;this.on_change(a,()=>{this._set_bar_color()});const{show_value:d}=this.model.properties;this.on_change([r,n,d],()=>this._update_title())}styles(){return[...super.styles(),h.default,c.default]}_update_title(){r.empty(this.title_el);const t=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=t?"none":"",!t&&(0!=this.model.title.length&&(this.title_el.textContent=this.model.title+": "),this.model.show_value)){const{value:t}=this._calc_to(),e=t.map(t=>this.model.pretty(t)).join(" .. ");this.title_el.appendChild(r.span({class:d.bk_slider_value},e))}}_set_bar_color(){if(!this.model.disabled){this.slider_el.querySelector(".noUi-connect").style.backgroundColor=this.model.bar_color}}render(){super.render();const{start:t,end:e,value:i,step:s}=this._calc_to();let n;if(this.model.tooltips){const t={to:t=>this.model.pretty(t)};n=o.repeat(t,i.length)}else n=!1;if(null==this.slider_el){this.slider_el=r.div(),l.create(this.slider_el,{range:{min:t,max:e},start:i,step:s,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:n,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",(t,e,i)=>this._slide(i)),this.noUiSlider.on("change",(t,e,i)=>this._change(i));const o=(t,e)=>{if(!n)return;this.slider_el.querySelectorAll(".noUi-handle")[t].querySelector(".noUi-tooltip").style.display=e?"block":""};this.noUiSlider.on("start",(t,e)=>o(e,!0)),this.noUiSlider.on("end",(t,e)=>o(e,!1))}else this.noUiSlider.updateOptions({range:{min:t,max:e},start:i,step:s});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=r.div({class:d.bk_slider_title}),this._update_title(),this.group_el=r.div({class:_.bk_input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)}_slide(t){this.model.value=this._calc_from(t)}_change(t){this.model.value=this._calc_from(t),this.model.value_throttled=this.model.value}}u.__name__="AbstractBaseSliderView";class m extends u{_calc_to(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}}_calc_from([t]){return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(t):t}}i.AbstractSliderView=m,m.__name__="AbstractSliderView";class p extends u{_calc_to(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}}_calc_from(t){return t}}i.AbstractRangeSliderView=p,p.__name__="AbstractRangeSliderView";class b extends n.Control{constructor(t){super(t),this.connected=!1}static init_AbstractSlider(){this.define(({Any:t,Boolean:e,Number:i,String:s,Color:l,Or:r,Enum:o,Ref:n})=>({title:[s,""],show_value:[e,!0],start:[t],end:[t],value:[t],value_throttled:[t],step:[i,1],format:[r(s,n(a.TickFormatter))],direction:[o("ltr","rtl"),"ltr"],tooltips:[e,!0],bar_color:[l,"#e6e6e6"]}))}_formatter(t,e){return""+t}pretty(t){return this._formatter(t,this.format)}}i.AbstractSlider=b,b.__name__="AbstractSlider",b.init_AbstractSlider()},
424: function _(t,e,r){
/*! nouislider - 14.6.0 - 6/27/2020 */
var n;n=function(){"use strict";var t="14.6.0";function e(t){t.parentElement.removeChild(t)}function r(t){return null!=t}function n(t){t.preventDefault()}function i(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function o(t,e,r){r>0&&(u(t,e),setTimeout((function(){c(t,e)}),r))}function s(t){return Math.max(Math.min(t,100),0)}function a(t){return Array.isArray(t)?t:[t]}function l(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function u(t,e){t.classList&&!/\s/.test(e)?t.classList.add(e):t.className+=" "+e}function c(t,e){t.classList&&!/\s/.test(e)?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function p(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function f(t,e){return 100/(e-t)}function d(t,e,r){return 100*e/(t[r+1]-t[r])}function h(t,e){for(var r=1;t>=e[r];)r+=1;return r}function m(t,e,r){if(r>=t.slice(-1)[0])return 100;var n=h(r,t),i=t[n-1],o=t[n],s=e[n-1],a=e[n];return s+function(t,e){return d(t,t[0]<0?e+Math.abs(t[0]):e-t[0],0)}([i,o],r)/f(s,a)}function g(t,e,r,n){if(100===n)return n;var i=h(n,t),o=t[i-1],s=t[i];return r?n-o>(s-o)/2?s:o:e[i-1]?t[i-1]+function(t,e){return Math.round(t/e)*e}(n-t[i-1],e[i-1]):n}function v(t,e,r){var n;if("number"==typeof e&&(e=[e]),!Array.isArray(e))throw new Error("noUiSlider (14.6.0): 'range' contains invalid value.");if(!i(n="min"===t?0:"max"===t?100:parseFloat(t))||!i(e[0]))throw new Error("noUiSlider (14.6.0): 'range' value isn't numeric.");r.xPct.push(n),r.xVal.push(e[0]),n?r.xSteps.push(!isNaN(e[1])&&e[1]):isNaN(e[1])||(r.xSteps[0]=e[1]),r.xHighestCompleteStep.push(0)}function b(t,e,r){if(e)if(r.xVal[t]!==r.xVal[t+1]){r.xSteps[t]=d([r.xVal[t],r.xVal[t+1]],e,0)/f(r.xPct[t],r.xPct[t+1]);var n=(r.xVal[t+1]-r.xVal[t])/r.xNumSteps[t],i=Math.ceil(Number(n.toFixed(3))-1),o=r.xVal[t]+r.xNumSteps[t]*i;r.xHighestCompleteStep[t]=o}else r.xSteps[t]=r.xHighestCompleteStep[t]=r.xVal[t]}function x(t,e,r){var n;this.xPct=[],this.xVal=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var i=[];for(n in t)t.hasOwnProperty(n)&&i.push([t[n],n]);for(i.length&&"object"==typeof i[0][0]?i.sort((function(t,e){return t[0][0]-e[0][0]})):i.sort((function(t,e){return t[0]-e[0]})),n=0;n<i.length;n++)v(i[n][1],i[n][0],this);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)b(n,this.xNumSteps[n],this)}x.prototype.getDistance=function(t){var e,r=[];for(e=0;e<this.xNumSteps.length-1;e++){var n=this.xNumSteps[e];if(n&&t/n%1!=0)throw new Error("noUiSlider (14.6.0): 'limit', 'margin' and 'padding' of "+this.xPct[e]+"% range must be divisible by step.");r[e]=d(this.xVal,t,e)}return r},x.prototype.getAbsoluteDistance=function(t,e,r){var n,i=0;if(t<this.xPct[this.xPct.length-1])for(;t>this.xPct[i+1];)i++;else t===this.xPct[this.xPct.length-1]&&(i=this.xPct.length-2);r||t!==this.xPct[i+1]||i++;var o=1,s=e[i],a=0,l=0,u=0,c=0;for(n=r?(t-this.xPct[i])/(this.xPct[i+1]-this.xPct[i]):(this.xPct[i+1]-t)/(this.xPct[i+1]-this.xPct[i]);s>0;)a=this.xPct[i+1+c]-this.xPct[i+c],e[i+c]*o+100-100*n>100?(l=a*n,o=(s-100*n)/e[i+c],n=1):(l=e[i+c]*a/100*o,o=0),r?(u-=l,this.xPct.length+c>=1&&c--):(u+=l,this.xPct.length-c>=1&&c++),s=e[i+c]*o;return t+u},x.prototype.toStepping=function(t){return t=m(this.xVal,this.xPct,t)},x.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n=h(r,e),i=t[n-1],o=t[n],s=e[n-1];return function(t,e){return e*(t[1]-t[0])/100+t[0]}([i,o],(r-s)*f(s,e[n]))}(this.xVal,this.xPct,t)},x.prototype.getStep=function(t){return t=g(this.xPct,this.xSteps,this.snap,t)},x.prototype.getDefaultStep=function(t,e,r){var n=h(t,this.xPct);return(100===t||e&&t===this.xPct[n-1])&&(n=Math.max(n-1,1)),(this.xVal[n]-this.xVal[n-1])/r},x.prototype.getNearbySteps=function(t){var e=h(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e],step:this.xNumSteps[e],highestStep:this.xHighestCompleteStep[e]}}},x.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(l);return Math.max.apply(null,t)},x.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var S={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number},w={target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",touchArea:"touch-area",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",connects:"connects",ltr:"ltr",rtl:"rtl",textDirectionLtr:"txt-dir-ltr",textDirectionRtl:"txt-dir-rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"};function y(t){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(t))return!0;throw new Error("noUiSlider (14.6.0): 'format' requires 'to' and 'from' methods.")}function E(t,e){if(!i(e))throw new Error("noUiSlider (14.6.0): 'step' is not numeric.");t.singleStep=e}function C(t,e){if(!i(e))throw new Error("noUiSlider (14.6.0): 'keyboardPageMultiplier' is not numeric.");t.keyboardPageMultiplier=e}function P(t,e){if(!i(e))throw new Error("noUiSlider (14.6.0): 'keyboardDefaultStep' is not numeric.");t.keyboardDefaultStep=e}function N(t,e){if("object"!=typeof e||Array.isArray(e))throw new Error("noUiSlider (14.6.0): 'range' is not an object.");if(void 0===e.min||void 0===e.max)throw new Error("noUiSlider (14.6.0): Missing 'min' or 'max' in 'range'.");if(e.min===e.max)throw new Error("noUiSlider (14.6.0): 'range' 'min' and 'max' cannot be equal.");t.spectrum=new x(e,t.snap,t.singleStep)}function k(t,e){if(e=a(e),!Array.isArray(e)||!e.length)throw new Error("noUiSlider (14.6.0): 'start' option is incorrect.");t.handles=e.length,t.start=e}function U(t,e){if(t.snap=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.0): 'snap' option must be a boolean.")}function A(t,e){if(t.animate=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.0): 'animate' option must be a boolean.")}function V(t,e){if(t.animationDuration=e,"number"!=typeof e)throw new Error("noUiSlider (14.6.0): 'animationDuration' option must be a number.")}function D(t,e){var r,n=[!1];if("lower"===e?e=[!0,!1]:"upper"===e&&(e=[!1,!0]),!0===e||!1===e){for(r=1;r<t.handles;r++)n.push(e);n.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error("noUiSlider (14.6.0): 'connect' option doesn't match handle count.");n=e}t.connect=n}function M(t,e){switch(e){case"horizontal":t.ort=0;break;case"vertical":t.ort=1;break;default:throw new Error("noUiSlider (14.6.0): 'orientation' option is invalid.")}}function O(t,e){if(!i(e))throw new Error("noUiSlider (14.6.0): 'margin' option must be numeric.");0!==e&&(t.margin=t.spectrum.getDistance(e))}function L(t,e){if(!i(e))throw new Error("noUiSlider (14.6.0): 'limit' option must be numeric.");if(t.limit=t.spectrum.getDistance(e),!t.limit||t.handles<2)throw new Error("noUiSlider (14.6.0): 'limit' option is only supported on linear sliders with 2 or more handles.")}function z(t,e){var r;if(!i(e)&&!Array.isArray(e))throw new Error("noUiSlider (14.6.0): 'padding' option must be numeric or array of exactly 2 numbers.");if(Array.isArray(e)&&2!==e.length&&!i(e[0])&&!i(e[1]))throw new Error("noUiSlider (14.6.0): 'padding' option must be numeric or array of exactly 2 numbers.");if(0!==e){for(Array.isArray(e)||(e=[e,e]),t.padding=[t.spectrum.getDistance(e[0]),t.spectrum.getDistance(e[1])],r=0;r<t.spectrum.xNumSteps.length-1;r++)if(t.padding[0][r]<0||t.padding[1][r]<0)throw new Error("noUiSlider (14.6.0): 'padding' option must be a positive number(s).");var n=e[0]+e[1],o=t.spectrum.xVal[0];if(n/(t.spectrum.xVal[t.spectrum.xVal.length-1]-o)>1)throw new Error("noUiSlider (14.6.0): 'padding' option must not exceed 100% of the range.")}}function H(t,e){switch(e){case"ltr":t.dir=0;break;case"rtl":t.dir=1;break;default:throw new Error("noUiSlider (14.6.0): 'direction' option was not recognized.")}}function j(t,e){if("string"!=typeof e)throw new Error("noUiSlider (14.6.0): 'behaviour' must be a string containing options.");var r=e.indexOf("tap")>=0,n=e.indexOf("drag")>=0,i=e.indexOf("fixed")>=0,o=e.indexOf("snap")>=0,s=e.indexOf("hover")>=0,a=e.indexOf("unconstrained")>=0;if(i){if(2!==t.handles)throw new Error("noUiSlider (14.6.0): 'fixed' behaviour must be used with 2 handles");O(t,t.start[1]-t.start[0])}if(a&&(t.margin||t.limit))throw new Error("noUiSlider (14.6.0): 'unconstrained' behaviour cannot be used with margin or limit");t.events={tap:r||o,drag:n,fixed:i,snap:o,hover:s,unconstrained:a}}function F(t,e){if(!1!==e)if(!0===e){t.tooltips=[];for(var r=0;r<t.handles;r++)t.tooltips.push(!0)}else{if(t.tooltips=a(e),t.tooltips.length!==t.handles)throw new Error("noUiSlider (14.6.0): must pass a formatter for all handles.");t.tooltips.forEach((function(t){if("boolean"!=typeof t&&("object"!=typeof t||"function"!=typeof t.to))throw new Error("noUiSlider (14.6.0): 'tooltips' must be passed a formatter or 'false'.")}))}}function R(t,e){t.ariaFormat=e,y(e)}function T(t,e){t.format=e,y(e)}function B(t,e){if(t.keyboardSupport=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.0): 'keyboardSupport' option must be a boolean.")}function q(t,e){t.documentElement=e}function X(t,e){if("string"!=typeof e&&!1!==e)throw new Error("noUiSlider (14.6.0): 'cssPrefix' must be a string or `false`.");t.cssPrefix=e}function _(t,e){if("object"!=typeof e)throw new Error("noUiSlider (14.6.0): 'cssClasses' must be an object.");if("string"==typeof t.cssPrefix)for(var r in t.cssClasses={},e)e.hasOwnProperty(r)&&(t.cssClasses[r]=t.cssPrefix+e[r]);else t.cssClasses=e}function Y(t){var e={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:S,format:S},n={step:{r:!1,t:E},keyboardPageMultiplier:{r:!1,t:C},keyboardDefaultStep:{r:!1,t:P},start:{r:!0,t:k},connect:{r:!0,t:D},direction:{r:!0,t:H},snap:{r:!1,t:U},animate:{r:!1,t:A},animationDuration:{r:!1,t:V},range:{r:!0,t:N},orientation:{r:!1,t:M},margin:{r:!1,t:O},limit:{r:!1,t:L},padding:{r:!1,t:z},behaviour:{r:!0,t:j},ariaFormat:{r:!1,t:R},format:{r:!1,t:T},tooltips:{r:!1,t:F},keyboardSupport:{r:!0,t:B},documentElement:{r:!1,t:q},cssPrefix:{r:!0,t:X},cssClasses:{r:!0,t:_}},i={connect:!1,direction:"ltr",behaviour:"tap",orientation:"horizontal",keyboardSupport:!0,cssPrefix:"noUi-",cssClasses:w,keyboardPageMultiplier:5,keyboardDefaultStep:10};t.format&&!t.ariaFormat&&(t.ariaFormat=t.format),Object.keys(n).forEach((function(o){if(!r(t[o])&&void 0===i[o]){if(n[o].r)throw new Error("noUiSlider (14.6.0): '"+o+"' is required.");return!0}n[o].t(e,r(t[o])?t[o]:i[o])})),e.pips=t.pips;var o=document.createElement("div"),s=void 0!==o.style.msTransform,a=void 0!==o.style.transform;return e.transformRule=a?"transform":s?"msTransform":"webkitTransform",e.style=[["left","top"],["right","bottom"]][e.dir][e.ort],e}function I(t,r,i){var l,f,d,h,m,g,v,b,x=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},S=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),w=t,y=r.spectrum,E=[],C=[],P=[],N=0,k={},U=t.ownerDocument,A=r.documentElement||U.documentElement,V=U.body,D="rtl"===U.dir||1===r.ort?0:100;function M(t,e){var r=U.createElement("div");return e&&u(r,e),t.appendChild(r),r}function O(t,e){var n=M(t,r.cssClasses.origin),i=M(n,r.cssClasses.handle);return M(i,r.cssClasses.touchArea),i.setAttribute("data-handle",e),r.keyboardSupport&&(i.setAttribute("tabindex","0"),i.addEventListener("keydown",(function(t){return function(t,e){if(H()||j(e))return!1;var n=["Left","Right"],i=["Down","Up"],o=["PageDown","PageUp"],s=["Home","End"];r.dir&&!r.ort?n.reverse():r.ort&&!r.dir&&(i.reverse(),o.reverse());var a,l=t.key.replace("Arrow",""),u=l===o[0],c=l===o[1],p=l===i[0]||l===n[0]||u,f=l===i[1]||l===n[1]||c,d=l===s[0],h=l===s[1];if(!(p||f||d||h))return!0;if(t.preventDefault(),f||p){var m=r.keyboardPageMultiplier,g=p?0:1,v=ft(e)[g];if(null===v)return!1;!1===v&&(v=y.getDefaultStep(C[e],p,r.keyboardDefaultStep)),(c||u)&&(v*=m),v=Math.max(v,1e-7),v*=p?-1:1,a=E[e]+v}else a=h?r.spectrum.xVal[r.spectrum.xVal.length-1]:r.spectrum.xVal[0];return at(e,y.toStepping(a),!0,!0),et("slide",e),et("update",e),et("change",e),et("set",e),!1}(t,e)}))),i.setAttribute("role","slider"),i.setAttribute("aria-orientation",r.ort?"vertical":"horizontal"),0===e?u(i,r.cssClasses.handleLower):e===r.handles-1&&u(i,r.cssClasses.handleUpper),n}function L(t,e){return!!e&&M(t,r.cssClasses.connect)}function z(t,e){return!!r.tooltips[e]&&M(t.firstChild,r.cssClasses.tooltip)}function H(){return w.hasAttribute("disabled")}function j(t){return f[t].hasAttribute("disabled")}function F(){m&&(tt("update.tooltips"),m.forEach((function(t){t&&e(t)})),m=null)}function R(){F(),m=f.map(z),Z("update.tooltips",(function(t,e,n){if(m[e]){var i=t[e];!0!==r.tooltips[e]&&(i=r.tooltips[e].to(n[e])),m[e].innerHTML=i}}))}function T(t,e,n){var i=U.createElement("div"),o=[];o[0]=r.cssClasses.valueNormal,o[1]=r.cssClasses.valueLarge,o[2]=r.cssClasses.valueSub;var s=[];s[0]=r.cssClasses.markerNormal,s[1]=r.cssClasses.markerLarge,s[2]=r.cssClasses.markerSub;var a=[r.cssClasses.valueHorizontal,r.cssClasses.valueVertical],l=[r.cssClasses.markerHorizontal,r.cssClasses.markerVertical];function c(t,e){var n=e===r.cssClasses.value,i=n?o:s;return e+" "+(n?a:l)[r.ort]+" "+i[t]}return u(i,r.cssClasses.pips),u(i,0===r.ort?r.cssClasses.pipsHorizontal:r.cssClasses.pipsVertical),Object.keys(t).forEach((function(o){!function(t,o,s){if(-1!==(s=e?e(o,s):s)){var a=M(i,!1);a.className=c(s,r.cssClasses.marker),a.style[r.style]=t+"%",s>0&&((a=M(i,!1)).className=c(s,r.cssClasses.value),a.setAttribute("data-value",o),a.style[r.style]=t+"%",a.innerHTML=n.to(o))}}(o,t[o][0],t[o][1])})),i}function B(){h&&(e(h),h=null)}function q(t){B();var e=t.mode,r=t.density||1,n=t.filter||!1,i=function(t,e,r){if("range"===t||"steps"===t)return y.xVal;if("count"===t){if(e<2)throw new Error("noUiSlider (14.6.0): 'values' (>= 2) required for mode 'count'.");var n=e-1,i=100/n;for(e=[];n--;)e[n]=n*i;e.push(100),t="positions"}return"positions"===t?e.map((function(t){return y.fromStepping(r?y.getStep(t):t)})):"values"===t?r?e.map((function(t){return y.fromStepping(y.getStep(y.toStepping(t)))})):e:void 0}(e,t.values||!1,t.stepped||!1),o=function(t,e,r){var n,i={},o=y.xVal[0],s=y.xVal[y.xVal.length-1],a=!1,l=!1,u=0;return n=r.slice().sort((function(t,e){return t-e})),(r=n.filter((function(t){return!this[t]&&(this[t]=!0)}),{}))[0]!==o&&(r.unshift(o),a=!0),r[r.length-1]!==s&&(r.push(s),l=!0),r.forEach((function(n,o){var s,c,p,f,d,h,m,g,v,b,x=n,S=r[o+1],w="steps"===e;if(w&&(s=y.xNumSteps[o]),s||(s=S-x),!1!==x&&void 0!==S)for(s=Math.max(s,1e-7),c=x;c<=S;c=(c+s).toFixed(7)/1){for(g=(d=(f=y.toStepping(c))-u)/t,b=d/(v=Math.round(g)),p=1;p<=v;p+=1)i[(h=u+p*b).toFixed(5)]=[y.fromStepping(h),0];m=r.indexOf(c)>-1?1:w?2:0,!o&&a&&c!==S&&(m=0),c===S&&l||(i[f.toFixed(5)]=[c,m]),u=f}})),i}(r,e,i),s=t.format||{to:Math.round};return h=w.appendChild(T(o,n,s))}function X(){var t=l.getBoundingClientRect(),e="offset"+["Width","Height"][r.ort];return 0===r.ort?t.width||l[e]:t.height||l[e]}function _(t,e,n,i){var o=function(o){return!!(o=function(t,e,r){var n,i,o=0===t.type.indexOf("touch"),s=0===t.type.indexOf("mouse"),a=0===t.type.indexOf("pointer");if(0===t.type.indexOf("MSPointer")&&(a=!0),o){var l=function(t){return t.target===r||r.contains(t.target)||t.target.shadowRoot&&t.target.shadowRoot.contains(r)};if("touchstart"===t.type){var u=Array.prototype.filter.call(t.touches,l);if(u.length>1)return!1;n=u[0].pageX,i=u[0].pageY}else{var c=Array.prototype.find.call(t.changedTouches,l);if(!c)return!1;n=c.pageX,i=c.pageY}}return e=e||p(U),(s||a)&&(n=t.clientX+e.x,i=t.clientY+e.y),t.pageOffset=e,t.points=[n,i],t.cursor=s||a,t}(o,i.pageOffset,i.target||e))&&!(H()&&!i.doNotReject)&&(s=w,a=r.cssClasses.tap,!((s.classList?s.classList.contains(a):new RegExp("\\b"+a+"\\b").test(s.className))&&!i.doNotReject)&&!(t===x.start&&void 0!==o.buttons&&o.buttons>1)&&(!i.hover||!o.buttons)&&(S||o.preventDefault(),o.calcPoint=o.points[r.ort],void n(o,i)));var s,a},s=[];return t.split(" ").forEach((function(t){e.addEventListener(t,o,!!S&&{passive:!0}),s.push([t,o])})),s}function I(t){var e,n,i,o,a,u,c=100*(t-(e=l,n=r.ort,i=e.getBoundingClientRect(),o=e.ownerDocument,a=o.documentElement,u=p(o),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(u.x=0),n?i.top+u.y-a.clientTop:i.left+u.x-a.clientLeft))/X();return c=s(c),r.dir?100-c:c}function W(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&G(t,e)}function $(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return G(t,e);var n=(r.dir?-1:1)*(t.calcPoint-e.startCalcPoint);it(n>0,100*n/e.baseSize,e.locations,e.handleNumbers)}function G(t,e){e.handle&&(c(e.handle,r.cssClasses.active),N-=1),e.listeners.forEach((function(t){A.removeEventListener(t[0],t[1])})),0===N&&(c(w,r.cssClasses.drag),st(),t.cursor&&(V.style.cursor="",V.removeEventListener("selectstart",n))),e.handleNumbers.forEach((function(t){et("change",t),et("set",t),et("end",t)}))}function J(t,e){if(e.handleNumbers.some(j))return!1;var i;1===e.handleNumbers.length&&(i=f[e.handleNumbers[0]].children[0],N+=1,u(i,r.cssClasses.active)),t.stopPropagation();var o=[],s=_(x.move,A,$,{target:t.target,handle:i,listeners:o,startCalcPoint:t.calcPoint,baseSize:X(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:C.slice()}),a=_(x.end,A,G,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers}),l=_("mouseout",A,W,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers});o.push.apply(o,s.concat(a,l)),t.cursor&&(V.style.cursor=getComputedStyle(t.target).cursor,f.length>1&&u(w,r.cssClasses.drag),V.addEventListener("selectstart",n,!1)),e.handleNumbers.forEach((function(t){et("start",t)}))}function K(t){if(!t.buttons&&!t.touches)return!1;t.stopPropagation();var e=I(t.calcPoint),n=function(t){var e=100,r=!1;return f.forEach((function(n,i){if(!j(i)){var o=C[i],s=Math.abs(o-t);(s<e||s<=e&&t>o||100===s&&100===e)&&(r=i,e=s)}})),r}(e);if(!1===n)return!1;r.events.snap||o(w,r.cssClasses.tap,r.animationDuration),at(n,e,!0,!0),st(),et("slide",n,!0),et("update",n,!0),et("change",n,!0),et("set",n,!0),r.events.snap&&J(t,{handleNumbers:[n]})}function Q(t){var e=I(t.calcPoint),r=y.getStep(e),n=y.fromStepping(r);Object.keys(k).forEach((function(t){"hover"===t.split(".")[0]&&k[t].forEach((function(t){t.call(g,n)}))}))}function Z(t,e){k[t]=k[t]||[],k[t].push(e),"update"===t.split(".")[0]&&f.forEach((function(t,e){et("update",e)}))}function tt(t){var e=t&&t.split(".")[0],r=e&&t.substring(e.length);Object.keys(k).forEach((function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||delete k[t]}))}function et(t,e,n){Object.keys(k).forEach((function(i){var o=i.split(".")[0];t===o&&k[i].forEach((function(t){t.call(g,E.map(r.format.to),e,E.slice(),n||!1,C.slice(),g)}))}))}function rt(t,e,n,i,o,a){var l;return f.length>1&&!r.events.unconstrained&&(i&&e>0&&(l=y.getAbsoluteDistance(t[e-1],r.margin,0),n=Math.max(n,l)),o&&e<f.length-1&&(l=y.getAbsoluteDistance(t[e+1],r.margin,1),n=Math.min(n,l))),f.length>1&&r.limit&&(i&&e>0&&(l=y.getAbsoluteDistance(t[e-1],r.limit,0),n=Math.min(n,l)),o&&e<f.length-1&&(l=y.getAbsoluteDistance(t[e+1],r.limit,1),n=Math.max(n,l))),r.padding&&(0===e&&(l=y.getAbsoluteDistance(0,r.padding[0],0),n=Math.max(n,l)),e===f.length-1&&(l=y.getAbsoluteDistance(100,r.padding[1],1),n=Math.min(n,l))),!((n=s(n=y.getStep(n)))===t[e]&&!a)&&n}function nt(t,e){var n=r.ort;return(n?e:t)+", "+(n?t:e)}function it(t,e,r,n){var i=r.slice(),o=[!t,t],s=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach((function(t,r){var n=rt(i,t,i[t]+e,o[r],s[r],!1);!1===n?e=0:(e=n-i[t],i[t]=n)})):o=s=[!0];var a=!1;n.forEach((function(t,n){a=at(t,r[t]+e,o[n],s[n])||a})),a&&n.forEach((function(t){et("update",t),et("slide",t)}))}function ot(t,e){return r.dir?100-t-e:t}function st(){P.forEach((function(t){var e=C[t]>50?-1:1,r=3+(f.length+e*t);f[t].style.zIndex=r}))}function at(t,e,n,i){return!1!==(e=rt(C,t,e,n,i,!1))&&(function(t,e){C[t]=e,E[t]=y.fromStepping(e);var n="translate("+nt(10*(ot(e,0)-D)+"%","0")+")";f[t].style[r.transformRule]=n,lt(t),lt(t+1)}(t,e),!0)}function lt(t){if(d[t]){var e=0,n=100;0!==t&&(e=C[t-1]),t!==d.length-1&&(n=C[t]);var i=n-e,o="translate("+nt(ot(e,i)+"%","0")+")",s="scale("+nt(i/100,"1")+")";d[t].style[r.transformRule]=o+" "+s}}function ut(t,e){return null===t||!1===t||void 0===t?C[e]:("number"==typeof t&&(t=String(t)),t=r.format.from(t),!1===(t=y.toStepping(t))||isNaN(t)?C[e]:t)}function ct(t,e){var n=a(t),i=void 0===C[0];e=void 0===e||!!e,r.animate&&!i&&o(w,r.cssClasses.tap,r.animationDuration),P.forEach((function(t){at(t,ut(n[t],t),!0,!1)}));for(var s=1===P.length?0:1;s<P.length;++s)P.forEach((function(t){at(t,C[t],!0,!0)}));st(),P.forEach((function(t){et("update",t),null!==n[t]&&e&&et("set",t)}))}function pt(){var t=E.map(r.format.to);return 1===t.length?t[0]:t}function ft(t){var e=C[t],n=y.getNearbySteps(e),i=E[t],o=n.thisStep.step,s=null;if(r.snap)return[i-n.stepBefore.startValue||null,n.stepAfter.startValue-i||null];!1!==o&&i+o>n.stepAfter.startValue&&(o=n.stepAfter.startValue-i),s=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===e?o=null:0===e&&(s=null);var a=y.countStepDecimals();return null!==o&&!1!==o&&(o=Number(o.toFixed(a))),null!==s&&!1!==s&&(s=Number(s.toFixed(a))),[s,o]}return u(v=w,r.cssClasses.target),0===r.dir?u(v,r.cssClasses.ltr):u(v,r.cssClasses.rtl),0===r.ort?u(v,r.cssClasses.horizontal):u(v,r.cssClasses.vertical),u(v,"rtl"===getComputedStyle(v).direction?r.cssClasses.textDirectionRtl:r.cssClasses.textDirectionLtr),l=M(v,r.cssClasses.base),function(t,e){var n=M(e,r.cssClasses.connects);f=[],(d=[]).push(L(n,t[0]));for(var i=0;i<r.handles;i++)f.push(O(e,i)),P[i]=i,d.push(L(n,t[i+1]))}(r.connect,l),(b=r.events).fixed||f.forEach((function(t,e){_(x.start,t.children[0],J,{handleNumbers:[e]})})),b.tap&&_(x.start,l,K,{}),b.hover&&_(x.move,l,Q,{hover:!0}),b.drag&&d.forEach((function(t,e){if(!1!==t&&0!==e&&e!==d.length-1){var n=f[e-1],i=f[e],o=[t];u(t,r.cssClasses.draggable),b.fixed&&(o.push(n.children[0]),o.push(i.children[0])),o.forEach((function(t){_(x.start,t,J,{handles:[n,i],handleNumbers:[e-1,e]})}))}})),ct(r.start),r.pips&&q(r.pips),r.tooltips&&R(),Z("update",(function(t,e,n,i,o){P.forEach((function(t){var e=f[t],i=rt(C,t,0,!0,!0,!0),s=rt(C,t,100,!0,!0,!0),a=o[t],l=r.ariaFormat.to(n[t]);i=y.fromStepping(i).toFixed(1),s=y.fromStepping(s).toFixed(1),a=y.fromStepping(a).toFixed(1),e.children[0].setAttribute("aria-valuemin",i),e.children[0].setAttribute("aria-valuemax",s),e.children[0].setAttribute("aria-valuenow",a),e.children[0].setAttribute("aria-valuetext",l)}))})),g={destroy:function(){for(var t in r.cssClasses)r.cssClasses.hasOwnProperty(t)&&c(w,r.cssClasses[t]);for(;w.firstChild;)w.removeChild(w.firstChild);delete w.noUiSlider},steps:function(){return P.map(ft)},on:Z,off:tt,get:pt,set:ct,setHandle:function(t,e,r){if(!((t=Number(t))>=0&&t<P.length))throw new Error("noUiSlider (14.6.0): invalid handle number, got: "+t);at(t,ut(e,t),!0,!0),et("update",t),r&&et("set",t)},reset:function(t){ct(r.start,t)},__moveHandles:function(t,e,r){it(t,e,C,r)},options:i,updateOptions:function(t,e){var n=pt(),o=["margin","limit","padding","range","animate","snap","step","format","pips","tooltips"];o.forEach((function(e){void 0!==t[e]&&(i[e]=t[e])}));var s=Y(i);o.forEach((function(e){void 0!==t[e]&&(r[e]=s[e])})),y=s.spectrum,r.margin=s.margin,r.limit=s.limit,r.padding=s.padding,r.pips?q(r.pips):B(),r.tooltips?R():F(),C=[],ct(t.start||n,e)},target:w,removePips:B,removeTooltips:F,getTooltips:function(){return m},getOrigins:function(){return f},pips:q}}return{__spectrum:x,version:t,cssClasses:w,create:function(t,e){if(!t||!t.nodeName)throw new Error("noUiSlider (14.6.0): create requires a single element, got: "+t);if(t.noUiSlider)throw new Error("noUiSlider (14.6.0): Slider was already initialized.");var r=I(t,Y(e),e);return t.noUiSlider=r,r}}},"function"==typeof define&&define.amd?define([],n):"object"==typeof r?e.exports=n():window.noUiSlider=n()},
425: function _(e,l,i){Object.defineProperty(i,"__esModule",{value:!0}),i.bk_slider_value="bk-slider-value",i.bk_slider_title="bk-slider-title"},
426: function _(n,o,t){Object.defineProperty(t,"__esModule",{value:!0});t.default="\n.bk-root {\n  /*! nouislider - 14.6.0 - 6/27/2020 */\n  /* Functional styling;\n * These styles are required for noUiSlider to function.\n * You don't need to change these rules to apply your design.\n */\n  /* Wrapper for all connect elements.\n */\n  /* Offset direction\n */\n  /* Give origins 0 height/width so they don't interfere with clicking the\n * connect elements.\n */\n  /* Slider size and handle placement;\n */\n  /* Styling;\n * Giving the connect element a border radius causes issues with using transform: scale\n */\n  /* Handles and cursors;\n */\n  /* Handle stripes;\n */\n  /* Disabled state;\n */\n  /* Base;\n *\n */\n  /* Values;\n *\n */\n  /* Markings;\n *\n */\n  /* Horizontal layout;\n *\n */\n  /* Vertical layout;\n *\n */\n}\n.bk-root .noUi-target,\n.bk-root .noUi-target * {\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-user-select: none;\n  -ms-touch-action: none;\n  touch-action: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  user-select: none;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .noUi-target {\n  position: relative;\n}\n.bk-root .noUi-base,\n.bk-root .noUi-connects {\n  width: 100%;\n  height: 100%;\n  position: relative;\n  z-index: 1;\n}\n.bk-root .noUi-connects {\n  overflow: hidden;\n  z-index: 0;\n}\n.bk-root .noUi-connect,\n.bk-root .noUi-origin {\n  will-change: transform;\n  position: absolute;\n  z-index: 1;\n  top: 0;\n  right: 0;\n  -ms-transform-origin: 0 0;\n  -webkit-transform-origin: 0 0;\n  -webkit-transform-style: preserve-3d;\n  transform-origin: 0 0;\n  transform-style: flat;\n}\n.bk-root .noUi-connect {\n  height: 100%;\n  width: 100%;\n}\n.bk-root .noUi-origin {\n  height: 10%;\n  width: 10%;\n}\n.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-origin {\n  left: 0;\n  right: auto;\n}\n.bk-root .noUi-vertical .noUi-origin {\n  width: 0;\n}\n.bk-root .noUi-horizontal .noUi-origin {\n  height: 0;\n}\n.bk-root .noUi-handle {\n  -webkit-backface-visibility: hidden;\n  backface-visibility: hidden;\n  position: absolute;\n}\n.bk-root .noUi-touch-area {\n  height: 100%;\n  width: 100%;\n}\n.bk-root .noUi-state-tap .noUi-connect,\n.bk-root .noUi-state-tap .noUi-origin {\n  -webkit-transition: transform 0.3s;\n  transition: transform 0.3s;\n}\n.bk-root .noUi-state-drag * {\n  cursor: inherit !important;\n}\n.bk-root .noUi-horizontal {\n  height: 18px;\n}\n.bk-root .noUi-horizontal .noUi-handle {\n  width: 34px;\n  height: 28px;\n  right: -17px;\n  top: -6px;\n}\n.bk-root .noUi-vertical {\n  width: 18px;\n}\n.bk-root .noUi-vertical .noUi-handle {\n  width: 28px;\n  height: 34px;\n  right: -6px;\n  top: -17px;\n}\n.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-handle {\n  left: -17px;\n  right: auto;\n}\n.bk-root .noUi-target {\n  background: #FAFAFA;\n  border-radius: 4px;\n  border: 1px solid #D3D3D3;\n  box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;\n}\n.bk-root .noUi-connects {\n  border-radius: 3px;\n}\n.bk-root .noUi-connect {\n  background: #3FB8AF;\n}\n.bk-root .noUi-draggable {\n  cursor: ew-resize;\n}\n.bk-root .noUi-vertical .noUi-draggable {\n  cursor: ns-resize;\n}\n.bk-root .noUi-handle {\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #FFF;\n  cursor: default;\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;\n}\n.bk-root .noUi-active {\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;\n}\n.bk-root .noUi-handle:before,\n.bk-root .noUi-handle:after {\n  content: \"\";\n  display: block;\n  position: absolute;\n  height: 14px;\n  width: 1px;\n  background: #E8E7E6;\n  left: 14px;\n  top: 6px;\n}\n.bk-root .noUi-handle:after {\n  left: 17px;\n}\n.bk-root .noUi-vertical .noUi-handle:before,\n.bk-root .noUi-vertical .noUi-handle:after {\n  width: 14px;\n  height: 1px;\n  left: 6px;\n  top: 14px;\n}\n.bk-root .noUi-vertical .noUi-handle:after {\n  top: 17px;\n}\n.bk-root [disabled] .noUi-connect {\n  background: #B8B8B8;\n}\n.bk-root [disabled].noUi-target,\n.bk-root [disabled].noUi-handle,\n.bk-root [disabled] .noUi-handle {\n  cursor: not-allowed;\n}\n.bk-root .noUi-pips,\n.bk-root .noUi-pips * {\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .noUi-pips {\n  position: absolute;\n  color: #999;\n}\n.bk-root .noUi-value {\n  position: absolute;\n  white-space: nowrap;\n  text-align: center;\n}\n.bk-root .noUi-value-sub {\n  color: #ccc;\n  font-size: 10px;\n}\n.bk-root .noUi-marker {\n  position: absolute;\n  background: #CCC;\n}\n.bk-root .noUi-marker-sub {\n  background: #AAA;\n}\n.bk-root .noUi-marker-large {\n  background: #AAA;\n}\n.bk-root .noUi-pips-horizontal {\n  padding: 10px 0;\n  height: 80px;\n  top: 100%;\n  left: 0;\n  width: 100%;\n}\n.bk-root .noUi-value-horizontal {\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.bk-root .noUi-rtl .noUi-value-horizontal {\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n.bk-root .noUi-marker-horizontal.noUi-marker {\n  margin-left: -1px;\n  width: 2px;\n  height: 5px;\n}\n.bk-root .noUi-marker-horizontal.noUi-marker-sub {\n  height: 10px;\n}\n.bk-root .noUi-marker-horizontal.noUi-marker-large {\n  height: 15px;\n}\n.bk-root .noUi-pips-vertical {\n  padding: 0 10px;\n  height: 100%;\n  top: 0;\n  left: 100%;\n}\n.bk-root .noUi-value-vertical {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  padding-left: 25px;\n}\n.bk-root .noUi-rtl .noUi-value-vertical {\n  -webkit-transform: translate(0, 50%);\n  transform: translate(0, 50%);\n}\n.bk-root .noUi-marker-vertical.noUi-marker {\n  width: 5px;\n  height: 2px;\n  margin-top: -1px;\n}\n.bk-root .noUi-marker-vertical.noUi-marker-sub {\n  width: 10px;\n}\n.bk-root .noUi-marker-vertical.noUi-marker-large {\n  width: 15px;\n}\n.bk-root .noUi-tooltip {\n  display: block;\n  position: absolute;\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #fff;\n  color: #000;\n  padding: 5px;\n  text-align: center;\n  white-space: nowrap;\n}\n.bk-root .noUi-horizontal .noUi-tooltip {\n  -webkit-transform: translate(-50%, 0);\n  transform: translate(-50%, 0);\n  left: 50%;\n  bottom: 120%;\n}\n.bk-root .noUi-vertical .noUi-tooltip {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  top: 50%;\n  right: 120%;\n}\n.bk-root .noUi-horizontal .noUi-origin > .noUi-tooltip {\n  -webkit-transform: translate(50%, 0);\n  transform: translate(50%, 0);\n  left: auto;\n  bottom: 10px;\n}\n.bk-root .noUi-vertical .noUi-origin > .noUi-tooltip {\n  -webkit-transform: translate(0, -18px);\n  transform: translate(0, -18px);\n  top: auto;\n  right: 28px;\n}\n.bk-root .noUi-handle {\n  cursor: grab;\n  cursor: -webkit-grab;\n}\n.bk-root .noUi-handle.noUi-active {\n  cursor: grabbing;\n  cursor: -webkit-grabbing;\n}\n.bk-root .noUi-handle:after,\n.bk-root .noUi-handle:before {\n  display: none;\n}\n.bk-root .noUi-tooltip {\n  display: none;\n  white-space: nowrap;\n}\n.bk-root .noUi-handle:hover .noUi-tooltip {\n  display: block;\n}\n.bk-root .noUi-horizontal {\n  width: 100%;\n  height: 10px;\n}\n.bk-root .noUi-vertical {\n  width: 10px;\n  height: 100%;\n}\n.bk-root .noUi-horizontal .noUi-handle {\n  width: 14px;\n  height: 18px;\n  right: -7px;\n  top: -5px;\n}\n.bk-root .noUi-vertical .noUi-handle {\n  width: 18px;\n  height: 14px;\n  right: -5px;\n  top: -7px;\n}\n.bk-root .noUi-target.noUi-horizontal {\n  margin: 5px 0px;\n}\n.bk-root .noUi-target.noUi-vertical {\n  margin: 0px 5px;\n}\n"},
427: function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});t.default="\n.bk-root .bk-slider-title {\n  white-space: nowrap;\n}\n.bk-root .bk-slider-value {\n  font-weight: 600;\n}\n"},
428: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1).__importDefault(e(186)),a=e(423);class d extends a.AbstractSliderView{}i.DateSliderView=d,d.__name__="DateSliderView";class s extends a.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}static init_DateSlider(){this.prototype.default_view=d,this.override({format:"%d %b %Y"})}_formatter(e,t){return r.default(e,t)}}i.DateSlider=s,s.__name__="DateSlider",s.init_DateSlider()},
429: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),_=e(430),n=r.__importStar(e(18));class s extends _.MarkupView{render(){super.render(),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text}}i.DivView=s,s.__name__="DivView";class a extends _.Markup{constructor(e){super(e)}static init_Div(){this.prototype.default_view=s,this.define({render_as_text:[n.Boolean,!1]})}}i.Div=a,a.__name__="Div",a.init_Div()},
430: function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),a=e(217),n=e(72),l=i.__importStar(e(18)),r=e(472),_=e(431),c=i.__importDefault(e(432));class u extends r.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>{this.layout.invalidate_cache(),this.render(),this.root.compute_layout()})}styles(){return[...super.styles(),c.default]}_update_layout(){this.layout=new a.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render();const e=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.markup_el=n.div({class:_.bk_clearfix,style:e}),this.el.appendChild(this.markup_el)}}s.MarkupView=u,u.__name__="MarkupView";class o extends r.Widget{constructor(e){super(e)}static init_Markup(){this.define({text:[l.String,""],style:[l.Any,{}]})}}s.Markup=o,o.__name__="Markup",o.init_Markup()},
431: function _(e,c,f){Object.defineProperty(f,"__esModule",{value:!0}),f.bk_clearfix="bk-clearfix"},
432: function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root .bk-clearfix:before,\n.bk-root .bk-clearfix:after {\n  content: "";\n  display: table;\n}\n.bk-root .bk-clearfix:after {\n  clear: both;\n}\n'},
433: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(404),o=e(313),_=e(72),d=n.__importStar(e(18)),l=e(8),r=e(173),u=e(281),c=e(282),h=n.__importDefault(e(284));class p extends s.AbstractButtonView{constructor(){super(...arguments),this._open=!1}styles(){return[...super.styles(),h.default]}render(){super.render();const e=_.div({class:[c.bk_caret,r.bk_down]});if(this.model.is_split){const t=this._render_button(e);t.classList.add(u.bk_dropdown_toggle),t.addEventListener("click",()=>this._toggle_menu()),this.group_el.appendChild(t)}else this.button_el.appendChild(e);const t=this.model.menu.map((e,t)=>{if(null==e)return _.div({class:c.bk_divider});{const i=l.isString(e)?e:e[0],n=_.div({},i);return n.addEventListener("click",()=>this._item_click(t)),n}});this.menu=_.div({class:[c.bk_menu,r.bk_below]},t),this.el.appendChild(this.menu),_.undisplay(this.menu)}_show_menu(){if(!this._open){this._open=!0,_.display(this.menu);const e=t=>{const{target:i}=t;i instanceof HTMLElement&&!this.el.contains(i)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,_.undisplay(this.menu))}_toggle_menu(){this._open?this._hide_menu():this._show_menu()}click(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new o.ButtonClick),super.click()):this._toggle_menu()}_item_click(e){this._hide_menu();const t=this.model.menu[e];if(null!=t){const i=l.isString(t)?t:t[1];l.isString(i)?this.model.trigger_event(new o.MenuItemClick(i)):i.execute(this.model,{index:e})}}}i.DropdownView=p,p.__name__="DropdownView";class m extends s.AbstractButton{constructor(e){super(e)}static init_Dropdown(){this.prototype.default_view=p,this.define({split:[d.Boolean,!1],menu:[d.Array,[]]}),this.override({label:"Dropdown"})}get is_split(){return this.split}}i.Dropdown=m,m.__name__="Dropdown",m.init_Dropdown()},
434: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const l=e(1).__importStar(e(18)),s=e(472);class n extends s.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render()),this.connect(this.model.properties.width.change,()=>this.render())}render(){null==this.dialogEl&&(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=this.model.multiple,this.dialogEl.onchange=()=>{const{files:e}=this.dialogEl;null!=e&&this.load_files(e)},this.el.appendChild(this.dialogEl)),null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.disabled=this.model.disabled}async load_files(e){const t=[],i=[],l=[];let s;for(s=0;s<e.length;s++){i.push(e[s].name);const n=await this.readfile(e[s]),[,o,,a]=n.split(/[:;,]/,4);t.push(a),l.push(o)}this.model.multiple?(this.model.filename=i,this.model.mime_type=l,this.model.value=t):(this.model.filename=i[0],this.model.mime_type=l[0],this.model.value=t[0])}readfile(e){return new Promise((t,i)=>{const l=new FileReader;l.onload=()=>{var s;const{result:n}=l;null!=n?t(n):i(null!==(s=l.error)&&void 0!==s?s:new Error(`unable to read '${e.name}'`))},l.readAsDataURL(e)})}}i.FileInputView=n,n.__name__="FileInputView";class o extends s.Widget{constructor(e){super(e)}static init_FileInput(){this.prototype.default_view=n,this.define({value:[l.Any,""],mime_type:[l.Any,""],filename:[l.Any,""],accept:[l.String,""],multiple:[l.Boolean,!1]})}}i.FileInput=o,o.__name__="FileInput",o.init_FileInput()},
435: function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(72),l=e(8),o=i.__importStar(e(18)),c=e(410),r=e(412);class h extends c.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,()=>this.render_selection()),this.connect(this.model.properties.options.change,()=>this.render()),this.connect(this.model.properties.name.change,()=>this.render()),this.connect(this.model.properties.title.change,()=>this.render()),this.connect(this.model.properties.size.change,()=>this.render()),this.connect(this.model.properties.disabled.change,()=>this.render())}render(){super.render();const e=this.model.options.map(e=>{let t,s;return l.isString(e)?t=s=e:[t,s]=e,n.option({value:t},s)});this.select_el=n.select({multiple:!0,class:r.bk_input,name:this.model.name,disabled:this.model.disabled},e),this.select_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.select_el),this.render_selection()}render_selection(){const e=new Set(this.model.value);for(const t of this.el.querySelectorAll("option"))t.selected=e.has(t.value);this.select_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus"),t=[];for(const e of this.el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.select_el.focus()}}s.MultiSelectView=h,h.__name__="MultiSelectView";class d extends c.InputWidget{constructor(e){super(e)}static init_MultiSelect(){this.prototype.default_view=h,this.define({value:[o.Array,[]],options:[o.Array,[]],size:[o.Number,4]})}}s.MultiSelect=d,d.__name__="MultiSelect",d.init_MultiSelect()},
436: function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});const t=a(430),p=a(72);class s extends t.MarkupView{render(){super.render();const a=p.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(a)}}r.ParagraphView=s,s.__name__="ParagraphView";class i extends t.Markup{constructor(a){super(a)}static init_Paragraph(){this.prototype.default_view=s}}r.Paragraph=i,i.__name__="Paragraph",i.init_Paragraph()},
437: function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(409);class r extends n.TextInputView{render(){super.render(),this.input_el.type="password"}}s.PasswordInputView=r,r.__name__="PasswordInputView";class p extends n.TextInput{constructor(e){super(e)}static init_PasswordInput(){this.prototype.default_view=r}}s.PasswordInput=p,p.__name__="PasswordInput",p.init_PasswordInput()},
438: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const l=e(1),s=l.__importDefault(e(439)),o=e(72),n=e(8),h=e(217),a=l.__importStar(e(18)),c=e(412),u=l.__importDefault(e(440)),d=e(410);class _ extends d.InputWidgetView{constructor(){super(...arguments),this._last_height=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled.change,()=>this.set_disabled());const{value:e,max_items:t,option_limit:i,delete_button:l,placeholder:s,options:o,name:n,title:h}=this.model.properties;this.on_change([e,t,i,l,s,o,n,h],()=>this.render())}styles(){return[...super.styles(),u.default]}_update_layout(){this.layout=new h.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render(),this.select_el=o.select({multiple:!0,class:c.bk_input,name:this.model.name,disabled:this.model.disabled}),this.group_el.appendChild(this.select_el);const e=new Set(this.model.value),t=this.model.options.map(t=>{let i,l;return n.isString(t)?i=l=t:[i,l]=t,{value:i,label:l,selected:e.has(i)}}),i=this.model.solid?"solid":"light",l="choices__item "+i,h="choices__button "+i,a={choices:t,duplicateItemsAllowed:!1,removeItemButton:this.model.delete_button,classNames:{item:l,button:h}};null!=this.model.placeholder&&(a.placeholderValue=this.model.placeholder),null!=this.model.max_items&&(a.maxItemCount=this.model.max_items),null!=this.model.option_limit&&(a.renderChoiceLimit=this.model.option_limit),this.choice_el=new s.default(this.select_el,a);const u=()=>this.choice_el.containerOuter.element.getBoundingClientRect().height;null!=this._last_height&&this._last_height!=u()&&this.root.invalidate_layout(),this._last_height=u(),this.select_el.addEventListener("change",()=>this.change_input())}set_disabled(){this.model.disabled?this.choice_el.disable():this.choice_el.enable()}change_input(){const e=null!=this.el.querySelector("select:focus"),t=[];for(const e of this.el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.select_el.focus()}}i.MultiChoiceView=_,_.__name__="MultiChoiceView";class r extends d.InputWidget{constructor(e){super(e)}static init_MultiChoice(){this.prototype.default_view=_,this.define({value:[a.Array,[]],options:[a.Array,[]],max_items:[a.Number,null],delete_button:[a.Boolean,!0],placeholder:[a.String,null],option_limit:[a.Number,null],solid:[a.Boolean,!0]})}}i.MultiChoice=r,r.__name__="MultiChoice",r.init_MultiChoice()},
439: function _(e,t,i){
/*! choices.js v9.0.1 | © 2019 Josh Johnson | https://github.com/jshjohnson/Choices#readme */
var n,s;n=window,s=function(){return function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="/public/assets/scripts/",i(i.s=4)}([function(e,t,i){"use strict";var n=function(e){return function(e){return!!e&&"object"==typeof e}(e)&&!function(e){var t=Object.prototype.toString.call(e);return"[object RegExp]"===t||"[object Date]"===t||function(e){return e.$$typeof===s}(e)}(e)},s="function"==typeof Symbol&&Symbol.for?Symbol.for("react.element"):60103;function r(e,t){return!1!==t.clone&&t.isMergeableObject(e)?l((i=e,Array.isArray(i)?[]:{}),e,t):e;var i}function o(e,t,i){return e.concat(t).map((function(e){return r(e,i)}))}function a(e){return Object.keys(e).concat(function(e){return Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(e).filter((function(t){return e.propertyIsEnumerable(t)})):[]}(e))}function c(e,t,i){var n={};return i.isMergeableObject(e)&&a(e).forEach((function(t){n[t]=r(e[t],i)})),a(t).forEach((function(s){(function(e,t){try{return t in e&&!(Object.hasOwnProperty.call(e,t)&&Object.propertyIsEnumerable.call(e,t))}catch(e){return!1}})(e,s)||(i.isMergeableObject(t[s])&&e[s]?n[s]=function(e,t){if(!t.customMerge)return l;var i=t.customMerge(e);return"function"==typeof i?i:l}(s,i)(e[s],t[s],i):n[s]=r(t[s],i))})),n}function l(e,t,i){(i=i||{}).arrayMerge=i.arrayMerge||o,i.isMergeableObject=i.isMergeableObject||n,i.cloneUnlessOtherwiseSpecified=r;var s=Array.isArray(t);return s===Array.isArray(e)?s?i.arrayMerge(e,t,i):c(e,t,i):r(t,i)}l.all=function(e,t){if(!Array.isArray(e))throw new Error("first argument should be an array");return e.reduce((function(e,i){return l(e,i,t)}),{})};var h=l;e.exports=h},function(e,t,i){"use strict";(function(e,n){var s,r=i(3);s="undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==e?e:n;var o=Object(r.a)(s);t.a=o}).call(this,i(5),i(6)(e))},function(e,t,i){
/*!
                 * Fuse.js v3.4.5 - Lightweight fuzzy-search (http://fusejs.io)
                 *
                 * Copyright (c) 2012-2017 Kirollos Risk (http://kiro.me)
                 * All Rights Reserved. Apache Software License 2.0
                 *
                 * http://www.apache.org/licenses/LICENSE-2.0
                 */
e.exports=function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=1)}([function(e,t){e.exports=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===Object.prototype.toString.call(e)}},function(e,t,i){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function s(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=i(2),o=i(8),a=i(0),c=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.caseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_,y=i.id,E=void 0===y?null:y,I=i.keys,S=void 0===I?[]:I,w=i.shouldSort,O=void 0===w||w,C=i.getFn,A=void 0===C?o:C,L=i.sortFn,T=void 0===L?function(e,t){return e.score-t.score}:L,x=i.tokenize,k=void 0!==x&&x,P=i.matchAllTokens,D=void 0!==P&&P,M=i.includeMatches,N=void 0!==M&&M,F=i.includeScore,j=void 0!==F&&F,K=i.verbose,R=void 0!==K&&K;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b,id:E,keys:S,includeMatches:N,includeScore:j,shouldSort:O,getFn:A,sortFn:T,verbose:R,tokenize:k,matchAllTokens:D},this.setCollection(t)}var t,i;return t=e,(i=[{key:"setCollection",value:function(e){return this.list=e,e}},{key:"search",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{limit:!1};this._log('---------\nSearch pattern: "'.concat(e,'"'));var i=this._prepareSearchers(e),n=i.tokenSearchers,s=i.fullSearcher,r=this._search(n,s),o=r.weights,a=r.results;return this._computeScore(o,a),this.options.shouldSort&&this._sort(a),t.limit&&"number"==typeof t.limit&&(a=a.slice(0,t.limit)),this._format(a)}},{key:"_prepareSearchers",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",t=[];if(this.options.tokenize)for(var i=e.split(this.options.tokenSeparator),n=0,s=i.length;n<s;n+=1)t.push(new r(i[n],this.options));return{tokenSearchers:t,fullSearcher:new r(e,this.options)}}},{key:"_search",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1?arguments[1]:void 0,i=this.list,n={},s=[];if("string"==typeof i[0]){for(var r=0,o=i.length;r<o;r+=1)this._analyze({key:"",value:i[r],record:r,index:r},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t});return{weights:null,results:s}}for(var a={},c=0,l=i.length;c<l;c+=1)for(var h=i[c],u=0,d=this.options.keys.length;u<d;u+=1){var p=this.options.keys[u];if("string"!=typeof p){if(a[p.name]={weight:1-p.weight||1},p.weight<=0||p.weight>1)throw new Error("Key weight has to be > 0 and <= 1");p=p.name}else a[p]={weight:1};this._analyze({key:p,value:this.options.getFn(h,p),record:h,index:c},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t})}return{weights:a,results:s}}},{key:"_analyze",value:function(e,t){var i=e.key,n=e.arrayIndex,s=void 0===n?-1:n,r=e.value,o=e.record,c=e.index,l=t.tokenSearchers,h=void 0===l?[]:l,u=t.fullSearcher,d=void 0===u?[]:u,p=t.resultMap,m=void 0===p?{}:p,f=t.results,v=void 0===f?[]:f;if(null!=r){var g=!1,_=-1,b=0;if("string"==typeof r){this._log("\nKey: ".concat(""===i?"-":i));var y=d.search(r);if(this._log('Full text: "'.concat(r,'", score: ').concat(y.score)),this.options.tokenize){for(var E=r.split(this.options.tokenSeparator),I=[],S=0;S<h.length;S+=1){var w=h[S];this._log('\nPattern: "'.concat(w.pattern,'"'));for(var O=!1,C=0;C<E.length;C+=1){var A=E[C],L=w.search(A),T={};L.isMatch?(T[A]=L.score,g=!0,O=!0,I.push(L.score)):(T[A]=1,this.options.matchAllTokens||I.push(1)),this._log('Token: "'.concat(A,'", score: ').concat(T[A]))}O&&(b+=1)}_=I[0];for(var x=I.length,k=1;k<x;k+=1)_+=I[k];_/=x,this._log("Token score average:",_)}var P=y.score;_>-1&&(P=(P+_)/2),this._log("Score average:",P);var D=!this.options.tokenize||!this.options.matchAllTokens||b>=h.length;if(this._log("\nCheck Matches: ".concat(D)),(g||y.isMatch)&&D){var M=m[c];M?M.output.push({key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}):(m[c]={item:o,output:[{key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}]},v.push(m[c]))}}else if(a(r))for(var N=0,F=r.length;N<F;N+=1)this._analyze({key:i,arrayIndex:N,value:r[N],record:o,index:c},{resultMap:m,results:v,tokenSearchers:h,fullSearcher:d})}}},{key:"_computeScore",value:function(e,t){this._log("\n\nComputing score:\n");for(var i=0,n=t.length;i<n;i+=1){for(var s=t[i].output,r=s.length,o=1,a=1,c=0;c<r;c+=1){var l=e?e[s[c].key].weight:1,h=(1===l?s[c].score:s[c].score||.001)*l;1!==l?a=Math.min(a,h):(s[c].nScore=h,o*=h)}t[i].score=1===a?o:a,this._log(t[i])}}},{key:"_sort",value:function(e){this._log("\n\nSorting...."),e.sort(this.options.sortFn)}},{key:"_format",value:function(e){var t=[];if(this.options.verbose){var i=[];this._log("\n\nOutput:\n\n",JSON.stringify(e,(function(e,t){if("object"===n(t)&&null!==t){if(-1!==i.indexOf(t))return;i.push(t)}return t}))),i=null}var s=[];this.options.includeMatches&&s.push((function(e,t){var i=e.output;t.matches=[];for(var n=0,s=i.length;n<s;n+=1){var r=i[n];if(0!==r.matchedIndices.length){var o={indices:r.matchedIndices,value:r.value};r.key&&(o.key=r.key),r.hasOwnProperty("arrayIndex")&&r.arrayIndex>-1&&(o.arrayIndex=r.arrayIndex),t.matches.push(o)}}})),this.options.includeScore&&s.push((function(e,t){t.score=e.score}));for(var r=0,o=e.length;r<o;r+=1){var a=e[r];if(this.options.id&&(a.item=this.options.getFn(a.item,this.options.id)[0]),s.length){for(var c={item:a.item},l=0,h=s.length;l<h;l+=1)s[l](a,c);t.push(c)}else t.push(a.item)}return t}},{key:"_log",value:function(){var e;this.options.verbose&&(e=console).log.apply(e,arguments)}}])&&s(t.prototype,i),e}();e.exports=c},function(e,t,i){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=i(3),r=i(4),o=i(7),a=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.isCaseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b},this.pattern=this.options.isCaseSensitive?t:t.toLowerCase(),this.pattern.length<=u&&(this.patternAlphabet=o(this.pattern))}var t,i;return t=e,(i=[{key:"search",value:function(e){if(this.options.isCaseSensitive||(e=e.toLowerCase()),this.pattern===e)return{isMatch:!0,score:0,matchedIndices:[[0,e.length-1]]};var t=this.options,i=t.maxPatternLength,n=t.tokenSeparator;if(this.pattern.length>i)return s(e,this.pattern,n);var o=this.options,a=o.location,c=o.distance,l=o.threshold,h=o.findAllMatches,u=o.minMatchCharLength;return r(e,this.pattern,this.patternAlphabet,{location:a,distance:c,threshold:l,findAllMatches:h,minMatchCharLength:u})}}])&&n(t.prototype,i),e}();e.exports=a},function(e,t){var i=/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;e.exports=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:/ +/g,s=new RegExp(t.replace(i,"\\$&").replace(n,"|")),r=e.match(s),o=!!r,a=[];if(o)for(var c=0,l=r.length;c<l;c+=1){var h=r[c];a.push([e.indexOf(h),h.length-1])}return{score:o?.5:1,isMatch:o,matchedIndices:a}}},function(e,t,i){var n=i(5),s=i(6);e.exports=function(e,t,i,r){for(var o=r.location,a=void 0===o?0:o,c=r.distance,l=void 0===c?100:c,h=r.threshold,u=void 0===h?.6:h,d=r.findAllMatches,p=void 0!==d&&d,m=r.minMatchCharLength,f=void 0===m?1:m,v=a,g=e.length,_=u,b=e.indexOf(t,v),y=t.length,E=[],I=0;I<g;I+=1)E[I]=0;if(-1!==b){var S=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});if(_=Math.min(S,_),-1!==(b=e.lastIndexOf(t,v+y))){var w=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});_=Math.min(w,_)}}b=-1;for(var O=[],C=1,A=y+g,L=1<<y-1,T=0;T<y;T+=1){for(var x=0,k=A;x<k;)n(t,{errors:T,currentLocation:v+k,expectedLocation:v,distance:l})<=_?x=k:A=k,k=Math.floor((A-x)/2+x);A=k;var P=Math.max(1,v-k+1),D=p?g:Math.min(v+k,g)+y,M=Array(D+2);M[D+1]=(1<<T)-1;for(var N=D;N>=P;N-=1){var F=N-1,j=i[e.charAt(F)];if(j&&(E[F]=1),M[N]=(M[N+1]<<1|1)&j,0!==T&&(M[N]|=(O[N+1]|O[N])<<1|1|O[N+1]),M[N]&L&&(C=n(t,{errors:T,currentLocation:F,expectedLocation:v,distance:l}))<=_){if(_=C,(b=F)<=v)break;P=Math.max(1,2*v-b)}}if(n(t,{errors:T+1,currentLocation:v,expectedLocation:v,distance:l})>_)break;O=M}return{isMatch:b>=0,score:0===C?.001:C,matchedIndices:s(E,f)}}},function(e,t){e.exports=function(e,t){var i=t.errors,n=void 0===i?0:i,s=t.currentLocation,r=void 0===s?0:s,o=t.expectedLocation,a=void 0===o?0:o,c=t.distance,l=void 0===c?100:c,h=n/e.length,u=Math.abs(a-r);return l?h+u/l:u?1:h}},function(e,t){e.exports=function(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,i=[],n=-1,s=-1,r=0,o=e.length;r<o;r+=1){var a=e[r];a&&-1===n?n=r:a||-1===n||((s=r-1)-n+1>=t&&i.push([n,s]),n=-1)}return e[r-1]&&r-n>=t&&i.push([n,r-1]),i}},function(e,t){e.exports=function(e){for(var t={},i=e.length,n=0;n<i;n+=1)t[e.charAt(n)]=0;for(var s=0;s<i;s+=1)t[e.charAt(s)]|=1<<i-s-1;return t}},function(e,t,i){var n=i(0);e.exports=function(e,t){return function e(t,i,s){if(i){var r=i.indexOf("."),o=i,a=null;-1!==r&&(o=i.slice(0,r),a=i.slice(r+1));var c=t[o];if(null!=c)if(a||"string"!=typeof c&&"number"!=typeof c)if(n(c))for(var l=0,h=c.length;l<h;l+=1)e(c[l],a,s);else a&&e(c,a,s);else s.push(c.toString())}else s.push(t);return s}(e,t,[])}}])},function(e,t,i){"use strict";function n(e){var t,i=e.Symbol;return"function"==typeof i?i.observable?t=i.observable:(t=i("observable"),i.observable=t):t="@@observable",t}i.d(t,"a",(function(){return n}))},function(e,t,i){e.exports=i(7)},function(e,t){var i;i=function(){return this}();try{i=i||new Function("return this")()}catch(e){"object"==typeof window&&(i=window)}e.exports=i},function(e,t){e.exports=function(e){if(!e.webpackPolyfill){var t=Object.create(e);t.children||(t.children=[]),Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}),Object.defineProperty(t,"exports",{enumerable:!0}),t.webpackPolyfill=1}return t}},function(e,t,i){"use strict";i.r(t);var n=i(2),s=i.n(n),r=i(0),o=i.n(r),a=i(1),c=function(){return Math.random().toString(36).substring(7).split("").join(".")},l={INIT:"@@redux/INIT"+c(),REPLACE:"@@redux/REPLACE"+c(),PROBE_UNKNOWN_ACTION:function(){return"@@redux/PROBE_UNKNOWN_ACTION"+c()}};function h(e){if("object"!=typeof e||null===e)return!1;for(var t=e;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}function u(e,t,i){var n;if("function"==typeof t&&"function"==typeof i||"function"==typeof i&&"function"==typeof arguments[3])throw new Error("It looks like you are passing several store enhancers to createStore(). This is not supported. Instead, compose them together to a single function.");if("function"==typeof t&&void 0===i&&(i=t,t=void 0),void 0!==i){if("function"!=typeof i)throw new Error("Expected the enhancer to be a function.");return i(u)(e,t)}if("function"!=typeof e)throw new Error("Expected the reducer to be a function.");var s=e,r=t,o=[],c=o,d=!1;function p(){c===o&&(c=o.slice())}function m(){if(d)throw new Error("You may not call store.getState() while the reducer is executing. The reducer has already received the state as an argument. Pass it down from the top reducer instead of reading it from the store.");return r}function f(e){if("function"!=typeof e)throw new Error("Expected the listener to be a function.");if(d)throw new Error("You may not call store.subscribe() while the reducer is executing. If you would like to be notified after the store has been updated, subscribe from a component and invoke store.getState() in the callback to access the latest state. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");var t=!0;return p(),c.push(e),function(){if(t){if(d)throw new Error("You may not unsubscribe from a store listener while the reducer is executing. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");t=!1,p();var i=c.indexOf(e);c.splice(i,1)}}}function v(e){if(!h(e))throw new Error("Actions must be plain objects. Use custom middleware for async actions.");if(void 0===e.type)throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');if(d)throw new Error("Reducers may not dispatch actions.");try{d=!0,r=s(r,e)}finally{d=!1}for(var t=o=c,i=0;i<t.length;i++)(0,t[i])();return e}function g(e){if("function"!=typeof e)throw new Error("Expected the nextReducer to be a function.");s=e,v({type:l.REPLACE})}function _(){var e,t=f;return(e={subscribe:function(e){if("object"!=typeof e||null===e)throw new TypeError("Expected the observer to be an object.");function i(){e.next&&e.next(m())}return i(),{unsubscribe:t(i)}}})[a.a]=function(){return this},e}return v({type:l.INIT}),(n={dispatch:v,subscribe:f,getState:m,replaceReducer:g})[a.a]=_,n}function d(e,t){var i=t&&t.type;return"Given "+(i&&'action "'+String(i)+'"'||"an action")+', reducer "'+e+'" returned undefined. To ignore an action, you must explicitly return the previous state. If you want this reducer to hold no value, you can return null instead of undefined.'}var p,m=[],f=[],v=[],g={loading:!1},_=function(e,t){switch(void 0===e&&(e=g),t.type){case"SET_IS_LOADING":return{loading:t.isLoading};default:return e}},b=function(e){return Array.from({length:e},(function(){return(e=0,t=36,Math.floor(Math.random()*(t-e)+e)).toString(36);var e,t})).join("")},y=function(e){return Object.prototype.toString.call(e).slice(8,-1)},E=function(e,t){return null!=t&&y(t)===e},I=function(e){return"string"!=typeof e?e:e.replace(/&/g,"&amp;").replace(/>/g,"&rt;").replace(/</g,"&lt;").replace(/"/g,"&quot;")},S=(p=document.createElement("div"),function(e){var t=e.trim();p.innerHTML=t;for(var i=p.children[0];p.firstChild;)p.removeChild(p.firstChild);return i}),w=function(e,t){return e.score-t.score},O=function(e){return JSON.parse(JSON.stringify(e))},C=function(e){for(var t=Object.keys(e),i={},n=0;n<t.length;n++){var s=t[n];"function"==typeof e[s]&&(i[s]=e[s])}var r,o=Object.keys(i);try{!function(e){Object.keys(e).forEach((function(t){var i=e[t];if(void 0===i(void 0,{type:l.INIT}))throw new Error('Reducer "'+t+"\" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined. If you don't want to set a value for this reducer, you can use null instead of undefined.");if(void 0===i(void 0,{type:l.PROBE_UNKNOWN_ACTION()}))throw new Error('Reducer "'+t+"\" returned undefined when probed with a random type. Don't try to handle "+l.INIT+' or other actions in "redux/*" namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined, but can be null.')}))}(i)}catch(e){r=e}return function(e,t){if(void 0===e&&(e={}),r)throw r;for(var n=!1,s={},a=0;a<o.length;a++){var c=o[a],l=i[c],h=e[c],u=l(h,t);if(void 0===u){var p=d(c,t);throw new Error(p)}s[c]=u,n=n||u!==h}return n?s:e}}({items:function(e,t){switch(void 0===e&&(e=m),t.type){case"ADD_ITEM":return[].concat(e,[{id:t.id,choiceId:t.choiceId,groupId:t.groupId,value:t.value,label:t.label,active:!0,highlighted:!1,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]).map((function(e){var t=e;return t.highlighted=!1,t}));case"REMOVE_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.active=!1),i}));case"HIGHLIGHT_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.highlighted=t.highlighted),i}));default:return e}},groups:function(e,t){switch(void 0===e&&(e=f),t.type){case"ADD_GROUP":return[].concat(e,[{id:t.id,value:t.value,active:t.active,disabled:t.disabled}]);case"CLEAR_CHOICES":return[];default:return e}},choices:function(e,t){switch(void 0===e&&(e=v),t.type){case"ADD_CHOICE":return[].concat(e,[{id:t.id,elementId:t.elementId,groupId:t.groupId,value:t.value,label:t.label||t.value,disabled:t.disabled||!1,selected:!1,active:!0,score:9999,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]);case"ADD_ITEM":return t.activateOptions?e.map((function(e){var i=e;return i.active=t.active,i})):t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!0),i})):e;case"REMOVE_ITEM":return t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!1),i})):e;case"FILTER_CHOICES":return e.map((function(e){var i=e;return i.active=t.results.some((function(e){var t=e.item,n=e.score;return t.id===i.id&&(i.score=n,!0)})),i}));case"ACTIVATE_CHOICES":return e.map((function(e){var i=e;return i.active=t.active,i}));case"CLEAR_CHOICES":return v;default:return e}},general:_}),A=function(e,t){var i=e;if("CLEAR_ALL"===t.type)i=void 0;else if("RESET_TO"===t.type)return O(t.state);return C(i,t)};function L(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var T=function(){function e(){this._store=u(A,window.__REDUX_DEVTOOLS_EXTENSION__&&window.__REDUX_DEVTOOLS_EXTENSION__())}var t,i,n,s=e.prototype;return s.subscribe=function(e){this._store.subscribe(e)},s.dispatch=function(e){this._store.dispatch(e)},s.isLoading=function(){return this.state.general.loading},s.getChoiceById=function(e){return this.activeChoices.find((function(t){return t.id===parseInt(e,10)}))},s.getGroupById=function(e){return this.groups.find((function(t){return t.id===e}))},t=e,(i=[{key:"state",get:function(){return this._store.getState()}},{key:"items",get:function(){return this.state.items}},{key:"activeItems",get:function(){return this.items.filter((function(e){return!0===e.active}))}},{key:"highlightedActiveItems",get:function(){return this.items.filter((function(e){return e.active&&e.highlighted}))}},{key:"choices",get:function(){return this.state.choices}},{key:"activeChoices",get:function(){return this.choices.filter((function(e){return!0===e.active}))}},{key:"selectableChoices",get:function(){return this.choices.filter((function(e){return!0!==e.disabled}))}},{key:"searchableChoices",get:function(){return this.selectableChoices.filter((function(e){return!0!==e.placeholder}))}},{key:"placeholderChoice",get:function(){return[].concat(this.choices).reverse().find((function(e){return!0===e.placeholder}))}},{key:"groups",get:function(){return this.state.groups}},{key:"activeGroups",get:function(){var e=this.groups,t=this.choices;return e.filter((function(e){var i=!0===e.active&&!1===e.disabled,n=t.some((function(e){return!0===e.active&&!1===e.disabled}));return i&&n}),[])}}])&&L(t.prototype,i),n&&L(t,n),e}();function x(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var k=function(){function e(e){var t=e.element,i=e.type,n=e.classNames;this.element=t,this.classNames=n,this.type=i,this.isActive=!1}var t,i,n,s=e.prototype;return s.getChild=function(e){return this.element.querySelector(e)},s.show=function(){return this.element.classList.add(this.classNames.activeState),this.element.setAttribute("aria-expanded","true"),this.isActive=!0,this},s.hide=function(){return this.element.classList.remove(this.classNames.activeState),this.element.setAttribute("aria-expanded","false"),this.isActive=!1,this},t=e,(i=[{key:"distanceFromTopWindow",get:function(){return this.element.getBoundingClientRect().bottom}}])&&x(t.prototype,i),n&&x(t,n),e}(),P={items:[],choices:[],silent:!1,renderChoiceLimit:-1,maxItemCount:-1,addItems:!0,addItemFilter:null,removeItems:!0,removeItemButton:!1,editItems:!1,duplicateItemsAllowed:!0,delimiter:",",paste:!0,searchEnabled:!0,searchChoices:!0,searchFloor:1,searchResultLimit:4,searchFields:["label","value"],position:"auto",resetScrollPosition:!0,shouldSort:!0,shouldSortItems:!1,sorter:function(e,t){var i=e.value,n=e.label,s=void 0===n?i:n,r=t.value,o=t.label,a=void 0===o?r:o;return s.localeCompare(a,[],{sensitivity:"base",ignorePunctuation:!0,numeric:!0})},placeholder:!0,placeholderValue:null,searchPlaceholderValue:null,prependValue:null,appendValue:null,renderSelectedChoices:"auto",loadingText:"Loading...",noResultsText:"No results found",noChoicesText:"No choices to choose from",itemSelectText:"Press to select",uniqueItemText:"Only unique values can be added",customAddItemText:"Only values matching specific conditions can be added",addItemText:function(e){return'Press Enter to add <b>"'+I(e)+'"</b>'},maxItemText:function(e){return"Only "+e+" values can be added"},valueComparer:function(e,t){return e===t},fuseOptions:{includeScore:!0},callbackOnInit:null,callbackOnCreateTemplates:null,classNames:{containerOuter:"choices",containerInner:"choices__inner",input:"choices__input",inputCloned:"choices__input--cloned",list:"choices__list",listItems:"choices__list--multiple",listSingle:"choices__list--single",listDropdown:"choices__list--dropdown",item:"choices__item",itemSelectable:"choices__item--selectable",itemDisabled:"choices__item--disabled",itemChoice:"choices__item--choice",placeholder:"choices__placeholder",group:"choices__group",groupHeading:"choices__heading",button:"choices__button",activeState:"is-active",focusState:"is-focused",openState:"is-open",disabledState:"is-disabled",highlightedState:"is-highlighted",selectedState:"is-selected",flippedState:"is-flipped",loadingState:"is-loading",noResults:"has-no-results",noChoices:"has-no-choices"}},D="showDropdown",M="hideDropdown",N="change",F="choice",j="search",K="addItem",R="removeItem",H="highlightItem",B="highlightChoice",V="ADD_CHOICE",G="FILTER_CHOICES",q="ACTIVATE_CHOICES",U="CLEAR_CHOICES",z="ADD_GROUP",W="ADD_ITEM",X="REMOVE_ITEM",$="HIGHLIGHT_ITEM",J=46,Y=8,Z=13,Q=65,ee=27,te=38,ie=40,ne=33,se=34,re=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.position;this.element=t,this.classNames=n,this.type=i,this.position=s,this.isOpen=!1,this.isFlipped=!1,this.isFocussed=!1,this.isDisabled=!1,this.isLoading=!1,this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t=e.prototype;return t.addEventListeners=function(){this.element.addEventListener("focus",this._onFocus),this.element.addEventListener("blur",this._onBlur)},t.removeEventListeners=function(){this.element.removeEventListener("focus",this._onFocus),this.element.removeEventListener("blur",this._onBlur)},t.shouldFlip=function(e){if("number"!=typeof e)return!1;var t=!1;return"auto"===this.position?t=!window.matchMedia("(min-height: "+(e+1)+"px)").matches:"top"===this.position&&(t=!0),t},t.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},t.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},t.open=function(e){this.element.classList.add(this.classNames.openState),this.element.setAttribute("aria-expanded","true"),this.isOpen=!0,this.shouldFlip(e)&&(this.element.classList.add(this.classNames.flippedState),this.isFlipped=!0)},t.close=function(){this.element.classList.remove(this.classNames.openState),this.element.setAttribute("aria-expanded","false"),this.removeActiveDescendant(),this.isOpen=!1,this.isFlipped&&(this.element.classList.remove(this.classNames.flippedState),this.isFlipped=!1)},t.focus=function(){this.isFocussed||this.element.focus()},t.addFocusState=function(){this.element.classList.add(this.classNames.focusState)},t.removeFocusState=function(){this.element.classList.remove(this.classNames.focusState)},t.enable=function(){this.element.classList.remove(this.classNames.disabledState),this.element.removeAttribute("aria-disabled"),"select-one"===this.type&&this.element.setAttribute("tabindex","0"),this.isDisabled=!1},t.disable=function(){this.element.classList.add(this.classNames.disabledState),this.element.setAttribute("aria-disabled","true"),"select-one"===this.type&&this.element.setAttribute("tabindex","-1"),this.isDisabled=!0},t.wrap=function(e){!function(e,t){void 0===t&&(t=document.createElement("div")),e.nextSibling?e.parentNode.insertBefore(t,e.nextSibling):e.parentNode.appendChild(t),t.appendChild(e)}(e,this.element)},t.unwrap=function(e){this.element.parentNode.insertBefore(e,this.element),this.element.parentNode.removeChild(this.element)},t.addLoadingState=function(){this.element.classList.add(this.classNames.loadingState),this.element.setAttribute("aria-busy","true"),this.isLoading=!0},t.removeLoadingState=function(){this.element.classList.remove(this.classNames.loadingState),this.element.removeAttribute("aria-busy"),this.isLoading=!1},t._onFocus=function(){this.isFocussed=!0},t._onBlur=function(){this.isFocussed=!1},e}();function oe(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var ae=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.preventPaste;this.element=t,this.type=i,this.classNames=n,this.preventPaste=s,this.isFocussed=this.element===document.activeElement,this.isDisabled=t.disabled,this._onPaste=this._onPaste.bind(this),this._onInput=this._onInput.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t,i,n,s=e.prototype;return s.addEventListeners=function(){this.element.addEventListener("paste",this._onPaste),this.element.addEventListener("input",this._onInput,{passive:!0}),this.element.addEventListener("focus",this._onFocus,{passive:!0}),this.element.addEventListener("blur",this._onBlur,{passive:!0})},s.removeEventListeners=function(){this.element.removeEventListener("input",this._onInput,{passive:!0}),this.element.removeEventListener("paste",this._onPaste),this.element.removeEventListener("focus",this._onFocus,{passive:!0}),this.element.removeEventListener("blur",this._onBlur,{passive:!0})},s.enable=function(){this.element.removeAttribute("disabled"),this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.isDisabled=!0},s.focus=function(){this.isFocussed||this.element.focus()},s.blur=function(){this.isFocussed&&this.element.blur()},s.clear=function(e){return void 0===e&&(e=!0),this.element.value&&(this.element.value=""),e&&this.setWidth(),this},s.setWidth=function(){var e=this.element,t=e.style,i=e.value,n=e.placeholder;t.minWidth=n.length+1+"ch",t.width=i.length+1+"ch"},s.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},s.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},s._onInput=function(){"select-one"!==this.type&&this.setWidth()},s._onPaste=function(e){this.preventPaste&&e.preventDefault()},s._onFocus=function(){this.isFocussed=!0},s._onBlur=function(){this.isFocussed=!1},t=e,(i=[{key:"placeholder",set:function(e){this.element.placeholder=e}},{key:"value",get:function(){return I(this.element.value)},set:function(e){this.element.value=e}}])&&oe(t.prototype,i),n&&oe(t,n),e}(),ce=function(){function e(e){var t=e.element;this.element=t,this.scrollPos=this.element.scrollTop,this.height=this.element.offsetHeight}var t=e.prototype;return t.clear=function(){this.element.innerHTML=""},t.append=function(e){this.element.appendChild(e)},t.getChild=function(e){return this.element.querySelector(e)},t.hasChildren=function(){return this.element.hasChildNodes()},t.scrollToTop=function(){this.element.scrollTop=0},t.scrollToChildElement=function(e,t){var i=this;if(e){var n=this.element.offsetHeight,s=this.element.scrollTop+n,r=e.offsetHeight,o=e.offsetTop+r,a=t>0?this.element.scrollTop+o-s:e.offsetTop;requestAnimationFrame((function(){i._animateScroll(a,t)}))}},t._scrollDown=function(e,t,i){var n=(i-e)/t,s=n>1?n:1;this.element.scrollTop=e+s},t._scrollUp=function(e,t,i){var n=(e-i)/t,s=n>1?n:1;this.element.scrollTop=e-s},t._animateScroll=function(e,t){var i=this,n=this.element.scrollTop,s=!1;t>0?(this._scrollDown(n,4,e),n<e&&(s=!0)):(this._scrollUp(n,4,e),n>e&&(s=!0)),s&&requestAnimationFrame((function(){i._animateScroll(e,t)}))},e}();function le(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var he=function(){function e(e){var t=e.element,i=e.classNames;if(this.element=t,this.classNames=i,!(t instanceof HTMLInputElement||t instanceof HTMLSelectElement))throw new TypeError("Invalid element passed");this.isDisabled=!1}var t,i,n,s=e.prototype;return s.conceal=function(){this.element.classList.add(this.classNames.input),this.element.hidden=!0,this.element.tabIndex=-1;var e=this.element.getAttribute("style");e&&this.element.setAttribute("data-choice-orig-style",e),this.element.setAttribute("data-choice","active")},s.reveal=function(){this.element.classList.remove(this.classNames.input),this.element.hidden=!1,this.element.removeAttribute("tabindex");var e=this.element.getAttribute("data-choice-orig-style");e?(this.element.removeAttribute("data-choice-orig-style"),this.element.setAttribute("style",e)):this.element.removeAttribute("style"),this.element.removeAttribute("data-choice"),this.element.value=this.element.value},s.enable=function(){this.element.removeAttribute("disabled"),this.element.disabled=!1,this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.element.disabled=!0,this.isDisabled=!0},s.triggerEvent=function(e,t){!function(e,t,i){void 0===i&&(i=null);var n=new CustomEvent(t,{detail:i,bubbles:!0,cancelable:!0});e.dispatchEvent(n)}(this.element,e,t)},t=e,(i=[{key:"isActive",get:function(){return"active"===this.element.dataset.choice}},{key:"dir",get:function(){return this.element.dir}},{key:"value",get:function(){return this.element.value},set:function(e){this.element.value=e}}])&&le(t.prototype,i),n&&le(t,n),e}();function ue(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var de=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.delimiter;return(i=e.call(this,{element:n,classNames:s})||this).delimiter=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,n=o,(s=[{key:"value",get:function(){return this.element.value},set:function(e){var t=e.map((function(e){return e.value})).join(this.delimiter);this.element.setAttribute("value",t),this.element.value=t}}])&&ue(n.prototype,s),r&&ue(n,r),o}(he);function pe(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var me=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.template;return(i=e.call(this,{element:n,classNames:s})||this).template=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,o.prototype.appendDocFragment=function(e){this.element.innerHTML="",this.element.appendChild(e)},n=o,(s=[{key:"placeholderOption",get:function(){return this.element.querySelector('option[value=""]')||this.element.querySelector("option[placeholder]")}},{key:"optionGroups",get:function(){return Array.from(this.element.getElementsByTagName("OPTGROUP"))}},{key:"options",get:function(){return Array.from(this.element.options)},set:function(e){var t=this,i=document.createDocumentFragment();e.forEach((function(e){return n=e,s=t.template(n),void i.appendChild(s);var n,s})),this.appendDocFragment(i)}}])&&pe(n.prototype,s),r&&pe(n,r),o}(he),fe={containerOuter:function(e,t,i,n,s,r){var o=e.containerOuter,a=Object.assign(document.createElement("div"),{className:o});return a.dataset.type=r,t&&(a.dir=t),n&&(a.tabIndex=0),i&&(a.setAttribute("role",s?"combobox":"listbox"),s&&a.setAttribute("aria-autocomplete","list")),a.setAttribute("aria-haspopup","true"),a.setAttribute("aria-expanded","false"),a},containerInner:function(e){var t=e.containerInner;return Object.assign(document.createElement("div"),{className:t})},itemList:function(e,t){var i=e.list,n=e.listSingle,s=e.listItems;return Object.assign(document.createElement("div"),{className:i+" "+(t?n:s)})},placeholder:function(e,t){var i=e.placeholder;return Object.assign(document.createElement("div"),{className:i,innerHTML:t})},item:function(e,t,i){var n=e.item,s=e.button,r=e.highlightedState,o=e.itemSelectable,a=e.placeholder,c=t.id,l=t.value,h=t.label,u=t.customProperties,d=t.active,p=t.disabled,m=t.highlighted,f=t.placeholder,v=Object.assign(document.createElement("div"),{className:n,innerHTML:h});if(Object.assign(v.dataset,{item:"",id:c,value:l,customProperties:u}),d&&v.setAttribute("aria-selected","true"),p&&v.setAttribute("aria-disabled","true"),f&&v.classList.add(a),v.classList.add(m?r:o),i){p&&v.classList.remove(o),v.dataset.deletable="";var g=Object.assign(document.createElement("button"),{type:"button",className:s,innerHTML:"Remove item"});g.setAttribute("aria-label","Remove item: '"+l+"'"),g.dataset.button="",v.appendChild(g)}return v},choiceList:function(e,t){var i=e.list,n=Object.assign(document.createElement("div"),{className:i});return t||n.setAttribute("aria-multiselectable","true"),n.setAttribute("role","listbox"),n},choiceGroup:function(e,t){var i=e.group,n=e.groupHeading,s=e.itemDisabled,r=t.id,o=t.value,a=t.disabled,c=Object.assign(document.createElement("div"),{className:i+" "+(a?s:"")});return c.setAttribute("role","group"),Object.assign(c.dataset,{group:"",id:r,value:o}),a&&c.setAttribute("aria-disabled","true"),c.appendChild(Object.assign(document.createElement("div"),{className:n,innerHTML:o})),c},choice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.itemSelectable,o=e.selectedState,a=e.itemDisabled,c=e.placeholder,l=t.id,h=t.value,u=t.label,d=t.groupId,p=t.elementId,m=t.disabled,f=t.selected,v=t.placeholder,g=Object.assign(document.createElement("div"),{id:p,innerHTML:u,className:n+" "+s});return f&&g.classList.add(o),v&&g.classList.add(c),g.setAttribute("role",d>0?"treeitem":"option"),Object.assign(g.dataset,{choice:"",id:l,value:h,selectText:i}),m?(g.classList.add(a),g.dataset.choiceDisabled="",g.setAttribute("aria-disabled","true")):(g.classList.add(r),g.dataset.choiceSelectable=""),g},input:function(e,t){var i=e.input,n=e.inputCloned,s=Object.assign(document.createElement("input"),{type:"text",className:i+" "+n,autocomplete:"off",autocapitalize:"off",spellcheck:!1});return s.setAttribute("role","textbox"),s.setAttribute("aria-autocomplete","list"),s.setAttribute("aria-label",t),s},dropdown:function(e){var t=e.list,i=e.listDropdown,n=document.createElement("div");return n.classList.add(t,i),n.setAttribute("aria-expanded","false"),n},notice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.noResults,o=e.noChoices;void 0===i&&(i="");var a=[n,s];return"no-choices"===i?a.push(o):"no-results"===i&&a.push(r),Object.assign(document.createElement("div"),{innerHTML:t,className:a.join(" ")})},option:function(e){var t=e.label,i=e.value,n=e.customProperties,s=e.active,r=e.disabled,o=new Option(t,i,!1,s);return n&&(o.dataset.customProperties=n),o.disabled=r,o}},ve=function(e){return void 0===e&&(e=!0),{type:q,active:e}},ge=function(e,t){return{type:$,id:e,highlighted:t}},_e=function(e){var t=e.value,i=e.id,n=e.active,s=e.disabled;return{type:z,value:t,id:i,active:n,disabled:s}},be=function(e){return{type:"SET_IS_LOADING",isLoading:e}};function ye(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var Ee="-ms-scroll-limit"in document.documentElement.style&&"-ms-ime-align"in document.documentElement.style,Ie={},Se=function(){var e,t,i;function n(e,t){var i=this;void 0===e&&(e="[data-choice]"),void 0===t&&(t={}),this.config=o.a.all([P,n.defaults.options,t],{arrayMerge:function(e,t){return[].concat(t)}});var s,r,a,c,l=(s=this.config,r=P,a=Object.keys(s).sort(),c=Object.keys(r).sort(),a.filter((function(e){return c.indexOf(e)<0})));l.length&&console.warn("Unknown config option(s) passed",l.join(", "));var h="string"==typeof e?document.querySelector(e):e;if(!(h instanceof HTMLInputElement||h instanceof HTMLSelectElement))throw TypeError("Expected one of the following types text|select-one|select-multiple");if(this._isTextElement="text"===h.type,this._isSelectOneElement="select-one"===h.type,this._isSelectMultipleElement="select-multiple"===h.type,this._isSelectElement=this._isSelectOneElement||this._isSelectMultipleElement,this.config.searchEnabled=this._isSelectMultipleElement||this.config.searchEnabled,["auto","always"].includes(this.config.renderSelectedChoices)||(this.config.renderSelectedChoices="auto"),t.addItemFilter&&"function"!=typeof t.addItemFilter){var u=t.addItemFilter instanceof RegExp?t.addItemFilter:new RegExp(t.addItemFilter);this.config.addItemFilter=u.test.bind(u)}if(this._isTextElement?this.passedElement=new de({element:h,classNames:this.config.classNames,delimiter:this.config.delimiter}):this.passedElement=new me({element:h,classNames:this.config.classNames,template:function(e){return i._templates.option(e)}}),this.initialised=!1,this._store=new T,this._initialState={},this._currentState={},this._prevState={},this._currentValue="",this._canSearch=this.config.searchEnabled,this._isScrollingOnIe=!1,this._highlightPosition=0,this._wasTap=!0,this._placeholderValue=this._generatePlaceholderValue(),this._baseId=function(e,t){var i=e.id||e.name&&e.name+"-"+b(2)||b(4);return i=t+"-"+(i=i.replace(/(:|\.|\[|\]|,)/g,""))}(this.passedElement.element,"choices-"),this._direction=this.passedElement.dir,!this._direction){var d=window.getComputedStyle(this.passedElement.element).direction;d!==window.getComputedStyle(document.documentElement).direction&&(this._direction=d)}if(this._idNames={itemChoice:"item-choice"},this._presetGroups=this.passedElement.optionGroups,this._presetOptions=this.passedElement.options,this._presetChoices=this.config.choices,this._presetItems=this.config.items,this.passedElement.value&&(this._presetItems=this._presetItems.concat(this.passedElement.value.split(this.config.delimiter))),this.passedElement.options&&this.passedElement.options.forEach((function(e){i._presetChoices.push({value:e.value,label:e.innerHTML,selected:e.selected,disabled:e.disabled||e.parentNode.disabled,placeholder:""===e.value||e.hasAttribute("placeholder"),customProperties:e.getAttribute("data-custom-properties")})})),this._render=this._render.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this),this._onKeyUp=this._onKeyUp.bind(this),this._onKeyDown=this._onKeyDown.bind(this),this._onClick=this._onClick.bind(this),this._onTouchMove=this._onTouchMove.bind(this),this._onTouchEnd=this._onTouchEnd.bind(this),this._onMouseDown=this._onMouseDown.bind(this),this._onMouseOver=this._onMouseOver.bind(this),this._onFormReset=this._onFormReset.bind(this),this._onAKey=this._onAKey.bind(this),this._onEnterKey=this._onEnterKey.bind(this),this._onEscapeKey=this._onEscapeKey.bind(this),this._onDirectionKey=this._onDirectionKey.bind(this),this._onDeleteKey=this._onDeleteKey.bind(this),this.passedElement.isActive)return this.config.silent||console.warn("Trying to initialise Choices on element already initialised"),void(this.initialised=!0);this.init()}e=n,i=[{key:"defaults",get:function(){return Object.preventExtensions({get options(){return Ie},get templates(){return fe}})}}],(t=null)&&ye(e.prototype,t),i&&ye(e,i);var r=n.prototype;return r.init=function(){if(!this.initialised){this._createTemplates(),this._createElements(),this._createStructure(),this._initialState=O(this._store.state),this._store.subscribe(this._render),this._render(),this._addEventListeners(),(!this.config.addItems||this.passedElement.element.hasAttribute("disabled"))&&this.disable(),this.initialised=!0;var e=this.config.callbackOnInit;e&&"function"==typeof e&&e.call(this)}},r.destroy=function(){this.initialised&&(this._removeEventListeners(),this.passedElement.reveal(),this.containerOuter.unwrap(this.passedElement.element),this.clearStore(),this._isSelectElement&&(this.passedElement.options=this._presetOptions),this._templates=null,this.initialised=!1)},r.enable=function(){return this.passedElement.isDisabled&&this.passedElement.enable(),this.containerOuter.isDisabled&&(this._addEventListeners(),this.input.enable(),this.containerOuter.enable()),this},r.disable=function(){return this.passedElement.isDisabled||this.passedElement.disable(),this.containerOuter.isDisabled||(this._removeEventListeners(),this.input.disable(),this.containerOuter.disable()),this},r.highlightItem=function(e,t){if(void 0===t&&(t=!0),!e)return this;var i=e.id,n=e.groupId,s=void 0===n?-1:n,r=e.value,o=void 0===r?"":r,a=e.label,c=void 0===a?"":a,l=s>=0?this._store.getGroupById(s):null;return this._store.dispatch(ge(i,!0)),t&&this.passedElement.triggerEvent(H,{id:i,value:o,label:c,groupValue:l&&l.value?l.value:null}),this},r.unhighlightItem=function(e){if(!e)return this;var t=e.id,i=e.groupId,n=void 0===i?-1:i,s=e.value,r=void 0===s?"":s,o=e.label,a=void 0===o?"":o,c=n>=0?this._store.getGroupById(n):null;return this._store.dispatch(ge(t,!1)),this.passedElement.triggerEvent(H,{id:t,value:r,label:a,groupValue:c&&c.value?c.value:null}),this},r.highlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.highlightItem(t)})),this},r.unhighlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.unhighlightItem(t)})),this},r.removeActiveItemsByValue=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.value===e})).forEach((function(e){return t._removeItem(e)})),this},r.removeActiveItems=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.id!==e})).forEach((function(e){return t._removeItem(e)})),this},r.removeHighlightedItems=function(e){var t=this;return void 0===e&&(e=!1),this._store.highlightedActiveItems.forEach((function(i){t._removeItem(i),e&&t._triggerChange(i.value)})),this},r.showDropdown=function(e){var t=this;return this.dropdown.isActive||requestAnimationFrame((function(){t.dropdown.show(),t.containerOuter.open(t.dropdown.distanceFromTopWindow),!e&&t._canSearch&&t.input.focus(),t.passedElement.triggerEvent(D,{})})),this},r.hideDropdown=function(e){var t=this;return this.dropdown.isActive?(requestAnimationFrame((function(){t.dropdown.hide(),t.containerOuter.close(),!e&&t._canSearch&&(t.input.removeActiveDescendant(),t.input.blur()),t.passedElement.triggerEvent(M,{})})),this):this},r.getValue=function(e){void 0===e&&(e=!1);var t=this._store.activeItems.reduce((function(t,i){var n=e?i.value:i;return t.push(n),t}),[]);return this._isSelectOneElement?t[0]:t},r.setValue=function(e){var t=this;return this.initialised?(e.forEach((function(e){return t._setChoiceOrItem(e)})),this):this},r.setChoiceByValue=function(e){var t=this;return!this.initialised||this._isTextElement||(Array.isArray(e)?e:[e]).forEach((function(e){return t._findAndSelectChoiceByValue(e)})),this},r.setChoices=function(e,t,i,n){var s=this;if(void 0===e&&(e=[]),void 0===t&&(t="value"),void 0===i&&(i="label"),void 0===n&&(n=!1),!this.initialised)throw new ReferenceError("setChoices was called on a non-initialized instance of Choices");if(!this._isSelectElement)throw new TypeError("setChoices can't be used with INPUT based Choices");if("string"!=typeof t||!t)throw new TypeError("value parameter must be a name of 'value' field in passed objects");if(n&&this.clearChoices(),"function"==typeof e){var r=e(this);if("function"==typeof Promise&&r instanceof Promise)return new Promise((function(e){return requestAnimationFrame(e)})).then((function(){return s._handleLoadingState(!0)})).then((function(){return r})).then((function(e){return s.setChoices(e,t,i,n)})).catch((function(e){s.config.silent||console.error(e)})).then((function(){return s._handleLoadingState(!1)})).then((function(){return s}));if(!Array.isArray(r))throw new TypeError(".setChoices first argument function must return either array of choices or Promise, got: "+typeof r);return this.setChoices(r,t,i,!1)}if(!Array.isArray(e))throw new TypeError(".setChoices must be called either with array of choices with a function resulting into Promise of array of choices");return this.containerOuter.removeLoadingState(),this._startLoading(),e.forEach((function(e){e.choices?s._addGroup({id:parseInt(e.id,10)||null,group:e,valueKey:t,labelKey:i}):s._addChoice({value:e[t],label:e[i],isSelected:e.selected,isDisabled:e.disabled,customProperties:e.customProperties,placeholder:e.placeholder})})),this._stopLoading(),this},r.clearChoices=function(){return this._store.dispatch({type:U}),this},r.clearStore=function(){return this._store.dispatch({type:"CLEAR_ALL"}),this},r.clearInput=function(){var e=!this._isSelectOneElement;return this.input.clear(e),!this._isTextElement&&this._canSearch&&(this._isSearching=!1,this._store.dispatch(ve(!0))),this},r._render=function(){if(!this._store.isLoading()){this._currentState=this._store.state;var e=this._currentState.choices!==this._prevState.choices||this._currentState.groups!==this._prevState.groups||this._currentState.items!==this._prevState.items,t=this._isSelectElement,i=this._currentState.items!==this._prevState.items;e&&(t&&this._renderChoices(),i&&this._renderItems(),this._prevState=this._currentState)}},r._renderChoices=function(){var e=this,t=this._store,i=t.activeGroups,n=t.activeChoices,s=document.createDocumentFragment();if(this.choiceList.clear(),this.config.resetScrollPosition&&requestAnimationFrame((function(){return e.choiceList.scrollToTop()})),i.length>=1&&!this._isSearching){var r=n.filter((function(e){return!0===e.placeholder&&-1===e.groupId}));r.length>=1&&(s=this._createChoicesFragment(r,s)),s=this._createGroupsFragment(i,n,s)}else n.length>=1&&(s=this._createChoicesFragment(n,s));if(s.childNodes&&s.childNodes.length>0){var o=this._store.activeItems,a=this._canAddItem(o,this.input.value);a.response?(this.choiceList.append(s),this._highlightChoice()):this.choiceList.append(this._getTemplate("notice",a.notice))}else{var c,l;this._isSearching?(l="function"==typeof this.config.noResultsText?this.config.noResultsText():this.config.noResultsText,c=this._getTemplate("notice",l,"no-results")):(l="function"==typeof this.config.noChoicesText?this.config.noChoicesText():this.config.noChoicesText,c=this._getTemplate("notice",l,"no-choices")),this.choiceList.append(c)}},r._renderItems=function(){var e=this._store.activeItems||[];this.itemList.clear();var t=this._createItemsFragment(e);t.childNodes&&this.itemList.append(t)},r._createGroupsFragment=function(e,t,i){var n=this;return void 0===i&&(i=document.createDocumentFragment()),this.config.shouldSort&&e.sort(this.config.sorter),e.forEach((function(e){var s=function(e){return t.filter((function(t){return n._isSelectOneElement?t.groupId===e.id:t.groupId===e.id&&("always"===n.config.renderSelectedChoices||!t.selected)}))}(e);if(s.length>=1){var r=n._getTemplate("choiceGroup",e);i.appendChild(r),n._createChoicesFragment(s,i,!0)}})),i},r._createChoicesFragment=function(e,t,i){var n=this;void 0===t&&(t=document.createDocumentFragment()),void 0===i&&(i=!1);var s=this.config,r=s.renderSelectedChoices,o=s.searchResultLimit,a=s.renderChoiceLimit,c=this._isSearching?w:this.config.sorter,l=function(e){if("auto"!==r||n._isSelectOneElement||!e.selected){var i=n._getTemplate("choice",e,n.config.itemSelectText);t.appendChild(i)}},h=e;"auto"!==r||this._isSelectOneElement||(h=e.filter((function(e){return!e.selected})));var u=h.reduce((function(e,t){return t.placeholder?e.placeholderChoices.push(t):e.normalChoices.push(t),e}),{placeholderChoices:[],normalChoices:[]}),d=u.placeholderChoices,p=u.normalChoices;(this.config.shouldSort||this._isSearching)&&p.sort(c);var m=h.length,f=this._isSelectOneElement?[].concat(d,p):p;this._isSearching?m=o:a&&a>0&&!i&&(m=a);for(var v=0;v<m;v+=1)f[v]&&l(f[v]);return t},r._createItemsFragment=function(e,t){var i=this;void 0===t&&(t=document.createDocumentFragment());var n=this.config,s=n.shouldSortItems,r=n.sorter,o=n.removeItemButton;return s&&!this._isSelectOneElement&&e.sort(r),this._isTextElement?this.passedElement.value=e:this.passedElement.options=e,e.forEach((function(e){var n=i._getTemplate("item",e,o);t.appendChild(n)})),t},r._triggerChange=function(e){null!=e&&this.passedElement.triggerEvent(N,{value:e})},r._selectPlaceholderChoice=function(){var e=this._store.placeholderChoice;e&&(this._addItem({value:e.value,label:e.label,choiceId:e.id,groupId:e.groupId,placeholder:e.placeholder}),this._triggerChange(e.value))},r._handleButtonAction=function(e,t){if(e&&t&&this.config.removeItems&&this.config.removeItemButton){var i=t.parentNode.getAttribute("data-id"),n=e.find((function(e){return e.id===parseInt(i,10)}));this._removeItem(n),this._triggerChange(n.value),this._isSelectOneElement&&this._selectPlaceholderChoice()}},r._handleItemAction=function(e,t,i){var n=this;if(void 0===i&&(i=!1),e&&t&&this.config.removeItems&&!this._isSelectOneElement){var s=t.getAttribute("data-id");e.forEach((function(e){e.id!==parseInt(s,10)||e.highlighted?!i&&e.highlighted&&n.unhighlightItem(e):n.highlightItem(e)})),this.input.focus()}},r._handleChoiceAction=function(e,t){if(e&&t){var i=t.dataset.id,n=this._store.getChoiceById(i);if(n){var s=e[0]&&e[0].keyCode?e[0].keyCode:null,r=this.dropdown.isActive;n.keyCode=s,this.passedElement.triggerEvent(F,{choice:n}),n.selected||n.disabled||this._canAddItem(e,n.value).response&&(this._addItem({value:n.value,label:n.label,choiceId:n.id,groupId:n.groupId,customProperties:n.customProperties,placeholder:n.placeholder,keyCode:n.keyCode}),this._triggerChange(n.value)),this.clearInput(),r&&this._isSelectOneElement&&(this.hideDropdown(!0),this.containerOuter.focus())}}},r._handleBackspace=function(e){if(this.config.removeItems&&e){var t=e[e.length-1],i=e.some((function(e){return e.highlighted}));this.config.editItems&&!i&&t?(this.input.value=t.value,this.input.setWidth(),this._removeItem(t),this._triggerChange(t.value)):(i||this.highlightItem(t,!1),this.removeHighlightedItems(!0))}},r._startLoading=function(){this._store.dispatch(be(!0))},r._stopLoading=function(){this._store.dispatch(be(!1))},r._handleLoadingState=function(e){void 0===e&&(e=!0);var t=this.itemList.getChild("."+this.config.classNames.placeholder);e?(this.disable(),this.containerOuter.addLoadingState(),this._isSelectOneElement?t?t.innerHTML=this.config.loadingText:(t=this._getTemplate("placeholder",this.config.loadingText),this.itemList.append(t)):this.input.placeholder=this.config.loadingText):(this.enable(),this.containerOuter.removeLoadingState(),this._isSelectOneElement?t.innerHTML=this._placeholderValue||"":this.input.placeholder=this._placeholderValue||"")},r._handleSearch=function(e){if(e&&this.input.isFocussed){var t=this._store.choices,i=this.config,n=i.searchFloor,s=i.searchChoices,r=t.some((function(e){return!e.active}));if(e&&e.length>=n){var o=s?this._searchChoices(e):0;this.passedElement.triggerEvent(j,{value:e,resultCount:o})}else r&&(this._isSearching=!1,this._store.dispatch(ve(!0)))}},r._canAddItem=function(e,t){var i=!0,n="function"==typeof this.config.addItemText?this.config.addItemText(t):this.config.addItemText;if(!this._isSelectOneElement){var s=function(e,t,i){return void 0===i&&(i="value"),e.some((function(e){return"string"==typeof t?e[i]===t.trim():e[i]===t}))}(e,t);this.config.maxItemCount>0&&this.config.maxItemCount<=e.length&&(i=!1,n="function"==typeof this.config.maxItemText?this.config.maxItemText(this.config.maxItemCount):this.config.maxItemText),!this.config.duplicateItemsAllowed&&s&&i&&(i=!1,n="function"==typeof this.config.uniqueItemText?this.config.uniqueItemText(t):this.config.uniqueItemText),this._isTextElement&&this.config.addItems&&i&&"function"==typeof this.config.addItemFilter&&!this.config.addItemFilter(t)&&(i=!1,n="function"==typeof this.config.customAddItemText?this.config.customAddItemText(t):this.config.customAddItemText)}return{response:i,notice:n}},r._searchChoices=function(e){var t="string"==typeof e?e.trim():e,i="string"==typeof this._currentValue?this._currentValue.trim():this._currentValue;if(t.length<1&&t===i+" ")return 0;var n=this._store.searchableChoices,r=t,o=[].concat(this.config.searchFields),a=Object.assign(this.config.fuseOptions,{keys:o}),c=new s.a(n,a).search(r);return this._currentValue=t,this._highlightPosition=0,this._isSearching=!0,this._store.dispatch(function(e){return{type:G,results:e}}(c)),c.length},r._addEventListeners=function(){var e=document.documentElement;e.addEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.addEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.addEventListener("mousedown",this._onMouseDown,!0),e.addEventListener("click",this._onClick,{passive:!0}),e.addEventListener("touchmove",this._onTouchMove,{passive:!0}),this.dropdown.element.addEventListener("mouseover",this._onMouseOver,{passive:!0}),this._isSelectOneElement&&(this.containerOuter.element.addEventListener("focus",this._onFocus,{passive:!0}),this.containerOuter.element.addEventListener("blur",this._onBlur,{passive:!0})),this.input.element.addEventListener("keyup",this._onKeyUp,{passive:!0}),this.input.element.addEventListener("focus",this._onFocus,{passive:!0}),this.input.element.addEventListener("blur",this._onBlur,{passive:!0}),this.input.element.form&&this.input.element.form.addEventListener("reset",this._onFormReset,{passive:!0}),this.input.addEventListeners()},r._removeEventListeners=function(){var e=document.documentElement;e.removeEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.removeEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.removeEventListener("mousedown",this._onMouseDown,!0),e.removeEventListener("click",this._onClick),e.removeEventListener("touchmove",this._onTouchMove),this.dropdown.element.removeEventListener("mouseover",this._onMouseOver),this._isSelectOneElement&&(this.containerOuter.element.removeEventListener("focus",this._onFocus),this.containerOuter.element.removeEventListener("blur",this._onBlur)),this.input.element.removeEventListener("keyup",this._onKeyUp),this.input.element.removeEventListener("focus",this._onFocus),this.input.element.removeEventListener("blur",this._onBlur),this.input.element.form&&this.input.element.form.removeEventListener("reset",this._onFormReset),this.input.removeEventListeners()},r._onKeyDown=function(e){var t,i=e.target,n=e.keyCode,s=e.ctrlKey,r=e.metaKey,o=this._store.activeItems,a=this.input.isFocussed,c=this.dropdown.isActive,l=this.itemList.hasChildren(),h=String.fromCharCode(n),u=J,d=Y,p=Z,m=Q,f=ee,v=te,g=ie,_=ne,b=se,y=s||r;!this._isTextElement&&/[a-zA-Z0-9-_ ]/.test(h)&&this.showDropdown();var E=((t={})[m]=this._onAKey,t[p]=this._onEnterKey,t[f]=this._onEscapeKey,t[v]=this._onDirectionKey,t[_]=this._onDirectionKey,t[g]=this._onDirectionKey,t[b]=this._onDirectionKey,t[d]=this._onDeleteKey,t[u]=this._onDeleteKey,t);E[n]&&E[n]({event:e,target:i,keyCode:n,metaKey:r,activeItems:o,hasFocusedInput:a,hasActiveDropdown:c,hasItems:l,hasCtrlDownKeyPressed:y})},r._onKeyUp=function(e){var t=e.target,i=e.keyCode,n=this.input.value,s=this._store.activeItems,r=this._canAddItem(s,n),o=J,a=Y;if(this._isTextElement)if(r.notice&&n){var c=this._getTemplate("notice",r.notice);this.dropdown.element.innerHTML=c.outerHTML,this.showDropdown(!0)}else this.hideDropdown(!0);else{var l=(i===o||i===a)&&!t.value,h=!this._isTextElement&&this._isSearching,u=this._canSearch&&r.response;l&&h?(this._isSearching=!1,this._store.dispatch(ve(!0))):u&&this._handleSearch(this.input.value)}this._canSearch=this.config.searchEnabled},r._onAKey=function(e){var t=e.hasItems;e.hasCtrlDownKeyPressed&&t&&(this._canSearch=!1,this.config.removeItems&&!this.input.value&&this.input.element===document.activeElement&&this.highlightAll())},r._onEnterKey=function(e){var t=e.event,i=e.target,n=e.activeItems,s=e.hasActiveDropdown,r=Z,o=i.hasAttribute("data-button");if(this._isTextElement&&i.value){var a=this.input.value;this._canAddItem(n,a).response&&(this.hideDropdown(!0),this._addItem({value:a}),this._triggerChange(a),this.clearInput())}if(o&&(this._handleButtonAction(n,i),t.preventDefault()),s){var c=this.dropdown.getChild("."+this.config.classNames.highlightedState);c&&(n[0]&&(n[0].keyCode=r),this._handleChoiceAction(n,c)),t.preventDefault()}else this._isSelectOneElement&&(this.showDropdown(),t.preventDefault())},r._onEscapeKey=function(e){e.hasActiveDropdown&&(this.hideDropdown(!0),this.containerOuter.focus())},r._onDirectionKey=function(e){var t,i,n,s=e.event,r=e.hasActiveDropdown,o=e.keyCode,a=e.metaKey,c=ie,l=ne,h=se;if(r||this._isSelectOneElement){this.showDropdown(),this._canSearch=!1;var u,d=o===c||o===h?1:-1;if(a||o===h||o===l)u=d>0?this.dropdown.element.querySelector("[data-choice-selectable]:last-of-type"):this.dropdown.element.querySelector("[data-choice-selectable]");else{var p=this.dropdown.element.querySelector("."+this.config.classNames.highlightedState);u=p?function(e,t,i){if(void 0===i&&(i=1),e instanceof Element&&"string"==typeof t){for(var n=(i>0?"next":"previous")+"ElementSibling",s=e[n];s;){if(s.matches(t))return s;s=s[n]}return s}}(p,"[data-choice-selectable]",d):this.dropdown.element.querySelector("[data-choice-selectable]")}u&&(t=u,i=this.choiceList.element,void 0===(n=d)&&(n=1),t&&(n>0?i.scrollTop+i.offsetHeight>=t.offsetTop+t.offsetHeight:t.offsetTop>=i.scrollTop)||this.choiceList.scrollToChildElement(u,d),this._highlightChoice(u)),s.preventDefault()}},r._onDeleteKey=function(e){var t=e.event,i=e.target,n=e.hasFocusedInput,s=e.activeItems;!n||i.value||this._isSelectOneElement||(this._handleBackspace(s),t.preventDefault())},r._onTouchMove=function(){this._wasTap&&(this._wasTap=!1)},r._onTouchEnd=function(e){var t=(e||e.touches[0]).target;this._wasTap&&this.containerOuter.element.contains(t)&&((t===this.containerOuter.element||t===this.containerInner.element)&&(this._isTextElement?this.input.focus():this._isSelectMultipleElement&&this.showDropdown()),e.stopPropagation()),this._wasTap=!0},r._onMouseDown=function(e){var t=e.target;if(t instanceof HTMLElement){if(Ee&&this.choiceList.element.contains(t)){var i=this.choiceList.element.firstElementChild,n="ltr"===this._direction?e.offsetX>=i.offsetWidth:e.offsetX<i.offsetLeft;this._isScrollingOnIe=n}if(t!==this.input.element){var s=t.closest("[data-button],[data-item],[data-choice]");if(s instanceof HTMLElement){var r=e.shiftKey,o=this._store.activeItems,a=s.dataset;"button"in a?this._handleButtonAction(o,s):"item"in a?this._handleItemAction(o,s,r):"choice"in a&&this._handleChoiceAction(o,s)}e.preventDefault()}}},r._onMouseOver=function(e){var t=e.target;t instanceof HTMLElement&&"choice"in t.dataset&&this._highlightChoice(t)},r._onClick=function(e){var t=e.target;this.containerOuter.element.contains(t)?this.dropdown.isActive||this.containerOuter.isDisabled?this._isSelectOneElement&&t!==this.input.element&&!this.dropdown.element.contains(t)&&this.hideDropdown():this._isTextElement?document.activeElement!==this.input.element&&this.input.focus():(this.showDropdown(),this.containerOuter.focus()):(this._store.highlightedActiveItems.length>0&&this.unhighlightAll(),this.containerOuter.removeFocusState(),this.hideDropdown(!0))},r._onFocus=function(e){var t,i=this,n=e.target;this.containerOuter.element.contains(n)&&((t={}).text=function(){n===i.input.element&&i.containerOuter.addFocusState()},t["select-one"]=function(){i.containerOuter.addFocusState(),n===i.input.element&&i.showDropdown(!0)},t["select-multiple"]=function(){n===i.input.element&&(i.showDropdown(!0),i.containerOuter.addFocusState())},t)[this.passedElement.element.type]()},r._onBlur=function(e){var t=this,i=e.target;if(this.containerOuter.element.contains(i)&&!this._isScrollingOnIe){var n,s=this._store.activeItems.some((function(e){return e.highlighted}));((n={}).text=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),s&&t.unhighlightAll(),t.hideDropdown(!0))},n["select-one"]=function(){t.containerOuter.removeFocusState(),(i===t.input.element||i===t.containerOuter.element&&!t._canSearch)&&t.hideDropdown(!0)},n["select-multiple"]=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),t.hideDropdown(!0),s&&t.unhighlightAll())},n)[this.passedElement.element.type]()}else this._isScrollingOnIe=!1,this.input.element.focus()},r._onFormReset=function(){this._store.dispatch({type:"RESET_TO",state:this._initialState})},r._highlightChoice=function(e){var t=this;void 0===e&&(e=null);var i=Array.from(this.dropdown.element.querySelectorAll("[data-choice-selectable]"));if(i.length){var n=e;Array.from(this.dropdown.element.querySelectorAll("."+this.config.classNames.highlightedState)).forEach((function(e){e.classList.remove(t.config.classNames.highlightedState),e.setAttribute("aria-selected","false")})),n?this._highlightPosition=i.indexOf(n):(n=i.length>this._highlightPosition?i[this._highlightPosition]:i[i.length-1])||(n=i[0]),n.classList.add(this.config.classNames.highlightedState),n.setAttribute("aria-selected","true"),this.passedElement.triggerEvent(B,{el:n}),this.dropdown.isActive&&(this.input.setActiveDescendant(n.id),this.containerOuter.setActiveDescendant(n.id))}},r._addItem=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.choiceId,r=void 0===s?-1:s,o=e.groupId,a=void 0===o?-1:o,c=e.customProperties,l=void 0===c?null:c,h=e.placeholder,u=void 0!==h&&h,d=e.keyCode,p=void 0===d?null:d,m="string"==typeof t?t.trim():t,f=p,v=l,g=this._store.items,_=n||m,b=r||-1,y=a>=0?this._store.getGroupById(a):null,E=g?g.length+1:1;return this.config.prependValue&&(m=this.config.prependValue+m.toString()),this.config.appendValue&&(m+=this.config.appendValue.toString()),this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.choiceId,r=e.groupId,o=e.customProperties,a=e.placeholder,c=e.keyCode;return{type:W,value:t,label:i,id:n,choiceId:s,groupId:r,customProperties:o,placeholder:a,keyCode:c}}({value:m,label:_,id:E,choiceId:b,groupId:a,customProperties:l,placeholder:u,keyCode:f})),this._isSelectOneElement&&this.removeActiveItems(E),this.passedElement.triggerEvent(K,{id:E,value:m,label:_,customProperties:v,groupValue:y&&y.value?y.value:void 0,keyCode:f}),this},r._removeItem=function(e){if(!e||!E("Object",e))return this;var t=e.id,i=e.value,n=e.label,s=e.choiceId,r=e.groupId,o=r>=0?this._store.getGroupById(r):null;return this._store.dispatch(function(e,t){return{type:X,id:e,choiceId:t}}(t,s)),o&&o.value?this.passedElement.triggerEvent(R,{id:t,value:i,label:n,groupValue:o.value}):this.passedElement.triggerEvent(R,{id:t,value:i,label:n}),this},r._addChoice=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.isSelected,r=void 0!==s&&s,o=e.isDisabled,a=void 0!==o&&o,c=e.groupId,l=void 0===c?-1:c,h=e.customProperties,u=void 0===h?null:h,d=e.placeholder,p=void 0!==d&&d,m=e.keyCode,f=void 0===m?null:m;if(null!=t){var v=this._store.choices,g=n||t,_=v?v.length+1:1,b=this._baseId+"-"+this._idNames.itemChoice+"-"+_;this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.groupId,r=e.disabled,o=e.elementId,a=e.customProperties,c=e.placeholder,l=e.keyCode;return{type:V,value:t,label:i,id:n,groupId:s,disabled:r,elementId:o,customProperties:a,placeholder:c,keyCode:l}}({id:_,groupId:l,elementId:b,value:t,label:g,disabled:a,customProperties:u,placeholder:p,keyCode:f})),r&&this._addItem({value:t,label:g,choiceId:_,customProperties:u,placeholder:p,keyCode:f})}},r._addGroup=function(e){var t=this,i=e.group,n=e.id,s=e.valueKey,r=void 0===s?"value":s,o=e.labelKey,a=void 0===o?"label":o,c=E("Object",i)?i.choices:Array.from(i.getElementsByTagName("OPTION")),l=n||Math.floor((new Date).valueOf()*Math.random()),h=!!i.disabled&&i.disabled;c?(this._store.dispatch(_e({value:i.label,id:l,active:!0,disabled:h})),c.forEach((function(e){var i=e.disabled||e.parentNode&&e.parentNode.disabled;t._addChoice({value:e[r],label:E("Object",e)?e[a]:e.innerHTML,isSelected:e.selected,isDisabled:i,groupId:l,customProperties:e.customProperties,placeholder:e.placeholder})}))):this._store.dispatch(_e({value:i.label,id:i.id,active:!1,disabled:i.disabled}))},r._getTemplate=function(e){var t;if(!e)return null;for(var i=this.config.classNames,n=arguments.length,s=new Array(n>1?n-1:0),r=1;r<n;r++)s[r-1]=arguments[r];return(t=this._templates[e]).call.apply(t,[this,i].concat(s))},r._createTemplates=function(){var e=this.config.callbackOnCreateTemplates,t={};e&&"function"==typeof e&&(t=e.call(this,S)),this._templates=o()(fe,t)},r._createElements=function(){this.containerOuter=new re({element:this._getTemplate("containerOuter",this._direction,this._isSelectElement,this._isSelectOneElement,this.config.searchEnabled,this.passedElement.element.type),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.containerInner=new re({element:this._getTemplate("containerInner"),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.input=new ae({element:this._getTemplate("input",this._placeholderValue),classNames:this.config.classNames,type:this.passedElement.element.type,preventPaste:!this.config.paste}),this.choiceList=new ce({element:this._getTemplate("choiceList",this._isSelectOneElement)}),this.itemList=new ce({element:this._getTemplate("itemList",this._isSelectOneElement)}),this.dropdown=new k({element:this._getTemplate("dropdown"),classNames:this.config.classNames,type:this.passedElement.element.type})},r._createStructure=function(){this.passedElement.conceal(),this.containerInner.wrap(this.passedElement.element),this.containerOuter.wrap(this.containerInner.element),this._isSelectOneElement?this.input.placeholder=this.config.searchPlaceholderValue||"":this._placeholderValue&&(this.input.placeholder=this._placeholderValue,this.input.setWidth()),this.containerOuter.element.appendChild(this.containerInner.element),this.containerOuter.element.appendChild(this.dropdown.element),this.containerInner.element.appendChild(this.itemList.element),this._isTextElement||this.dropdown.element.appendChild(this.choiceList.element),this._isSelectOneElement?this.config.searchEnabled&&this.dropdown.element.insertBefore(this.input.element,this.dropdown.element.firstChild):this.containerInner.element.appendChild(this.input.element),this._isSelectElement&&(this._highlightPosition=0,this._isSearching=!1,this._startLoading(),this._presetGroups.length?this._addPredefinedGroups(this._presetGroups):this._addPredefinedChoices(this._presetChoices),this._stopLoading()),this._isTextElement&&this._addPredefinedItems(this._presetItems)},r._addPredefinedGroups=function(e){var t=this,i=this.passedElement.placeholderOption;i&&"SELECT"===i.parentNode.tagName&&this._addChoice({value:i.value,label:i.innerHTML,isSelected:i.selected,isDisabled:i.disabled,placeholder:!0}),e.forEach((function(e){return t._addGroup({group:e,id:e.id||null})}))},r._addPredefinedChoices=function(e){var t=this;this.config.shouldSort&&e.sort(this.config.sorter);var i=e.some((function(e){return e.selected})),n=e.findIndex((function(e){return void 0===e.disabled||!e.disabled}));e.forEach((function(e,s){var r=e.value,o=e.label,a=e.customProperties,c=e.placeholder;if(t._isSelectElement)if(e.choices)t._addGroup({group:e,id:e.id||null});else{var l=!(!t._isSelectOneElement||i||s!==n)||e.selected,h=e.disabled;t._addChoice({value:r,label:o,isSelected:l,isDisabled:h,customProperties:a,placeholder:c})}else t._addChoice({value:r,label:o,isSelected:e.selected,isDisabled:e.disabled,customProperties:a,placeholder:c})}))},r._addPredefinedItems=function(e){var t=this;e.forEach((function(e){"object"==typeof e&&e.value&&t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}),"string"==typeof e&&t._addItem({value:e})}))},r._setChoiceOrItem=function(e){var t=this;({object:function(){e.value&&(t._isTextElement?t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}):t._addChoice({value:e.value,label:e.label,isSelected:!0,isDisabled:!1,customProperties:e.customProperties,placeholder:e.placeholder}))},string:function(){t._isTextElement?t._addItem({value:e}):t._addChoice({value:e,label:e,isSelected:!0,isDisabled:!1})}})[y(e).toLowerCase()]()},r._findAndSelectChoiceByValue=function(e){var t=this,i=this._store.choices.find((function(i){return t.config.valueComparer(i.value,e)}));i&&!i.selected&&this._addItem({value:i.value,label:i.label,choiceId:i.id,groupId:i.groupId,customProperties:i.customProperties,placeholder:i.placeholder,keyCode:i.keyCode})},r._generatePlaceholderValue=function(){if(this._isSelectElement){var e=this.passedElement.placeholderOption;return!!e&&e.text}var t=this.config,i=t.placeholder,n=t.placeholderValue,s=this.passedElement.element.dataset;if(i){if(n)return n;if(s.placeholder)return s.placeholder}return!1},n}();t.default=Se}]).default},"object"==typeof i&&"object"==typeof t?t.exports=s():"function"==typeof define&&define.amd?define([],s):"object"==typeof i?i.Choices=s():n.Choices=s()},
440: function _(n,o,e){Object.defineProperty(e,"__esModule",{value:!0});e.default="\n.bk-root {\n  /*===============================\n=            Choices            =\n===============================*/\n  /*=====  End of Choices  ======*/\n}\n.bk-root .choices {\n  position: relative;\n  margin-bottom: 24px;\n  font-size: 16px;\n}\n.bk-root .choices:focus {\n  outline: none;\n}\n.bk-root .choices:last-child {\n  margin-bottom: 0;\n}\n.bk-root .choices.is-disabled .choices__inner,\n.bk-root .choices.is-disabled .choices__input {\n  background-color: #eaeaea;\n  cursor: not-allowed;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n.bk-root .choices.is-disabled .choices__item {\n  cursor: not-allowed;\n}\n.bk-root .choices [hidden] {\n  display: none !important;\n}\n.bk-root .choices[data-type*='select-one'] {\n  cursor: pointer;\n}\n.bk-root .choices[data-type*='select-one'] .choices__inner {\n  padding-bottom: 7.5px;\n}\n.bk-root .choices[data-type*='select-one'] .choices__input {\n  display: block;\n  width: 100%;\n  padding: 10px;\n  border-bottom: 1px solid #dddddd;\n  background-color: #ffffff;\n  margin: 0;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  padding: 0;\n  background-size: 8px;\n  position: absolute;\n  top: 50%;\n  right: 0;\n  margin-top: -10px;\n  margin-right: 25px;\n  height: 20px;\n  width: 20px;\n  border-radius: 10em;\n  opacity: 0.5;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button:hover,\n.bk-root .choices[data-type*='select-one'] .choices__button:focus {\n  opacity: 1;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button:focus {\n  box-shadow: 0px 0px 0px 2px #00bcd4;\n}\n.bk-root .choices[data-type*='select-one'] .choices__item[data-value=''] .choices__button {\n  display: none;\n}\n.bk-root .choices[data-type*='select-one']:after {\n  content: '';\n  height: 0;\n  width: 0;\n  border-style: solid;\n  border-color: #333333 transparent transparent transparent;\n  border-width: 5px;\n  position: absolute;\n  right: 11.5px;\n  top: 50%;\n  margin-top: -2.5px;\n  pointer-events: none;\n}\n.bk-root .choices[data-type*='select-one'].is-open:after {\n  border-color: transparent transparent #333333 transparent;\n  margin-top: -7.5px;\n}\n.bk-root .choices[data-type*='select-one'][dir='rtl']:after {\n  left: 11.5px;\n  right: auto;\n}\n.bk-root .choices[data-type*='select-one'][dir='rtl'] .choices__button {\n  right: auto;\n  left: 0;\n  margin-left: 25px;\n  margin-right: 0;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__inner,\n.bk-root .choices[data-type*='text'] .choices__inner {\n  cursor: text;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__button,\n.bk-root .choices[data-type*='text'] .choices__button {\n  position: relative;\n  display: inline-block;\n  margin-top: 0;\n  margin-right: -4px;\n  margin-bottom: 0;\n  margin-left: 8px;\n  padding-left: 16px;\n  border-left: 1px solid #008fa1;\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjRkZGIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  background-size: 8px;\n  width: 8px;\n  line-height: 1;\n  opacity: 0.75;\n  border-radius: 0;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__button:hover,\n.bk-root .choices[data-type*='select-multiple'] .choices__button:focus,\n.bk-root .choices[data-type*='text'] .choices__button:hover,\n.bk-root .choices[data-type*='text'] .choices__button:focus {\n  opacity: 1;\n}\n.bk-root .choices__inner {\n  display: inline-block;\n  vertical-align: top;\n  width: 100%;\n  background-color: #f9f9f9;\n  padding: 7.5px 7.5px 3.75px;\n  border: 1px solid #dddddd;\n  border-radius: 2.5px;\n  font-size: 14px;\n  min-height: 44px;\n  overflow: hidden;\n}\n.bk-root .is-focused .choices__inner,\n.bk-root .is-open .choices__inner {\n  border-color: #b7b7b7;\n}\n.bk-root .is-open .choices__inner {\n  border-radius: 2.5px 2.5px 0 0;\n}\n.bk-root .is-flipped.is-open .choices__inner {\n  border-radius: 0 0 2.5px 2.5px;\n}\n.bk-root .choices__list {\n  margin: 0;\n  padding-left: 0;\n  list-style: none;\n}\n.bk-root .choices__list--single {\n  display: inline-block;\n  padding: 4px 16px 4px 4px;\n  width: 100%;\n}\n.bk-root [dir='rtl'] .choices__list--single {\n  padding-right: 4px;\n  padding-left: 16px;\n}\n.bk-root .choices__list--single .choices__item {\n  width: 100%;\n}\n.bk-root .choices__list--multiple {\n  display: inline;\n}\n.bk-root .choices__list--multiple .choices__item {\n  display: inline-block;\n  vertical-align: middle;\n  border-radius: 20px;\n  padding: 4px 10px;\n  font-size: 12px;\n  font-weight: 500;\n  margin-right: 3.75px;\n  margin-bottom: 3.75px;\n  background-color: #00bcd4;\n  border: 1px solid #00a5bb;\n  color: #ffffff;\n  word-break: break-all;\n  box-sizing: border-box;\n}\n.bk-root .choices__list--multiple .choices__item[data-deletable] {\n  padding-right: 5px;\n}\n.bk-root [dir='rtl'] .choices__list--multiple .choices__item {\n  margin-right: 0;\n  margin-left: 3.75px;\n}\n.bk-root .choices__list--multiple .choices__item.is-highlighted {\n  background-color: #00a5bb;\n  border: 1px solid #008fa1;\n}\n.bk-root .is-disabled .choices__list--multiple .choices__item {\n  background-color: #aaaaaa;\n  border: 1px solid #919191;\n}\n.bk-root .choices__list--dropdown {\n  visibility: hidden;\n  z-index: 1;\n  position: absolute;\n  width: 100%;\n  background-color: #ffffff;\n  border: 1px solid #dddddd;\n  top: 100%;\n  margin-top: -1px;\n  border-bottom-left-radius: 2.5px;\n  border-bottom-right-radius: 2.5px;\n  overflow: hidden;\n  word-break: break-all;\n  will-change: visibility;\n}\n.bk-root .choices__list--dropdown.is-active {\n  visibility: visible;\n}\n.bk-root .is-open .choices__list--dropdown {\n  border-color: #b7b7b7;\n}\n.bk-root .is-flipped .choices__list--dropdown {\n  top: auto;\n  bottom: 100%;\n  margin-top: 0;\n  margin-bottom: -1px;\n  border-radius: 0.25rem 0.25rem 0 0;\n}\n.bk-root .choices__list--dropdown .choices__list {\n  position: relative;\n  max-height: 300px;\n  overflow: auto;\n  -webkit-overflow-scrolling: touch;\n  will-change: scroll-position;\n}\n.bk-root .choices__list--dropdown .choices__item {\n  position: relative;\n  padding: 10px;\n  font-size: 14px;\n}\n.bk-root [dir='rtl'] .choices__list--dropdown .choices__item {\n  text-align: right;\n}\n@media (min-width: 640px) {\n  .bk-root .choices__list--dropdown .choices__item--selectable {\n    padding-right: 100px;\n  }\n  .bk-root .choices__list--dropdown .choices__item--selectable:after {\n    content: attr(data-select-text);\n    font-size: 12px;\n    opacity: 0;\n    position: absolute;\n    right: 10px;\n    top: 50%;\n    transform: translateY(-50%);\n  }\n  .bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable {\n    text-align: right;\n    padding-left: 100px;\n    padding-right: 10px;\n  }\n  .bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable:after {\n    right: auto;\n    left: 10px;\n  }\n}\n.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted {\n  background-color: #f2f2f2;\n}\n.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted:after {\n  opacity: 0.5;\n}\n.bk-root .choices__item {\n  cursor: default;\n}\n.bk-root .choices__item--selectable {\n  cursor: pointer;\n}\n.bk-root .choices__item--disabled {\n  cursor: not-allowed;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  opacity: 0.5;\n}\n.bk-root .choices__heading {\n  font-weight: 600;\n  font-size: 12px;\n  padding: 10px;\n  border-bottom: 1px solid #f7f7f7;\n  color: gray;\n}\n.bk-root .choices__button {\n  text-indent: -9999px;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  border: 0;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center;\n  cursor: pointer;\n}\n.bk-root .choices__button:focus {\n  outline: none;\n}\n.bk-root .choices__input {\n  display: inline-block;\n  vertical-align: baseline;\n  background-color: #f9f9f9;\n  font-size: 14px;\n  margin-bottom: 5px;\n  border: 0;\n  border-radius: 0;\n  max-width: 100%;\n  padding: 4px 0 4px 2px;\n}\n.bk-root .choices__input:focus {\n  outline: 0;\n}\n.bk-root [dir='rtl'] .choices__input {\n  padding-right: 2px;\n  padding-left: 0;\n}\n.bk-root .choices__placeholder {\n  opacity: 0.5;\n}\n.bk-root .choices {\n  width: 100%;\n}\n.bk-root .choices {\n  box-sizing: border-box;\n}\n.bk-root .choices *,\n.bk-root .choices *:before,\n.bk-root .choices *:after {\n  box-sizing: inherit;\n}\n.bk-root .choices__inner .choices__item.light {\n  background-color: rgba(0, 126, 255, 0.08);\n  border-radius: 5px;\n  border: 1px solid rgba(0, 126, 255, 0.24);\n  color: #007eff;\n}\n.bk-root .choices__inner .choices__item.solid {\n  background-color: #1f77b4;\n  border: none;\n  border-radius: 5px;\n  color: white;\n}\n.bk-root .choices__inner .choices__item.solid .is-highlighted {\n  background-color: #1f77b4;\n  border: none;\n}\n.bk-root .choices__input {\n  background-color: transparent;\n}\n.bk-root .choices__inner {\n  background: transparent;\n  border: 1px solid darkgray;\n  border-radius: 5px;\n  min-height: unset;\n}\n.bk-root .choices__list {\n  white-space: initial;\n}\n.bk-root .choices[data-type*=select-multiple] .choices__button.light {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDA3ZWZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n}\n.bk-root .choices[data-type*=select-multiple] .choices__button.solid {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjZmZmZmZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  border-left: 1px solid white;\n  opacity: 1;\n}\n"},
441: function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0});const i=e(1),n=i.__importStar(e(188)),s=e(410),u=e(72),h=e(11),o=i.__importStar(e(18)),a=e(442),r=e(412),d=/^[-+]?\d*$/,p=/^[-+]?\d*\.?\d*(?:(?:\d|\d.)[eE][-+]?)*\d*$/;class _ extends s.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.value.change,()=>{this.input_el.value=this.format_value,this.old_value=this.input_el.value}),this.connect(this.model.properties.low.change,()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&h.assert(t<=l,"Invalid bounds, low must be inferior to high"),null!=e&&null!=t&&(this.model.value=Math.max(e,t))}),this.connect(this.model.properties.high.change,()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&h.assert(l>=t,"Invalid bounds, high must be superior to low"),null!=e&&null!=l&&(this.model.value=Math.min(e,l))}),this.connect(this.model.properties.high.change,()=>this.input_el.placeholder=this.model.placeholder),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder)}get format_value(){return null!=this.model.value?this.model.pretty(this.model.value):""}_set_input_filter(e){this.input_el.addEventListener("input",()=>{const{selectionStart:t,selectionEnd:l}=this.input_el;if(e(this.input_el.value))this.old_value=this.input_el.value;else{const e=this.old_value.length-this.input_el.value.length;this.input_el.value=this.old_value,t&&l&&this.input_el.setSelectionRange(t-1,l+e)}})}render(){super.render(),this.input_el=u.input({type:"text",class:r.bk_input,name:this.model.name,value:this.format_value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.old_value=this.format_value,this.set_input_filter(),this.input_el.addEventListener("change",()=>this.change_input()),this.input_el.addEventListener("focusout",()=>this.input_el.value=this.format_value),this.group_el.appendChild(this.input_el)}set_input_filter(){"int"==this.model.mode?this._set_input_filter(e=>d.test(e)):"float"==this.model.mode&&this._set_input_filter(e=>p.test(e))}bound_value(e){let t=e;const{low:l,high:i}=this.model;return t=null!=l?Math.max(l,t):t,t=null!=i?Math.min(i,t):t,t}get value(){let e=""!==this.input_el.value?Number(this.input_el.value):null;return null!=e&&(e=this.bound_value(e)),e}change_input(){null==this.value?this.model.value=null:Number.isNaN(this.value)||(this.model.value=this.value)}}l.NumericInputView=_,_.__name__="NumericInputView";class m extends s.InputWidget{constructor(e){super(e)}static init_NumericInput(){this.prototype.default_view=_,this.define({value:[o.Number,null],placeholder:[o.String,""],mode:[o.Any,"int"],format:[o.Any],low:[o.Number,null],high:[o.Number,null]})}_formatter(e,t){return a.isString(t)?n.format(e,t):t.doFormat([e],{loc:0})[0]}pretty(e){return null!=this.format?this._formatter(e,this.format):""+e}}l.NumericInput=m,m.__name__="NumericInput",m.init_NumericInput()},
442: function _(t,_,r){Object.defineProperty(r,"__esModule",{value:!0});const e=t(1);e.__exportStar(t(13),r),e.__exportStar(t(9),r),e.__exportStar(t(29),r),e.__exportStar(t(443),r),e.__exportStar(t(8),r),e.__exportStar(t(25),r)},
443: function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});class n{constructor(e){this.seed=e%2147483647,this.seed<=0&&(this.seed+=2147483646)}integer(){return this.seed=48271*this.seed%2147483647,this.seed}float(){return(this.integer()-1)/2147483646}floats(e){const t=new Array(e);for(let s=0;s<e;s++)t[s]=this.float();return t}}s.Random=n,n.__name__="Random",s.random=new n(Date.now())},
444: function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const s=e(430),i=e(72);class n extends s.MarkupView{render(){super.render();const e=i.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(e)}}r.PreTextView=n,n.__name__="PreTextView";class _ extends s.Markup{constructor(e){super(e)}static init_PreText(){this.prototype.default_view=n}}r.PreText=_,_.__name__="PreText",_.init_PreText()},
445: function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),a=t(415),n=t(72),u=i.__importStar(t(18)),s=t(173);class _ extends a.ButtonGroupView{change_active(t){this.model.active!==t&&(this.model.active=t)}_update_active(){const{active:t}=this.model;this._buttons.forEach((o,e)=>{n.classes(o).toggle(s.bk_active,t===e)})}}e.RadioButtonGroupView=_,_.__name__="RadioButtonGroupView";class c extends a.ButtonGroup{constructor(t){super(t)}static init_RadioButtonGroup(){this.prototype.default_view=_,this.define({active:[u.Any,null]})}}e.RadioButtonGroup=c,c.__name__="RadioButtonGroup",c.init_RadioButtonGroup()},
446: function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),a=e(72),s=e(29),o=n.__importStar(e(18)),d=e(417),l=e(173),p=e(412);class r extends d.InputGroupView{render(){super.render();const e=a.div({class:[p.bk_input_group,this.model.inline?l.bk_inline:null]});this.el.appendChild(e);const i=s.uniqueId(),{active:t,labels:n}=this.model;this._inputs=[];for(let s=0;s<n.length;s++){const o=a.input({type:"radio",name:i,value:""+s});o.addEventListener("change",()=>this.change_active(s)),this._inputs.push(o),this.model.disabled&&(o.disabled=!0),s==t&&(o.checked=!0);const d=a.label({},o,a.span({},n[s]));e.appendChild(d)}}change_active(e){this.model.active=e}}t.RadioGroupView=r,r.__name__="RadioGroupView";class u extends d.InputGroup{constructor(e){super(e)}static init_RadioGroup(){this.prototype.default_view=r,this.define({active:[o.Number],labels:[o.Array,[]],inline:[o.Boolean,!1]})}}t.RadioGroup=u,u.__name__="RadioGroup",u.init_RadioGroup()},
447: function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1).__importStar(e(188)),a=e(423),n=e(8);class o extends a.AbstractRangeSliderView{}r.RangeSliderView=o,o.__name__="RangeSliderView";class s extends a.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_RangeSlider(){this.prototype.default_view=o,this.override({format:"0[.]00"})}_formatter(e,t){return n.isString(t)?i.format(e,t):t.doFormat([e],{loc:0})[0]}}r.RangeSlider=s,s.__name__="RangeSlider",s.init_RangeSlider()},
448: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(72),l=e(8),o=e(13),p=n.__importStar(e(18)),u=e(410),a=e(412);class _ extends u.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,options:t}=this.model.properties;this.on_change(e,()=>{this._update_value()}),this.on_change(t,()=>{s.empty(this.input_el),s.append(this.input_el,...this.options_el())})}options_el(){function e(e){return e.map(e=>{let t,i;return l.isString(e)?t=i=e:[t,i]=e,s.option({value:t},i)})}const{options:t}=this.model;return l.isArray(t)?e(t):o.entries(t).map(([t,i])=>s.optgroup({label:t},e(i)))}render(){super.render(),this.input_el=s.select({class:a.bk_input,name:this.model.name,disabled:this.model.disabled},this.options_el()),this._update_value(),this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){const e=this.input_el.value;this.model.value=e,super.change_input()}_update_value(){const{value:e}=this.model;null!=e&&0!=e.length&&(this.input_el.value=this.model.value)}}i.SelectView=_,_.__name__="SelectView";class h extends u.InputWidget{constructor(e){super(e)}static init_Select(){this.prototype.default_view=_,this.define({value:[p.String,""],options:[p.Any,[]]})}}i.Select=h,h.__name__="Select",h.init_Select()},
449: function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1).__importStar(e(188)),o=e(423),s=e(8);class _ extends o.AbstractSliderView{}r.SliderView=_,_.__name__="SliderView";class a extends o.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}static init_Slider(){this.prototype.default_view=_,this.override({format:"0[.]00"})}_formatter(e,t){return s.isString(t)?i.format(e,t):t.doFormat([e],{loc:0})[0]}}r.Slider=a,a.__name__="Slider",a.init_Slider()},
450: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(441),l=n.__importStar(e(18)),r=e(72),{min:o,max:_,floor:a,abs:h}=Math;function u(e){return a(e)!==e?e.toFixed(16).replace(/0+$/,"").split(".")[1].length:0}class p extends s.NumericInputView{*buttons(){yield this.btn_up_el,yield this.btn_down_el}initialize(){super.initialize(),this._interval=200}connect_signals(){super.connect_signals();const e=this.model.properties;this.on_change(e.disabled,()=>{for(const e of this.buttons())r.toggle_attribute(e,"disabled",this.model.disabled)})}render(){super.render(),this.wrapper_el=r.div({class:"bk-spin-wrapper"}),this.group_el.replaceChild(this.wrapper_el,this.input_el),this.btn_up_el=r.button({class:"bk-spin-btn bk-spin-btn-up"}),this.btn_down_el=r.button({class:"bk-spin-btn bk-spin-btn-down"}),this.wrapper_el.appendChild(this.input_el),this.wrapper_el.appendChild(this.btn_up_el),this.wrapper_el.appendChild(this.btn_down_el);for(const e of this.buttons())r.toggle_attribute(e,"disabled",this.model.disabled),e.addEventListener("mousedown",e=>this._btn_mouse_down(e)),e.addEventListener("mouseup",()=>this._btn_mouse_up()),e.addEventListener("mouseleave",()=>this._btn_mouse_leave());this.input_el.addEventListener("keydown",e=>this._input_key_down(e)),this.input_el.addEventListener("keyup",()=>this.model.value_throttled=this.model.value),this.input_el.addEventListener("wheel",e=>this._input_mouse_wheel(e)),this.input_el.addEventListener("wheel",function(e,t,i=!1){let n;return function(...s){const l=this,r=i&&void 0===n;void 0!==n&&clearTimeout(n),n=setTimeout((function(){n=void 0,i||e.apply(l,s)}),t),r&&e.apply(l,s)}}(()=>{this.model.value_throttled=this.model.value},this.model.wheel_wait,!1))}get precision(){const{low:e,high:t,step:i}=this.model;return _(...[e,t,i].map(h).reduce((e,t)=>(null!=t&&e.push(t),e),[]).map(u))}_start_incrementation(e){clearInterval(this._interval_handle),this._counter=0;const{step:t}=this.model,i=e=>{if(this._counter+=1,this._counter%5==0){const t=Math.floor(this._counter/5);t<10?(clearInterval(this._interval_handle),this._interval_handle=setInterval(()=>i(e),this._interval/(t+1))):t>=10&&t<=13&&(clearInterval(this._interval_handle),this._interval_handle=setInterval(()=>i(2*e),this._interval/10))}this.increment(e)};this._interval_handle=setInterval(()=>i(e*t),this._interval)}_stop_incrementation(){clearInterval(this._interval_handle),this.model.value_throttled=this.model.value}_btn_mouse_down(e){e.preventDefault();const t=e.currentTarget===this.btn_up_el?1:-1;this.increment(t*this.model.step),this.input_el.focus(),this._start_incrementation(t)}_btn_mouse_up(){this._stop_incrementation()}_btn_mouse_leave(){this._stop_incrementation()}_input_mouse_wheel(e){if(document.activeElement===this.input_el){e.preventDefault();const t=e.deltaY>0?-1:1;this.increment(t*this.model.step)}}_input_key_down(e){switch(e.keyCode){case r.Keys.Up:return e.preventDefault(),this.increment(this.model.step);case r.Keys.Down:return e.preventDefault(),this.increment(-this.model.step);case r.Keys.PageUp:return e.preventDefault(),this.increment(this.model.page_step_multiplier*this.model.step);case r.Keys.PageDown:return e.preventDefault(),this.increment(-this.model.page_step_multiplier*this.model.step)}}adjust_to_precision(e){return this.bound_value(Number(e.toFixed(this.precision)))}increment(e){const{low:t,high:i}=this.model;null==this.model.value?e>0?this.model.value=null!=t?t:null!=i?o(0,i):0:e<0&&(this.model.value=null!=i?i:null!=t?_(t,0):0):this.model.value=this.adjust_to_precision(this.model.value+e)}change_input(){super.change_input(),this.model.value_throttled=this.model.value}}i.SpinnerView=p,p.__name__="SpinnerView";class d extends s.NumericInput{constructor(e){super(e)}static init_Spinner(){this.prototype.default_view=p,this.define({value_throttled:[l.Number,null],step:[l.Number,1],page_step_multiplier:[l.Number,10],wheel_wait:[l.Number,100]}),this.override({mode:"float"})}}i.Spinner=d,d.__name__="Spinner",d.init_Spinner()},
451: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(410),l=e(72),h=s.__importStar(e(18)),o=e(412);class a extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.value.change,()=>this.input_el.value=this.model.value),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder),this.connect(this.model.properties.rows.change,()=>this.input_el.rows=this.model.rows),this.connect(this.model.properties.cols.change,()=>this.input_el.cols=this.model.cols),this.connect(this.model.properties.max_length.change,()=>this.input_el.maxLength=this.model.max_length)}render(){super.render(),this.input_el=l.textarea({class:o.bk_input,name:this.model.name,disabled:this.model.disabled,placeholder:this.model.placeholder,cols:this.model.cols,rows:this.model.rows,maxLength:this.model.max_length}),this.input_el.textContent=this.model.value,this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){this.model.value=this.input_el.value,super.change_input()}}i.TextAreaInputView=a,a.__name__="TextAreaInputView";class p extends n.InputWidget{constructor(e){super(e)}static init_TextAreaInput(){this.prototype.default_view=a,this.define({value:[h.String,""],value_input:[h.String,""],placeholder:[h.String,""],cols:[h.Number,20],rows:[h.Number,2],max_length:[h.Number,500]})}}i.TextAreaInput=p,p.__name__="TextAreaInput",p.init_TextAreaInput()},
452: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),c=e(404),o=e(72),a=s.__importStar(e(18)),n=e(173);class l extends c.AbstractButtonView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._update_active())}render(){super.render(),this._update_active()}click(){this.model.active=!this.model.active,super.click()}_update_active(){o.classes(this.button_el).toggle(n.bk_active,this.model.active)}}i.ToggleView=l,l.__name__="ToggleView";class _ extends c.AbstractButton{constructor(e){super(e)}static init_Toggle(){this.prototype.default_view=l,this.define({active:[a.Boolean,!1]}),this.override({label:"Toggle"})}}i.Toggle=_,_.__name__="Toggle",_.init_Toggle()},
}, 402, {"models/widgets/main":402,"models/widgets/index":403,"models/widgets/abstract_button":404,"models/widgets/control":405,"models/widgets/widget":472,"models/widgets/abstract_icon":407,"models/widgets/autocomplete_input":408,"models/widgets/text_input":409,"models/widgets/input_widget":410,"styles/widgets/inputs.css":411,"styles/widgets/inputs":412,"models/widgets/button":413,"models/widgets/checkbox_button_group":414,"models/widgets/button_group":415,"models/widgets/checkbox_group":416,"models/widgets/input_group":417,"models/widgets/color_picker":418,"models/widgets/date_picker":419,"styles/widgets/flatpickr.css":421,"models/widgets/date_range_slider":422,"models/widgets/abstract_slider":423,"styles/widgets/sliders":425,"styles/widgets/nouislider.css":426,"styles/widgets/sliders.css":427,"models/widgets/date_slider":428,"models/widgets/div":429,"models/widgets/markup":430,"styles/clearfix":431,"styles/clearfix.css":432,"models/widgets/dropdown":433,"models/widgets/file_input":434,"models/widgets/multiselect":435,"models/widgets/paragraph":436,"models/widgets/password_input":437,"models/widgets/multichoice":438,"styles/widgets/choices.css":440,"models/widgets/numeric_input":441,"api/linalg":442,"core/util/random":443,"models/widgets/pretext":444,"models/widgets/radio_button_group":445,"models/widgets/radio_group":446,"models/widgets/range_slider":447,"models/widgets/selectbox":448,"models/widgets/slider":449,"models/widgets/spinner":450,"models/widgets/textarea_input":451,"models/widgets/toggle":452}, {});
})

