# This file auto-generated by `generate_schema_interface.py`.
# Do not modify this file directly.

import traitlets as T

from .. import _interface as schema

from .named_channels import Color, Column, Detail, Label, Opacity, Order, Path, Row, Shape, Size, Text, X, Y


class Encoding(schema.Encoding):
    """Object for storing channel encodings

    Attributes
    ----------
    color: Color
        Color of the marks - either fill or stroke color based on mark type.
    column: Column
        Horizontal facets for trellis plots.
    detail: Union(Detail, List(Detail))
        Additional levels of detail for grouping data in aggregate views and in line and area marks without mapping data to a specific visual channel.
    label: Label
        
    opacity: Opacity
        Opacity of the marks - either can be a value or in a range.
    order: Union(Order, List(Order))
        Layer order for non-stacked marks, or stack order for stacked marks.
    path: Union(Path, List(Path))
        Order of data points in line marks.
    row: Row
        Vertical facets for trellis plots.
    shape: Shape
        The symbol's shape (only for `point` marks).
    size: Size
        Size of the mark.
    text: Text
        Text of the `text` mark.
    x: X
        X coordinates for `point`, `circle`, `square`, `line`, `rule`, `text`, and `tick` (or to width and height for `bar` and `area` marks).
    y: Y
        Y coordinates for `point`, `circle`, `square`, `line`, `rule`, `text`, and `tick` (or to width and height for `bar` and `area` marks).
    """
    color = T.Instance(Color, allow_none=True, default_value=None, help="""Color of the marks - either fill or stroke color based on mark type.""")
    column = T.Instance(Column, allow_none=True, default_value=None, help="""Horizontal facets for trellis plots.""")
    detail = T.Union([T.Instance(Detail, allow_none=True, default_value=None, help="""Interface for any kind of FieldDef."""), T.List(T.Instance(Detail, help="""Interface for any kind of FieldDef."""), allow_none=True, default_value=None)])
    label = T.Instance(Label, allow_none=True, default_value=None)
    opacity = T.Instance(Opacity, allow_none=True, default_value=None, help="""Opacity of the marks - either can be a value or in a range.""")
    order = T.Union([T.Instance(Order, allow_none=True, default_value=None), T.List(T.Instance(Order), allow_none=True, default_value=None)])
    path = T.Union([T.Instance(Path, allow_none=True, default_value=None), T.List(T.Instance(Path), allow_none=True, default_value=None)])
    row = T.Instance(Row, allow_none=True, default_value=None, help="""Vertical facets for trellis plots.""")
    shape = T.Instance(Shape, allow_none=True, default_value=None, help="""The symbol's shape (only for `point` marks).""")
    size = T.Instance(Size, allow_none=True, default_value=None, help="""Size of the mark.""")
    text = T.Instance(Text, allow_none=True, default_value=None, help="""Text of the `text` mark.""")
    x = T.Instance(X, allow_none=True, default_value=None, help="""X coordinates for `point`, `circle`, `square`, `line`, `rule`, `text`, and `tick` (or to width and height for `bar` and `area` marks).""")
    y = T.Instance(Y, allow_none=True, default_value=None, help="""Y coordinates for `point`, `circle`, `square`, `line`, `rule`, `text`, and `tick` (or to width and height for `bar` and `area` marks).""")
    
    channel_names = ['color', 'column', 'detail', 'label', 'opacity', 'order', 'path', 'row', 'shape', 'size', 'text', 'x', 'y']
    skip = ['channel_names']


class Facet(schema.Facet):
    """Object for storing channel encodings

    Attributes
    ----------
    column: Column
        
    row: Row
        
    """
    column = T.Instance(Column, allow_none=True, default_value=None)
    row = T.Instance(Row, allow_none=True, default_value=None)
    
    channel_names = ['column', 'row']
    skip = ['channel_names']


