# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_rpm.configuration import Configuration


class RpmRepositorySyncURL(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'remote': 'str',
        'mirror': 'bool',
        'sync_policy': 'SyncPolicyEnum',
        'skip_types': 'list[SkipTypesEnum]',
        'optimize': 'bool'
    }

    attribute_map = {
        'remote': 'remote',
        'mirror': 'mirror',
        'sync_policy': 'sync_policy',
        'skip_types': 'skip_types',
        'optimize': 'optimize'
    }

    def __init__(self, remote=None, mirror=None, sync_policy=None, skip_types=[], optimize=True, local_vars_configuration=None):  # noqa: E501
        """RpmRepositorySyncURL - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._remote = None
        self._mirror = None
        self._sync_policy = None
        self._skip_types = None
        self._optimize = None
        self.discriminator = None

        if remote is not None:
            self.remote = remote
        self.mirror = mirror
        self.sync_policy = sync_policy
        if skip_types is not None:
            self.skip_types = skip_types
        if optimize is not None:
            self.optimize = optimize

    @property
    def remote(self):
        """Gets the remote of this RpmRepositorySyncURL.  # noqa: E501

        A remote to sync from. This will override a remote set on repository.  # noqa: E501

        :return: The remote of this RpmRepositorySyncURL.  # noqa: E501
        :rtype: str
        """
        return self._remote

    @remote.setter
    def remote(self, remote):
        """Sets the remote of this RpmRepositorySyncURL.

        A remote to sync from. This will override a remote set on repository.  # noqa: E501

        :param remote: The remote of this RpmRepositorySyncURL.  # noqa: E501
        :type: str
        """

        self._remote = remote

    @property
    def mirror(self):
        """Gets the mirror of this RpmRepositorySyncURL.  # noqa: E501

        DEPRECATED: If ``True``, ``sync_policy`` will default to 'mirror_complete' instead of 'additive'.  # noqa: E501

        :return: The mirror of this RpmRepositorySyncURL.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this RpmRepositorySyncURL.

        DEPRECATED: If ``True``, ``sync_policy`` will default to 'mirror_complete' instead of 'additive'.  # noqa: E501

        :param mirror: The mirror of this RpmRepositorySyncURL.  # noqa: E501
        :type: bool
        """

        self._mirror = mirror

    @property
    def sync_policy(self):
        """Gets the sync_policy of this RpmRepositorySyncURL.  # noqa: E501

        Options: 'additive', 'mirror_complete', 'mirror_content_only'. Default: 'additive'. Modifies how the sync is performed. 'mirror_complete' will clone the original metadata and create an automatic publication from it, but comes with some limitations and does not work for certain repositories. 'mirror_content_only' will change the repository contents to match the remote but the metadata will be regenerated and will not be bit-for-bit identical. 'additive' will retain the existing contents of the repository and add the contents of the repository being synced.  # noqa: E501

        :return: The sync_policy of this RpmRepositorySyncURL.  # noqa: E501
        :rtype: SyncPolicyEnum
        """
        return self._sync_policy

    @sync_policy.setter
    def sync_policy(self, sync_policy):
        """Sets the sync_policy of this RpmRepositorySyncURL.

        Options: 'additive', 'mirror_complete', 'mirror_content_only'. Default: 'additive'. Modifies how the sync is performed. 'mirror_complete' will clone the original metadata and create an automatic publication from it, but comes with some limitations and does not work for certain repositories. 'mirror_content_only' will change the repository contents to match the remote but the metadata will be regenerated and will not be bit-for-bit identical. 'additive' will retain the existing contents of the repository and add the contents of the repository being synced.  # noqa: E501

        :param sync_policy: The sync_policy of this RpmRepositorySyncURL.  # noqa: E501
        :type: SyncPolicyEnum
        """

        self._sync_policy = sync_policy

    @property
    def skip_types(self):
        """Gets the skip_types of this RpmRepositorySyncURL.  # noqa: E501

        List of content types to skip during sync.  # noqa: E501

        :return: The skip_types of this RpmRepositorySyncURL.  # noqa: E501
        :rtype: list[SkipTypesEnum]
        """
        return self._skip_types

    @skip_types.setter
    def skip_types(self, skip_types):
        """Sets the skip_types of this RpmRepositorySyncURL.

        List of content types to skip during sync.  # noqa: E501

        :param skip_types: The skip_types of this RpmRepositorySyncURL.  # noqa: E501
        :type: list[SkipTypesEnum]
        """

        self._skip_types = skip_types

    @property
    def optimize(self):
        """Gets the optimize of this RpmRepositorySyncURL.  # noqa: E501

        Whether or not to optimize sync.  # noqa: E501

        :return: The optimize of this RpmRepositorySyncURL.  # noqa: E501
        :rtype: bool
        """
        return self._optimize

    @optimize.setter
    def optimize(self, optimize):
        """Sets the optimize of this RpmRepositorySyncURL.

        Whether or not to optimize sync.  # noqa: E501

        :param optimize: The optimize of this RpmRepositorySyncURL.  # noqa: E501
        :type: bool
        """

        self._optimize = optimize

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RpmRepositorySyncURL):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RpmRepositorySyncURL):
            return True

        return self.to_dict() != other.to_dict()
