# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ancv', 'ancv.data', 'ancv.data.models', 'ancv.visualization', 'ancv.web']

package_data = \
{'': ['*']}

install_requires = \
['Babel>=2.10.3,<3.0.0',
 'aiohttp[speedups]>=3.8.1,<4.0.0',
 'cachetools>=5.2.0,<6.0.0',
 'gidgethub>=5.1.0,<6.0.0',
 'humanize>=4.1.0,<5.0.0',
 'pydantic[email]>=1.9.1,<2.0.0',
 'rich>=12.4.4,<13.0.0',
 'structlog>=21.5,<23.0',
 'typer>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['ancv = ancv.__main__:app']}

setup_kwargs = {
    'name': 'ancv',
    'version': '1.1.0',
    'description': 'Renders your (JSON) resume/CV for online & pretty terminal display',
    'long_description': '# [ancv](https://github.com/alexpovel/ancv)\n\nGetting your resume aka [an CV](https://youtu.be/mJUtMEJdvqM?t=16) (*[ANSI](https://en.wikipedia.org/wiki/ANSI_escape_code)-v* 🤡) straight to your and anyone else\'s terminals:\n\n![showcase cv terminal output](docs/images/showcase.svg)\n\n---\n\nBe warned though, for this is kinda useless and just for fun:\n\n<p align="center">\n   <img src="docs/images/users-venn.svg" alt="users venn diagram">\n</p>\n\n## Getting started\n\n1. Create your resume according to the [JSON Resume Schema](https://jsonresume.org/schema/) (see also the [schema specification](https://github.com/jsonresume/resume-schema/blob/master/schema.json)) either:\n\n   - manually (see [the `heyho` sample](./ancv/data/showcase.resume.json) for a possible starting point),\n   - exporting from [LinkedIn](https://www.linkedin.com/) using [Joshua Tzucker\'s LinkedIn exporter](https://joshuatz.com/projects/web-stuff/linkedin-profile-to-json-resume-exporter/) ([repo](https://github.com/joshuatz/linkedin-to-jsonresume))[^1], or\n   - exporting from one of the platforms advertised as offering [JSON resume integration](https://jsonresume.org/schema/).\n2. [Create a **public** gist](https://gist.github.com/) named `resume.json` with your resume contents.\n3. You\'re now the proud owner of an ancv.\n   Time to try it out.\n\n   The following examples work out-of-the-box.\n   **Replace `heyho` with your GitHub username** once you\'re all set up.\n\n   - curl:\n\n      ```bash\n      curl -L ancv.io/heyho\n      ```\n\n      with `-L` being shorthand for [`--location`](https://curl.se/docs/manpage.html), allowing you to follow the redirect from `http://ancv.io` through to `https://ancv.io`.\n      It\'s shorter than its also perfectly viable alternative:\n\n      ```bash\n      curl https://ancv.io/heyho\n      ```\n\n      Lastly, you might want to page the output for easiest reading, top-to-bottom:\n\n      ```bash\n      curl -sL ancv.io/heyho | less\n      ```\n\n      If that garbles the rendered output, try `less -r` aka [`--raw-control-chars`](https://man7.org/linux/man-pages/man1/less.1.html).\n\n   - wget:\n\n     ```bash\n     wget -O - --quiet ancv.io/heyho\n     ```\n\n     where `-O` is short for [`--output-document`](https://linux.die.net/man/1/wget), used here to redirect to stdout.\n\n   - PowerShell 7:\n\n     ```powershell\n     (iwr ancv.io/heyho).Content\n     ```\n\n     where `iwr` is an alias for [`Invoke-Webrequest`](https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/invoke-webrequest?view=powershell-7.2), returning an object whose `Content` we access.\n   - PowerShell 5:\n\n     ```powershell\n     (iwr -UseBasicParsing ancv.io/heyho).Content\n     ```\n\n     where `-UseBasicParsing` is *only* required if you haven\'t set up Internet Explorer yet ([yes, really](https://stackoverflow.com/q/38005341/11477374)).\n     If you have, then it works as PowerShell 7 (where that flag is deprecated and the default anyway).\n\n## Configuration\n\n*All configuration is optional.*\n\nThe CV is constructed as follows:\n\n![conceptual flow chart](docs/images/concept-flow-chart.svg)\n\nIn summary:\n\n- you control:\n  - the base layout using a *template*: order of items, indentations, text alignment, position of dates and much more.\n    Templates are like layouts/skeletons.\n  - colors, italics, boldface, underlining, blinking (yes, really) and more using a *theme*. A couple exist but you can easily add your own one.\n  - almost all text, save for strings like *Education*, names of months etc. These are governed by *translations*, of which there are a couple available already.\n  - text content like emojis and newlines to control paragraph breaks.\n\n    Emojis are user-controlled: if you want them, use them in your `resume.json`; in the future, there might be *templates* with emojis baked in, but you\'d have to actively opt into using one.\n  - date formatting, in a limited fashion through the `dec31_as_year` toggle.\n    If that toggle is `true`, dates in the format `YYYY-12-31` will be displayed as `YYYY` only.\n  - lastly, there\'s a toggle for ASCII-only output.\n\n    It only concerns the *template* and controls the drawing of boxes and such (e.g., [`-`](https://unicode-table.com/en/002D/) versus [`─`](https://unicode-table.com/en/2500/) : only the latter will produce gapless rules).\n    If you yourself use non-ASCII characters in your texts, use a *language* containing non-ASCII characters (Spanish, French, ...) or a *theme* with non-ASCII characters (e.g., a theme might use the `•` character to print bullet points), non-ASCII Unicode will still occur.\n    As such, this toggle currently isn\'t very powerful, but with some care it *does* ultimately allow you to be ASCII-only.\n\n  If you come up with new templates, themes or translations, a PR would be highly appreciated.\n- you *do not* control:\n  - anything about a viewer\'s terminal!\n\n    Any recent terminal will support a baseline of features (e.g., colors), but large parts of the functionalities depend on the *font* used: proper Unicode support is needed for pretty output (see `ascii_only`), and ideally emojis if you\'re into that (although it\'s easy to pick an emoji-free template).\n    Many themes leverage Unicode characters as well.\n  - access to your CV: like the gist itself, it will be publicly available on GitHub.\n\nThe components may be controlled using the `ancv` field in your `resume.json`:\n\n```json\n{\n   "meta": {\n     "ancv": {\n        "template": "Sequential",\n        "theme": "lollipop",\n        "ascii_only": false,\n        "language": "en",\n        "dec31_as_year": false\n     }\n   }\n}\n```\n\nThe shown values are the default ones.\nAll fields, including the `ancv` one itself, are optional, and the above defaults will be set for omitted fields.\nThis means **a [valid JSON resume](https://github.com/jsonresume/resume-schema/blob/master/schema.json) (without an `ancv` section) is valid already**.\n\nThe currently available options are:\n\n```bash\n$ pip install ancv >> /dev/null && ancv list\nComponents\n├── Templates\n│   └── Sequential\n├── Themes\n│   ├── plain\n│   ├── grayscale\n│   ├── basic\n│   ├── lollipop\n│   └── hendrix\n└── Translations\n    ├── en\n    ├── de\n    ├── es\n    └── fr\n```\n\n## Installation\n\n### As a library\n\nInstall the package as usual:\n\n```bash\npip install ancv\n```\n\nThis also allows you to import whatever you could want or need from the package, if anything.\nNote that it\'s pretty heavy on the dependencies.\n\n### As a container\n\nSee also the available [packages aka images](https://github.com/alexpovel/ancv/pkgs/container/ancv):\n\n```bash\ndocker pull ghcr.io/alexpovel/ancv\n```\n\nVersioned tags (so you can pin a major) are available.\n\n### Local usage\n\nOnce installed, you could for example check whether your `resume.json` is valid at all (`validate`) or get a glimpse at the final product (`render`):\n\n```bash\n# pip route:\n$ ancv render resume.json\n# container route:\n$ docker run -v $(pwd)/resume.json:/app/resume.json ghcr.io/alexpovel/ancv render\n```\n\n## Self-hosting\n\nSelf-hosting is a first-class citizen here.\n\n### Context: Cloud Hosting\n\nThe <https://ancv.io> site is hosted on [Google Cloud Run](https://cloud.google.com/run) (serverless) and deployed there [automatically](https://github.com/alexpovel/ancv/runs/8172131447), such that the latest release you see here is also the code executing in that cloud environment.\nThat\'s convenient to get started: simply create a `resume.json` gist and you\'re good to go within minutes.\nIt can also be used for debugging and playing around; it\'s a playground of sorts.\n\nYou\'re invited to use this service for as much and as long as you\'d like.\nHowever, obviously, as an individual I cannot guarantee its availability in perpetuity.\nYou might also feel uncomfortable uploading your CV onto GitHub, since it *has* to be public for this whole exercise to work.\nLastly, you might also be suspicious of me inserting funny business into your CV before serving it out.\nIf this is you, self-hosting is for you.\n\n### Setup\n\nFor simplicity, using Docker Compose (with Docker\'s recent [Compose CLI plugin](https://docs.docker.com/compose/install/compose-plugin/)):\n\n1. Clone this repository onto your server (or fork it, make your edits and clone that)\n2. `cd self-hosting`\n3. Edit [Caddy\'s config file](./self-hosting/Caddyfile) ([more info](https://caddyserver.com/docs/caddyfile)) to contain your own domain name\n4. Place your `resume.json` into the directory\n5. Run `docker compose up`\n\nCaddy (chosen here for simplicity) will handle HTTPS automatically for you, but will of course require domain names to be set up correctly to answer ACME challenges.\nHandling DNS is up to you; for dynamic DNS, I can recommend [`qmcgaw/ddns-updater`](https://github.com/qdm12/ddns-updater).\n\nIf you self-host in the cloud, the server infrastructure might be taken care of for you by your provider already (as is the case for Google Cloud Run).\nIn these cases, a dedicated proxy is unnecessary and a single [Dockerfile](./Dockerfile) might suffice (adjusted to your needs).\nTrue [serverless](https://www.serverless.com/) is also a possibility and an excellent fit here.\nFor example, one could use [Digital Ocean\'s *Functions*](https://docs.digitalocean.com/products/functions/).\nIf you go that route and succeed, please let me know! (I had given up with how depressingly hard dependency management was, as opposed to tried-and-tested container images.)\n\n---\n\n<p align="center">\n   <a href="https://github.com/alexpovel/ancv">\n     <img src="https://github.githubassets.com/images/modules/site/icons/footer/github-mark.svg" alt="github logo">\n   </a>\n</p>\n\n[^1]: The exporter has a couple caveats.\n  You will probably not be able to paste its result into a gist and have it work out of the box.\n  It is recommended to paste the export into an editor capable of helping you find errors against the contained `$schema`, like VS Code.\n  Alternatively, a local `ancv render your-file.json` will print `pydantic` validation errors, which might be helpful in debugging.\n  For example, the exporter might leave `$.basics.url` an empty string, which isn\'t a valid URI and therefore fails the schema and, by extension, `ancv`.\n  Similarly, `endDate` keys might get empty string values.\n  **Remove these entries** entirely to stay conformant to the JSON Resume Schema (to which `ancv` stays conformant).\n',
    'author': 'Alex Povel',
    'author_email': 'python@alexpovel.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://ancv.io',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
