/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.summary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ansj.app.keyword.KeyWordComputer;
import org.ansj.app.keyword.Keyword;
import org.ansj.app.summary.pojo.Summary;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.nlpcn.commons.lang.tire.SmartGetWord;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.MapCount;

public class SummaryComputer {
    private static final Set<String> FILTER_SET = new HashSet<String>();
    private int len = 300;
    private boolean isSplitSummary = true;
    String title;
    String content;

    public SummaryComputer(String title, String content) {
        this.title = title;
        this.content = content;
    }

    public SummaryComputer(int len, String title, String content) {
        this.len = len;
        this.title = title;
        this.content = content;
    }

    public SummaryComputer(int len, boolean isSplitSummary, String title, String content) {
        this.len = len;
        this.title = title;
        this.content = content;
        this.isSplitSummary = isSplitSummary;
    }

    public Summary toSummary() {
        return this.toSummary(new ArrayList<Keyword>());
    }

    public Summary toSummary(String query) {
        List<Term> parse = NlpAnalysis.parse(query).getTerms();
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (Term term : parse) {
            if (FILTER_SET.contains(term.natrue().natureStr)) continue;
            keywords.add(new Keyword(term.getName(), term.termNatures().allFreq, 1.0));
        }
        return this.toSummary(keywords);
    }

    public Summary toSummary(List<Keyword> keywords) {
        if (keywords == null) {
            keywords = new ArrayList<Keyword>();
        }
        if (keywords.size() == 0) {
            KeyWordComputer kc = new KeyWordComputer(10);
            keywords = kc.computeArticleTfidf(this.title, this.content);
        }
        return this.explan(keywords, this.content);
    }

    private Summary explan(List<Keyword> keywords, String content) {
        SmartForest<Double> sf = new SmartForest<Double>();
        for (Keyword keyword : keywords) {
            sf.add(keyword.getName(), keyword.getScore());
        }
        List<Sentence> sentences = this.toSentenceList(content.toCharArray());
        for (Sentence sentence : sentences) {
            this.computeScore(sentence, sf);
        }
        double d = 0.0;
        int maxIndex = 0;
        MapCount mc = new MapCount();
        for (int i = 0; i < sentences.size(); ++i) {
            double tempScore = sentences.get(i).score;
            int tempLength = sentences.get((int)i).value.length();
            mc.addAll(sentences.get(i).mc.get());
            if (tempLength >= this.len) {
                if (d < (tempScore *= (double)mc.get().size())) {
                    d = tempScore;
                    maxIndex = i;
                    continue;
                }
                mc.get().clear();
            }
            for (int j = i + 1; j < sentences.size(); ++j) {
                tempScore += sentences.get(j).score;
                mc.addAll(sentences.get(j).mc.get());
                if ((tempLength += sentences.get((int)j).value.length()) < this.len) continue;
                if (d < (tempScore *= (double)mc.get().size())) {
                    d = tempScore;
                    maxIndex = i;
                }
                mc.get().clear();
                break;
            }
            if (tempLength >= this.len) continue;
            if (d < (tempScore *= (double)mc.get().size())) {
                d = tempScore;
                maxIndex = i;
                break;
            }
            mc.get().clear();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = maxIndex; i < sentences.size(); ++i) {
            sb.append(sentences.get((int)i).value);
            if (sb.length() > this.len) break;
        }
        String summaryStr = sb.toString();
        if (this.isSplitSummary && sb.length() > this.len) {
            double value = this.len;
            StringBuilder newSummary = new StringBuilder();
            char c = '\u0000';
            for (int i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                value = c < '\u0100' ? (value -= 0.5) : (value -= 1.0);
                if (value < 0.0) break;
                newSummary.append(c);
            }
            summaryStr = newSummary.toString();
        }
        return new Summary(keywords, summaryStr);
    }

    private void computeScore(Sentence sentence, SmartForest<Double> forest) {
        SmartGetWord<Double> sgw = new SmartGetWord<Double>(forest, sentence.value);
        String name = null;
        while ((name = sgw.getFrontWords()) != null) {
            sentence.updateScore(name, sgw.getParam());
        }
        if (sentence.score == 0.0) {
            sentence.score = (double)sentence.value.length() * -0.005;
        } else {
            Sentence sentence2 = sentence;
            sentence2.score = sentence2.score / Math.log(sentence.value.length() + 3);
        }
    }

    public List<Sentence> toSentenceList(char[] chars) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        block4: for (int i = 0; i < chars.length; ++i) {
            if (sb.length() == 0 && (Character.isWhitespace(chars[i]) || chars[i] == '\u00a0')) continue;
            sb.append(chars[i]);
            switch (chars[i]) {
                case '.': {
                    if (i >= chars.length - 1 || chars[i + 1] <= '\u0080') continue block4;
                    this.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case ',': 
                case ';': 
                case '?': 
                case '\u00a0': 
                case '\u3002': 
                case '\uff01': 
                case '\uff0c': 
                case '\uff1b': 
                case '\uff1f': {
                    this.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                }
            }
        }
        if (sb.length() > 0) {
            this.insertIntoList(sb, sentences);
        }
        return sentences;
    }

    private void insertIntoList(StringBuilder sb, List<Sentence> sentences) {
        String content = sb.toString().trim();
        if (content.length() > 0) {
            sentences.add(new Sentence(content));
        }
    }

    static {
        FILTER_SET.add("w");
        FILTER_SET.add("null");
    }

    class Sentence {
        String value;
        private double score;
        private MapCount<String> mc = new MapCount();

        public Sentence(String value) {
            this.value = value.trim();
        }

        public void updateScore(String name, double score) {
            this.mc.add(name);
            Double size = this.mc.get().get(name);
            this.score += score / size;
        }

        public String toString() {
            return this.value;
        }
    }
}

