/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.DicReader;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.name.PersonAttrLibrary;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.dat.DoubleArrayTire;
import org.nlpcn.commons.lang.dat.Item;

public class DATDictionary {
    public static final char[] IN_SYSTEM = new char[65536];
    private static final DoubleArrayTire DAT = DATDictionary.loadDAT();
    public static int arrayLength = DATDictionary.DAT.arrayLength;

    private static DoubleArrayTire loadDAT() {
        long start = System.currentTimeMillis();
        try {
            DoubleArrayTire dat = DoubleArrayTire.loadText(DicReader.getInputStream("core.dic"), AnsjItem.class);
            DATDictionary.personNameFull(dat);
            for (Item item : dat.getDAT()) {
                if (item == null || item.getName() == null) continue;
                if (item.getStatus() < 4) {
                    for (int i = 0; i < item.getName().length(); ++i) {
                        DATDictionary.IN_SYSTEM[item.getName().charAt((int)i)] = item.getName().charAt(i);
                    }
                }
                if (item.getStatus() >= 2) continue;
                item.setName(null);
            }
            DATDictionary.IN_SYSTEM[65285] = 37;
            MyStaticValue.LIBRARYLOG.info("init core library ok use time :{}", (Object)(System.currentTimeMillis() - start));
            return dat;
        }
        catch (InstantiationException e) {
            MyStaticValue.LIBRARYLOG.warn("\u65e0\u6cd5\u5b9e\u4f8b\u5316", e);
        }
        catch (IllegalAccessException e) {
            MyStaticValue.LIBRARYLOG.warn("\u975e\u6cd5\u8bbf\u95ee", e);
        }
        catch (NumberFormatException e) {
            MyStaticValue.LIBRARYLOG.warn("\u6570\u5b57\u683c\u5f0f\u5f02\u5e38", e);
        }
        catch (IOException e) {
            MyStaticValue.LIBRARYLOG.warn("IO\u5f02\u5e38", e);
        }
        return null;
    }

    private static void personNameFull(DoubleArrayTire dat) throws NumberFormatException, IOException {
        HashMap<String, PersonNatureAttr> personMap = new PersonAttrLibrary().getPersonMap();
        AnsjItem ansjItem = null;
        Set<Map.Entry<String, PersonNatureAttr>> entrySet = personMap.entrySet();
        int c = 0;
        String temp = null;
        for (Map.Entry<String, PersonNatureAttr> entry : entrySet) {
            temp = entry.getKey();
            if (temp.length() == 1 && (ansjItem = (AnsjItem)dat.getDAT()[temp.charAt(0)]) == null) {
                ansjItem = new AnsjItem();
                ansjItem.setBase(c);
                ansjItem.setCheck(-1);
                ansjItem.setStatus((byte)3);
                ansjItem.setName(temp);
                dat.getDAT()[temp.charAt((int)0)] = ansjItem;
            } else {
                ansjItem = (AnsjItem)dat.getItem(temp);
            }
            if (ansjItem == null) continue;
            if (ansjItem.termNatures == null) {
                ansjItem.termNatures = temp.length() == 1 && temp.charAt(0) < '\u0100' ? TermNatures.NULL : new TermNatures(TermNature.NR);
            }
            ansjItem.termNatures.setPersonNatureAttr(entry.getValue());
        }
    }

    public static int status(char c) {
        AnsjItem item = (AnsjItem)DAT.getDAT()[c];
        if (item == null) {
            return 0;
        }
        return item.getStatus();
    }

    public static boolean isInSystemDic(String word) {
        Object item = DAT.getItem(word);
        return item != null && ((Item)item).getStatus() > 1;
    }

    public static AnsjItem getItem(int index) {
        AnsjItem item = (AnsjItem)DAT.getItem(index);
        if (item == null) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static AnsjItem getItem(String str) {
        AnsjItem item = (AnsjItem)DAT.getItem(str);
        if (item == null) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static int getId(String str) {
        return DAT.getId(str);
    }
}

