/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import org.ansj.domain.Nature;
import org.ansj.domain.Term;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatureLibrary {
    public static final Logger logger = LoggerFactory.getLogger(NatureLibrary.class);
    private static final int YI = 1;
    private static final int FYI = -1;
    private static final HashMap<String, Nature> NATUREMAP = new HashMap();
    private static int[][] NATURETABLE = null;

    private static void init() {
        Throwable throwable;
        BufferedReader reader;
        String split = "\t";
        int maxLength = 0;
        String temp = null;
        String[] strs = null;
        try {
            reader = MyStaticValue.getNatureMapReader();
            throwable = null;
            try {
                int p0 = 0;
                int p1 = 0;
                int p2 = 0;
                while ((temp = reader.readLine()) != null) {
                    strs = temp.split(split);
                    if (strs.length != 4) continue;
                    p0 = Integer.parseInt(strs[0]);
                    p1 = Integer.parseInt(strs[1]);
                    p2 = Integer.parseInt(strs[3]);
                    NATUREMAP.put(strs[2], new Nature(strs[2], p0, p1, p2));
                    maxLength = Math.max(maxLength, p1);
                }
            }
            catch (Throwable p0) {
                throwable = p0;
                throw p0;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable p0) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("\u8bcd\u6027\u5217\u8868\u52a0\u8f7d\u5931\u8d25!", e);
        }
        try {
            reader = MyStaticValue.getNatureTableReader();
            throwable = null;
            try {
                NATURETABLE = new int[maxLength + 1][maxLength + 1];
                int j = 0;
                while ((temp = reader.readLine()) != null) {
                    if (StringUtil.isBlank(temp)) continue;
                    strs = temp.split(split);
                    for (int i = 0; i < strs.length; ++i) {
                        NatureLibrary.NATURETABLE[j][i] = Integer.parseInt(strs[i]);
                    }
                    ++j;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("\u52a0\u8f7d\u8bcd\u6027\u5173\u7cfb\u5931\u8d25!", e);
        }
    }

    public static int getTwoNatureFreq(Nature from, Nature to) {
        if (from.index < 0 || to.index < 0) {
            return 0;
        }
        return NATURETABLE[from.index][to.index];
    }

    public static int getTwoTermFreq(Term fromTerm, Term toTerm) {
        Nature from = fromTerm.natrue();
        Nature to = toTerm.natrue();
        if (from.index < 0 || to.index < 0) {
            return 0;
        }
        return NATURETABLE[from.index][to.index];
    }

    public static Nature getNature(String natureStr) {
        Nature nature = NATUREMAP.get(natureStr);
        if (nature == null) {
            nature = new Nature(natureStr, -1, -1, 1);
            NATUREMAP.put(natureStr, nature);
            return nature;
        }
        return nature;
    }

    static {
        NatureLibrary.init();
    }
}

