/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.recognition.Recognition;

public class FilterRecognition
implements Recognition {
    private Set<String> filter = new HashSet<String>();
    private Set<String> natureFilter = new HashSet<String>();
    private List<Pattern> regexList = new ArrayList<Pattern>();

    public void insertStopWords(List<String> filterWords) {
        this.filter.addAll(filterWords);
    }

    public void insertStopWord(String ... filterWord) {
        for (String word : filterWord) {
            this.filter.add(word);
        }
    }

    public void insertStopNatures(String ... filterNatures) {
        for (String natureStr : filterNatures) {
            this.natureFilter.add(natureStr);
        }
    }

    public void insertStopRegex(String regex) {
        this.regexList.add(Pattern.compile(regex));
    }

    @Override
    public void recognition(Result result) {
        List<Term> list = result.getTerms();
        Iterator<Term> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Term term = iterator.next();
            if (this.filter.size() > 0 && this.filter.contains(term.getName())) {
                iterator.remove();
                continue;
            }
            if (this.natureFilter.size() > 0 && this.natureFilter.contains(term.natrue().natureStr)) {
                iterator.remove();
                continue;
            }
            if (this.regexList.size() <= 0) continue;
            for (Pattern stopwordPattern : this.regexList) {
                if (!stopwordPattern.matcher(term.getName()).matches()) continue;
                iterator.remove();
                continue block0;
            }
        }
    }
}

