/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ansj.domain.Nature;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.NatureLibrary;
import org.ansj.library.company.CompanyAttrLibrary;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;

public class TermUtil {
    private static final HashMap<String, int[]> companyMap = CompanyAttrLibrary.getCompanyMap();

    public static Term makeNewTermNum(Term from, Term to, TermNatures termNatures) {
        Term term = new Term(from.getName() + to.getName(), from.getOffe(), termNatures);
        term.termNatures().numAttr = from.termNatures().numAttr;
        TermUtil.termLink(term, to.to());
        TermUtil.termLink(term.from(), term);
        return term;
    }

    public static void termLink(Term from, Term to) {
        if (from == null || to == null) {
            return;
        }
        from.setTo(to);
        to.setFrom(from);
    }

    public static void insertTerm(Term[] terms, Term term, InsertTermType type) {
        Term self = terms[term.getOffe()];
        if (self == null) {
            terms[term.getOffe()] = term;
            return;
        }
        int len = term.getName().length();
        if (self.getName().length() == len) {
            if (type == InsertTermType.REPLACE) {
                term.setNext(self.next());
                terms[term.getOffe()] = term;
            } else if (type == InsertTermType.SCORE_ADD_SORT) {
                self.score(self.score() + term.score());
                self.selfScore(self.selfScore() + term.selfScore());
            }
            return;
        }
        if (self.getName().length() > len) {
            term.setNext(self);
            terms[term.getOffe()] = term;
            return;
        }
        Term next = self;
        Term before = self;
        while ((next = before.next()) != null) {
            if (next.getName().length() == len) {
                if (type == InsertTermType.REPLACE) {
                    term.setNext(next.next());
                    before.setNext(term);
                } else if (type == InsertTermType.SCORE_ADD_SORT) {
                    next.score(next.score() + term.score());
                    next.selfScore(next.selfScore() + term.selfScore());
                }
                return;
            }
            if (next.getName().length() > len) {
                before.setNext(term);
                term.setNext(next);
                return;
            }
            before = next;
        }
        before.setNext(term);
    }

    public static void insertTermNum(Term[] terms, Term term) {
        terms[term.getOffe()] = term;
    }

    public static void insertTerm(Term[] terms, List<Term> tempList, TermNatures nr) {
        StringBuilder sb = new StringBuilder();
        int offe = tempList.get(0).getOffe();
        for (Term term : tempList) {
            sb.append(term.getName());
            terms[term.getOffe()] = null;
        }
        Term term = new Term(sb.toString(), offe, TermNatures.NR);
        TermUtil.insertTermNum(terms, term);
    }

    protected static Term setToAndfrom(Term to, Term from) {
        from.setTo(to);
        to.setFrom(from);
        return from;
    }

    public static void parseNature(Term term) {
        if (!Nature.NW.equals(term.natrue())) {
            return;
        }
        String name = term.getName();
        if (name.length() <= 3) {
            return;
        }
        if (ForeignPersonRecognition.isFName(name)) {
            term.setNature(NatureLibrary.getNature("nrf"));
            return;
        }
        List<Term> subTerm = term.getSubTerm();
        term.setSubTerm(subTerm);
        Term first = subTerm.get(0);
        Term last = subTerm.get(subTerm.size() - 1);
        int[] is = companyMap.get(first.getName());
        int all = 0;
        is = companyMap.get(last.getName());
        if (is != null) {
            all += is[1];
        }
        if (all > 1000) {
            term.setNature(NatureLibrary.getNature("nt"));
            return;
        }
    }

    public static List<Term> getSubTerm(Term from, Term to) {
        ArrayList<Term> subTerm = new ArrayList<Term>(3);
        while ((from = from.to()) != to) {
            subTerm.add(from);
        }
        return subTerm;
    }

    public static enum InsertTermType {
        SKIP,
        REPLACE,
        SCORE_ADD_SORT;

    }
}

