/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nlpcn.commons.lang.util.logging.Log;

public class Log4j2Impl
implements Log {
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;

    public Log4j2Impl(Logger log) {
        this.log = log;
    }

    public Log4j2Impl(String loggerName) {
        this.log = LogManager.getLogger((String)loggerName);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        ++this.errorCount;
        this.log.error(s, e);
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        this.log.error(s);
    }

    @Override
    public void debug(String s) {
        ++this.debugCount;
        this.log.debug(s);
    }

    @Override
    public void debug(String s, Throwable e) {
        ++this.debugCount;
        this.log.debug(s, e);
    }

    @Override
    public void warn(String s) {
        this.log.warn(s);
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.warn(s, e);
        ++this.warnCount;
    }

    public int getWarnCount() {
        return this.warnCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.info(msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabled(Level.WARN);
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public String toString() {
        return this.log.toString();
    }
}

